	SUBROUTINE DUMP_RECORDS(SCREEN_TITLE)
$INCLUDE: 'CDRCOM.FOR'
C
C	Dump a continuous stretch of recorded signal to
C	printer/plotter/file
C
	CHARACTER*(*) SCREEN_TITLE
	CHARACTER DEVICE
	CHARACTER*20 STRING
	INTEGER IXY(2),IPLOT_AREA(4)
	PARAMETER ( POINTS_MAX = 5120.)
C
C	CODE
C
	CALL MOVE_CURSOR(2,LTOP)
	CALL ERASE_EOS
	CALL DISPLAY_STRING(SCREEN_TITLE)
	CALL NEW_LINE
	CALL NEW_LINE
C
	CALL DISPLAY_STRING('Start at record ? ')
	CALL GET_NUMBER(RN,1.,FLOAT(N_RECORDS),1.)
	IR_START = IFIX(RN)
	CALL DISPLAY_STRING('End at record ? ')
	CALL GET_NUMBER(RN,FLOAT(IR_START),FLOAT(N_RECORDS)
     &,FLOAT(N_RECORDS))
	IR_END = IFIX(RN)
C
	CALL ASK_USER(
     &'Plot on printer (D), or plotter (P) ? ',DEVICE)

	CALL NEW_LINE
	CALL DISPLAY_STRING('WAIT ... Plotting ')
C
C	Open selected workstation
C
	IF(DEVICE.EQ.'P') THEN
		CALL OPEN_WORKSTATION(IDEV,11)
		CALL LOAD_FONTS(IDEV)
		CALL SET_TEXT_FACE(IDEV,1)
		ICHAR_HEIGHT = NDC_MAX/60
	ELSEIF(DEVICE.EQ.'D') THEN
		CALL OPEN_WORKSTATION(IDEV,21)
		CALL LOAD_FONTS(IDEV)
		CALL SET_TEXT_FACE(IDEV,1)
		ICHAR_HEIGHT = NDC_MAX/60
	ELSE
		RETURN
	ENDIF
C
C	Get character height and width
C
	CALL SET_CHARACTER_HEIGHT(IDEV,ICHAR_HEIGHT)
	CALL GET_CHARACTER_SIZE(ICHAR_WIDTH,ICHAR_HEIGHT)
C
C
C	Set physical plotting area
C
	IPLOT_AREA(1) = 7*ICHAR_WIDTH
	IPLOT_AREA(3) = IPLOT_AREA(1) + 1024*24
	IPLOT_AREA(2) = 5000
	IPLOT_AREA(4) = IPLOT_AREA(2) + MAX_ADC*3


C	IDATA_INC is the data reduction factor and IPLOT_INC is the
C	inter-point spacing on the plotted page. They are set to
C	ensure that the complete record is contained within
C	the plotting area.

	POINTS_IN_DATA =FLOAT(IR_END - IR_START + 1)*FLOAT(NP_RECORD)
	IDATA_INC = MAX0(IFIX( POINTS_IN_DATA / POINTS_MAX ),1)
	NPOINTS_IN_PLOT = IFIX(POINTS_IN_DATA / FLOAT(IDATA_INC) )
	IPLOT_INC = (IPLOT_AREA(3)-IPLOT_AREA(1))/NPOINTS_IN_PLOT


	CALL DISPLAY_INT(NPOINTS_IN_PLOT)
	CALL DISPLAY_INT(IDATA_INC)
	CALL DISPLAY_INT(IPLOT_INC)

	IY_SCALE = (IPLOT_AREA(4) - IPLOT_AREA(2))/MAX_ADC

	IR = IR_START
	CALL GET_RECORD(IR)
	J = 0
	IDATA_OLD = 0
	IDATA = 0
	IX = IPLOT_AREA(1)

100	IF( (IR .LE. IR_END) .AND. (IX.LT.IPLOT_AREA(3)) ) THEN

C		If data pointer IDATA has rolled over, plot contents
C		of display array IWORK and get a new record

		IF( IDATA .LT. IDATA_OLD) THEN
			CALL POLYLINE( IDEV, IWORK, J/2)
			J = 0
			IR = IR + 1
			IF( IR .LE. IR_END ) CALL GET_RECORD(IR)
		ENDIF

C		Create an X,Y plotting point

		J = J + 1
		IWORK(J) = IX
		J = J + 1
		IWORK(J) = IBUFFER(IDATA+1)*IY_SCALE + IPLOT_AREA(2)

		IX = IX + IPLOT_INC
		IDATA_OLD = IDATA
		IDATA = MOD(IDATA + IDATA_INC,NP_RECORD)

	GOTO 100
	ENDIF

C	Plot any remaining points

	IF( J .GT. 0 ) THEN
		CALL POLYLINE( IDEV, IWORK, J/2 )
	ENDIF

C
C --	Title
C
	IXY(1) = IPLOT_AREA(1)
	IXY(2) = NDC_MAX - 3*ICHAR_HEIGHT
	CALL GRAPHICS_TEXT(IDEV,IXY,'File ... '//FILE_NAME)
	IXY(2) = NDC_MAX - 4*ICHAR_HEIGHT
	CALL GRAPHICS_TEXT(IDEV,IXY,CELL(1:60))


C
C --	Create suitably sized integer calibration bars
C
C	Vertical bar
C
	Y_25 = BIT_CURRENT*FLOAT(MAX_ADC)/4.
	Y_BAR = 10.**(IFIX(ALOG10(Y_25))+1)
	DY = Y_BAR*0.1
	DO 5 I=1,9
		IF(Y_BAR.LE.Y_25) GOTO 6
		Y_BAR = Y_BAR - DY
5	CONTINUE
6	CONTINUE


C
C -- Plot vertical calibration bar
C
	IBAR_Y = IFIX(Y_BAR/BIT_CURRENT)
	IX = IPLOT_AREA(1) - 5*ICHAR_WIDTH
	IY = 3*ICHAR_HEIGHT
	CALL YT_CALIBRATION(IDEV,IX,IY
     &,IBAR_Y,ICHAR_WIDTH,ICHAR_HEIGHT,Y_BAR,Y_UNITS,'V')
C
C -- 	Plot horizontal bar
C
	X_10 = DT*POINTS_IN_DATA/10.
	X_BAR = 10.**(IFIX(ALOG10(X_10))+1)
	DX = X_BAR*0.1
	DO 7 I=1,9
		IF(X_BAR.LE.X_10) GOTO 8
		X_BAR = X_BAR - DX
7	CONTINUE
8	CONTINUE
C

	IBAR_T = IFIX(FLOAT(IPLOT_INC)*X_BAR/(DT*FLOAT(IDATA_INC)))
	CALL YT_CALIBRATION(IDEV,IX,IY
     &,IBAR_T,ICHAR_WIDTH,ICHAR_HEIGHT,X_BAR,T_UNITS,'H')
C
C
C	Plot last page and close workstation
C
	CALL UPDATE_WORKSTATION(IDEV)
	CALL CLEAR_WORKSTATION(IDEV)
	CALL UNLOAD_FONTS(IDEV)
	CALL CLOSE_WORKSTATION(IDEV)
	CALL SET_MARGINS(2,1,80,25)
	RETURN
	END

