	subroutine analyse_events
c
c	Analyse peak value, area,  rise-time, for each record
c	and plot variable.
C	-------------------------------------------
C
$INCLUDE:'cdrcom.FOR'
C
	CHARACTER*52 TITLE
	CHARACTER*18 YLABEL,xlabel
	CHARACTER KEY
	CHARACTER*40 STRING
	LOGICAL special,plot_available,new_menu,histogram,averaging

	character*52 report(10)
	REAL xy(1)
	EQUIVALENCE (xy,iwork(2001))

	character*52 msg(2)

	parameter(nmenu=10,istatus_left=59,istatus_top=19)

	character*20 menu(nmenu) /
     &	' Edit events      F1',
     &	' Analyse events   F2',
     &	' Plot X/Y graph   F3',
     &	' Plot histogram   F4',
     &	' Set axes range   F5',
     &	' Plot hard copy   F6',
     &	' List graph       F7',
     &	' Set event types  F8',
     &	' Match events     F9',
     &	' Exit            ESC'/

	parameter(nvars=11)
	character*16 var_name(nvars)
	integer*2 ivar_map(nvars)

	PARAMETER(NPRE_TRIGGER=100)
	INTEGER*2 IA_START /0/,IA_END /0/
C
C	CODE

	IF((IA_START.EQ.0) .AND. (IA_END.EQ.0) ) THEN
	    np_dead = int( dead_time/dt )
	    IA_START = 0
	    IA_END = MIN0(NP_DEAD,NP_RECORD - NPRE_TRIGGER)
	ENDIF

	if( iev_sta .eq. 0 ) iev_sta = 1
	if( iev_end .eq. 0 ) iev_end = n_events
	iev_end = min( iev_end,n_events)
	if( iev_skip .eq. 0 ) iev_skip = 1
c
c	Define list of variable
c
	VAR_NAME(1) = 'Record No.'
	IVAR_MAP(1) = 1
	VAR_NAME(2) = 'Clock Time s'
	IVAR_MAP(2) = 2
	VAR_NAME(3) = 'Rise Time '//T_UNITS
	IVAR_MAP(3) = 3
	VAR_NAME(4) = 'Duration '//Y_UNITS
	IVAR_MAP(4) = 4
	VAR_NAME(5) = 'Peak '//Y_UNITS
	IVAR_MAP(5) = 5
	VAR_NAME(6) = 'Area '//Y_UNITS//T_UNITS
	IVAR_MAP(6) = 6
	VAR_NAME(7) = 'Zero level '//Y_UNITS
	IVAR_MAP(7) = 7
	VAR_NAME(8) = 'Interval s'
	IVAR_MAP(8) = 8
	VAR_NAME(9) = 'Amp(exp) '//Y_UNITS
	IVAR_MAP(9) = 9
	VAR_NAME(10) = 'Tau(exp) '//t_units
	IVAR_MAP(10) = 10
	VAR_NAME(11) = 'R(exp) '
	IVAR_MAP(11) = 11

c ---------------------------------------------

	plot_available = .false.
	iop = 1

C
100	CONTINUE
	    CALL SET_MARGINS(2,1,80,25)

	    write(report(1)
     &	    ,'(''File .. ''a,'' Events '',i5,''-'',i5)')
     &	    file_name,iev_sta,iev_end
	    report(2) = cell
	    nlines = 2
c
	    CALL ERASE_ALL
	    call display_box(1,1,istatus_left-2,25)
	    CALL MOVE_CURSOR(2,1)
	    CALL DISPLAY_STRING(' Analyse Detected Events ')

C
C	    Plot graph on screen
C
	    if( plot_available ) then
		if( .not. histogram ) then
		     call plot_graph('S',xy,np,xlo,ylo,xhi,yhi
     &		     ,xtic,ytic,xlabel,ylabel,report,nlines)
		else
		     call plot_histogram('S',xy,np,xlo,ylo,xhi,yhi
     &		     ,xtic,ytic,xlabel,ylabel,report,nlines)
		endif
	    endif
c
c	    Display status box
c
	    call display_box(istatus_left-1,istatus_top-1,79,25)
	    call set_margins(istatus_left,istatus_top,79,25)
	    call move_cursor(istatus_left,istatus_top)
	    call display_string(file_name)
	    call new_line
	    write(string,'(''Events '',i5,''-'',i5)') iev_sta,iev_end
	    call display_string(string(1:20))
	    call new_line
	    if( iev_type .ne. 0 ) then
		call display_string('Type: '//type_List(iev_type))
	    else
		call display_string('Type: ANY')
	    endif
	    call new_line
	    write(string,'(''An. area'',i4,''-'',i4)') ia_start,ia_end
	    call display_string(string(1:20))
	    call new_line
	    write(string,'(''No. points '',i5)') np
	    call display_string(string(1:20))

	    call set_margins(2,1,80,25)

c
c	Wait for user to select an option from menu
c
	new_menu = .true.
	iop = Iwait_MENU_VERTICAL1(menu,'123456789$',nmenu
     &	,istatus_left-1,1,new_menu,iop,' Options ',key)

	if( iop .eq. 0 ) goto 100
	GOTO(1,2,3,4,5,6,7,8,9,10) IOP
c
c -- Edit detected events
c
1	if( n_events .gt. 0 )
     &	call edit_events( ia_start, ia_end, npre_trigger )
	goto 100

c
c -- Analyse records on file
c
2	if( n_events .gt. 0 ) then
	    call measure_events(ia_start,ia_end,
     &	    iev_sta,iev_end,iev_skip,iev_type)
	    plot_available = .false.
	endif
	goto 100
c
c -- X/Y plot of a selected pair of variables
c
	new_menu = .true.
3	ix_var = Iwait_MENU_VERTICAL1(var_name,'123456789A',nvars
     &	,3,5,new_menu,iop,' X Variable ',key)
	xlabel = var_name(ix_var)
	new_menu = .true.
	iy_var = Iwait_MENU_VERTICAL1(var_name,'123456789A',nvars
     &	,4,6,new_menu,iop,' Y Variable ',key)
	ylabel = var_name(iy_var)

	if( iev_skip .gt. 1 ) then
	    call query_box(5,7,'Skipping events! Use Averaging (Y/N) ',
     &	    key)
	    if( key .eq. 'Y' ) then
		averaging = .true.
	    else
		averaging = .false.
	    endif
	endif

	call create_graph(ivar_map(ix_var),ivar_map(iy_var)
     &	,iev_sta,iev_end,iev_skip,iev_type,averaging
     &	,xy,np,xmin,ymin,xmax,ymax)

	xlo = xmin
	ylo = ymin
	xhi = xmax
	yhi = ymax
	if(xlo .eq. xhi ) xhi = xlo + 1.
	if(ylo .eq. yhi ) yhi = ylo + 1.
	xtic = (xhi-xlo)/5.
	ytic = (yhi-ylo)/5.
	if( np .gt. 1 ) plot_available = .true.
	histogram = .false.
	goto 100
c
c -- Create frequency histogram for selected variable
c
4	new_menu = .true.
	ih_var = Iwait_MENU_VERTICAL1(var_name,'12345678',nvars
     &	,3,5,new_menu,iop,' Histogram of ',key)
	xlabel = var_name(ih_var)

	call create_histogram(ivar_map(ih_var)
     &	,iev_sta,iev_end,iev_type
     &	,xy,np,xmin,ymin,xmax,ymax,ylabel)

	xlo = xmin
	ylo = ymin
	xhi = xmax
	yhi = ymax
	if(xlo .eq. xhi ) xhi = xlo + 1.
	if(ylo .eq. yhi ) yhi = ylo + 1.
	xtic = (xhi-xlo)/5.
	ytic = (yhi-ylo)/5.
	plot_available = .true.
	histogram = .true.
	goto 100
C
C -- Set plot axes range and tic spacing
C
5	if( plot_available ) call set_axes_form(3,5,xmin,ymin,xmax,ymax
     &	,xlo,ylo,xhi,yhi,xtic,ytic)
	GOTO 100
C
C -- Plot hard copy of currently displayed graph
C
6	if( plot_available ) then
	    if( .not. histogram ) then
		 call plot_graph('H',xy,np,xlo,ylo,xhi,yhi
     &		 ,xtic,ytic,xlabel,ylabel,report,nlines)
	    else
		 call plot_histogram('H',xy,np,xlo,ylo,xhi,yhi
     &		 ,xtic,ytic,xlabel,ylabel,report,nlines)
	    endif
	endif
	GOTO 100
C
C -- Display table of current graph values
c
7	if( plot_available ) then
	    call list_table(xy,2,np,15,3,4,xlabel(1:12)//ylabel(1:12))
	endif
	goto 100
c
c -- Set event classification types
c
8	call set_type_list
	goto 100
c
c -- Find matching events
c
9	call match_events( ia_start, ia_end )
	goto 100

c -- Exit
c
10	call set_margins(2,1,80,25)
	return

	END

	SUBROUTINE CREATE_GRAPH(IX_VAR,IY_VAR
     &	,iev_sta,iev_end,iev_skip,irequired_type,averaging,
     &	 xy,NP,XMIN,YMIN,XMAX,YMAX)
$INCLUDE:'cdrcom.FOR'
C
c	Create aN X/Y plot of variables IX_VAR and IY_VAR
c	from record analysis array (see ANALYSIS in cdrcom.FOR)
c	using events between iev_sta and iev_end in list CDR.EVE
c	of event type IREQUIRED_TYPE
c
c	Return histogram in array XY of length NP points.
c	Data range is returned in XMIN,YMIN,XMAX,YMAX
c	YLABEL is returned as blank or as % if percentage
C	------------------------------------------------
C
C
	REAL XY(1)
	LOGICAL AVERAGING
C
C	CODE
C	----
C
	call display_message(5,7,30,' WAIT ... Creating graph ',1)

C
C	CODE
C	----
C
	J = 0
	XMIN = 1E30
	YMIN = 1E30
	XMAX = -1E30
	YMAX = -1E30

C	Don't use averaging if inter-point step is 1
C
	IF(iev_skip .EQ. 1) averaging = .FALSE.


	DO 100 IEVENT = iev_sta,iev_end-iev_skip+1,iev_skip
C
	    IF( averaging ) THEN
C
C		Average from IEVENT to IEVENT + iev_skip - 1

		X = 0.
		Y = 0.
		NAVG = 0
		DO 110 II = IEVENT,IEVENT+iev_skip-1

		    CALL GET_EVENT_ANALYSIS(II)

C		    If IREQUIRED_TYPE is 1..5 then include
C		    event only if it matches. If IREQUIRED_TYPE=0
C		    include ALL types EXCEPT REJECTED
C
		    IF( (IEVENT_TYPE .EQ. IREQUIRED_TYPE) .OR.
     &		    ((IREQUIRED_TYPE.EQ.0) .AND. (IEVENT_TYPE.NE.1))
     &			) THEN
			X = X + ANALYSIS(IX_VAR)
			Y = Y + ANALYSIS(IY_VAR)
			NAVG = NAVG + 1
		    ENDIF
110		CONTINUE

C		Put average into XY plotting array
C		and update min./max. values

		J = J + 1
		X = X / FLOAT(NAVG)
		XY(J) = X
		IF(X.LT.XMIN) XMIN = X
		IF(X.GT.XMAX) XMAX = X

		J = J + 1
		Y = Y / FLOAT(NAVG)
		XY(J) = Y
		IF(Y.LT.YMIN) YMIN = Y
		IF(Y.GT.YMAX) YMAX = Y

	    ELSE
C
C		No averaging
C
		CALL GET_EVENT_ANALYSIS( IEVENT )
C

C		If IREQUIRED_TYPE is 1..5 then include
C		event only if it matches. If IREQUIRED_TYPE=0
C		include ALL types EXCEPT REJECTED
C
		IF( (IEVENT_TYPE .EQ. IREQUIRED_TYPE) .OR.
     &		((IREQUIRED_TYPE.EQ.0) .AND. (IEVENT_TYPE.NE.1))
     &		) THEN
		    J = J + 1
		    X = ANALYSIS(IX_VAR)
		    XY(J) = X
		    IF(X.LT.XMIN) XMIN = X
		    IF(X.GT.XMAX) XMAX = X

		    J = J + 1
		    Y = ANALYSIS(IY_VAR)
		    XY(J) = Y
		    IF(Y.LT.YMIN) YMIN = Y
		    IF(Y.GT.YMAX) YMAX = Y
		ENDIF
	    ENDIF

100	CONTINUE
	NP = J/2

	RETURN
	END


	SUBROUTINE CREATE_HISTOGRAM(ih_var
     &	,iev_sta,iev_end,irequired_type
     &	,xy,np,xmin,ymin,xmax,ymax,YLABEL)
$include: 'cdrcom.for'
C
c	Create a frequency histogram of variable No. IH_VAR
c	from record analysis array (see ANALYSIS in cdrcom.FOR)
c	using records between iev_sta and iev_end in file IFILE_NO
c	of type RECORD_TYPE (EVOKED,SPONT., or ALL records excepted REJECTED)
c
c	Return histogram in array XY of length NP points.
c	Data range is returned in XMIN,YMIN,XMAX,YMAX
c	YLABEL is returned as blank or as % if percentage
C	------------------------------------------------
C
	REAL XY(1),xmin,xmax,ymin,ymax
	integer*2 iev_sta,iev_end,np,ih_var
	CHARACTER*(*) YLABEL

	parameter(nmenu=4)
	character*30 menu(nmenu) /
     &	' No. of bins (<=100)',
     &	' Bin Range (Lower Limit)',
     &	' Bin Range (Upper Limit)',
     &	' Y axis as Percentage (Y/N)' /
	character*12 list(nmenu)
	character*36 title

	parameter(bigneg=-1E30,bigpos=1E30)
	parameter(maxbins=100)
	integer*4 bins4(maxbins),ymax4,total4
	integer*2 nbins /100/
	character percent / 'N' /
	character*6 status
C
C	CODE
C
C
C --	Find Min./Max. range of data (used as initial setting
c	of histogram range
C
	iskip = max((iev_end-iev_sta)/100,1)
	binlo = 1E30
	binhi = -1E30
	DO 50 ievent = iev_sta,iev_end,iskip
C
	    CALL GET_EVENT_ANALYSIS(IEVENT)
C
C	    If IREQUIRED_TYPE is 1..5 then include
C	    event only if it matches. If IREQUIRED_TYPE=0
C	    include ALL types EXCEPT REJECTED(=1)
C
	    IF( (IEVENT_TYPE .EQ. IREQUIRED_TYPE) .OR.
     &	    ((IREQUIRED_TYPE.EQ.0) .AND. (IEVENT_TYPE.NE.1)) ) then
		x = analysis(ih_var)
		if( binlo .gt. x ) binlo = x
		if( binhi .lt. x ) binhi = x
	    endif
50     CONTINUE


c
c	Let user set histogram range
c
	write(list(1),'(i3)') nbins
	write(list(2),'(f11.3)') binlo
	write(list(3),'(f11.3)') binhi
	list(4) = percent

	title = ' '
10	if( title .eq. ' ' ) title = ' Set Histogram Range '
	call text_window(menu,list,nmenu,4,6,title)

	nbins = int(check_limits(list,2.,float(maxbins),1,title))
	if( title .ne. ' ' ) goto 10
	binlo = check_limits(list,bigneg,bigpos,2,title)
	if( title .ne. ' ' ) goto 10
	binhi = check_limits(list,binlo+1E-30,bigpos,3,title)
	if( title .ne. ' ' ) goto 10

	call upper_case(list(4))
	if( index(list(4),'Y') .ne. 0 ) then
	    percent = 'Y'
	else
	    percent = 'N'
	endif

	call display_message(5,7,30,' WAIT ... Creating histogram ',1)
C
	bin_width = (binhi - binlo ) / float(nbins)
C
C -- Clear bin count accumulators
C
	DO 5 I=1,NBINS
	    BINS4(i) = 0
5	CONTINUE
C
C -- Generate bins
C

	DO 100 ievent = iev_sta,iev_end
C
		CALL GET_EVENT_ANALYSIS(IEVENT)
C
C	       If IREQUIRED_TYPE is 1..5 then include
C	       event only if it matches. If IREQUIRED_TYPE=0
C	       include ALL types EXCEPT REJECTED
C
	       IF( (IEVENT_TYPE .EQ. IREQUIRED_TYPE) .OR.
     &	       ((IREQUIRED_TYPE.EQ.0) .AND. (IEVENT_TYPE.NE.1)) ) then

		    x = analysis(ih_var)
		    idx = int( (x - binlo)/bin_width ) + 1
		    idx = min(max(idx,1),nbins)
		    bins4(idx) = bins4(idx) + 1
	       ENDIF
100	CONTINUE

c
c	Calculate total contents of bins
c
	total4 = 0
	ymax4 = 0
	do 110 i = 1,nbins
	    total4 = total4 + bins4(i)
	    if( ymax4 .lt. bins4(i) ) ymax4 = bins4(i)
110	continue
c
c	Scale into % (if required)
c
	if( percent .eq. 'Y' ) then
	    scale = 100./float(total4)
	    ylabel = '%'
	else
	    scale = 1.
	    ylabel = ' '
	endif
c
c	Copy into output XY array
c
	x = binlo + bin_width/2.
	j = 1
	do 120 i = 1,nbins
	    xy(j) = x
	    j = j + 1
	    xy(j) = float(bins4(i))*scale
	    j = j + 1
	    x = x + bin_width
120	continue
C
C -- Axes data range
C
	xmin = binlo
	xmax = binhi
	ymin = 0.
	ymax = float( ymax4 )
	np = nbins
	RETURN
	END

	subroutine set_axes_form(ix,iy,xmin,ymin,xmax,ymax
     &	,xlo,ylo,xhi,yhi,xtic,ytic)

	parameter(naxes_menu=6)
	parameter(bigneg=-1E30,bigpos=1E30)
	character*36 axes_menu(naxes_menu)
	character*12 list(naxes_menu)
	character*46 err
c
c	code
c
	WRITE(axes_menu(1)
     &	,'('' X axis range: minimum ('',G10.4,'')'')') XMIN
	WRITE(axes_menu(2)
     &	,'('' X axis range: maximum ('',G10.4,'')'')') XMAX
	axes_menu(3) = ' X axis tic spacing '
	WRITE(axes_menu(4)
     &	,'('' Y axis range: minimum ('',G10.4,'')'')') YMIN
	WRITE(axes_menu(5)
     &	,'('' Y axis range: maximum ('',G10.4,'')'')') YMAX
	axes_menu(6) = ' Y axis tic spacing '

	write(list(1),'(F12.3)') xlo
	write(list(2),'(F12.3)') xhi
	write(list(3),'(F12.3)') xtic
	write(list(4),'(F12.3)') ylo
	write(list(5),'(F12.3)') yhi
	write(list(6),'(F12.3)') ytic

	err = ' '
2100	if( err .eq. ' ' ) err = ' Set axes range '

	CALL text_window(axes_menu,list,naxes_menu,ix,iy,err)

	xlo  = check_limits(list,bigneg,bigpos,1,err)
	if( err .ne. ' ' ) goto 2100
	xhi  = check_limits(list,bigneg,bigpos,2,err)
	if( err .ne. ' ' ) goto 2100
	xtic = check_limits(list,bigneg,bigpos,3,err)
	if( err .ne. ' ' ) goto 2100
	ylo  = check_limits(list,bigneg,bigpos,4,err)
	if( err .ne. ' ' ) goto 2100
	yhi  = check_limits(list,bigneg,bigpos,5,err)
	if( err .ne. ' ' ) goto 2100
	ytic = check_limits(list,bigneg,bigpos,6,err)
	if( err .ne. ' ' ) goto 2100

	return
	end

	SUBROUTINE SET_TYPE_LIST
$INCLUDE: 'CDRCOM.FOR'
C
C	Get user entered operation parameters from keyboard
C	(check for valid range)
C
	CHARACTER*24 MENU(MAX_TYPES)
C
C	CODE
C	----
C
C	Set up data entry form
C
	MENU(1) = ' 1 (Always REJECT) '
	MENU(2) = ' 2 '
	MENU(3) = ' 3 '
	MENU(4) = ' 4 '
	MENU(5) = ' 5 '
	TYPE_LIST(1) = 'REJECT'
C
C
100	CALL TEXT_WINDOW(MENU,TYPE_LIST,MAX_TYPES,3,5
     &	,' Event classification types ')
C
	DO 110 I = 1,MAX_TYPES
	     CALL UPPER_CASE(TYPE_LIST(I))
110	CONTINUE
	N_TYPES = MAX_TYPES
C
	RETURN
	END

	SUBROUTINE measure_EVENTS(IA_START,IA_END,
     &	iev_sta,iev_end,iev_skip,irequired_type)
$INCLUDE: 'CDRCOM.FOR'
C
C	Analyse events stored in file CDR.EVE. Limits of analysis
C	area defined by IA_START, IA_END which are offsets relative
C	IEVENT_OFFSET. (IA_START & IA_END are initialy set
C	IA_START = 0 IA_END = NP_DEAD or NP_RECORD which ever is smaller)
c
c	Range of events analysed are returned in iev_sta and iev_end
c	the event type analysed was irequired_type
c	-----------------------------------------------------------------
C
	PARAMETER(NROWS=5)
	CHARACTER*44 MENU(NROWS)
	CHARACTER*6 LIST(NROWS)
	character*42 title
	CHARACTER*50 STRING
	CHARACTER POLARITY,KEY
	LOGICAL SPECIAL
	REAL X(NP_RECORD),Y(NP_RECORD)
	EQUIVALENCE(X,IWORK(1)),(Y,IWORK(1025))

	character*32 msg(2)
C
C	CODE
C
C	Let user set up analysis parameters
C
	i = 1
	write(menu(i),'(''Start at event (1)'')')
	write(list(i),'(i5)') min(max(iev_sta,1),n_events)
	i = i + 1
	write(menu(i),'(''End at event ('',i5,'')'')') n_events
	if( iev_end .le. 0 ) iev_end = n_events
	write(list(i),'(i5)') iev_end
	i = i + 1
	write(menu(i),'(''in steps of '')')
	write(list(i),'(i5)') max(iev_skip,1)
	i = i + 1
	write(menu(i),'(''Points averaged at event peak'')')
	write(list(i),'(i5)') max(npeak_avg,1)
	i = i + 1
	MENU(i) = 'Type '//TYPE_LIST(1)//' '//TYPE_LIST(2)//' '//
     &TYPE_LIST(3)//' '//TYPE_LIST(4)//' '//TYPE_LIST(5)//' ALL'
	if( irequired_type .eq. 0 ) then
	    list(i) = 'ALL'
	else
	    list(i) = type_list(irequired_type)
	endif

C
	title = ' '
5	if( title .eq. ' ' )
     &	title = ' Set analysis parameters (RETURN to Begin) '
	CALL TEXT_WINDOW(MENU,LIST,NROWS,2,5,title)
C
	I = 1
	iev_sta = int(check_limits(list,1.,float(n_events),i,title))
	if( title .ne. ' ' ) goto 5

	I = i + 1
	iev_end = int(check_limits(list,float(iev_sta),float(n_events),
     &	 i,title))
	if( title .ne. ' ' ) goto 5

	I = i + 1
	iev_skip = int(check_limits(list,float(1.),float(n_events),
     &	 i,title))
	if( title .ne. ' ' ) goto 5

	I = i + 1
	npeak_avg = int(check_limits(list,1.,64.,i,title))
	if( title .ne. ' ' ) goto 5

	I = I + 1
	CALL UPPER_CASE(LIST(I))
	IREQUIRED_TYPE = 0
	DO 10 J = 1,MAX_TYPES
		IF( LIST(I) .EQ. TYPE_LIST(J) ) THEN
			IREQUIRED_TYPE = J
		ENDIF
10	CONTINUE

	msg(1) = 'WAIT ... Analysing events '
	msg(2) = ' '
	call display_message(4,6,30,msg,2)
	ixc = 5
	iyc = 8
C
C	Analyse specified events and store results in CDR.EVE file
C


	T_RECORD = FLOAT(NP_RECORD)*DT
	ILAST_RECORD = ICAL_RECORD
	ILAST_START = ICAL_CURSOR
	IF(TRIGGER_LEVEL.LT.0.) THEN
		ISIGN = -1
	ELSE
		ISIGN = 1
	ENDIF
	DO 100 IEVENT = iev_sta,iev_end
C
C	    Check for Esc key
C
	    CALL GET_KEY(KEY,SPECIAL)
	    IF(KEY.EQ.'$') goto 200
C
C	    Read in data for event
C
	    CALL GET_EVENT( IEVENT, IRECORD )
C
	    IF(MOD(IEVENT,10).EQ.0) THEN
		CALL MOVE_CURSOR(ixc,iyc)
		WRITE(STRING,9100) IEVENT,iev_end
9100		FORMAT('Events ',I5,'/',I5)
		CALL DISPLAY_STRING(STRING(1:18))
	    ENDIF
C
	    IF(  (IEVENT_TYPE .EQ. IREQUIRED_TYPE) .or.
     &	    ((irequired_type.eq.0).and.(ievent_type.ne.1))  ) then
C
C		Time since last event of this type
C
		TIME_EVENT = FLOAT(IEVENT_START-ICAL_CURSOR)*DT
     &		+ T_RECORD*(IEVENT_RECORD-ICAL_RECORD)
C
C		    Time separation from previous event
C
		TIME_LAST = (FLOAT(IEVENT_START-ILAST_START)*DT
     &		+ T_RECORD*(IEVENT_RECORD-ILAST_RECORD) )/1000.
		ILAST_START = IEVENT_START
		ILAST_RECORD = IEVENT_RECORD
C
		IEVENT_OFFSET = IEVENT_START + (IEVENT_RECORD-IRECORD)
     &		*NP_RECORD
		I_START = MAX0(IEVENT_OFFSET + IA_START,1)
		I_END = MIN0(NP_RECORD+I_START-1,IA_END+IEVENT_OFFSET)
		NP_ANALYSIS = I_END - I_START + 1

C
C		Calculate and subtract baseline
C
		CALL ADD_ARRAY(-IEVENT_ZERO,IBUFFER(I_START),NP_ANALYSIS)
		ZERO_CURRENT = FLOAT(IEVENT_ZERO-ICAL_CURRENT)
     &		*BIT_CURRENT + CAL_CURRENT
C
C		Peak analysis
C
		IF(ISIGN.LT.0) THEN
		    CALL NEGATE_ARRAY(IBUFFER(I_START),NP_ANALYSIS)
		ENDIF
C
		CALL MAX_ARRAY(IBUFFER(I_START),NP_ANALYSIS
     &		,IPEAK_LEVEL,IPEAK)
		IPEAK = IPEAK + I_START - 1
		LEVEL_10 = IPEAK_LEVEL/10
		LEVEL_90 = IPEAK_LEVEL - LEVEL_10
		CALL AVERAGE_SEGMENT(IBUFFER,IPEAK,IPEAK+NPEAK_AVG-1
     &		,PEAK,SUM)
		PEAK = FLOAT(ISIGN)*BIT_CURRENT*PEAK
C
C		Calculate rise-time
C
		J = 0
		DO 110 I=IPEAK,I_START,-1
		    IF(IBUFFER(I).LE.LEVEL_90) J = J + 1
		    IF(IBUFFER(I).LT.LEVEL_10) GOTO 111
110		CONTINUE
111		RISE_TIME = FLOAT(J)*DT
		IP_10 = I
C
C		Calculate duration
C
		DO 120 I = IPEAK,I_END
		    IF(IBUFFER(I).LT.LEVEL_10) GOTO 121
120		CONTINUE
121		CONTINUE
		IL_10 = I
		DURATION = FLOAT(IL_10-IP_10)*DT
C
C ----------	Calculate area
C
		CALL AVERAGE_SEGMENT(IBUFFER,IP_10,IL_10,AVG,AREA)
		AREA = AREA*DT*BIT_CURRENT*FLOAT(ISIGN)
C
C ----------	Calculate best fit decaying exponential 			  --
C
C		Find 90% - 10% decay region
C
		DO 130 IL_90 = IPEAK,IL_10
		    IF(IBUFFER(IL_90).LE.LEVEL_90) GOTO 131
130		CONTINUE
131		CONTINUE
		IF(IBUFFER(IL_10).LE.0) IL_10 = IL_10 - 1
		NFIT = IL_10 - IL_90 + 1
C
		IF(NFIT.GE.2) THEN
C
C		    Create arrays of Ln(Y) and X
C		    and calculate average of Ln(Y) and X
C
		    SUM_X = 0.
		    SUM_Y = 0.
		    J = 1
		    DO 140 I = IL_90,IL_10
			Y(J) = ALOG(FLOAT(IBUFFER(I))*BIT_CURRENT)
			X(J) = FLOAT(I-IPEAK)*DT
			SUM_Y = Y(J) + SUM_Y
			SUM_X = SUM_X + X(J)
			J = J + 1
140		    CONTINUE
		    AVG_X = SUM_X/FLOAT(NFIT)
		    AVG_Y = SUM_Y/FLOAT(NFIT)
C
C		    Subtract avg. X and ln(Y) from arrays
C		    and create sums of X-AVG_X (X-AVG_X)**2
C		    Y-AVG-Y (Y-AVG_Y)**2 and (X-AVG_X)(Y-AVG_Y)
C
		    SUM_X = 0.
		    SUM_Y = 0.
		    SUM_X2 = 0.
		    SUM_Y2 = 0.
		    SUM_XY = 0.
		    DO 150 I = 1,NFIT
			YI = Y(I)
			XI = X(I)
			YI = YI - AVG_Y
			XI = XI - AVG_X
			SUM_Y = YI + SUM_Y
			SUM_X = XI + SUM_X
			SUM_XY = SUM_XY + XI*YI
			SUM_X2 = SUM_X2 + XI*XI
			SUM_Y2 = SUM_Y2 + YI*YI
150		    CONTINUE
C
C		    calculate best fitting slope, y intercept and
C		    correlation coeff R.
C
		    SLOPE = (SUM_XY)/SUM_X2
		    Y_INTERCEPT = AVG_Y - SLOPE*AVG_X
		    TAU = -1./SLOPE
		    AMP = EXP(Y_INTERCEPT)
		    R = (SUM_XY)/SQRT(SUM_X2*SUM_Y2)
C
		ELSE
		    AMP = 0.
		    TAU = 0.
		    R = 0.
		ENDIF
C
		IEVENT_ANALYSED = 1
		CALL PUT_EVENT(IEVENT)
C
	    ENDIF
C
100	CONTINUE
200	CONTINUE
	RETURN
	END


	SUBROUTINE AVERAGE_SEGMENT(IBUFFER,I0,I1,AVG,SUM)
C
C	AVERAGE ELEMENTS OF IBUFFER FROM I0 TO I1 (INCLUSIVE)
C	AND RETURN AVERAGE IN AVG AND SUM IN SUM.
C
	INTEGER IBUFFER(1)
C
C	CODE
C
	SUM = 0.
	DO 10 I = I0,I1
		SUM = SUM + FLOAT(IBUFFER(I))
10	CONTINUE
	AVG = SUM/FLOAT(I1 - I0 + 1)
	RETURN
	END

	SUBROUTINE GET_EVENT(IEVENT,IRECORD)
$INCLUDE: 'CDRCOM.FOR'
C
C	Get position of an event from CDR.EVE file
C	and load it into IBUFFER from CDR.DAT
C
	INTEGER*4 IPOINTER_32,IEVENT_32,NB_32
	INTEGER *2 IP(2)
	EQUIVALENCE(IPOINTER_32,IP)
C
C	CODE
C
	NB_32 = NBYTES_EVENT
	IEVENT_32 = MAX0(MIN0(N_EVENTS,IEVENT),1)
	IPOINTER_32 = (IEVENT_32-1)*NB_32
	CALL MOVE_FILE_POINTER(IFILE_2,IERR,IP(1),IP(2))
	CALL READ_BYTES(IFILE_2,IERR,IEVENT_BUFFER,NBYTES_EVENT)
C
C	Read 3 records before, containing, and after detected event
C	(except for events in first record in file)
C
	IF(IEVENT_RECORD.GT.1) THEN
		IRECORD = IEVENT_RECORD - 1
	ELSE
		IRECORD = IEVENT_RECORD
	ENDIF
	call move_cursor(1,1)
	call display_int(irecord)
	call display_int(np_record)
	IBLOCK =  (IRECORD - 1)*(NP_RECORD/NP_SECTOR) + 2
	CALL READ_FILE(IFILE_1,IERROR,IBUFFER,IBLOCK
     &,(NP_RECORD*3)/NP_SECTOR)
	IF(IERROR.NE.0) THEN
	    CALL MOVE_CURSOR(2,25)
	    CALL DISPLAY_REVERSED('ERROR reading file CDR.DAT')
	ENDIF
	RETURN
	END


	SUBROUTINE PUT_EVENT(IEVENT)
$INCLUDE: 'CDRCOM.FOR'
C
C	Get position of an event from CDR.EVE file
C	and load it into IBUFFER from CDR.DAT
C
	INTEGER*4 IPOINTER_32,IEVENT_32,NB_32
	INTEGER*2 IP(2)
	EQUIVALENCE(IPOINTER_32,IP)
C
C	CODE
C
	NB_32 = NBYTES_EVENT
	IEVENT_32 = MAX0(MIN0(N_EVENTS+1,IEVENT),1)
	IPOINTER_32 = (IEVENT_32-1)*NB_32
	CALL MOVE_FILE_POINTER(IFILE_2,IERR,IP(1),IP(2))
	CALL WRITE_BYTES(IFILE_2,IERR,IEVENT_BUFFER,NBYTES_EVENT)
	RETURN
	END


	SUBROUTINE GET_EVENT_ANALYSIS(IEVENT)
$INCLUDE: 'CDRCOM.FOR'
C
C	Get position of an event from CDR.EVE file
C	and load it into IBUFFER from CDR.DAT
C
	INTEGER*4 IPOINTER_32,IEVENT_32,NB_32
	INTEGER*2 IP(2)
	EQUIVALENCE(IPOINTER_32,IP)
C
C	CODE
C
	NB_32 = NBYTES_EVENT
	IEVENT_32 = MAX0(MIN0(N_EVENTS+1,IEVENT),1)
	IPOINTER_32 = (IEVENT_32-1)*NB_32
	CALL MOVE_FILE_POINTER(IFILE_2,IERR,IP(1),IP(2))
	CALL READ_BYTES(IFILE_2,IERR,IEVENT_BUFFER,NBYTES_EVENT)
	RETURN
	END



