       PROGRAM CDR
C
C	CDR Computer Disc Recorder
C	--------------------------------------------------
C	Copyright - Univ. of Strathclyde, J. Dempster 1987
C	--------------------------------------------------
C	Note: This program is supplied for academic
C	research purposes only on the basis that its use will
C	be acknowledged in any publications. It  must not be
C	sold or distributed to other users without the permission 
C	of the author. The program is provide on an "as found"
C	basis without any software support. While this program
C	has been extensively tested, it the responsibility of the
C	user to verify that it functions correctly for their own
C	purposes.
C
C	For further details, contact:
C
C	John Dempster
C	Department of Physiology and Pharmacology
C	University of Strathclyde
C	Glasgow
C	G1 1XW
C	Tel. 041 552 4400 x2673
C	---------------------------------------------------
C	
C	V3.4 ... LAB-PC, DT2812 added.
C	v3.4b ... FEB 93 files_menu bug fixed
c	v3.4c ... MAR 93 Importing of SCAN files fixed
c	V3.4d ... MAY 93 Problem with DT2812 fixed
c	V3.4e ... AUG 1993 Changes to LAB.LIB
c	V3.5 .... FEB 1994 Support for Digidata 1200
c	V3.6 .... APR 1994 Support for N.I. ATMIO-16F
c	v3.6a ... APR 1994 ATMIO-16F in diff mode
c	V3.6b ... Channel flipping bug fixed (labpc.for) 2/9/94
c	V3.6c ... Disk space problem with Export to scan fixed 18/10/94
c       V3.7 ... Import from pCLAMP and export to WCP added
c                CED micro1401 support added
c	V3.7a ... pClamp import bug fixed
c       V3.7b ... 3/4/97 pCLAMP sampling interval bug fixed
c       V3.7c ... 9/10/97 Another pClamp import bug fixed
c                 (Import from V5 files with unusual A/D resolution
c       V3.7d ... 17/2/98 Export to WCP file Time now in secs
c       V3.7e ... 18/2/98 ical_cursor and ical_record set to zero
c
C	Cell identification header block
C	--------------------------------
C
$INCLUDE: 'CDRCOM.FOR'
C
	PARAMETER(nmenu=8,istatus_left=59,istatus_top=19)
	CHARACTER*20 MENU(nmenu) /
     &	 'Record to disc    F1',
     &	 'View recording    F2',
     &	 'Search for events F3',
     &	 'Analyse events    F4',
     &	 'Set parameters    F5',
     &	 'Load/Save files   F6',
     &	 'Lab. Interface   F10',
     &	 'Exit program       Q' /


	CHARACTER KEY,default_disc
	character*40 string
	character*40 lab_card_name /  ' ' /
	LOGICAL new_menu
	logical initialise / .true. /

C
C	CODE
C	----
C

C	Prevent run-time MATHs error from aborting program
C	(see Appendix D Microsoft FORTRAN V4.1 Users Guide)
	CALL LCWRQQ(16#133E)

	CALL OPEN_WORKSTATION(ISCREEN,1)
	CALL SET_MARGINS(2,1,80,25)
C
C -- Set size of display area
C 
	CALL SET_CHARACTER_HEIGHT(ISCREEN,1000)
	CALL GET_CHARACTER_SIZE(IW,IH)
	IDISPLAY_AREA(1) = IW
	IDISPLAY_AREA(2) = NDC_MAX - 24576 - IH
	IDISPLAY_AREA(3) = IDISPLAY_AREA(1) + ((60*IW)/512)*512
	IDISPLAY_AREA(4) = IDISPLAY_AREA(2) + 24576
	CALL SET_SIZE(IDISPLAY_AREA(1),IDISPLAY_AREA(2)
     &,IDISPLAY_AREA(3),IDISPLAY_AREA(4))
	FILE_NAME = ' '

	call change_directory(ierr,'\')
C
C	Master option selection loop
C	----------------------------
C
100	continue

	call erase_all

c
c	Display title
c
	call display_box(1,1,istatus_left-2,25)
	call move_cursor(5,5)
	call display_string(
     &  '     CDR - Computer Disc Recorder V3.7e')
	call move_cursor(5,6)
	call display_string(
     &  ' (c) J. Dempster 1990-1998, All Rights Reserved')
$if defined (life)
	call move_cursor(5,7)
	call display_string(
     &	'  (Licensed to Life Science Resources, 1994)')
$endif
$if defined (demo)
	call move_cursor(5,8)
	call display_string(
     &	' (Demonstration version - recording disabled)')
$endif


	if( initialise ) then
	    call initialise_files
	    initialise = .false.
	endif

	call move_cursor(2,24)
	if( error .ne. ' ' ) then
	    call display_string(error(1:50))
	    error = ' '
	else
	    call display_string(error(1:50))
	    call move_cursor(2,24)
	    call get_lab_interface_name ( interface_card, lab_card_name )
	    call display_string( lab_card_name )
	endif

	call move_cursor(2,22)
	CALL GET_DEFAULT_DISC(DEFAULT_DISC)
	CALL GET_DIRECTORY(STRING,NC)
	CALL DISPLAY_STRING('Dir:  '//DEFAULT_DISC//':\'//STRING(1:nc))
	call move_cursor(2,23)
	call display_string('File: '//file_name)
	write(string,'('' ('',f8.1,''s)'')') recording_time
	call display_stringt( string  )

	call move_cursor(2,24)
	call display_string(cell)

c
c	Display program status
c
	call display_box(istatus_left-1,istatus_top-1,79,25)
	call set_margins(istatus_left,istatus_top,79,25)
	call move_cursor(istatus_left,istatus_top)

	call new_line

	if( file_name .eq. ' ' ) then
	    call display_string('Recording not saved')
	else
	    write( string, '(''Saved on '',a)') file_name
	    call display_stringt( string )
	endif
	call new_line

	write(string,'(''% work file    '',i3,''%'')')
     &	int(100.*FLOAT(N_RECORDS)/FLOAT(MAX_RECORDS))
	call display_stringt( string )
	call new_line


	write(string,'(''Free disc '',i7,''K'')' )
     &	int4(free_disc_space())
	call display_stringt( string )
	call new_line

	write(string,'(''Free Mem  '',i4,''Kb'')' ) ifree_memory()
	call display_stringt( string )

	call set_margins(2,1,80,25)

C
c	Present options menu and wait for user response
c
	key = ' '
	new_Menu = .true.
	iop = Iwait_MENU_VERTICAL1(menu,'1234560Q'
     &	,nmenu,istatus_left-1,1,new_menu,iop,' Options',key)

C
C	Save header block on 1st block of CDR.DAT
C	To ensure any parameter change is saved.
C
	SIGNATURE = 'CDR '
	T_UNITS = 'ms'
	CALL WRITE_FILE(IFILE_1,IERR,IHEAD,1,1)
105	CONTINUE

	IF(IOP.EQ.0) GOTO 100
	GOTO(1,2,3,4,5,6,7,8) IOP
C
C	Digitise analogue current signal and store on disc
C	--------------------------------------------------
C
1	continue
$if defined(demo)
$else
	CALL RECORD_SIGNAL
$endif
	GOTO 100
C
C	View stored current signal 
C	---------------------------
C
2	IF(N_RECORDS.GT.0) THEN
	  call view_recording
	ELSE
	  ERROR = 'ERROR: No recorded data to view!'
	ENDIF
	GOTO 100
C
C	Search recorded signal for events
C	--------------------------------------------------
C
3	IF(N_RECORDS.GT.0) THEN
	  CALL SEARCH_FOR_EVENTS
	ELSE
	  ERROR = 'ERROR: No recorded data to search!'
	ENDIF
	GOTO 100
C
C	-----------------------------------------------
C
4	IF(N_EVENTS.GT.0) THEN
	    call analyse_events
	ELSE
	  ERROR = 'ERROR: No detected events data to analyse!'
	ENDIF
	GOTO 100
C
C	-----------------------------------------------------
C
C	Enter data collection parameters
C	--------------------------------
C
5	CALL SET_PARAMETERS
	GOTO 100
C
C	Save/load PATCH.1 & PATCH.2 files + test signal
C	-----------------------------------------------
C
6	CALL FILE_OPTIONS
	GOTO 100
c
c	Choose lab. interface
c
7	call select_lab_interface( interface_card, lab_card_name )
	goto 100

C
8      CALL QUERY_BOX(2,2,' Exit Program! Are you sure (Y/N) ? '
     &,KEY)
	IF( KEY .EQ. 'Y' ) THEN
		CALL CLOSE_FILE(IFILE_1,IERR)
		CALL CLOSE_FILE(IFILE_2,IERR)
		CALL CLOSE_WORKSTATION(ISCREEN)
		STOP
	ENDIF
	GOTO 100
	END


	SUBROUTINE INITIALISE_FILES
C
C	Initialisation
C
$INCLUDE: 'CDRCOM.FOR'
	CHARACTER KEY
C
C	CODE
C	----
C
	BIT_CURRENT = CONVERT_GAIN(GAIN_CURRENT)
C
	IERR = 0
	CALL OPEN_FILE(IFILE_1,IERR,'\gemapps\gemsys\CDR.DAT')
	IF(IERR.NE.0) THEN
		call move_cursor(3,10)
		CALL ASK_USER(
     &'File ... CDR.DAT not found on disc, Create new file (Y/N) ? '
     &,KEY)
		IF(KEY.EQ.'N') then
		    call get_screen_device( iscreen )
		    call close_workstation( iscreen )
		    stop
		endif
C
C		Create new file
C
		CALL DISPLAY_STRING(
     &'Size of file to be create (Mbyte) ? ')
		CALL GET_NUMBER(SIZE_MBYTE,.1,1000.,2.)
		MAX_RECORDS = IFIX(SIZE_MBYTE*512.*1024.
     &		/FLOAT(NP_RECORD)) - NP_BUFFER/NP_RECORD - 1
		CALL CREATE_FILE(IFILE_1,IERR,'\gemapps\gemsys\CDR.DAT')
		CALL WRITE_FILE(IFILE_1,IERR,IHEAD,1,1)
		NBLOCK = IFIX(SIZE_MBYTE*2048.)+1
		CALL WRITE_FILE(IFILE_1,IERR,IHEAD,NBLOCK,1)
		IF(IERR.NE.0) THEN
			CALL DISPLAY_STRING(
     &'ERROR ... Can''t create work file ... CDR.DAT')
			STOP
		ENDIF
C
C		Close and re-open to make permanent in case of a crash
C
		CALL CLOSE_FILE(IFILE_1,IERR)
		CALL OPEN_FILE(IFILE_1,IERR,'\gemapps\gemsys\CDR.DAT')
C
	ELSE
		CALL READ_FILE(IFILE_1,IERR,IHEAD,1,1)
	ENDIF
C
C	Open open/close state list file
C
	CALL OPEN_FILE(IFILE_2,IERR,'\gemapps\gemsys\CDR.EVE')
	IF(IERR.NE.0) then
	    caLL CREATE_FILE(IFILE_2,IERR,'\gemapps\gemsys\CDR.EVE')
	end if
	IF(IERR .NE. 0) THEN
		CALL DISPLAY_STRING(
     &'ERROR ... Can''t create event list file ... CDR.EVE')
		STOP
	ENDIF
	RETURN
	END

	BLOCK DATA
$INCLUDE: 'CDRCOM.FOR'
	DATA GAIN_CURRENT /100./
	DATA CAL_CURRENT,ICAL_CURRENT /0.,2048/
        data ical_cursor,ical_record /0,0/
	DATA DT /0.08/
	DATA RECORDING_TIME /10./
	DATA N_RECORDS,MAX_RECORDS,N_EVENTS /0,1,0/
	DATA RANGE_VOLTS /5./
	DATA TRIGGER_LEVEL,TRIGGER_TIME /10.,0./
	DATA DEAD_TIME,RUNNING_MEAN /20.,20./
	DATA INTERFACE_CARD /1/
	DATA TYPE_LIST /'REJECT','1     ','2     ','3     ','4     '/
	data file_name / 'Newfile.cdr' /
	data default_path / ' '/

	END

	SUBROUTINE SET_PARAMETERS
$INCLUDE: 'CDRCOM.FOR'
C
C	Get user entered operation parameters from keyboard
C	(check for valid range)
C
	PARAMETER(NROWS=5)
	CHARACTER*40 MENU(NROWS) /
     &	' Duration of recording (s)',
     &	' Calibration scale factor (mV/Units)',
     &	' Units ',
     &	' Digital sampling interval (ms)',
     &	' Lab. Interface range (1.25,2.5,5,10V)' /

	CHARACTER*12 TEXT(NROWS)
	character*50 title
C
C	CODE
C	----
C
C	Set up data entry form
C

	CALL LAB_LIMITS(MAX0(INTERFACE_CARD,1)
     &,DT_MIN,DT_MAX,AD_MIN,AD_MAX,DAC)

C
	WRITE(TEXT(1),'(f12.3)') RECORDING_TIME
	WRITE(TEXT(2),'(f12.3)') GAIN_CURRENT
	TEXT(3) = Y_UNITS
	WRITE(TEXT(4),'(f12.3)') DT
	WRITE(TEXT(5),'(f12.3)') RANGE_VOLTS
C
	title = ' '
100	if( title .eq. ' ' ) then
	    title = ' Set Recording/Analysis Parameters '
	endif
	CALL TEXT_WINDOW(MENU,TEXT,NROWS,2,5,title)

	i = 1
	recording_time = check_limits(text,0.,1E30,i,title)
	if( title .ne. ' ' ) goto 100

	i = i + 1
	gain_current = check_limits(text,0.,1E30,i,title)
	if( title .ne. ' ' ) goto 100
	bit_current = convert_gain( gain_current )

	i = i + 1
	ix = ileading_space( text(i) )
	y_units = text(i)(ix:ix+2)
C
	i = i + 1
	dt = check_limits(text,dt_min,dt_max,i,title)
	if( title .ne. ' ' ) goto 100

	i = i + 1
	range_volts = check_limits(text,ad_min,ad_max,i,title)
	if( title .ne. ' ' ) goto 100

C
C
C
C	Check that requested size of sample is within
C	limits of data file
C
	N_RECORDS = MIN0(IFIX( (RECORDING_TIME*1000.)
     &	/(DT*FLOAT(NP_RECORD)) ),MAX_RECORDS)
	RECORDING_TIME = FLOAT(N_RECORDS)*DT*FLOAT(NP_RECORD)/1000.
	BIT_CURRENT = CONVERT_GAIN(GAIN_CURRENT)
	ERROR =  ' '
	RETURN
	END

	REAL FUNCTION CONVERT_GAIN(GAIN_IN)
$INCLUDE: 'CDRCOM.FOR'
C
C	Derive "bit_value" from "gain" and vice_versa
C
	PARAMETER( ADC_MAX = 2048.)
	CONVERT_GAIN = 1000.*RANGE_VOLTS/(ADC_MAX*GAIN_IN)
	RETURN
	END

	SUBROUTINE PUT_RECORD(IRECORD_IN)
C
$INCLUDE: 'CDRCOM.FOR'
C
	IRECORD = IRECORD_IN
	IF(IRECORD .GT. N_RECORDS) IRECORD = N_RECORDS
	IF(IRECORD .LT. 1) IRECORD = 1
C
	IBLOCK =  (IRECORD - 1)*(NP_RECORD/NP_SECTOR) + 2
	CALL WRITE_FILE(IFILE_1,IERROR,IBUFFER,IBLOCK
     &,NP_RECORD/NP_SECTOR)
	RETURN
	END

	SUBROUTINE GET_RECORD(IRECORD_IN)
$INCLUDE: 'CDRCOM.FOR'
C
C	Ensure that record # remains within legal limits for file
C
	IRECORD = IRECORD_IN
	IF(IRECORD .GT. N_RECORDS) IRECORD = N_RECORDS
	IF(IRECORD .LT. 1) IRECORD = 1
C
	IBLOCK =  (IRECORD - 1)*(NP_RECORD/NP_SECTOR) + 2
	CALL READ_FILE(IFILE_1,IERROR,IBUFFER,IBLOCK
     &,NP_RECORD/NP_SECTOR)
	RETURN
	END
