unit PrintRec;
{ =================================================================
  WinWCP - Printer page/font setup form for printing signal records
  (called by REPLAY module)
  2/5/97 ... Calibration bar values only shown for enabled channels
  1/2/97 ... Line thickness and point size now text boxes
  =================================================================}
interface

uses WinTypes, WinProcs, Classes, Graphics, Forms, Controls, Buttons,
  StdCtrls, ExtCtrls,Printers,Global,Shared, Grids, SysUtils, Spin, fileio,
  PlotLib ;

type
  TPrintRecFrm = class(TForm)
    GroupBox1: TGroupBox;
    edLeftMargin: TEdit;
    Label1: TLabel;
    edTopMargin: TEdit;
    Label2: TLabel;
    edRightMargin: TEdit;
    Label3: TLabel;
    edBottomMargin: TEdit;
    Label4: TLabel;
    GroupBox2: TGroupBox;
    CalibrationBarTable: TStringGrid;
    GroupBox3: TGroupBox;
    Label5: TLabel;
    GroupBox4: TGroupBox;
    FontLab: TLabel;
    cbFonts: TComboBox;
    Label6: TLabel;
    GroupBox5: TGroupBox;
    ckShowZeroLevels: TCheckBox;
    ckShowLabels: TCheckBox;
    bPrint: TButton;
    bCancel: TButton;
    ckUseColor: TCheckBox;
    EdPointSize: TEdit;
    EdLineThickness: TEdit;
    procedure FormActivate(Sender: TObject);
    procedure bPrintClick(Sender: TObject);
    procedure EdPointSizeKeyPress(Sender: TObject; var Key: Char);
    procedure edLeftMarginKeyPress(Sender: TObject; var Key: Char);
  private
    { Private declarations }
  public
    { Public declarations }
  end;



var
  PrintRecFrm: TPrintRecFrm;

implementation

{$R *.DFM}
uses Replay,MDIform, maths ;


procedure TPrintRecFrm.FormActivate(Sender: TObject);
{ --------------------------------
  Initialise Print Record(s) form
  -------------------------------}
var
   n,ch,Row : Integer ;
begin

     { Fill Fonts list with typefaces available to printer }
     cbFonts.items := printer.fonts ;
     cbFonts.itemindex := cbFonts.items.indexof(Settings.Plot.FontName) ;
     if cbFonts.itemindex < 0 then  cbFonts.itemindex := 0 ;
     edPointSize.text := format( '%d pts',[Settings.Plot.FontSize]) ;

     edTopMargin.text := format( ' %.1f cm',[Settings.Plot.TopMargin]);
     edBottomMargin.text := format( ' %.1f cm',[Settings.Plot.BottomMargin]);
     edLeftMargin.text := format( ' %.1f cm',[Settings.Plot.LeftMargin]);
     edRightMargin.text := format( ' %.1f cm',[Settings.Plot.RightMargin]);
     edLineThickness.text := format( ' %d pts', [Settings.Plot.LineThickness] ) ;

     ckShowLabels.checked := Settings.ShowLabels ;
     ckShowZeroLevels.checked := Settings.ShowZeroLevels ;
     ckUseColor.checked := Settings.Plot.UseColor ;

     { Fill calibration bar table }

     { Set Column widths }
     CalibrationBarTable.colwidths[0] := Canvas.TextWidth('XXXXX') ;
     CalibrationBarTable.colwidths[1] := Canvas.TextWidth('XXXXXXXXX') ;

     CalibrationBarTable.options := [goEditing,goHorzLine,goVertLine] ;
     CalibrationBarTable.RowCount := fH.NumChannels + 1 ;
     CalibrationBarTable.cells[0,0] := 'Time ';

     CalibrationBarTable.cells[1,0] := Format( '%.1f %s',
                                       [Settings.TimeBarValue*Settings.TScale,
                                        Settings.TUnits]);

     { Adjust number of rows to number of enabled channels }
      n := 1 ;
      for ch := 0 to fH.NumChannels-1 do if Channel[ch].InUse then Inc(n) ;
      CalibrationBarTable.RowCount := n ;
     { Fill table with calibration bar data }
     Row := 1 ;
     for ch := 0 to fH.NumChannels-1 do if Channel[ch].InUse then begin
         CalibrationBarTable.cells[0,Row] := Channel[ch].ADCName ;
         CalibrationBarTable.cells[1,Row] := Format( '%.1f %s',
                                              [Settings.BarValue[ch],
                                               Channel[ch].ADCUnits]) ;
         Inc(Row) ;
         end ;

     { Ensure calibration bars have focus when dialog box opens }
     CalibrationBarTable.SetFocus ;

     end;


procedure TPrintRecFrm.bPrintClick(Sender: TObject);
{ -----------------------
  Update global settings
  ----------------------}
var
   Row,ch : Integer ;
begin

     { Set printer typeface and size }
     Settings.Plot.TopMargin := ExtractFloat(edTopMargin.text,
                                Settings.Plot.TopMargin) ;
     Settings.Plot.BottomMargin := ExtractFloat(edBottomMargin.text,
                                   Settings.Plot.BottomMargin) ;
     Settings.Plot.LeftMargin := ExtractFloat(edLeftMargin.text,
                                 Settings.Plot.LeftMargin) ;
     Settings.Plot.RightMargin := ExtractFloat(edRightMargin.text,
                                  Settings.Plot.RightMargin) ;
     Settings.Plot.LineThickness := ExtractInt( edLineThickness.text )  ;

     Settings.Plot.FontName := cbFonts.text ;
     Settings.Plot.FontSize := ExtractInt( edPointSize.text ) ;

     Settings.ShowLabels := ckShowLabels.checked ;
     Settings.ShowZeroLevels := ckShowZeroLevels.checked ;
     Settings.Plot.UseColor := ckUseColor.checked ;

     { Set calibration bars }
     Settings.TimeBarValue := ExtractFloat(CalibrationBarTable.cells[1,0], 1. )
                              * Settings.TUnscale ;
     Row := 1 ;
     for ch := 0 to fH.NumChannels-1 do if Channel[ch].InUse then begin
         Settings.BarValue[ch] := ExtractFloat(CalibrationBarTable.Cells[1,Row],10. ) ;
         Inc(Row) ;
         end ;

     end ;

procedure TPrintRecFrm.EdPointSizeKeyPress(Sender: TObject; var Key: Char);
{ ----------------
  Check font size
  ---------------}
begin
     if key = chr(13) then TEdit(Sender).text := format( ' %d pts',
                           [IntLimitTo(ExtractInt(TEdit(Sender).text),1,64)] ) ;
     end;

procedure TPrintRecFrm.edLeftMarginKeyPress(Sender: TObject;
  var Key: Char);
{ -----------------
  Check margin size
  -----------------}
begin
     if key = chr(13) then TEdit(Sender).text := format( ' %.1f cm',
                           [FloatLimitTo(ExtractFloat(TEdit(Sender).text,5.0),
                            0.0,10.0)]);
     end;

end.
