unit Setaxes;
{ =====================================
  WinWCP - Set X/Y Plot axes and labels
  2/2/97 ... Text boxes now used for font & line thickness
  =====================================}

interface

uses WinTypes, WinProcs, Classes, Graphics, Forms, Controls, Buttons,
  StdCtrls, Spin, Global, sysutils, shared ;

type
  TSetAxesFrm = class(TForm)
    XAxisGrp: TGroupBox;
    edXlo: TEdit;
    lbXMin: TLabel;
    edXHi: TEdit;
    lbxMax: TLabel;
    edXTic: TEdit;
    Label1: TLabel;
    cbXAxisType: TComboBox;
    YAxisGrp: TGroupBox;
    lbYMin: TLabel;
    lbYMax: TLabel;
    Label4: TLabel;
    edYLo: TEdit;
    edYHi: TEdit;
    EdYTic: TEdit;
    cbYAxisType: TComboBox;
    FontGrp: TGroupBox;
    cbFontName: TComboBox;
    Label2: TLabel;
    Label3: TLabel;
    TraceGrp: TGroupBox;
    ckMarkers: TCheckBox;
    ckLines: TCheckBox;
    bOK: TButton;
    bCancel: TButton;
    LabelsGrp: TGroupBox;
    EdXLab: TEdit;
    Label5: TLabel;
    edYLab: TEdit;
    Label6: TLabel;
    edTitle: TEdit;
    Label7: TLabel;
    Label8: TLabel;
    Label9: TLabel;
    EdLineThickness: TEdit;
    EdMarkerSize: TEdit;
    EdFontSize: TEdit;
    procedure FormActivate(Sender: TObject);
    procedure bOKClick(Sender: TObject);
    procedure bCancelClick(Sender: TObject);
    procedure EdLineThicknessKeyPress(Sender: TObject; var Key: Char);
  private
    { Private declarations }
  public
    { Public declarations }
    SetPlot : TPlot ;
  end;

var
  SetAxesFrm: TSetAxesFrm;

implementation

{$R *.DFM}


uses maths ;

procedure TSetAxesFrm.FormActivate(Sender: TObject);
begin

     edxLo.text :=  format( ' %8.3g', [SetPlot.XAxis.Lo] );
     edxHi.text :=  format( ' %8.3g', [SetPlot.XAxis.Hi] );
     edxTic.text := format( ' %8.3g', [SetPlot.XAxis.Tic] );
     if SetPlot.XAxis.log then cbXAxisType.itemindex := 1
                          else cbXAxisType.itemindex := 0 ;

     edyLo.text :=  format( ' %8.3g', [SetPlot.yAxis.Lo] );
     edyHi.text :=  format( ' %8.3g', [SetPlot.yAxis.Hi] );
     edyTic.text := format( ' %8.3g', [SetPlot.yAxis.Tic] );
     if SetPlot.YAxis.log then cbYAxisType.itemindex := 1
                       else cbYAxisType.itemindex := 0 ;

     EdXLab.text := SetPlot.XAxis.lab ;
     EdYLab.text := SetPlot.YAxis.lab ;
     EdTitle.text := SetPlot.title ;

     cbFontName.clear ;
     cbFontName.sorted := True ;
     cbFontName.items := screen.fonts ;
     cbFontName.ItemIndex := cbFontname.items.indexof( Settings.Plot.FontName ) ;
     edFontSize.text := format( ' %d pts', [Settings.Plot.FontSize] ) ;
     edMarkerSize.text := format( ' %d pts', [Settings.Plot.MarkerSize] ) ;
     edLineThickness.text := format( ' %d pts', [Settings.Plot.LineThickness] ) ;

     ckLines.checked := Settings.Plot.ShowLines ;
     ckMarkers.checked := Settings.Plot.ShowMarkers ;

     end;

procedure TSetAxesFrm.bOKClick(Sender: TObject);
begin

     { Update SetAxes's local Plot record }

     SetPlot.XAxis.Lo := ExtractFloat( edXlo.text, SetPlot.XAxis.Lo ) ;
     SetPlot.XAxis.Hi := ExtractFloat( edXHi.text, SetPlot.XAxis.Hi ) ;
     SetPlot.XAxis.Tic := ExtractFloat( edXTic.text, SetPlot.XAxis.Tic ) ;
     if cbXAxisType.itemIndex = 0 then SetPlot.XAxis.log := false
                                  else SetPlot.XAxis.log := True ;
     SetPlot.YAxis.Lo := ExtractFloat( edYlo.text, SetPlot.YAxis.Lo ) ;
     SetPlot.YAxis.Hi := ExtractFloat( edYHi.text, SetPlot.YAxis.Hi ) ;
     SetPlot.YAxis.Tic := ExtractFloat( edYTic.text, SetPlot.YAxis.Tic ) ;
     if cbYAxisType.itemIndex = 0 then SetPlot.YAxis.log := false
                                  else SetPlot.YAxis.log := True ;
     SetPlot.XAxis.Lab := edXLab.text ;
     SetPlot.YAxis.Lab := edYLab.text ;
     SetPlot.Title := edTitle.text ;

     Settings.Plot.FontName := cbFontName.text ;
     Settings.Plot.FontSize := ExtractInt(edFontSize.text) ;
     Settings.Plot.MarkerSize := ExtractInt(edMarkerSize.text) ;
     Settings.Plot.LineThickness := ExtractInt(edLineThickness.text) ;

     Settings.Plot.ShowLines :=  ckLines.checked ;
     Settings.Plot.ShowMarkers := ckMarkers.checked ;

     SetAxesFrm.Hide ;
     end;

procedure TSetAxesFrm.bCancelClick(Sender: TObject);
begin
     SetAxesFrm.Hide ;
     end;

procedure TSetAxesFrm.EdLineThicknessKeyPress(Sender: TObject;
  var Key: Char);
{ ----------------
  Check point size
  ----------------}
begin
     if key = chr(13) then TEdit(Sender).text := format( ' %d pts',
                           [IntLimitTo(ExtractInt(TEdit(Sender).text),1,64)] ) ;
     end;

end.
