unit Printgra;
{ =======================================================
  Print a graph or histogram
  30/5/97 ... Margins now checked when return key pressed
  =======================================================}

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, StdCtrls, Spin, Buttons, Global, Printers, Shared ;

type
  TPrintGraphFrm = class(TForm)
    GroupBox1: TGroupBox;
    Label1: TLabel;
    Label2: TLabel;
    Label3: TLabel;
    Label4: TLabel;
    edLeftMargin: TEdit;
    edTopMargin: TEdit;
    edRightMargin: TEdit;
    edBottomMargin: TEdit;
    bOK: TButton;
    bCancel: TButton;
    procedure FormShow(Sender: TObject);
    procedure bOKClick(Sender: TObject);
    procedure edRightMarginKeyPress(Sender: TObject; var Key: Char);
    procedure edTopMarginKeyPress(Sender: TObject; var Key: Char);
    procedure edBottomMarginKeyPress(Sender: TObject; var Key: Char);
    procedure edLeftMarginKeyPress(Sender: TObject; var Key: Char);
  private
    { Private declarations }
  public
    { Public declarations }
    Plot : TPlot ;
  end;

var
  PrintGraphFrm: TPrintGraphFrm;

implementation

{$R *.DFM}


procedure TPrintGraphFrm.FormShow(Sender: TObject);
begin
     edTopMargin.text := format( '%.1f cm',[Settings.Plot.TopMargin]);
     edBottomMargin.text := format( '%.1f cm',[Settings.Plot.BottomMargin]);
     edLeftMargin.text := format( '%.1f cm',[Settings.Plot.LeftMargin]);
     edRightMargin.text := format( '%.1f cm',[Settings.Plot.RightMargin]);
     end;

procedure TPrintGraphFrm.bOKClick(Sender: TObject);
begin

     Settings.Plot.TopMargin := ExtractFloat(edTopMargin.text,
                                Settings.Plot.TopMargin) ;
     Settings.Plot.BottomMargin := ExtractFloat(edBottomMargin.text,
                                   Settings.Plot.BottomMargin) ;
     Settings.Plot.LeftMargin := ExtractFloat(edLeftMargin.text,
                                 Settings.Plot.LeftMargin) ;
     Settings.Plot.RightMargin := ExtractFloat(edRightMargin.text,
                                  Settings.Plot.RightMargin) ;

     hide ;

     end;


procedure TPrintGraphFrm.edRightMarginKeyPress(Sender: TObject;
  var Key: Char);
begin
     if key = chr(13) then
        edRightMargin.text := format( '%.1f cm',
        [ExtractFloat(edRightMargin.text,Settings.Plot.RightMargin)]);
     end;


procedure TPrintGraphFrm.edTopMarginKeyPress(Sender: TObject;
  var Key: Char);
begin
     if key = chr(13) then
        edTopMargin.text := format( '%.1f cm',
        [ExtractFloat(edTopMargin.text,Settings.Plot.TopMargin)]);
     end;


procedure TPrintGraphFrm.edBottomMarginKeyPress(Sender: TObject;
  var Key: Char);
begin
     if key = chr(13) then
        edBottomMargin.text := format( '%.1f cm',
        [ExtractFloat(edBottomMargin.text,Settings.Plot.BottomMargin)]);
     end;


procedure TPrintGraphFrm.edLeftMarginKeyPress(Sender: TObject;
  var Key: Char);
begin
     if key = chr(13) then
        edLeftMargin.text := format( '%.1f cm',
        [ExtractFloat(edLeftMargin.text,Settings.Plot.LeftMargin)]);
     end;


end.
