unit Curvfit1;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, StdCtrls, SSQUnit, Shared ;

type
  TFitSetupFrm = class(TForm)
    ParametersGrp: TGroupBox;
    ckFixed0: TCheckBox;
    Label2: TLabel;
    Edpar0: TEdit;
    lbPar0: TLabel;
    lbPar1: TLabel;
    EdPar1: TEdit;
    ckFixed1: TCheckBox;
    lbPar2: TLabel;
    EdPar2: TEdit;
    ckFixed2: TCheckBox;
    lbPar3: TLabel;
    EdPar3: TEdit;
    ckFixed3: TCheckBox;
    lbPar4: TLabel;
    EdPar4: TEdit;
    ckFixed4: TCheckBox;
    lbPar5: TLabel;
    EdPar5: TEdit;
    ckFixed5: TCheckBox;
    lbPar6: TLabel;
    Edpar6: TEdit;
    ckFixed6: TCheckBox;
    lbPar7: TLabel;
    Edpar7: TEdit;
    ckFixed7: TCheckBox;
    bOK: TButton;
    bCancel: TButton;
    Label1: TLabel;
    procedure FormShow(Sender: TObject);
    procedure bOKClick(Sender: TObject);
    procedure bCancelClick(Sender: TObject);
  private
    { Private declarations }
    procedure SetParameterLine( var lb : TLabel ;
                                var ed : TEdit ;
                                var ck : TCheckBox ;
                                ParNum : LongInt ) ;
    procedure GetParameterLine( const ed : TEdit ;
                                const ck : TCheckBox ;
                                ParNum : LongInt ) ;

  public
    { Public declarations }
    Equation : TEquation ;
    XUnits : string[8] ;
    YUnits : string[8] ;

  end;

var
  FitSetupFrm: TFitSetupFrm;

implementation


{$R *.DFM}
var
   TScale : Array[0..8] of Single ;

procedure TFitSetupFrm.FormShow(Sender: TObject);
{ ---------------------------------------
  Initialisation when dialog formis shown
  ---------------------------------------}
begin
     SetParameterLine( lbPar0, edPar0,  ckFixed0, 0 ) ;
     SetParameterLine( lbPar1, edPar1,  ckFixed1, 1) ;
     SetParameterLine( lbPar2, edPar2,  ckFixed2, 2 ) ;
     SetParameterLine( lbPar3, edPar3,  ckFixed3, 3 ) ;
     SetParameterLine( lbPar4, edPar4,  ckFixed4, 4 ) ;
     SetParameterLine( lbPar5, edPar5,  ckFixed5, 5 ) ;
     SetParameterLine( lbPar6, edPar6,  ckFixed6, 6 ) ;
     SetParameterLine( lbPar7, edPar7,  ckFixed7, 7 ) ;
     end;


procedure TFitSetupFrm.SetParameterLine( var lb : TLabel ;
                                         var ed : TEdit ;
                                         var ck : TCheckBox ;
                                         ParNum : LongInt ) ;
{ -------------------------------------------
  Create parameter line on form from Equation
  -------------------------------------------}
var
   s,ParName,ParUnits : string ;
   nPars : LongInt ;
begin
     nPars := GetNumEquationParameters( Equation ) ;
     if ParNum < nPars then begin
        GetParameterInfo( Equation, ParName , ParUnits, XUnits, YUnits, ParNum ) ;
        lb.caption := ParName ;
        if Pos( 'ms', ParUnits ) > 0 then TScale[ParNum] := 1000.
                                     else TScale[ParNum] := 1. ;
        ed.text := format('%8.3g', [Equation.Par[ParNum]*TScale[ParNum]])
                   + ' ' + ParUnits ;
        ed.enabled := True ;
        ck.Enabled := True ;
        if Equation.ParSD[ParNum] = -1. then ck.Checked := True
                                        else ck.Checked := False ;
        lb.Visible := True ;
        end
     else begin
        lb.visible := False ;
        ed.text := '' ;
        ed.enabled := False ;
        ck.enabled := False ;
        ck.checked := False ;
        end ;
     end ;

procedure TFitSetupFrm.GetParameterLine( const ed : TEdit ;
                                         const ck : TCheckBox ;
                                         ParNum : LongInt ) ;
{ -----------------------------------------------
  Read parameter line on form and update Equation
  -----------------------------------------------}
begin
     if ed.enabled then  begin
        equation.Par[ParNum] := ExtractFloat( ed.text,
                                Equation.Par[ParNum]*TScale[ParNum] ) /
                                TScale[ParNum] ;
        if ck.Checked then equation.ParSD[ParNum] := -1.
                      else equation.ParSD[ParNum] := 0. ;
        end ;
     end ;


procedure TFitSetupFrm.bOKClick(Sender: TObject);
begin
     GetParameterLine( edPar0, ckFixed0, 0 ) ;
     GetParameterLine( edPar1, ckFixed1, 1 ) ;
     GetParameterLine( edPar2, ckFixed2, 2 ) ;
     GetParameterLine( edPar3, ckFixed3, 3 ) ;
     GetParameterLine( edPar4, ckFixed4, 4 ) ;
     GetParameterLine( edPar5, ckFixed5, 5 ) ;
     GetParameterLine( edPar6, ckFixed6, 6 ) ;
     GetParameterLine( edPar7, ckFixed7, 7 ) ;
     Equation.ParametersSet := True ;
     hide ;
     end;

procedure TFitSetupFrm.bCancelClick(Sender: TObject);
begin
     hide ;
     end;

end.
