unit Global;
{ ==============================================
  WinCDR - Global variables and type definitions
  (c) J. Dempster 1998
  ==============================================}
interface

uses sysUtils, Graphics, Classes, SSQUnit ;

const
     FileVersion = 7.0 ;
     MaxADCValue = 2047 ;
     MinADCValue = -2048 ;
     MaxDACValue = 2047 ;
     MinDACValue = -2048 ;
     MinDT = 1.5E-5 ;
     NumDACChannels = 2 ;
     ChannelLimit = 5 ;
     NumSamplesPerSector = 256 ;
     NumBytesPerSector = NumSamplesPerSector*2 ;
     VarLimit = 13 ;
     FitVarLimit = 10 ;
     MaxTBuf = 29951 ;
     VoltsTomV = 1000. ;
     mVToVolts = 1E-3 ;
     AmpsTonA = 1E9 ;
     nAToAmps = 1E-9 ;
     nSToSeimens = 1E-9 ;
     msToSecs = 1E-3 ;
     SecsToms = 1E3 ;
     pFToFarad = 1E-12 ;
     FaradTopF = 1E12 ;
     MinSingle = 1.5E-45 ;
     { Variable constants }
     vRecord = 0 ;
     vGroup = 1 ;
     vTime = 2 ;
     vAverage = 3 ;
     vArea = 4 ;
     vPeak = 5 ;
     vVariance = 6 ;
     vRiseTime = 7 ;
     vRateofRise = 8 ;
     vLatency = 9 ;
     vT50 = 10 ;
     vT90 = 11 ;
     vInterval = 12 ;
     vBaseline = 13 ;
     BitMapsMinSize = 16 ;
     BitMapsMaxSize = 10000 ;
     EmptyFlag = 32767 ;
     MaxSingle = 16382 ;
type
    TDestination = (ToPrinter,ToClipboard) ;
    TIntArray = Array[0..MaxTBuf] of SmallInt ;
    TSingleArray = Array[0..MaxSingle] of Single ;
    TLongIntArray = Array[0..MaxSingle] of LongInt ;
    TBooleanArray = Array[0..MaxSingle] of Boolean ;
    THeapBufferOp = (Allocate,Deallocate) ;
    TADCRange = string[20] ;
    TRecType = ( Background,Test) ;
    TRecordStatus = record
                  Valid : boolean ;
                  RecType : TRecType ;
                  end ;
    TRecordStatusArray = Array[0..MaxSingle] of TRecordStatus ;

    TAnalysis = record
          Available : boolean ;
          VarName : array[0..VarLimit] of string[12] ;
          ChannelName : array[0..ChannelLimit] of string[4] ;
          Units : array[0..ChannelLimit,0..VarLimit] of string[8] ;
          UnitsScale : array[0..ChannelLimit,0..VarLimit] of single ;
          Value : array[0..ChannelLimit,0..VarLimit] of single ;
          MaxValue : array[0..ChannelLimit,0..VarLimit] of single ;
          MinValue : array[0..ChannelLimit,0..VarLimit] of single ;
          Mean : array[0..ChannelLimit,0..VarLimit] of single ;
          StDev : array[0..ChannelLimit,0..VarLimit] of single ;
          StErr : array[0..ChannelLimit,0..VarLimit] of single ;
          InSummary : array[0..VarLimit] of Boolean ;
          Num : LongInt ;
          NumVariables : LongInt ;
          end ;


{ Data record header block }
TWCPRecHeader = record
           Status : string[8] ;
           RecType : string[4] ;
           Number : Single ;
           Time : Single ;
           dt : Single ;
           ADCVoltageRange : array[0..ChannelLimit] of Single ;
           Analysis : TAnalysis ;
           Equation : TEquation ;
           Ident : string[16] ;
           end ;

{ WCP data file header block }
TWCPFileHeader = record
            FileName : string ;
            FileHandle : integer ;
            NumSamples : LongInt ;
            NumChannels : LongInt ;
            NumSamplesPerRecord : LongInt ;
            NumBytesPerRecord : LongInt ;
            NumDataBytesPerRecord : LongInt ;
            NumAnalysisBytesPerRecord : LongInt ;
            NumBytesInHeader : LongInt ;
            NumRecords : LongInt ;
            RecordNum : LongInt ;
            dt : single ;
            ADCVoltageRange : single ;
            ADCMaxBits : single ;
            NumZeroAvg : LongInt ;
            IdentLine : string[76] ;
            Version : Single ;
            CurrentRecord : LongInt ;
            SaveHeader : Boolean ;
            end ;

{ CDr data file header block }
TCDRFileHeader = record
            FileName : string ;
            WCPFileName : string ;
            FileHandle : integer ;
            FilePointer : LongInt ;
            NumSamples : LongInt ;
            NumChannels : LongInt ;
            NumSamplesInFile : LongInt ;
            NumBlocksInFile : LongInt ;
            NumSamplesPerBlock : LongInt ;
            NumBytesPerBlock : LongInt ;
            NumBytesInHeader : LongInt ;
            RecordDuration : single ;
            RecordNum : LongInt ;
            dt : single ;
            ADCVoltageRange : single ;
            ADCMaxBits : single ;
            IdentLine : string[76] ;
            Version : Single ;
            SaveHeader : Boolean ;
            end ;


TString4 = string[4] ;
TString6 = string[6] ;
TString8 = string[8] ;
TChannel = record
         xMin : single ;
         xMax : single ;
         yMin : single ;
         yMax : single ;
         xScale : single ;
         yScale : single ;
         Left : LongInt ;
         Right : LongInt ;
         Top : LongInt ;
         Bottom : LongInt ;
         TimeZero : single ;
         ADCZero : LongInt ;
         ADCZeroAt : LongInt ;
         ADCSCale : single ;
         ADCCalibrationFactor : single ;
         ADCCalibrationValue : single ;
         ADCAmplifierGain : single ;
         ADCUnits : Tstring6 ;
         ADCName : TString6 ;
         InUse : Boolean ;
         ChannelOffset : LongInt ;
         CursorIndex : LongInt ;
         ZeroIndex : LongInt ;
         CursorTime : single ;
         CursorValue : single ;
         Cursor0 : Integer ;
         Cursor1 : Integer ;
         TZeroCursor : Integer ;
         color : TColor ;
         end ;

TAxis = record
      Lo : Single ;
      Hi : Single ;
      Lo1 : Single ;
      Hi1 : Single ;
      Tic : Single ;
      Min : Single ;
      Max : single ;
      Position : LongInt ;
      Scale : single ;
      Log : Boolean ;
      Lab : string ;
      AutoRange : Boolean ;
      StartofTickLabels : Integer ;
      end ;

TPlot = record
      Left : LongInt ;
      Right : LongInt ;
      Top : LongInt ;
      Bottom : LongInt ;
      XAxis : TAxis ;
      YAxis : TAxis ;
      Title : string ;
      FontName : string ;
      FontSize : LongInt ;
      NumGraphs : LongInt ;
      BinBorders : Boolean ;
      BinFillStyle : TBrushStyle ;
      BinFillColor : TColor ;
      LineThickness : LongInt ;
      MarkerSize : LongInt ;
      end ;

TSealTest = record
          CurrentChannel : LongInt ;
          VoltageChannel : LongInt ;
          HoldingVoltage1 : single ;
          HoldingVoltage2 : single ;
          HoldingVoltage3 : single ;
          PulseHeight : single ;
          PulseHeight1 : single ;
          PulseHeight2 : single ;
          PulseHeight3 : single ;
          PulseWidth : single ;
          Use : LongInt ;
          AutoScale : Boolean ;
          DisplayScale : LongInt ;
          yMin : Array[0..ChannelLimit] of LongInt ;
          yMax : Array[0..ChannelLimit] of LongInt ;
          FreeRun : Boolean ;
          FirstSweep : Boolean ;
          end ;

TVCommand = record
          DivideFactor : single ;
          HoldingVoltage : single ;
          HoldingVoltageAlt : single ;
          end ;

TDigitalPort = record
             Value : LongInt ;
             end ;
TEventDetector = record
               Channel : LongInt ;
               yThreshold : single ;
               tThreshold : single ;
               DeadTime : single ;
               BaselineAverage : single ;
               RecordSize : LongInt ;
               PreTriggerPercentage : single ;
               end ;
TPageSettings = record
              FontName : string ;
              FontSize : LongInt ;
              LineThickness : LongInt ;
              ShowLines : boolean ;
              MarkerSize : LongInt ;
              ShowMarkers : boolean ;
              LeftMargin : single ;
              RightMargin : single ;
              TopMargin : single ;
              BottomMargin : single ;
              UseColor : boolean ;
              end ;

TCED1902 = record
           ComPort : LongInt ;
           InUse : Boolean ;
           Input : LongInt ;
           InputName : string[16] ;
           Gain : LongInt ;
           GainValue : Single ;
           HPFilter : LongInt ;
           HPFilterValue : Single ;
           LPFilter : LongInt ;
           LPFilterValue : Single ;
           NotchFilter : LongInt ;
           ACCoupled : LongInt ;
           DCOffset : LongInt ;
           end ;

TVarianceSettings = record
                  RecordSize : LongInt ;
                  RecordOverlap : LongInt ;
                  TauRise : Single ;
                  TauDecay : single ;
                  end ;
TSettings = record

          TriggerMode : string[1] ;
          EventDetector : TEventDetector ;
          AutoErase : Boolean ;
          NumRecordsRequired : LongInt ;
          RecordDuration : Single ;
          NumBytesRequired : LongInt ;
          DisplayDuration : Single ;
          Variance : TVarianceSettings ;
          VProgramFileName : string ;
          VCommand : TVCommand ;
          DigitalPort : TDigitalPort ;
          UpdateOutputs : boolean ;
          TopMargin : LongInt ;
          TopLine : LongInt ;
          BottomMargin : LongInt ;
          LeftMargin : LongInt ;
          RightMargin : LongInt ;
          Plot : TPageSettings ;
          ZeroLevels : boolean ;
          BarValue : array[0..ChannelLimit] of single ;
          TimeBarValue : single ;
          ShowLabels : boolean ;
          ShowZeroLevels : boolean ;
          CutOffFrequency : single ;
          MinDACInterval : single ;
          MinSamplingInterval : single ;
          MaxSamplingInterval : single ;
          SealTest : TSealTest ;
          TUnits : string[2] ;
          TScale : single ;
          TUnScale : single ;
          BitmapWidth : LongInt ;
          BitmapHeight : LongInt ;
          SectorWriteTime : single ;
          DataDirectory : string ;
          ProgDirectory : string ;
          VProtDirectory : string ;
          WavGenNoDisplay : boolean ;
          LaboratoryInterface : LongInt ;
          CED1902 : TCED1902 ;
          DD1200IOPort : LongInt ;
          DD1200IRQ : LongInt ;
          DD1200DMA : LongInt ;
          NIDisableDMA : Boolean ;
          end ;

{TDisplayList = record
                 List : array[0..200] of LongInt ;
                 OnDisplay : array[0..200] of Boolean ;
                 Latest : LongInt ;
                 EndofList : Integer ;
                 ActiveRecord : Integer ;
                 ActiveRecordIndex : Integer ;
                 Refresh : Boolean ;
                 end ;}

TWaveShape = ( wvNone, wvStep0, wvStep1, wvStep2, wvRamp, wvpTrain, wvWave,
               wvDigStep0,wvDigStep1, wvDigTrain ) ;

TWaveform = record
          Shape : Array[0..17] of TWaveShape ;
          Amplitude :     Array[0..17] of Single ;
          Duration :      Array[0..17] of Single ;
          Increment :     Array[0..17] of Single ;
          RampStart :     Array[0..17] of Single ;
          RampEnd :       Array[0..17] of Single ;
          PulseInterval : Array[0..17] of Single ;
          NumPulses : Array[0..17] of LongInt ;
          Period :        Array[0..17] of Single ;
          Delay :         Array[0..17] of Single ;
          Invert :        Array[0..17] of Boolean ;
          HoldingVoltage : Single ;
          VMin : Single ;
          VMax : Single ;
          RecordInterval : Single ;
          RecordDuration : Single ;
          RecordDelay : Single ;
          RecordDelayIncrement : Single ;
          NumSteps : LongInt ;
          NumRepeats : LongInt ;
          dt : Single ;
          DACdt : Single ;
          FileName : string ;
          ExtWaveData : Array[0..1023] of single ;
          ExtEndOfData : Integer ;
          ExtDACdt : single ;
          NextFile : string ;
          StepCounter : LongInt ;
          RepeatCounter : LongInt ;
          EndOfProtocol : LongInt ;
          EndofInterval : LongInt ;
          LeakCounter : longint ;
          NumLeaks : LongInt ;
          DigitalInUse : Boolean ;
          DigitalPortValue : LongInt ;
          RecordingStart : LongInt ;
          InUse : Boolean ;
          Saved : Boolean ;
          RecordIntervalChanged : boolean ;
          LeakScale : LongInt ;
          NextProtocolFileName : string ;
          end ;

TBuf = class(TObject)
     Buf : array[0..MaxTBuf] of Integer ;
     end ;

Txy = record
    x : Single ;
    y : Single ;
    end ;

TMarkerShape = ( SquareMarker, CircleMarker ) ;
TxyBuf = class(TObject)
         NumPoints : LongInt ;
         x : array[0..4096] of Single ;
         y : array[0..4096] of Single ;
         MarkerShape : TMarkerShape ;
         MarkerSize : LongInt ;
         MarkerSolid : Boolean ;
         Color : TColor ;
         end ;

TViewBuf = record
         nPoints : LongInt ;
         x : array[0..1000] of Single ;
         YMin : array[0..ChannelLimit,0..1000] of Integer ;
         YMax : array[0..ChannelLimit,0..1000] of Integer ;
         tDisplay : single ;
         xMin : single ;
         xMax : single ;
         ChannelSelected : Integer ;
         end ;

{ Histogram record }
TBin = record
     Lo : Single ;
     Mid : Single ;
     Hi :  Single ;
     y : Single ;
     end ;

THistBuf = class(TObject)
         NumBins : LongInt ;
         Bin : array[0..1000] of TBin ;
         yHi : Single ;
         BinWidth : Single ;
         end ;

TWCPClipboardRecord = record
                    Channel : Array[0..ChannelLimit] of TChannel ;
                    FileHdr : TWCPFileHeader ;
                    RecHdr : TWCPRecHeader ;
                    ADC : TIntArray ;
                    end ;


{ Global Variables }
var
fH : TWCPFileHeader ;
CdrFH : TCDRFileHeader ;
Channel : array[0..ChannelLimit] of TChannel ;
WCPfH : TWCPFileHeader ;
WCPChannel : Array[0..ChannelLimit] of TChannel ;
RecordTypes : TStringList ;
ChannelNames : TStringList ;
Settings : TSettings ;
CED1902A : TCED1902 ;
LogFileName : string ;
CF_WCPFormat : Word ;
QuantChildExists : boolean ;
implementation


end.
