	SUBROUTINE SSQMIN(X,M,N,ITMAX,IPRINT,NUMSIG,NSIGSQ,DELTA,
     &	RMACH,W,SLTJJ,ICONV,ITER,SSQ,F,FUNC,work)
	real work(1)
C
C       V1.1 Modified from Bryant/Brown listing
C       J.DEMPSTER 28-NOV-82
C
C       Function parameter array
        REAL X(N)
C       Super-lower triangle matrix
        REAL SLTJJ(1)
C       Machine precision constants
        REAL RMACH(2)
C       Residual array length(ydat - yfit)
        REAL F(M)
C       Weighting array
        REAL W(M)
C       Work buffer
C
C
	INTEGER JACSS,GRADSS,FPLSS,DIAGSS,JACM1,GRDM1,FPLM1,DIAGM1,
     &	ENDSS,DELEND,FMNSS,GRDEND,XBADSS,XBEND
        EXTERNAL FUNC
C
C       Work buffer structure
C
C      (1+N(N-1)/2)
C      :---------:------N*M----------:-----------:
C      1         JACSS               GRADSS      GRDEND
C
C                :--N--:             :----M------------:---N----:
C                      DELEND        FPLSS             DIAGSS   ENDSS
C                                                                :--->cont.
C                                                                FMNSS
C
C       :-------M------:--N-1---:
C       FMNSS          XBADSS   XBEND
C
C
C
C
C               SSQMIN   ------   VERSION II.
C
C       ORIGINAL SOURCE FOR SSQMIN WAS GIFT FROM K. BROWN, 3/19/76.
C       PROGRAM WAS MODIFIED A FOLLOWS:
C
C       1.      WEIGHTING VECTOR W(1) WAS ADDED SO THAT ALL RESIDUALS
C	EQUAL F(I) * SQRT1(W(I)).
C
C       2.      THE VARIABLE KOUT WHICH INDICATED ON EXIT WHETHER F(I)
C       WAS CALCULATED FROM UPDATED X(J) WAS REMOVED. IN
C       CONDITIONS WHERE KOUT =0 THE NEW F(I)'S AND AN UPDATED
C       SSQ IS OUTPUTTED . SSQ ( SUM WEIGHTED F(I) SQUARED )
C       WAS PUT INTO THE CALL STRING.
C
C       3.      A NEW ARRAY SLTJJ(K) WHICH CONTAINS THE SUPER LOWER
C       TRIANGLE OF JOCOBIAN (TRANSPOSE)*JACOBIAN WAS ADDED TO THE
C       CALL STRING. IT HAS THE SIZE N*(N+1)/2 AND IS USED FOR
C       CALCULATING THE STATSTICS OF THE FIT. STORAGE OF
C       ELEMENTS IS AS FOLLOWS:C(1,1),C(2,1),C(2,2),C(3,2),C(3,3),
C       C(4,1)........
C       NOTE THE AREA WORK (1) THROU WORK (JACM1) IN WHICH SLTJJ
C       IS INITALLY STORED IS WRITTEN OVER (DO 52) IN CHOLESKY
C       AND IS NOT AVAILABLE ON RETURN.
C
C       4.      A BUG DUE TO SUBSCRIPTING W(I) OUT OF BOUNDS WAS
C       CORRECTED IN MAY '79. THE CRITERION FOR SWITCHING FROM
C       FORWARD DIFFERENCES (ISW=1) TO CENTRAL DIFFERENCES
C       (ISW = 2) FOR THE PARTIAL DERIVATIVE ESTIMATES IS SET
C       IN STATEMENT 27 (ERL2.LT.GRCIT).GRCIT IS INITALIZED
C       TO 1.E-3 AS IN ORIGINAL PROGRAM. THE VARIABLE T IN
C       CHOLESKY WAS MADE TT TO AVIOD CONFUSION WITH ARRAY T.
C
C       SSQMIN -- IS A FINITE DIFFERENCE LEVENBERG-MARQUARDT LEAST
C       SQUARES ALGORTHM. GIVEN THE USER SUPPLIED INITIAL
C       ESTIMATE FOR X, SSQMIN FINDS THE MINIMUM OF
C       SUM ((F (X ,....,X ) ) ** 2)   J=1,2,.....M
C              J  1       N   J
C       BY A MODIFICATION OF THE LEVENBERG-MARQUARDT ALGORITHM
C       WHICH INCLUDES INTERNAL SCALING AND ELIMINATES THE
C       NEED FOR EXPLICIT DERIVATIVES. THE F (X ,...,X )
C                           J  1      N
C       CAN BE TAKEN TO BE THE RESIDUALS OBTAINED WHEN FITTING
C       NON-LINEAR MODEL, G, TO DATA Y IN THE LEAST SQUARES
C       SENSE ..., I.E.,TAKE
C               F (X ,...,X ) = G (X ,...,X ) - Y
C                J  1      N     J  1      N
C       REFERENCES:
C
C       BROWN,K.M. AND DENNIS,J.S. DERIVATIVE FREE ANALOGS OF
C       THE LEVENBERG-MARQUARDT AND GAUSS ALGORITHMS FOR
C       NON-LINEAR LEAST SQUARES APPROXIMATION. NUMERISCHE
C       MATHEMATIK 18:289 -297  (1972).
C       BROWN,K.M.  COMPUTER ORIENTED METHODS FOR FITTING
C       TABULAR DATA IN THE LINEAR AND NON-LINEAR LEAST SQUARES
C       SENSE.  TECHNICIAL REPORT NO. 72-13. DEPT..COMPUTER &
C       INFORM. SCIENCES; 114 LIND HALL, UNIVERSITY OF
C       MINNESOTA, MINNEAPOLIS, MINNESOTA  5545.
C
C       PARAMETERS :
C
C       X       REAL ARRAY WITH DIMENSION N.
C               INPUT --- INITIAL ESTIMATES
C               OUTPUT -- VALUES AT MIN (OR FINAL APPROXIMATION)
C
C       M       THE NUMBER OF RESIDUALS (OBSERVATIONS)
C
C       N       THE NUMBER OF UNKNOWN PARAMETERS
C
C       ITMAX   THE MAXIMUM NUMBER OF ITERATIONS TO BE ALLOWED
C               NOTE-- THE MAXIMUM NUMBER OF FUNCTION EVALUATIONS
C               ALLOWED IS ROUGHLY (N+1)*ITMAX  .
C
C       IPRINT  AN OUTPUT PARAMETER. IF IPRINT IS NON ZERO CONTROL
C               IS PASSED ONCE DURING EACH ITERATION TO SUBROUTINE
C               PRNOUT WHICH PRINTS INTERMEDIATE RESULTS (SEE BELOW)
C               IF IPRINT IS ZERO NO CALL IS MADE.
C
C       NUMSIG  FIRST CONVERGENCE CRITERION. CONVERGENCE CONDITION
C               SATISFIED IF ALL COMPONENTS OF TWO SUCCESSIVE
C               ITERATES AGREE TO NUMSIG DIGITS.
C
C       NSIGSQ  SECOND CONVERGENCE CRITERION. CONVERGENCE CONDITIONS
C               SATISFIED IF SUM OF SQUARES OF RESIDUALS FOR TWO
C               SUCCESSIVE ITERATIONS AGREE TO NSIGSQ DIGITS.
C
C       DELTA   THIRD CONVERGENCE CRITERION. CONVERGENCE CONDITIONS
C               SATISFIED IF THE EUCLIDEAN NORM OF THE APPROXIMATE
C               GRADIENT VECTOR IS LESS THAN DELTA.
C
C         ***************  NOTE  ********************************
C
C               THE ITERATION WILL TERMIATE ( CONVERGENCE WILL CONSIDERED
C               ACHIEVED ) IF ANY ONE OF THE THREE CONDITIONS IS SATISFIED.
C
C       RMACH   A REAL ARRAY OF LENGTH TWO WHICH IS DEPENDENT
C               UPON THE MACHINE SIGNIFICANCE;
C               SIG (MAXIMUM NUMBER OF SIGNIFICANT
C               DIGITS ) AND SHOULD BE COMPUTED AS FOLLOWS:
C
C               RMACH(1)= 5.0*10.0 **(-SIG+3)
C               RMACH(2)=10.0 **(-(SIG/2)-1)
C
C          WORK SCRATCH ARRAY OF LENGTH 2*M+(N*(N+2*M+9))/2
C               WHOSE CONTENTS ARE
C
C       1 TO JACM1      N*(N+1)/2       LOWER SUPER TRIANGLE OF
C                               JACOBIAN( TRANSPOSED )
C                               TIMES JACOBIAN
C
C       JACESS TO GRDM1         N*M     JACOBIAN MATRIX
C
C       JACSS TO DELEND         N       DELTA X
C
C       GRADSS TO GRDEND        N       GRADIENT
C
C       GRADSS TO DIAGM1        M       INCREMENTED FUNCTION VECTOR
C
C       DIAGSS TO ENDSS N       SCALING VECTOR
C
C       FMNSS TO XBADSS-1       M       DECREMENTED FUNCTION VECTOR
C
C       XBADSS TO XBEND N       LASTEST SINGULAR POINT
C
C               NOTE:
C               SEVERAL WORDS ARE USED FOR TWO DIFFERENT QUANTITIES (E.G.,
C               JACOBIAN AND DELTA X) SO THEY MAY NOT BE AVAILABLE
C               THROUGHOUT THE PROGRAM.
C
C
C
C       W       WEIGHTING VECTOR OF LENGTH M
C
C       SLTJJ   ARRAY OF LENGTH N*(N+1)/2 WHICH CONTAINS THE LOWER SUPER
C               TRIANGLE OF J(TRANS)*J RETAINED FROM WORK(1) THROUGH
C               WORK(JACM1) IN DO 30. ELEMENTS STORED SERIALLY AS C(1,1),
C               C(2,1),C(2,2),C(3,1),C(3,2),...,C(N,N). USED IN STATISTICS
C               SUBROUTINES FOR STANDARD DEVIATIONS AND CORRELATION
C               COEFFICIENTS OF PARAMETERS.
C
C       ICONV   AN INTEGER OUTPUT PARAMETER INDICATING SUCCESSFUL
C               CONVERGENCE OR FAILURE
C
C               .GT.  0  MEANS CONVERGENCE IN ITER ITERATION
C                  =  1  CONVERGENCE BY FIRST CRITERION
C                  =  2  CONVERGENCE BY SECOND CRITERION
C                  =  3  CONVERGENCE BY THIRD CRITERION
C               .EQ.  0  MEANS FAILURE TO CONVERGE IN ITMAX ITERATIONS
C               .EQ. -1  MEANS FAILURE TO CONVERGE IN ITER ITERATIONS
C                BECAUSE OF UNAVOIDABLE SINGULARITY WAS ENCOUNTERED
C
C          ITER AN INTEGER OUTPUT PARAMETER WHOSE VALUE IS THE NUMBER OF
C               ITERATIONS USED. THE NUMBER OF FUNCTION EVALUATIONS USED
C               IS ROUGHLY (N+1)*ITER.
C
C          SSQ  THE SUM OF THE SQUARES OF THE RESIDUALS FOR THE CURRENT
C               X AT RETURN.
C
C          F    A REAL ARRAY OF LENGTH M WHICH CONTAINS THE FINAL VALUE
C               OF THE RESIDUALS (THE F(I)'S) .
C
C          PRNOUT       SUBROUTINE USED TO FURNISH INTERMEDIATE OUTPUT WHEN
C               IPRINT .EQ. 1 (SEE ABOVE). THE NAME PRNOUT MUST APPEAR
C               IN EXTERNAL STATEMENT OF CALLING PROGRAM. THE CALLING
C               SEQUENCE HAS SEVEN PARAMETERS AND IS GIVEN BY THE
C               FOLOWING :
C               SUBROUTINE PRNOUT(X,N,ICONV,ITER,SSQ,ERL2,GRAD)
C               USER DIMENSION X(N) AND GRAD(N).
C
C       EXPLANATION OF PARAMETERS ----
C
C               X       CURRENT X VECTOR
C               N       NUMBER OF UNKNOWNS
C               ICONV   CONVERGENCE INDICATOR (SEE ABOVE)
C               ITER    NUMBER OF THE CURRENT ITERATION
C               SSQ     THE NUMBER OF THE SQUARES OF THE RESIDUALS FOR THE
C               CURRENT X
C               ERL2    THE EUCLICEAN NORM OF THE GRADIENT FOR THE CURRENT X
C               GRAD    THE REAL ARRAY OF LENGTH N CONTAINING THE GRADIENT
C               AT THE CURRENT X
C
C               NOTE ----
C
C               N AND ITER MUST NOT BE CHANGED IN PRNOUT
C               X AND ERL2 SHOULD NOT BE CAPRICIOUSLY CHANGED.
C
C          FUNC A USER SUPPLIED SUBROUTINE WHICH CALCULATES THE RESIDUAL
C               VECTOR F OF LENGTH M. THE CALLING SEQUENCE HAS THE FOLOWING
C               FORM:
C                    SUBROUTINE FUNC(X,M,N,F)
C               THE USER MUST SUPPLY THE DIMENSION STATEMENT DIMENSION
C               X(N), F(M)
C               THE SUBROUTINE NAME MUST APPEAR IN AN EXTERNAL STATEMENT
C               IN THE PROGRAM THAT CALLS SSQMIN
C
C
C       S.H. BRYANT ---- REVISION MAY 12, 1979  ----
C
C       DEPARTMENT OF PHARACOLOGY AND CELL BIOPHYSICS,
C       COLLEGE OF MEDICINE,
C       UNIVERSITY OF CINCINNATI,
C       231 BETHESDA AVE.,
C       CINCINNATI,
C       OHIO. 45267.
C       TELEPHONE 513/ 872-5621.
C
C       CODE
C       ----
C
C       Initialisation
C       --------------
C
C       Set machine precision constants
C
        PREC=RMACH(1)
        REL=RMACH(2)
	DTST=SQRT1(PREC)
	DEPS=SQRT1(REL)
C
C       Set convergence limits
C
        RELCON=10.**(-NUMSIG)
        RELSSQ=10.**(-NSIGSQ)
C
C       Set up pointers into WORK buffer
C
        JACSS=1+(N*(N+1))/2
        JACM1=JACSS-1
        DELEND=JACM1+N
C       Gradient
        GRADSS=JACSS+N*M
        GRDM1=GRADSS-1
        GRDEND=GRDM1+N
C       Forward trial residuals
        FPLSS=GRADSS
        FPLM1=FPLSS-1
C       Diagonal elements of Jacobian
        DIAGSS=FPLSS+M
        DIAGM1=DIAGSS-1
        ENDSS=DIAGM1+N
C       Reverse trial residuals
        FMNSS=ENDSS+1
        XBADSS=FMNSS+M
        XBEND=XBADSS+N-1
        ICONV=-5
        ERL2=1.E35
        GCRIT=1.E-3
        IBAD=-99
        RN=1./FLOAT(N)
        NP1=N+1
        ISW=1
        ITER=1
C
C       Main loop
C       ---------
C
5       CONTINUE
C
C       Compute sum of squares
C       SSQ= W * (Ydata - Yfunction)**2)
C
        CALL SSQCAL(X,M,N,F,W,SSQ,FUNC)
C
C       Convergence test - 2
C       Sum of squares match to NSIGSQ figures
C
        IF(ITER.EQ.1) GO TO 125
          IF(ABS(SSQ-OLDSSQ) .GT.RELSSQ*AMAX1(.5,SSQ)) GOTO 125
          ICONV=2
          GOTO 74
125     OLDSSQ=SSQ
C
13      K=JACM1
C
C       Compute trial residuals by incrementing
C       and decrementing X(j) by HH j=1...N
C       R = Zi (Y(i) - Yfunc(i)) i=1...M
C
        DO 22 J=1,N
C
C               Compute size of increment in parameter
C
                XDABS=ABS(X(J))
                HH=REL*XDABS
                IF(ISW.EQ.2)HH=HH*1.E3
                IF(HH.LE.PREC) HH=PREC
C
C               Compute forward residuals Rf = X(J)+dX(J)
C
                XHOLD=X(J)
                X(J)=X(J)+HH
                CALL FUNC (X,M,N,WORK(FPLSS))
                X(J)=XHOLD
C
C               ISW=1 then skip reverse residuals
C
                IF(ISW.EQ.1) GO TO 16
C
C               Compute reverse residual Rr = X(J) - dX(J)
C
                X(J)=XHOLD-HH
                CALL FUNC (X,M,N,WORK(FMNSS))
                X(J)=XHOLD
C
C               Compute gradients (Central differences)
C               Store in JACSS - GRDM1
C		SQRT1(W(j))(Rf(j) - Rr)j))/2HH
C               for j=1..M and  X(i) i=1..N
C
                L=ENDSS
                RHH=.5/HH
                KK=0
                DO 14 I=FPLSS,DIAGM1
                        L=L+1
                        K=K+1
                        KK=KK+1
			WORK(K)=SQRT1(W(KK))*(WORK(I)-WORK(L))*RHH
14              CONTINUE
                GO TO 20
C
C               Case of no reverse residuals
C               Forward difference
C		G=SQRT1(W(j)(Rf(j) - Ro(j))/HH
C               j=1..M X(i) i=1..N
C
16              CONTINUE
                L=FPLM1
                RHH=1./HH
                DO 18 I=1,M
                        K=K+1
                        L=L+1
			WORK(K)=(SQRT1(W(I))*WORK(L)-F(I))*RHH
18              CONTINUE
20              CONTINUE
22      CONTINUE
C
C       G2= Z W(j)* ((Rf(j)-Rr(j))/2HH) * Ro(j)
C          j=1..M
C
C       ERL2 = Z G2
C          i=1..N
C
        ERL2=0.
        K=JACM1
        DO 26 I=GRADSS,GRDEND
                SUM=0.
                DO 24 J=1,M
                        K=K+1
                        SUM=SUM+WORK(K)*F(J)
24              CONTINUE
                WORK(I)=SUM
                ERL2=ERL2+SUM**2
26      CONTINUE
C
	ERL2=SQRT1(ERL2)
C
C       Intermediate results printout
C
        IF(IPRINT.NE.0) CALL PRNOUT(X,N,ICONV,ITER,SSQ,ERL2,
     +          WORK(GRADSS))
C
C       Convergence test - 3
C       Euclidian norm < DELTA
C
        IF(ERL2.GT.DELTA) GO TO 27
          ICONV=3
          CALL PRNOUT(X,N,ICONV,ITER,SSQ,ERL2,WORK(GRADSS))
          RETURN
27      IF(ERL2.LT.GCRIT) ISW=2
C
C
C       Compute summed cross-products of residual gradients
C       Sik = Z Gi(j) * Gk(j)   (i,k=1...N)
C            j=1...M
C       S11,S12,S22,S13,S23,S33,.....
C
28      L=0
        IS=JACM1-M
        DO 30 I=1,N
                IS=IS+M
                JS=JACM1
                DO 30 J=1,I
                        L=L+1
                        SUM=0.
                        DO 31 K=1,M
                                LI=IS+K
                                JS=JS+1
                                SUM=SUM+WORK(LI)*WORK(JS)
31                      CONTINUE
                        SLTJJ(L)=SUM
                        WORK(L)=SUM
30      CONTINUE
        L=0
        J=0
C
C       Compute normalised diagonal matrix
C	SQRT1(Sii)/( SQRT1(Zi (Sii)**2) ) i=1..N
C
        DNORM=0.
        DO 34 I=DIAGSS,ENDSS
                J=J+1
                L=L+J
		WORK(I)=SQRT1(WORK(L))
                DNORM=DNORM+WORK(L)**2
34      CONTINUE
	DNORM=1./SQRT1(AMIN1(DNORM,3.4E38))
        DO 36 I=DIAGSS,ENDSS
                WORK(I)=WORK(I)*DNORM
36      CONTINUE
C
C       Add ERL2 * Nii i=1..N
C       Diagonal elements of summed cross-products
C
        L=0
        K=0
        DO 40 J=DIAGSS,ENDSS
                K=K+1
                L=L+K
                WORK(L)=WORK(L)+ERL2*WORK(J)
                IF(IBAD.GT.0) WORK(L)=WORK(L)*1.5+DEPS
40      CONTINUE
        JK=1
        DO 52 I=1,N
                JL=JK
                JM=1
                DO 52 J=1,I
                        TT=WORK(JK)
                        IF(J.EQ.1) GO TO 46
                        DO 44 K=JL,JK1
                                TT=TT-WORK(K)*WORK(JM)
                                JM=JM+1
44                      CONTINUE
46              CONTINUE
                IF(I.NE.J) GO TO 48
                IF (WORK(JK)+TT*RN.LE.WORK(JK)) GO TO 76
		WORK(JK)=1./SQRT1(TT)
                GO TO 50
48              WORK(JK)=TT*WORK(JM)
50              CONTINUE
                JK1=JK
                JM=JM+1
                JK=JK+1
52      CONTINUE
        JK=1
        JL=JACM1
        KQ=GRDM1
        DO 60 I=1,N
                KQ=KQ+1
                TT=WORK(KQ)
                IF (JL.EQ.JACM1) GO TO 56
                JK=JK+JL-1-JACM1
                LIM=I-1+JACM1
                DO 54 J=JL,LIM
                        TT=TT-WORK(JK)*WORK(J)
                        JK=JK+1
54              CONTINUE
                GO TO 58
56              IF(TT.NE.0.) JL=JACM1+I
                JK=JK+I-1
58              WORK(JACM1+I)=TT*WORK(JK)
                JK=JK+1
60      CONTINUE
C
        DO 66 I=1,N
                J=NP1-I+JACM1
                JK=JK-1
                JM=JK
                JN=NP1-I+1
                TT=WORK(J)
                IF (N.LT.JN) GO TO 64
                LI=N+JACM1
                DO 62 MJ=JN,N
                        TT=TT-WORK(JM)*WORK(LI)
                        LI=LI-1
                        JM=JM-LI+JACM1
62              CONTINUE
64              WORK(J)=TT*WORK(JM)
66      CONTINUE
C
        IF(IBAD.NE.-99) IBAD=0
        J=JACM1
        DO 68 I=1,N
                J=J+1
                X(I)=X(I)-WORK(J)
68      CONTINUE
        J=JACM1
C
C       Convergence condition - 1
C       Xnew = Xold to NUMSIG places
C       5E-20 V1.1 .5 in V1.
C
        DO 70 I=1,N
                J=J+1
                IF(ABS(WORK(J)).GT.RELCON*AMAX1(.5,ABS(X(I)))) GO TO 72
70      CONTINUE
        CALL SSQCAL(X,M,N,F,W,SSQ,FUNC)
        ICONV=1
        GO TO 74
C
72      ITER=ITER+1
C
C       No. convergence after ITMAX iterations
C
        IF(ITER.LE.ITMAX) GO TO 5
          CALL SSQCAL(X,M,N,F,W,SSQ,FUNC)
          ICONV=0
          RETURN
C
C       Convergence obtained -exit point
C
74      CONTINUE
        CALL PRNOUT(X,N,ICONV,ITER,SSQ,ERL2,WORK(GRADSS))
        RETURN
C
C       Singularity processing
C
76      IF (IBAD.GE.2) GO TO 92
        IF(IBAD) 81,78,78
78      J=0
        DO 80 I=XBADSS,XBEND
                J=J+1
                IF(ABS(X(J)-WORK(I)).GT.AMAX1(DTST,ABS(WORK(I))*DTST))
     +                   GOTO 82
80      CONTINUE
        GO TO 92
81      IBAD=0
82      J=0
        DO 84 I=XBADSS,XBEND
                J=J+1
                WORK(I)=X(J)
84      CONTINUE
        IBAD=IBAD+1
        GO TO 28
92      CONTINUE
        ICONV=-1
        CALL SSQCAL(X,M,N,F,W,SSQ,FUNC)
        RETURN
        END
        SUBROUTINE PRNOUT(X,N,ICONV,ITER,SSQ,ERL2,WK)
C
C       Intermediate results printout
C
C     Parameters
        REAL X(1)
C     No. of parameters
        INTEGER N
C     Convergence state
        INTEGER ICONV
C     Current interation
        INTEGER ITER
C     Sum of squares
        REAL SSQ
C     Euclidian norm
        REAL ERL2
C     ????
        REAL WK
C
	CHARACTER KY
	CHARACTER*16 STRING
	LOGICAL SPECIAL

	call find_cursor(ix,iy)
	write(string,'('' Iteration '',i3,)') iter
	call display_string( string )
	call move_cursor(ix,iy)
	CALL GET_KEY(KY,SPECIAL)
	IF(KY.EQ.'$') ITER = 30001
        RETURN
        END
        SUBROUTINE SSQCAL(X,M,N,F,W,SSQ,FUNC)
C
C       Compute sum of squares of residuals
C
C     function parameter array
        REAL X(1)
C     No. of data points
        INTEGER M
C     No. of parameters in X
        INTEGER N
C     Residual array Ydat - Yfit
        REAL F(1)
C     Weighting array
        REAL W(1)
C     =Sum of squares on exit
        REAL SSQ
C     Residual computation function

	CALL FUNC(X,M,N,F)
        SSQ=0.
        DO 12 I=1,M
		F(I)=SQRT1(W(I))*F(I)
                SSQ=SSQ+F(I)**2
12      CONTINUE
        RETURN
        END

        SUBROUTINE STAT(M,N,F,Y,W,SLT,SSQ,SDX,SDMIN,R,XPAR)
C
C       J.DEMPSTER 1-FEB-82
C       Adapted from STAT by S.H. Bryant
CC      Subroutine to supply statistics for non-linear least-
C       squares fit of tabular data  by SSQMIN.
C       After minminsation takes J(TRANSPOSE)*J matrix from
C       ssqmin which is stored serially as a lower super tr-
C       angle in SLTJJ(1) through SLTJJ(JACM1). Creates full
C       matrix in C(N,N) which is then inverted to give the var-
C       iance/covariance martix from which standard deviances
C       and correlation coefficients are calculated by the
C       methods of Hamilton (1964).  Hamilton's R is calculated from
C       the data and theoretical values
C
C       Variables in call string:
C
C       M       -Integer no. of residuals (observations)
C       N       -Integer no. of fitted parameters
C       F       -Real array of length M which contains the
C                final values of the residuals
C       Y       -Real array of length M containing Y data
C       W       -Real weighting array of length M
C       SLT     -Real array of length N*(N+1)/2
C                on input stores lower super triangle of
C                J(TRANS)*J from SLTJJ in SSQMIN
C                on return contains parameter corr. coeffs.
C                as CX(1,1),CX(2,1),CX(2,2),CX(3,1)....CX(N,N)
C       SSQ     -Final sum of squares of residuals
C       SDX     -REal array of length N containing the % standard
C                deviations of each parameter X
C       SDMIN   -       Minimised standard deviation
C       R       -       Hamilton's R
C       XPAR    -       Fitted parameter array
C
C
C       Requires matrix inversion srtn. MINV
C
        DIMENSION Y(M),SLT(1),SDX(N),C(8,8),A(64)
C
        REAL F(M),W(M),XPAR(N)
	INTEGER LROW(8),MCOL(8)

	SDMIN=SQRT1(SSQ/FLOAT(M-N))
        SUMP=0.
        DO 1 I=1,M
	YWGHT=Y(I)*SQRT1(W(I))
1       SUMP=SUMP+(F(I)+YWGHT)**2
	R=SQRT1(AMIN1(3.4E38,SSQ)/SUMP)
C
C       Restore J(TRANSP)*J and place in C(I,J)
C
        L=0
        DO 2 I=1,N
        DO 2 J=1,I
        L=L+1
        C(I,J) = SLT(L)
2       CONTINUE
        DO 3 I=1,N
        DO 3 J=1,N
        IF (I.GE.J) GO TO 3
        C(I,J) = C(J,I)
3       CONTINUE
C
C       Invert C(I,J)
C
        L=0
        DO 4 J=1,N
        DO 4 I=1,N
        L=L+1
4       A(L)=C(I,J)
C
        CALL MINV (A,N,DET,LROW,MCOL)
C
        L=0
        DO 5 J=1,N
        DO 5 I=1,N
        L=L+1
5       C(I,J)=A(L)
C
C       Calculate std. dev. X(J)
C
        DO 6 J = 1,N
6	SDX(J) = SDMIN * SQRT1(ABS(C(J,J)))


C	*** REMOVED since causing F.P. error and not used
C       Calculate correlation coefficients for
C       X(1) on X(J). Return in lower super
C       triangle as X(1,1),X(2,2),X(3,1),X(3,2) ....
C

C	 L=0
C	 DO 7 I=1,N
C	 DO 7 J=1,I
C	 L=L+1
C	 SLT(L)=C(I,J)/SQRT1(C(I,I)*C(J,J))
C7	 CONTINUE
	 RETURN
        END
C
C
C     ..................................................................
C
C        SUBROUTINE MINV
C
C        PURPOSE
C           INVERT A MATRIX
C
C        USAGE
C           CALL MINV(A,N,D,L,M)
C
C        DESCRIPTION OF PARAMETERS
C           A - INPUT MATRIX, DESTROYED IN COMPUTATION AND REPLACED BY
C               RESULTANT INVERSE.
C           N - ORDER OF MATRIX A
C           D - RESULTANT DETERMINANT
C           L - WORK VECTOR OF LENGTH N
C           M - WORK VECTOR OF LENGTH N
C
C        REMARKS
C           MATRIX A MUST BE A GENERAL MATRIX
C
C        SUBROUTINES AND FUNCTION SUBPROGRAMS REQUIRED
C           NONE
C
C        METHOD
C           THE STANDARD GAUSS-JORDAN METHOD IS USED. THE DETERMINANT
C           IS ALSO CALCULATED. A DETERMINANT OF ZERO INDICATES THAT
C           THE MATRIX IS SINGULAR.
C
C     ..................................................................
C
      SUBROUTINE MINV(A,N,D,L,M)
      DIMENSION A(1),L(1),M(1)
C
C        ...............................................................
C
C        IF A DOUBLE PRECISION VERSION OF THIS ROUTINE IS DESIRED, THE
C        C IN COLUMN 1 SHOULD BE REMOVED FROM THE DOUBLE PRECISION
C        STATEMENT WHICH FOLLOWS.
C
C     DOUBLE PRECISION A,D,BIGA,HOLD,DABS
C
C        THE C MUST ALSO BE REMOVED FROM DOUBLE PRECISION STATEMENTS
C        APPEARING IN OTHER ROUTINES USED IN CONJUNCTION WITH THIS
C        ROUTINE.
C
C        THE DOUBLE PRECISION VERSION OF THIS SUBROUTINE MUST ALSO
C        CONTAIN DOUBLE PRECISION FORTRAN FUNCTIONS.  ABS IN STATEMENT
C        10 MUST BE CHANGED TO DABS.
C
C        ...............................................................
C
C        SEARCH FOR LARGEST ELEMENT
C
      D=1.0
      NK=-N
      DO 80 K=1,N
      NK=NK+N
      L(K)=K
      M(K)=K
      KK=NK+K
      BIGA=A(KK)
      DO 20 J=K,N
      IZ=N*(J-1)
      DO 20 I=K,N
      IJ=IZ+I
   10 IF( ABS(BIGA)- ABS(A(IJ))) 15,20,20
   15 BIGA=A(IJ)
      L(K)=I
      M(K)=J
   20 CONTINUE
C
C        INTERCHANGE ROWS
C
      J=L(K)
      IF(J-K) 35,35,25
   25 KI=K-N
      DO 30 I=1,N
      KI=KI+N
      HOLD=-A(KI)
      JI=KI-K+J
      A(KI)=A(JI)
   30 A(JI) =HOLD
C
C        INTERCHANGE COLUMNS
C
   35 I=M(K)
      IF(I-K) 45,45,38
   38 JP=N*(I-1)
      DO 40 J=1,N
      JK=NK+J
      JI=JP+J
      HOLD=-A(JK)
      A(JK)=A(JI)
   40 A(JI) =HOLD
C
C        DIVIDE COLUMN BY MINUS PIVOT (VALUE OF PIVOT ELEMENT IS
C        CONTAINED IN BIGA)
C
   45 IF(BIGA) 48,46,48
   46 D=0.0
      RETURN
   48 DO 55 I=1,N
      IF(I-K) 50,55,50
   50 IK=NK+I
      A(IK)=A(IK)/(-BIGA)
   55 CONTINUE
C
C        REDUCE MATRIX
C
      DO 65 I=1,N
      IK=NK+I
      HOLD=A(IK)
      IJ=I-N
      DO 65 J=1,N
      IJ=IJ+N
      IF(I-K) 60,65,60
   60 IF(J-K) 62,65,62
   62 KJ=IJ-I+K
      A(IJ)=HOLD*A(KJ)+A(IJ)
   65 CONTINUE
C
C        DIVIDE ROW BY PIVOT
C
      KJ=K-N
      DO 75 J=1,N
      KJ=KJ+N
      IF(J-K) 70,75,70
   70 A(KJ)=A(KJ)/BIGA
   75 CONTINUE
C
C        PRODUCT OF PIVOTS
C
      D=D*BIGA
C
C        REPLACE PIVOT BY RECIPROCAL
C
      A(KK)=1.0/BIGA
   80 CONTINUE
C
C        FINAL ROW AND COLUMN INTERCHANGE
C
      K=N
  100 K=(K-1)
      IF(K) 150,150,105
  105 I=L(K)
      IF(I-K) 120,120,108
  108 JQ=N*(K-1)
      JR=N*(I-1)
      DO 110 J=1,N
      JK=JQ+J
      HOLD=A(JK)
      JI=JR+J
      A(JK)=-A(JI)
  110 A(JI) =HOLD
  120 J=M(K)
      IF(J-K) 100,100,125
  125 KI=K-N
      DO 130 I=1,N
      KI=KI+N
      HOLD=A(KI)
      JI=KI-K+J
      A(KI)=-A(JI)
  130 A(JI) =HOLD
      GO TO 100
  150 RETURN
      END

      REAL FUNCTION SQRT1(R)
      REAL R
      SQRT1 = SQRT(AMIN1(R,3.4E38))
      RETURN
      END

