	subroutine files_options
$INCLUDE:'wcpcom.for'
c
c	Data file handling module including import/export to other formats
c	------------------------------------------------------------------
C

	CHARACTER KEY
	logical new_menu,quit

	PARAMETER(Nmenu=8,istatus_left=59)
	CHARACTER*20 MENU(nmenu) /
     &	'Load   data file  F1',
     &	'Merge  data file  F2',
     &	'Delete data file  F3',
     &	'Remove rejected   F4',
     &	'Change directory  F5',
     &	'Simulation        F6',
     &	'File conversion   F7',
     &	'Exit             ESC' /

C
C -- CODE ------------------------------------------------------
C
C
C	Display program status box
C
	new_menu = .true.
	key = ' '
	quit = .false.
	do while( .not. quit )

	    call erase_box(1,1,istatus_left-2,25)
	    call title_box

	    iop = Iwait_MENU_VERTICAL1(menu,'1234567$',nmenu
     &	    ,2,2,new_menu,iop,' Files Options ',key)

	    select case (iop)

	    case(1)
		 CALL LOAD_data_FILE(3,3+iop)
	    case(2)
		 call merge_data_file(3,3+iop)
	    case(3)
		CALL DELETE_data_FILE(3,3+iop)
	    case(4)
		call remove_rejected_records
	    case(5)
		CALL CHANGE_data_DIRECTORY(3,3+iop)
	    case(6)
		call simulations
	    case(7)
		call file_conversion(3,3)
	    case(8)
		quit = .true.
	    end select
	end do
	return
	end


	SUBROUTINE LOAD_data_FILE(il,it)
C
C --	Load .wcp file
C
$INCLUDE:'wcpcom.for'
C
	parameter(max_files=500,nc_path=70)
	character*70 path
	CHARACTER*12 NEW_FILE_NAME / ' ' /

	character*12 files(max_files)
	equivalence( iwork, files )
C
C	CODE
C

C	Display directory of .wcp files and let user choose


	path = default_path
	ix = len_trim(path)+1
	path(ix:ix+4) = '*.wcp'
	call files_menu(path,0,new_file_name,il,it,10,files,max_files)

	if( new_file_name .ne. ' ' ) then

	    path(ix:nc_path) = new_file_name
	    file_name = path
	    open(unit=idata_file,file=file_name,form='binary',
     &	    access='direct',recl=512, iostat=istat )
	    call check_io_error( istat, 0 )
	    CALL GET_HEADER( idata_file )

	    if( n_records .eq. 0 ) call fix_data_file

	    close( unit=idata_file )

	    call write_to_log( 'Data File Loaded: '//file_name )

	end if
	return
	end

	subroutine delete_data_file(il,it)
C
C --	Delete .wcp file
C
$INCLUDE:'wcpcom.for'
C
	CHARACTER*12 NEW_FILE_NAME/ ' ' /
	parameter(max_files=500,nc_path=70)
	character*70 path / ' ' /
	character*12 files(max_files)
	equivalence( iwork, files )
	character key
C
C	CODE
C
	path = default_path
	ix = len_trim(path)+1
	path(ix:ix+4) = '*.wcp'
	call files_menu(path,0,new_file_name,il,it,10,files,max_files)

	if( new_file_name .ne. ' ' ) then
	    path(ix:nc_path) = new_file_name
	    call query_box(2,7,
     &	    ' Delete: '//path(1:60)//' (Y/N) ? ',key)
	    if( key .eq. 'Y' ) then
		call delete_file( ierr, path )
		call write_to_log(
     &		path(1:len_trim(path))//' deleted.' )
	    end if
	end if

	return
	end

	SUBROUTINE CHANGE_data_DIRECTORY(ileft,itop)
C
C --	Change directory
C
$INCLUDE:'wcpcom.for'

	parameter(max_drives=26)
	character*14 drives(max_drives)
	equivalence( iwork, drives )
	parameter(max_files=500)
	character*16 files(max_files)
	equivalence( iwork(300), files )
	character*58 path
	character*12 directory
	character*62 search
	character key
	logical new_menu,quit

C
C	CODE
C
	call get_drives( drives, ndrives )
	do i = 1,ndrives
	    if( drives(i)(1:1) .eq. default_path(1:1) ) idrive = i
	end do
c
c	Select disc drive
c
	ncp = len(default_path)
	call erase_box( ileft, itop, ileft+ncp+2, itop+12 )
	call display_box( ileft, itop, ileft+ncp+2, itop+12 )
	call move_cursor( ileft+1, itop+1 )
	call display_string( default_path )

	idrive = Iwait_MENU_VERTICAL1(drives,'1234567890',ndrives
     &	,ileft+2,itop+2,new_menu,idrive,' Disc Drive ',key)

	nd = len_trim(drives(idrive))
	path = drives(idrive)(1:nd)//'\'
	quit = .false.
	do while( .not. quit )

	    call move_cursor( ileft+1, itop+1 )
	    call display_string( default_path )

	    np = len_trim(path)
	    search = path(1:np)//'*.*'
	    ns = len_trim(search)
	    call files_menu(search(1:ns),2#10000,directory,
     &	    ileft+2,itop+2,10,files,max_files)

	    if( directory .ne. ' ' ) then
		np = len_trim(path)
		nd = len_trim(directory)
		path = path(1:np)//directory(1:nd)//'\'
	    else
		quit = .true.
	    end if
	end do

	default_path = path
	call write_to_log( 'Data Directory: '//path )

	return
	end

	SUBROUTINE GET_HEADER( ifile )
$INCLUDE:'wcpcom.for'
C
C	Read data from WCP file header block into HEADER common area
C
	CHARACTER*(512) HEADER
	EQUIVALENCE (ibuffer,HEADER)


	character*4 key
C
C	CODE
C	----
C
C	Read header block of .WCP file
C
	read(unit=ifile,rec=1,err=100) (ibuffer(i),i=1,256)

	call read_flt( 'VER=', header, version )

	call read_int( 'NC=', header, n_channels )
	call read_int( 'NBA=', header, nb_analysis )
	call read_int( 'NBD=', header, nb_data )
	n_points = (nb_data*npoints_per_block)/max(n_channels,1)
	call read_flt( 'AD=', header, adc_range )
	call read_int( 'NR=', header, n_records )
	call read_flt( 'DT=', header, dt )
	call read_int( 'NZ=', header, nzero )

	do i = 1,n_channels
	    write( key,'(''YN'',i1,''='')') i-1
	    call read_char( key, header, y_name(i) )
	    write( key,'(''YU'',i1,''='')') i-1
	    call read_char( key, header, y_units(i) )
	    write( key,'(''YS'',i1,''='')') i-1
	    call read_flt( key, header, y_scale(i) )
	    write( key,'(''YG'',i1,''='')') i-1
	    call read_flt( key, header, gain(i) )
	    write( key,'(''YZ'',i1,''='')') i-1
	    call read_int( key, header, iy_zero(i) )
	    write( key,'(''YR'',i1,''='')') i-1
	    call read_int( key, header, izero_sample(i) )
	end do

	call read_char( 'ID=', header, id )

	if( dt .gt. 5. ) then
	    tscale = 0.001
	    t_units = 's'
	else
	    tscale = 1.
	    t_units = 'ms'
	end if

	return

100	call move_cursor(2,25)
	call display_string(' ERROR ... No data file header block! ')
	return
	end

	SUBROUTINE SAVE_HEADER( ifile )
$INCLUDE:'wcpcom.for'
C
C	WRITE HEADER BLOCK TO SES FILE
C
	CHARACTER*(512) HEADER
	EQUIVALENCE (IBUFFER,HEADER)
	character*4 key
C
C	CODE
C	----
C
	version = 5.0

	HEADER = ' '
	call add_flt( version, 'VER=', header, '(f4.1)' )
	call add_int( n_channels, 'NC=', header, '(i2)' )
	call add_int( n_records, 'NF=', header, '(i5)' )
	call add_int( n_records, 'NR=', header, '(i5)' )
	call add_int( nb_analysis, 'NBA=', header, '(i2)' )
	call add_int( nb_data, 'NBD=', header, '(i4)' )
	call add_int( n_points, 'NP=', header, '(i4)' )
C
	call add_flt( dt, 'DT=', header, '(f8.4)' )
	call add_int( nzero, 'NZ=', header, '(i4)' )

	do i = 1,n_channels
	    write( key,'(''YN'',i1,''='')') i-1
	    call add_char( y_name(i), key, header )
	    write( key,'(''YU'',i1,''='')') i-1
	    call add_char( y_units(i), key, header )
	    write( key,'(''YS'',i1,''='')') i-1
	    call add_flt( y_scale(i), key, header, '(g10.3)' )
	    write( key,'(''YG'',i1,''='')') i-1
	    call add_flt( gain(i), key, header, '(g10.3)' )
	    write( key,'(''YZ'',i1,''='')') i-1
	    call add_int( iy_zero(i), key, header, '(i4)' )
	    write( key,'(''YR'',i1,''='')') i-1
	    call add_int( izero_sample(i), key, header, '(i4)' )
	end do

	call add_flt( y_scale(1), 'BC=', header, '(g10.3)' )
	call add_flt( gain(1), 'GC=', header, '(g10.3)' )
	call add_int( iy_zero(1), 'IZC=', header, '(i4)' )
	call add_flt( adc_range, 'AD=', header, '(f7.4)' )
	call add_char( t_units,'TU=', header )
	call add_char( y_units(1),'CU=', header )
	call add_char( id,'ID=', header )
	write(unit=ifile,rec=1,err=100) (ibuffer(i),i=1,256)
	return
100	call move_cursor(2,25)
	call display_string(' ERROR ... Could not create header block! ')
	return
	end

	subroutine remove_rejected_records
$include:'wcpcom.for'
c
c	Remove records marked as "REJECTED" from data file
c
	character*46 msg(2)
	parameter(nc_temp=30)
	character*30 temp
	character*8 stat
c
c	code
c
c
c	Open data file in current use
c
	open(unit=idata_file,file=file_name,form='binary',
     &	access='direct',recl=512)
	call get_header( idata_file )
c
c	Create a temporary file to hold compressed data
c
	ix = index( file_name, '.' )
	temp = file_name
	temp(ix:nc_temp) = '.tmp'
	open(unit=itemp_file,file=temp,form='binary',
     &	access='direct',recl=512,err=100)

	    msg(1) = ' WAIT ... Removing REJECTED records '
	    msg(2) = ' '
	    call display_message(3,5,len(msg(1))+2,msg,2)

	    nsaved = 0
	    do ir = 1,n_records

		call get_record(idata_file,ir,rec.buf,iwork)

		stat = rec.status
		write(msg(2),'('' Record '',i5,a)') ir,stat
		call move_cursor(4,7)
		call display_string(msg(2))

		if( rec.status .ne. 'REJECTED' ) then
		    nsaved = nsaved + 1
		    call put_record(itemp_file,nsaved,rec.buf,iwork)
		endif
	    end do

	    n_records = nsaved
	    call save_header( itemp_file )

	    close(unit=idata_file)
	    close(unit=itemp_file)
c
c	    Delete old file and rename temporary file
c
	    call delete_file( ierr, file_name )
	    call rename_file( ierr, temp, file_name )

	    call write_to_log('REJECTED records removed.')
	    return

100	call write_to_log(
     &	'REMOVE_REJECTED. Error! Could not open '//temp )
	return
	end

	subroutine merge_data_file(il,it)
C
C --	Merge the data from a SES file on to end of current file
C
$INCLUDE:'wcpcom.for'
C
	parameter(max_files=500,nc_path=52)
	character*70 path,msg(3)
	character*12 files(max_files),new_file_name
	equivalence( iwork, files )
	logical merge
C
C	CODE
C
c
c	Open current data file
c
	open(unit=idata_file,file=file_name,form='binary',
     &	access='direct',recl=512, iostat=istat )
	CALL GET_HEADER( idata_file )
	nc_old = n_channels
	np_old = n_points
	nba_old = nb_analysis
	gain_old = gain(1)
	n_records_old = n_records

	path = default_path
	ix = len_trim(path)+1
	path(ix:ix+4) = '*.wcp'
	call files_menu(path,0,new_file_name,il,it,10,files,max_files)

	merge = .false.
	if( new_file_name .ne. ' ' ) then

	    path(ix:nc_path) = new_file_name
	    open(unit=itemp_file,file=path,form='binary',
     &	    access='direct',recl=512, iostat=istat )

	    if( istat .eq. 0 ) then
		call get_header( itemp_file )

		if( (n_channels .eq. nc_old) .and.
     &		    (n_points .eq. np_old ) .and.
     &		    (nba_old .eq. nb_analysis ) ) then
		    merge = .true.
		    n_merge = n_records
		    call write_to_log( 'Merging file: '//path )
		else
		    close( unit=itemp_file )
		    call error_msg(2,24,
     & ' Merge not possible! Channels and/or record size mismatched')

		end if
	    else
		call error_msg(2,24,
     &		 ' Merge not possible! Cannot open this file! ')
	    end if
	end if

	if( merge ) then

c	    Add records to file (excluding REJECTED records)

	    msg(1) = ' WAIT ... Adding records '
	    msg(2) = ' '
	    call display_message(4,6,len(msg(1))+2,msg,2)

	    nadded = n_records_old
	    n_records = 32767
	    do ir = 1,n_merge
		call get_record( itemp_file, ir, rec.buf, iwork )
		if( rec.status .ne. 'REJECTED' ) then
		    nadded = nadded + 1
		    rec.ad_range = rec.ad_range*(gain_old/gain(1))
		    call put_record( idata_file, nadded, rec.buf, iwork )
		    write(msg(2),'('' Record '',i5)') nadded
		    call move_cursor(5,8)
		    call display_string(msg(2))
		endif
	    end do

	    close( unit=itemp_file )

	    call get_header( idata_file )
	    n_records = nadded
	    call save_header( idata_file )

	else
	    call display_message(3,5,44,
     &	    ' Different size records! Can''t merge files ',1)
	end if

	close(unit=idata_file)
	return
	end

	subroutine add_logical( log_val, key, string )
	logical log_val
	character*(*) key,string

	i0 = len_trim(string)+1
	nc = len(string)
	string(i0:nc) = key
	i0 = len_trim(string)+1
	write( string(i0:nc), '(l1,a2)' ) log_val,char(13)//char(10)
	return
	end

	subroutine add_flt( r, key, string, fstring )
	character*(*) key,string,fstring
	character*20 asc

	i0 = len_trim(string)+1
	nc = len(string)
	string(i0:nc) = key
	i0 = len_trim(string)+1
	write( asc, fmt=fstring ) r
	is = ileading_space(asc)
	ie = len_trim(asc)
	string(i0:nc) = asc(is:ie)//char(13)//char(10)
	return
	end

	subroutine add_int( i, key, string, fstring )
	character*(*) key,string,fstring
	character*20 asc

	i0 = len_trim(string)+1
	nc = len(string)
	string(i0:nc) = key
	i0 = len_trim(string)+1
	write( asc, fmt=fstring ) i
	is = ileading_space(asc)
	ie = len_trim(asc)
	string(i0:nc) = asc(is:ie)//char(13)//char(10)
	return
	end

	subroutine add_char( string_in, key, string )
	character*(*) key,string,string_in

	i0 = len_trim(string)+1
	nc = len(string)
	string(i0:nc) = key
	i0 = len_trim(string)+1
	string(i0:nc) = string_in
	i0 = len_trim(string)+1
	string(i0:i0+1) = char(13)//char(10)
	return
	end

	subroutine read_flt( mask, header, r )
	character*(*) mask, header
	real*4 r
	character*16 string

	call find_item( header, mask, is, ie )
	if( is .gt. 0 ) then
	    string = header(is:ie)
	    read( string, '(f16.0)', err=100 ) r
	end if

100	return
	end

	subroutine read_int( mask, header, i )
	character*(*) mask, header
	integer*2 i
	character*16 string

	string = ' '
	call find_item( header, mask, is, ie )
	if( is .gt. 0 ) then
	    string = header(is:ie)
	    read( string, '(f16.0)', err=100 ) r
	    i = int(r)
	end if
100	return
	end

	subroutine read_char( mask, header, string )
	character*(*) mask, header, string

	call find_item( header, mask, is, ie )
	if( is .gt. 0 ) string = header(is:ie)
	return
	end

	subroutine read_logical( mask, header, log )
	character*(*) mask, header
	logical log
	character*6 string

	call find_item( header, mask, is, ie )
	if( is .gt. 0 ) then
	    string = header(is:ie)
	    read( string, '(L1)', err=100 ) log
	end if
100	return
	end

	subroutine find_item( string, name, is,ie )
	character*(*) name,string
	integer*2 nc,is,ie
c
c	Searches <string> for items with the form:
c	<name> <data> <cr> <lf>
c	or
c	<name> <data> <\>
c

	nc = len( string )
	nn = len_trim(name)
	is = index( string, name(1:nn) )
	if ( is .gt. 0 ) then
	    ie = index( string(is:nc), char(13) )
	    if( ie .ne. 0 ) then
		ie = is + ie - 2
		is = is + nn
	    endif
	endif
c	 call move_cursor(1,1)
c	 call display_string(name)
c	 call display_string(string(is:ie))
c	 call display_int(is)
c	 call display_int(ie)
c	 call paws
	return
	end

	SUBROUTINE read_initialisation_file( fname )
	character*(*) fname
	CHARACTER*(512) HEADER
	EQUIVALENCE (ibuffer,HEADER)
C
$INCLUDE:'wcpcom.for'
C
	character drive
	logical file_exists
	character*3 key

C	CODE
C	----
C
	inquire(file=fname, exist=file_exists)

	call get_default_disc( drive )	    ! does not exist, create
	default_path = drive//':\'          ! one on the current drive.
	file_name = drive//':\standard.wcp'

	if( file_exists ) then

	    open(unit=ini_file,file=fname,form='binary',
     &	    access='direct',recl=512, iostat=istat )

	    read(unit=ini_file,rec=1,err=100) (ibuffer(i),i=1,256)
	    call read_int( 'IFC=', header, interface_card )
	    call read_int( 'TRM=', header, itrigger_mode )
	    call read_int( 'DSM=', header, idisplay_mode )
	    call read_int( 'FNT=', header, ifont )
	    call read_int( 'FSZ=', header, ipoint_size )
	    call read_int( 'LSZ=', header, iline_size )
	    call read_flt( 'PT=', header, pre_trigger )
	    call read_flt( 'TL=', header, trigger_level )
	    call read_int( 'TC=', header, itrigger_channel )
	    call read_char( 'DP=', header, default_path )
	    call read_char( 'FIL=', header, file_name )
	    call read_char( 'PRI=', header, primary_name )
	    call read_char( 'ALT=', header, alternate_name )
	    call read_flt( 'TPH=', header, TestPulseHeight )
	    call read_flt( 'TPS=', header, TestPulseScaleFactor )
	    call read_int( 'IVM=', header, iVm_chan )
	    call read_int( 'IIM=', header, iIm_chan )
	    do i = 1,max_channels
		key = 'C'// char( ichar('0')+i-1 ) // '='
		call read_int( key, header, icolour(i) )
	    end do

100	    close(unit=ini_file)
	end if
	return
	end

	SUBROUTINE save_initialisation_file( fname )
	character*(*) fname
	CHARACTER*(512) HEADER
	EQUIVALENCE (ibuffer,HEADER)
C
$INCLUDE:'wcpcom.for'

	character*3 key
	character ky
C
C	CODE
C	----
C
	open(unit=ini_file,file=fname,form='binary',
     &	access='direct',recl=512,iostat=istat)

	if( istat .eq. 0 ) then
	    header = ' '
	    call add_int( interface_card, 'IFC=', header, '(i4)' )
	    call add_int( itrigger_mode, 'TRM=', header, '(i2)' )
	    call add_int( idisplay_mode, 'DSM=', header, '(i2)' )
	    call add_int( ifont, 'FNT=', header, '(i2)' )
	    call add_int( ipoint_size, 'FSZ=', header, '(i3)' )
	    call add_int( iline_size, 'LSZ=', header, '(i3)' )
	    call add_flt( pre_trigger, 'PT=', header, '(f7.4)' )
	    call add_flt( trigger_level, 'TL=', header, '(f7.4)' )
	    call add_int( itrigger_channel, 'TC=', header, '(i1)' )
	    call add_char( default_path,'DP=', header )
	    call add_char( file_name,'FIL=', header )
	    call add_char( primary_name,'PRI=', header )
	    call add_char( alternate_name,'ALT=', header )
	    call add_flt( TestPulseHeight, 'TPH=', header, '(f7.4)' )
	    call add_flt(TestPulseScaleFactor,'TPS=', header, '(f7.4)')
	    call add_int( iVm_chan, 'IVM=', header, '(i3)' )
	    call add_int( iIm_chan, 'IIM=', header, '(i3)' )

	    do i = 1,max_channels
		key = 'C'// char( ichar('0')+i-1 ) // '='
		call add_int( icolour(i), key, header, '(i2)' )
	    end do

	    write(unit=ini_file,rec=1) (ibuffer(i),i=1,256)
	    close(unit=ini_file)
	else
	    call query_box(2,20,
     &	    'ERROR! Cannot create file \ses\wcp.ini',ky )
	end if
	return
	end

	subroutine fix_data_file
$include:'wcpcom.for'
c
c	Repairs a data file which reports that it has
c	no records in it by by scanning through the file
c	looking for records
c
	character*46 msg(2)
	logical quit

	msg(1) = ' WAIT ... Repairing data file '
	msg(2) = ' '
	call display_message(3,5,len(msg(1))+2,msg,2)

	nb_data = (n_points*n_channels)/npoints_per_block
	NB_record = NB_ANALYSIS + NB_DATA
	n_records = 0
	quit = .false.
	do while( .not. quit )
	    n_records = n_records + 1
	    isector = (n_records - 1)*NB_record + 2
	    read(unit=idata_file,rec=isector,iostat=istat,end=10) iwork
	    call move_cursor(4,7)
	    write( msg(1), '('' Records found: '',i5)') n_records
	    call display_string( msg(1) )
	end do
10	continue
	n_records = n_records - 1

	call save_header( idata_file )

	return
	end

c


