	subroutine file_conversion
$include:'wcpcom.for'
c
c	Convert SES data format to/from data files of other
c	electrophysiology programs
c
c	8/5/96 wcp_to_pclamp Error in sampling rate fixed
c	26/3/97 wcp_to_pclamp Error in signal scaling fixed
c
	parameter(nmenu = 9,istatus_left=59)
	character*28 menu(nmenu) /
     &	' SCAN      to  WCP       F1',
     &	' VCAN      to  WCP       F2',
     &	' AVG       to  WCP       F3',
     &	' pCLAMP    to  WCP       F4',
     &	' WCP       to  pCLAMP V6 F5',
     &	' CFS       to  WCP       F6',
     &	' WCP       to  CFS       F7',
     &	' ASCII     to  WCP       F8',
     &	' Exit                   ESC' /

	logical new_menu
	character key

c
c	code
c
	new_menu = .true.
	key = ' '

	iop = Iwait_MENU_VERTICAL1(menu,'12345678$',nmenu
     &	,3,3,new_menu,iop,' File Conversion ',key)

	select case (iop)
	case(1)
	    call scan_to_wcp( 26, 3	)
	case(2)
	    call vcan_to_wcp( 26, 3 )
	case(3)
	    call avg_to_wcp( 26, 3 )
	case(4)
	    call pclamp_to_wcp( 26, 3 )
	case(5)
	    call wcp_to_pclamp6( 26, 3 )
	case(6)
	    call cfs_to_wcp( 26, 3 )
	case(7)
	    call wcp_to_cfs
	case(8)
	    call ascii_to_wcp( 26, 3 )
	end select
	return
	end

	subroutine scan_to_wcp( ileft, itop )
$include:'wcpcom.for'
c
c	Convert a SCAN binary data file into a WCP file
c	8-JUN-93 ... Invalid FP crashing problem corrected
c
	character*12 new_file_name / ' ' /
	parameter(max_files=500,nc_path=52)
	character*52 path / ' ' /
	character*12 files(max_files)
	equivalence( iwork, files )

	character*512 header
	equivalence (ibuffer,header)

	character key

c
c	code
c

	call create_path( path, default_path, '*', '.sca' )
	call files_menu(path,0,new_file_name,ileft,itop,10,
     &	files,max_files)

	if( new_file_name .ne. ' ' ) then
c
c	    Open SCAN data file
c
	    call create_path(path,default_path,new_file_name,'.sca')
	    open(unit=itemp_file,
     &	    file=path,
     &	    form='binary',
     &	    access='direct',
     &	    iostat=istat,
     &	    recl=512)
c
c	    Open WCP file with same name
c
	    call create_path(file_name,
     &	    default_path,new_file_name,'.wcp')
	    call get_file_name(2,itop+12,
     &	    file_name,'.wcp','NEW',' Create file? ',iflag)
	    if( iflag .lt. 0 ) then
		close(unit=itemp_file)
		return
	    end if

	    open(unit=idata_file,
     &	    file=file_name,
     &	    form='binary',
     &	    access='direct',
     &	    recl=512)
c
c	    Get header block
c
	    read(unit=itemp_file,rec=1,iostat=istat) (ibuffer(i),i=1,256)

	    call write_to_log( 'Import from '//path )
c
c	    Check to see if this is an early (<5.0) .SCA data file
c	    which uses '\' as keyword separators. If so convert to <cr>
c
	    n = 0
	    do i = 1,256
		if( header(i:i) .eq. '\' ) n = n + 1
	    end do
	    if( n .gt. 6 ) then
		do i = 1,512
		    if( header(i:i) .eq. '\' ) header(i:i) = char(13)
		end do
	    end if

c
c	    Read old style keywords
c
	    call read_int( 'NC=', header, n_channels )
	    call read_int( 'NBA=', header, nb_analysis )
	    call read_int( 'NBD=', header, nb_data )
	    n_points = (nb_data*npoints_per_block)/max(n_channels,1)
	    call read_flt( 'AD=', header, adc_range )
	    call read_flt( 'PT=', header, pre_trigger )
	    call read_flt( 'TL=', header, trigger_level )
	    call read_int( 'NR=', header, n_records )
	    call read_flt( 'DT=', header, dt )
	    call read_flt( 'GC=', header, gain(1) )
	    call read_flt( 'BC=', header, y_scale(1) )
	    call read_int( 'IZC=', header, iy_zero(1) )
	    call read_int( 'NF=', header, n_records )
	    call read_char( 'CU=', header, y_units(1) )
c
c	    Convert old style record gain to record adc voltage range
c	    in each record's analysis block
c
	    do ir = 1,n_records

		nb_data = (n_points*n_channels)/npoints_per_block
		NB_record = NB_ANALYSIS + NB_DATA
		isector = (ir - 1)*NB_record + 2
		read(unit=itemp_file,rec=isector,iostat=istat)
     &		(rec.buf(i),i=1,256*nb_analysis)
		read(unit=itemp_file,rec=isector+nb_analysis,iostat=istat)
     &		(iwork(i),i=1,256*nb_data)

		tm = rec.scan_time
		gn = rec.scan_gain
		if( gn .le. 0. ) gn = 1.
		dt1 = rec.scan_dt
		if( rec.scan_t_units .eq. 's' ) dt1 = dt1*1E3

		rec.time = tm
		rec.number = float(ir)
		rec.dt = dt1
		if( rec.dt .le. 0. ) rec.dt = dt
		rec.ad_range = adc_range/gn

		call put_record(idata_file,ir,rec.buf,iwork)

		call display_progress( 2, 20,
     &		' Records done (ESC to abort) ', ir,n_records, key )

		if( key .eq. '$' )  then
		    n_records = ir
		    goto 101
		end if

	    end do
101	    continue

	    call save_header( idata_file )
	    close(unit=idata_file)
	    close(unit=itemp_file)

	    call write_to_log( 'New file '//file_name )

	end if
	return
	end

	subroutine vcan_to_wcp( ileft, itop )
$include:'wcpcom.for'
c
c	Convert a VCAN binary data file into a WCP file
c	8-JUN-93 ... Invalid FP crashing problem corrected
c
	character*12 new_file_name / ' ' /
	parameter(max_files=500,nc_path=52)
	character*52 path / ' ' /
	character*12 files(max_files)
	equivalence( iwork, files )
	character*512 header
	equivalence (ibuffer,header)

	character key

c
c	code
c

	call create_path( path, default_path, '*', '.vca' )
	call files_menu(path,0,new_file_name,ileft,itop,10,
     &	files,max_files)

	if( new_file_name .ne. ' ' ) then

c
c	    Open VCAN data file
c
	    call create_path(path,default_path,new_file_name,'.vca')
	    open(unit=itemp_file,
     &	    file=path,
     &	    form='binary',
     &	    access='direct',
     &	    iostat=istat,
     &	    recl=512)

	    call write_to_log( 'Import from '//path )
c
c	    Open WCP file with same name
c
	    call create_path(file_name,
     &	    default_path,new_file_name,'.wcp')
	    call get_file_name(2,itop+12,
     &	    file_name,'.wcp','NEW',   ' Create file? ',iflag)
	    if( iflag .lt. 0 ) then
		close(unit=itemp_file)
		return
	    end if

	    open(unit=idata_file,
     &	    file=file_name,
     &	    form='binary',
     &	    access='direct',
     &	    recl=512)
c
c	    Get header block
c

	    read(unit=itemp_file,rec=1,iostat=istat) (ibuffer(i),i=1,256)
c
c	    Check to see if this is an early (<5.0) .VCA data file
c	    which uses '\' as keyword separators. If so convert to <cr>
c
	    n = 0
	    do i = 1,256
		if( header(i:i) .eq. '\' ) n = n + 1
	    end do
	    if( n .gt. 6 ) then
		do i = 1,512
		    if( header(i:i) .eq. '\' ) header(i:i) = char(13)
		end do
	    end if
c
c	    Read old style keywords
c
	    call read_int( 'NC=', header, n_channels )
	    call read_int( 'NBA=', header, nb_analysis )
	    call read_int( 'NBD=', header, nb_data )
	    n_points = (nb_data*npoints_per_block)/max(n_channels,1)
	    call read_flt( 'AD=', header, adc_range )
	    call read_flt( 'PT=', header, pre_trigger )
	    call read_flt( 'TL=', header, trigger_level )
	    call read_int( 'NR=', header, n_records )
	    call read_flt( 'DT=', header, dt )
	    call read_flt( 'GC=', header, gain(1) )
	    call read_flt( 'GV=', header, gain(2) )
	    call read_flt( 'BC=', header, y_scale(1) )
	    call read_flt( 'BV=', header, y_scale(2) )
	    call read_int( 'IZC=', header, iy_zero(1) )
	    call read_int( 'IZV=', header, iy_zero(2) )
	    call read_int( 'NF=', header, n_records )
	    call read_char( 'CU=', header, y_units(1) )
	    call read_char( 'VU=', header, v_units(1) )
c
c	    Convert old style record gain to record adc voltage range
c	    in each record's analysis block
c
	    do ir = 1,n_records

		nb_data = (n_points*n_channels)/npoints_per_block
		NB_record = NB_ANALYSIS + NB_DATA
		isector = (ir - 1)*NB_record + 2
		read(unit=itemp_file,rec=isector,iostat=istat)
     &		(rec.buf(i),i=1,256*nb_analysis)
		read(unit=itemp_file,rec=isector+nb_analysis,iostat=istat)
     &		(iwork(i),i=1,256*nb_data)

		tm = rec.vcan_time
		gn = rec.vcan_gain
		if( gn .le. 0. ) gn = 1.
		dt1 = rec.vcan_dt
		if( rec.vcan_t_units .eq. 's' ) dt1 = dt1*1E3

		rec.time = tm
		rec.number = float(ir)
		rec.ad_range = adc_range/gn
		rec.dt = dt1
		if( rec.dt .le. 0. ) rec.dt = dt

		call put_record(idata_file,ir,rec.buf,iwork)

		call display_progress( 2,20,
     &		' Records done (ESC to abort) ', ir,n_records, key )

		if( key .eq. '$' )  then
		    n_records = ir
		    goto 101
		end if

	    end do
101	    continue

	    call save_header( idata_file )
	    close(unit=idata_file)
	    close(unit=itemp_file)

	    call write_to_log( 'New file '//file_name )

	end if
	return
	end

	subroutine avg_to_wcp( ileft, itop )
$include:'wcpcom.for'
c
c	Convert a WCP average (or leak) file .AVG
c	into a standard .WCP file
c
	character*52 avg_file_name / ' ' /
	character*52 wcp_file_name / ' ' /
	character*512 header
	equivalence (ibuffer,header)
	character key
	logical file_exists
c
c	code
c
c
	call create_path( avg_file_name, ' ', file_name  , '.avg' )
	inquire(file=avg_file_name,exist=file_exists)

	if( file_exists ) then

	    call create_path(wcp_file_name,' ',avg_file_name, '.wcp')
	    call get_file_name(2,itop,
     &	    wcp_file_name,'.wcp','NEW',' Create file? ',iflag)

	    if( iflag .ge. 0 ) then
c
c		Open the average file
c
		open(unit=iavg_file,
     &		file=avg_file_name,
     &		form='binary',
     &		access='direct',
     &		recl=512)
		call get_header( iavg_file )
c
c		Open the WCP file
c
		open(unit=itemp_file,
     &		file=wcp_file_name,
     &		form='binary',
     &		access='direct',
     &		recl=512)

		nr = 0
		do ir = 1,n_records
		    call get_record(iavg_file,ir,rec.buf,iwork)
		    nr = nr + 1
		    call put_record(itemp_file,nr,rec.buf,iwork)
		    call display_progress( 2, 20,
     &		    ' Records done (ESC to abort) ',nr,n_records,key)
		    if( key .eq. '$' ) goto 101
		end do
101		continue
		call save_header( itemp_file )
		close( unit=itemp_file )
		close( unit=iavg_file )
	    end if
	end if
	return
	end

	subroutine pclamp_to_wcp( ileft, itop )
$include:'wcpcom.for'
c
c	Convert a pCLAMP binary data file into an .WCP file
c
c
c	pCLAMP data file header format
c
	structure /pclamp5/
	union
	map
	integer*2 header(512)
	end map
	map
	real*4 par(80)
	character*77 comment
	character*80 labels
	character*35 reserved
	character*64 pulse
	real*4 par_ext(16)
	real*4 adc_offset(16)
	real*4 adc_gain(16)
	real*4 adc_amplification(16)
	real*4 adc_shift(16)
	character*8 units(16)
	end map
	end union
	end structure

	record /pclamp5/ pc5
	equivalence( pc5, iwork )

	structure /pclamp6/
	union
	map
	integer*2 header(1024)
	end map
	map
	character*4 FileType
	real*4 FileVersionNumber
	integer*2 OperationMode
	integer*4 ActualAcqLength
	integer*2 NumPointsIgnored
	integer*4 ActualEpisodes
	integer*4 FileStartDate
	integer*4 FileStartTime
	integer*4 StopwatchTime
	real*4 HeaderVersionNumber
	integer*2 nFileType
	integer*2 MSBinFormat
	integer*4 DataSectionPtr
	integer*4 TagSectionPtr
	integer*4 NumTagEntries
	integer*4 LongDescriptionPtr
	integer*4 LongDescriptionLines
	integer*4 DACFilePtr
	integer*4 DACFileNumEpisodes
	character*4 Unused
	integer*4 DeltaArrayPtr
	integer*4 NumDeltas
	integer*4 NoteBookPtr
	integer*4 NotebookManEntries
	integer*4 NotebookAutoEntries
	integer*4 SynchArrayPtr
	integer*4 SynchArraySize
	character*20 Unused100

	integer*2 ADCNumChannels
	real*4 ADCSampleInterval
	real*4 ADCSecondSampleInterval
	real*4 SynchTimeUnit
	real*4 SecondsPerRun
	integer*4 NumSamplesPerEpisode
	integer*4 PreTriggerSamples
	integer*4 EpisodePerRun
	integer*4 RunsPerTrial
	integer*4 NumberOfTrials
	integer*2 AveragingMode
	integer*2 UndoRunCount
	integer*2 FirstEpisodeInRun
	real*4 TriggerThreshold
	integer*2 TriggerSource
	integer*2 TriggerAction
	integer*2 TriggerPolarity
	real*4 ScopeOutputInterval
	real*4 EpisodeStartToStart
	real*4 RunStartToStart
	real*4 TrialStartToStart
	integer*4 AverageCount
	character*6 Unused194
	integer*2 DrawingStrategy
	integer*2 TiledDisplay
	integer*2 nEraseStrategy
	integer*2 DataDisplayMode
	integer*4 DisplayAverageUpdate
	integer*2 ChannelStatsStrategy
	integer*4 CalculationPeriod
	integer*4 SamplesPerTrace
	integer*4 StartDisplayNum
	integer*4 FinishDisplayNum
	integer*2 MultiColor
	integer*2 ShowPNRawData
	character*10 Unused234
	real*4 ADCRange
	real*4 DACRange
	integer*4 ADCResolution
	integer*4 DACResolution
	integer*2 ExperimentType
	integer*2 AutosampleEnable
	integer*2 AutosampleADCNum
	integer*2 AutosampleInstrument
	real*4 AutosampleAdditGain
	real*4 AutosampleFilter
	real*4 AutosampleMembraneCap
	integer*2 ManualInfoStrategy
	real*4 CellD1
	real*4 CellD2
	real*4 CellD3
	character*16 CreatorInfo
	character*56 FileComment
	character*12 Unused366

	integer*2 ADCPtoLChannelMap(16)
	integer*2 ADCSamplingSeq(16)
	character*10 ADCChannelname(16)
	character*8 ADCUnits(16)
	real*4 ProgrammableGain(16)
	real*4 DisplayAmplification(16)
	real*4 DisplayOffset(16)
	real*4 InstrumentScaleFactor(16)
	real*4 InstrumentOffset(16)
	real*4 SignalGain(16)
	real*4 SignalOffset(16)
	real*4 SignalLowPassFilter(16)
	real*4 SignalHighPassFilter(16)
	end map
	end union
	end structure

	record /pclamp6/ pc6
	equivalence( pc6, iwork )


	character*50 new_file_name / ' ' /
	parameter(max_files=500,nc_path=52)
	character*52 path / ' ' /
	character*12 files(max_files)
	equivalence( iwork, files )

	character key
	logical pClampV6,pClampV5

	character*4 fVersion
	character*5 fType
	integer*4 iblock,ifirst_block

c
c	code
c

	call create_path( path, default_path, '*', '.dat' )
	call files_menu(path,0,new_file_name,ileft,itop,10,
     &	files,max_files)

	if( new_file_name .ne. ' ' ) then
c
c	    Open pCLAMP data file
c
	    call create_path(path,default_path,new_file_name,'.dat')
	    open(unit=itemp_file,
     &	    file=path,
     &	    form='binary',
     &	    access='direct',
     &	    iostat=istat,
     &	    recl=512)

	    call write_to_log( 'Import pCLAMP '//path )

c
c	    Load header information from pCLAMP header file
c
	    read(unit=itemp_file,rec=1,iostat=istat)
     &	    (pc6.header(i),i=1,1024)
c
c	    Determine whether this is a pClamp V5 or V6 file
c
	    pClampV5 = .false.
	    pClampV6 = .false.
	    if( pc5.par(1) .eq. 1. .or.
     &		pc5.par(1).eq.10. ) pClampV5 = .true.
	    if( pc6.FileType .eq. 'ABF' .or.
     &		pc6.FileType .eq. 'CPLX' .or.
     &		pc6.FileType .eq. 'FTCX' ) pClampV6 = .true.

	    if( pClampV5 ) then
c
c		pClamp V5 data file
c
		fVersion = ' V5'
		if( pc5.par(1) .eq. 1. ) then
		    fType = 'CLPX'
		elseif( pc5.par(1) .eq. 10. ) then
		    fType = 'FTCX'
		else
		    fType = '??'
		end if

		n_channels = int(pc5.par(2))
		n_points = int(pc5.par(3)) / n_channels
		n_records_in = int(pc5.par(4))
                dt = (pc5.par(5)*n_channels)/1000.
		adc_range = pc5.par(53)
		ADCScale = (2.**pc5.par(55)) / 4096.
		if( ADCScale .lt. (1./32.)) then
		    call move_cursor(1,1)
		    call display_string(' Warning! Rescaling by ')
		    call display_flt( ADCScale )
		    if (ADCScale .eq. 0.) then ADCScale = 1.
		end if
		cell = pc5.comment
c
c		Channel scaling/units information
c		(pCLAMP gain factor Volts/units converted to
c		WCP gain factor mV/units. Note how pCLAMP's
c		starting A/D channel number obtained from pc.par(32) )
c
		ipc_chan = int ( pc5.par(32) ) + 1
		do ic = 1,n_channels
		    gain(ic) = pc5.adc_gain(ipc_chan)*1000.
		    y_scale(ic) = convert_gain( gain(ic) )
		    iy_zero(ic) = 2048
		    y_units(ic) = pc5.units(ipc_chan)
		    y_name(ic) = 'C'//char(ichar('0')+ic-1)
		    ipc_chan = ipc_chan + 1
		end do
		ifirst_block = 3
	    end if

	    if( pClampV6 ) then
c
c		pClamp V6 data file
c
		fType = pc6.FileType
		fVersion = ' V6'

		n_channels = pc6.ADCNumChannels
		if( pc6.NumSamplesPerEpisode .le. 0 ) then
		    pc6.NumSamplesPerEpisode = 512
		end if
		n_points = pc6.NumSamplesPerEpisode / n_channels
		n_records_in = pc6.ActualAcqLength /
     &			       pc6.NumSamplesPerEpisode
                dt = (pc6.ADCSampleInterval*n_Channels)/1000.
		adc_range = pc6.ADCRange
		ADCScale = (2.*pc6.ADCResolution) / 4096.
		cell = pc6.FileComment

c
c		Channel scaling/units information
c		(pCLAMP gain factor Volts/units converted to
c		WCP gain factor mV/units.
c
		do ic = 1,n_channels
		    ipc_chan = pc6.ADCSamplingSeq(ic) + 1
		    gain(ic) = pc6.SignalGain(ipc_chan) *
     &		    pc6.InstrumentScaleFactor(ipc_chan)*1000.

c		    Add "AddIt" gain if in use for this channel

                    if( (pc6.AutoSampleADCNum .eq. (ipc_Chan-1))
     &              .and. (pc6.AutoSampleEnable .ne. 0 ) ) then
			gain(ic) = gain(ic) * pc6.AutosampleAdditGain
		    end if

		   if( gain(ic) .eq. 0. ) gain(ic) = 1.

		    y_scale(ic) = convert_gain( gain(ic) )
		    iy_zero(ic) = 2048
		    y_units(ic) = pc6.ADCUnits(ipc_chan)
		    y_name(ic) = pc6.ADCChannelName(ipc_chan)
		end do
		ifirst_block = 5

	    end if

c
c	    Create a new WCP data file to hold converted data
c
	    if( pClampV6 .or. pClampV5 ) then
		call create_path(path,
     &		default_path,new_file_name,'.wcp')
		call get_file_name(3,13,path,'.wcp','NEW',
     &		' Copy to file ',iflag)
	    else
		iflag = -1
		call display_message(2,20,46,
     &		' Conversion failed: Unknown file format ',1)
		call wait(1.)
	    end if

	    if( iflag .ge. 0 ) then

		file_name = path
		open(unit=idata_file,
     &		file=file_name,
     &		form='binary',
     &		access='direct',
     &		recl=512)

		np = n_channels*n_points
		nb = np/256
		n_records = 0
		do ir = 1,n_records_in

		    iblock = (ir-1)*nb + ifirst_block
		    read(unit=itemp_file,rec=iblock,iostat=istat)
     &		     (iwork(i),i=1,np)
		    do i = 1,np
			iwork(i) = int(float(iwork(i))/ADCScale)
     &				   + 2048
		    end do
		    rec.status = 'ACCEPTED'
		    rec.number = float(ir)
		    rec.type = 'TEST'
		    rec.dt = dt
		    n_records = n_records + 1
		    call put_record(
     &		    idata_file, n_records, rec.buf, iwork )

		    call display_progress( 2, 20,
     &		    fVersion//fType//' Records (ESC to abort) ',
     &		    n_records,n_records_in,key)

		    iblock = iblock + np/256
		    if( key .eq. '$' )	goto 101

		end do
101		continue

		call write_to_log( 'To '//file_name )

		call save_header( idata_file )
		close(unit=idata_file)
	    end if

	    close(unit=itemp_file)

	end if
	return
	end

	subroutine wcp_to_pclamp5
$include:'wcpcom.for'
c
c	Convert an WCP binary data file into a pCLAMP file
c
c
c	pCLAMP data file header format
c
	structure /pclamp/
	union
	map
	integer*2 header(512)
	end map
	map
	real*4 par(80)
	character*77 comment
	character*80 labels
	character*35 reserved
	character*64 pulse
	real*4 par_ext(16)
	real*4 adc_offset(16)
	real*4 adc_gain(16)
	real*4 adc_amplification(16)
	real*4 adc_shift(16)
	character*8 units(16)
	end map
	end union
	end structure

	record /pclamp/ pc
	equivalence( pc, ibuffer )

	parameter(max_files=500,nc_path=52)
	character*52 path / ' ' /
	character*12 files(max_files)
	equivalence( iwork, files )

	character key
c
c	code
c

c
c	Open WCP file and get header information
c
	open(unit=idata_file,
     &	file=file_name,
     &	form='binary',
     &	access='direct',
     &	recl=512)
	call get_header( idata_file )
c
c	Create pCLAMP data file
c
	call create_path( path, ' ', file_name, '.dat' )
	call get_file_name(2,itop+12,
     &	path,'.dat','NEW', ' Create file? ',iflag)
	if( iflag .lt. 0 ) then
	    close(unit=idata_file)
	    return
	end if

	open(unit=itemp_file,
     &	file=path,
     &	form='binary',
     &	access='direct',
     &	recl=512)

	call write_to_log( 'Export to pCLAMP file: '//path )

c
c	Create pCLAMP header file
c
	do i = 1,80
	    pc.par(i) = 0.
	end do
	do i = 1,16
	    pc.par_ext(i) = 0.
	end do

	pc.par(1) = 1.
	pc.par(2) = float(n_channels)
	pc.par(3) = float(n_points)*float(n_channels)
	pc.par(4) = float(n_records)
	pc.par(5) = dt*1000.
	pc.par(6) = 0.
	pc.par(7) = 0.
	pc.par(8) = 0.
	pc.par(9) = 5.2
	pc.par(10) = 900101.
	pc.par(11) = 1.
	pc.par(12) = 1.
	pc.par(13) = float(n_records)
	pc.par(14) = aint(dt*500.)*2.
	pc.par(15) = 0.
	pc.par(16) = -1.
	pc.par(17) = 1.
	pc.par(18) = 1.
	pc.par(19) = 0.
	pc.par(24) = pc.par(3) / 512.
	pc.par(25) = 0.

	pc.par(51)=0.
	pc.par(53)=10.
	pc.par(55)=12.
	pc.par(56)=12.


	ichan = 15
	pc.par(32) = float(ichan-1)
	pc.par(33) = 100.
	pc.par(34) = 0.
	pc.par(41) = 100000.
	pc.par(42) = 100.
	pc.par(43) = 100.
	pc.par(47) = 0.
	pc.par(48) = float(n_channels)
	pc.comment = id

	pc.par_ext(1) = 0.
	pc.par_ext(13) = 0.

	do ic = 1,16
	    pc.adc_gain(ic) = 1.
	    pc.adc_offset(ic) = 0.
	    pc.adc_amplification(ic) = 1.
	    pc.adc_shift(ichan) = 0.
	    pc.units(ichan) = 'mV'
	end do

	do ic = 1,n_channels
c
c	    Set pCLAMP Channel gain (note how gain is adjusted
c	    to an A/D input range of +/-10V
	    pc.adc_gain(ichan) = gain(ic) * ( 10./adc_range ) / 1000.
	    pc.adc_offset(ichan) = 0.
	    pc.adc_amplification(ichan) = 1.
	    pc.adc_shift(ichan) = 0.
	    pc.units(ichan) = y_units(ic)
	    ichan = ichan + 1
	end do

	write(unit=itemp_file,rec=1) (pc.header(i),i=1,512)

	np = n_channels*n_points
	nb = np/256
	do ir = 1,n_records

	    call get_record( idata_file, ir, rec.buf, iwork )

	    do i = 1,np
		iwork(i) = iwork(i) - 2048
	    end do

	    iblock = (ir-1)*nb + 3
	    write(unit=itemp_file,rec=iblock) (iwork(i),i=1,np)

	    call display_progress( 2, 20,
     &	    ' Records done (ESC to abort) ', ir,n_records, key )

	    if( key .eq. '$' )	goto 101

	end do
101	continue

	close(unit=itemp_file)
	close(unit=idata_file)

	return
	end

	subroutine wcp_to_pclamp6( ileft, itop )
$include:'wcpcom.for'
c
c	Convert a .WCP file into a pCLAMP V6 .DAT file
c
	structure /pclamp6/
	union
	map
	integer*2 header(1024)
	end map
	map
	character*4 FileType
	real*4 FileVersionNumber
	integer*2 OperationMode
	integer*4 ActualAcqLength
	integer*2 NumPointsIgnored
	integer*4 ActualEpisodes
	integer*4 FileStartDate
	integer*4 FileStartTime
	integer*4 StopwatchTime
	real*4 HeaderVersionNumber
	integer*2 nFileType
	integer*2 MSBinFormat
	integer*4 DataSectionPtr
	integer*4 TagSectionPtr
	integer*4 NumTagEntries
	integer*4 LongDescriptionPtr
	integer*4 LongDescriptionLines
	integer*4 DACFilePtr
	integer*4 DACFileNumEpisodes
	character*4 Unused
	integer*4 DeltaArrayPtr
	integer*4 NumDeltas
	integer*4 NoteBookPtr
	integer*4 NotebookManEntries
	integer*4 NotebookAutoEntries
	integer*4 SynchArrayPtr
	integer*4 SynchArraySize
	character*20 Unused100

	integer*2 ADCNumChannels
	real*4 ADCSampleInterval
	real*4 ADCSecondSampleInterval
	real*4 SynchTimeUnit
	real*4 SecondsPerRun
	integer*4 NumSamplesPerEpisode
	integer*4 PreTriggerSamples
	integer*4 EpisodesPerRun
	integer*4 RunsPerTrial
	integer*4 NumberOfTrials
	integer*2 AveragingMode
	integer*2 UndoRunCount
	integer*2 FirstEpisodeInRun
	real*4 TriggerThreshold
	integer*2 TriggerSource
	integer*2 TriggerAction
	integer*2 TriggerPolarity
	real*4 ScopeOutputInterval
	real*4 EpisodeStartToStart
	real*4 RunStartToStart
	real*4 TrialStartToStart
	integer*4 AverageCount
	character*6 Unused194
	integer*2 DrawingStrategy
	integer*2 TiledDisplay
	integer*2 nEraseStrategy
	integer*2 DataDisplayMode
	integer*4 DisplayAverageUpdate
	integer*2 ChannelStatsStrategy
	integer*4 CalculationPeriod
	integer*4 SamplesPerTrace
	integer*4 StartDisplayNum
	integer*4 FinishDisplayNum
	integer*2 MultiColor
	integer*2 ShowPNRawData
	character*10 Unused234
	real*4 ADCRange
	real*4 DACRange
	integer*4 ADCResolution
	integer*4 DACResolution
	integer*2 ExperimentType
	integer*2 AutosampleEnable
	integer*2 AutosampleADCNum
	integer*2 AutosampleInstrument
	real*4 AutosampleAdditGain
	real*4 AutosampleFilter
	real*4 AutosampleMembraneCap
	integer*2 ManualInfoStrategy
	real*4 CellD1
	real*4 CellD2
	real*4 CellD3
	character*16 CreatorInfo
	character*56 FileComment
	character*12 Unused366

	integer*2 ADCPtoLChannelMap(16)
	integer*2 ADCSamplingSeq(16)
	character*10 ADCChannelname(16)
	character*8 ADCUnits(16)
	real*4 ProgrammableGain(16)
	real*4 DisplayAmplification(16)
	real*4 DisplayOffset(16)
	real*4 InstrumentScaleFactor(16)
	real*4 InstrumentOffset(16)
	real*4 SignalGain(16)
	real*4 SignalOffset(16)
	real*4 SignalLowPassFilter(16)
	real*4 SignalHighPassFilter(16)
	end map
	end union
	end structure

	record /pclamp6/ pc6
	equivalence( pc6, iwork )

	character*52 path / ' ' /

	character key
	integer*4 n4

c
c	code
c
c
c	Open WCP file and get header information
c
	open(unit=idata_file,
     &	file=file_name,
     &	form='binary',
     &	access='direct',
     &	recl=512)
	call get_header( idata_file )

c
c	Create a name for a pCLAMP data file
c
	call create_path( path, ' ', file_name, '.dat' )
	call get_file_name(2,itop+12,
     &	path,'.dat','NEW', ' Create file? ',iflag)
	if( iflag .lt. 0 ) return
c
c	Open the pCLAMP file
c
	open(unit=itemp_file,
     &	file=path,
     &	form='binary',
     &	access='direct',
     &	recl=512)

	call write_to_log( 'Export to pCLAMP file: '//path )
c
c	Create pClamp V6 (Axon Binary File) header
c
	do i = 1,1024
	    pc6.header(i) = 0
	end do

	pc6.FileType = 'ABF '
	pc6.FileVersionNumber = 1.1
	pc6.OperationMode = 5

	pc6.ActualAcqLength = n_points*n_channels
	n4 = n_records
	pc6.ActualAcqLength = pc6.ActualAcqLength*n4

	pc6.NumPointsIgnored = 0
	pc6.ActualEpisodes = n_records
	pc6.FileStartDate = 950101
	pc6.FileStartTime = 0
	pc6.StopwatchTime = 0
	pc6.HeaderVersionNumber = 1.1
	pc6.nFileType = 1
	pc6.MSBinFormat = 0

	pc6.DataSectionPtr = 4
	pc6.TagSectionPtr = 0
	pc6.NumTagEntries = 0
	pc6.LongDescriptionPtr = 0
	pc6.LongDescriptionLines = 0
	pc6.DACFilePtr = 0
	pc6.DACFileNumEpisodes = 0
	pc6.DeltaArrayPtr = 0
	pc6.NumDeltas = 0
	pc6.NotebookPtr = 0
	pc6.NotebookManEntries = 0
	pc6.NotebookAutoEntries = 0
	pc6.SynchArrayPtr = 0
	pc6.SynchArraySize = 0

	pc6.ADCNumChannels = n_channels
c       ** dt fixed 8/5/96
        pc6.ADCSampleInterval = (dt * 1000.) / float(n_channels)
	pc6.ADCSecondSampleInterval = 0.
	pc6.SynchTimeUnit = 0.
	pc6.SecondsPerRun = 0
	pc6.NumSamplesPerEpisode = n_points*n_channels
	pc6.PreTriggerSamples = 50
	pc6.EpisodesPerRun = 1
	pc6.RunsPerTrial = 1
	pc6.NumberofTrials = 1
	pc6.AveragingMode = 0
	pc6.UndoRunCount = -1
	pc6.FirstEpisodeInRun = 1
	pc6.TriggerThreshold = 100
	pc6.TriggerSource = -2
	pc6.TriggerAction = 0
	pc6.TriggerPolarity = 0
	pc6.ScopeOutputInterval = 0.
	pc6.EpisodeStartToStart = 1.
	pc6.RunStartToStart = 1.
	pc6.TrialStartToStart = 1.
	pc6.AverageCount = 1

	pc6.DrawingStrategy = 1
	pc6.TiledDisplay = 0
	pc6.DataDisplayMode = 1
	pc6.DisplayAverageUpdate = -1
	pc6.ChannelStatsStrategy = 1
	pc6.CalculationPeriod = 16384
	pc6.SamplesPerTrace = 1024
	pc6.StartDisplayNum = 1
	pc6.FinishDisplayNum = 0
	pc6.MultiColor = 1
	pc6.ShowPNRawData = 0

	pc6.ADCRange = ADC_Range
	pc6.DACRange = ADC_Range
	pc6.ADCResolution = 2048
	pc6.DACResolution = 2048
        pc6.AutoSampleEnable = 0
        pc6.AutoSampleAddItGain = 1.
        pc6.AutoSampleADCNum = 0

	pc6.ExperimentType = 0

	pc6.FileComment = id

	do i = 1,16
	    pc6.ADCPToLChannelMap(i) = i-1
	    pc6.ADCSamplingSeq(i) = -1
	    pc6.ADCChannelName(i) = ' '
	    pc6.ADCUnits(i) = 'mV'
	    pc6.ProgrammableGain(i) = 1.
	    pc6.DisplayAmplification(i) = 1.
	    pc6.DisplayOffset(i) = 0.
	    pc6.InstrumentScaleFactor(i) = 1.
	    pc6.InstrumentOffset(i) = 0.
	    pc6.SignalGain(i) = 1.
	    pc6.SignalOffset(i) = 0.
	    pc6.SignalLowpassFilter(i) = 100000.
	    pc6.SignalHighpassFilter(i) = 0.

	end do

	do ic = 1,n_channels
	    pc6.ADCSamplingSeq(ic) = 16-ic
	    ipc_chan = pc6.ADCSamplingSeq(ic) + 1
	    pc6.InstrumentScaleFactor(ipc_chan) = Gain(ic) / 1000.
	    pc6.ADCUnits(ipc_chan) = y_units(ic)
	    pc6.ADCChannelName(ipc_chan) = y_name(ic)
	end do

c
c	Write header information to pCLAMP header file
c
	write(unit=itemp_file,rec=1,iostat=istat)
     &	(pc6.header(i),i=1,1024)


	ifirst_block = 5
	key = 'S'
	nb = n_points*n_channels / 256
	do ir = 1,n_records

	    call get_record( idata_file, ir, rec.buf, iwork )

	    do i = 1,n_points*n_channels
		iWork(i) = iWork(i) - 2048
	    end do

	    iblock = (ir-1)*nb + ifirst_block
	    write(unit=itemp_file,rec=iblock,iostat=istat)
     &	     (iWork(i),i=1,n_points*n_channels)

	    call display_progress( 3, 20,
     &	    ' Records Exported (ESC to abort) ',ir,n_records,key)

	    if( key .eq. '$' )	goto 101

	end do
101	continue

	close(unit=itemp_file)
	close(unit=idata_file)

	return
	end



	subroutine cfs_to_wcp( ileft, itop )
$include:'wcpcom.for'
c
c	Convert a CED Filing System file to WCP
c
	structure / channel_def /
	character*22 chanName
	character*10 unitsY
	character*10 unitsX
	integer*1 dType
	integer*1 dKind
	integer*2 dSpacing
	integer*2 otherChan
	end structure

	structure / channel_info /
	integer*4 dataOffset		      !   {offset to first point}
	integer*4 dataPoints		       !{number of points in channel}
	real*4 scaleY
	real*4 offsetY
	real*4 scaleX
	real*4 offsetX
	end structure

	structure / data_header /
	integer*4 lastDS
	integer*4 dataSt
	integer*4 dataSz
	integer*2 flags
	integer*2 space(8)
	end structure

	structure /cfs_file_header/
	character*8 marker
	character*14 name
	integer*4 fileSz
	character*8 timeStr
	character*8 dateStr
	integer*2 dataChans
	integer*2 filVars
	integer*2 datVars
	integer*2 fileHeadSz
	integer*2 dataHeadSz
	integer*4 endPnt
	integer*2 dataSecs
	integer*2 diskBlkSize
	character*73 commentStr
	integer*4 tablePos
	integer*2 fspace(20)
	end structure

	record /channel_def/ ch_def
	record /channel_info/ ch_info
	record / cfs_file_header / fh
	record / data_header / dh

	integer*4 ipointer,ip
	character*12 new_file_name / ' ' /
	parameter(max_files=500,nc_path=52)
	character*52 path / ' ' /
	character*12 files(max_files)
	equivalence( iwork, files )
	real*4 scale(max_channels)
	integer*2 ispacing(max_channels)
	integer*4 ioffset(max_channels)
	integer*2 np(max_channels)
	character*40 string

	character key
c
c	code
c

	call create_path( path, default_path, '*', '.dat' )
	call files_menu(path,0,new_file_name,ileft,itop,10,
     &	files,max_files)

	if( new_file_name .ne. ' ' ) then
c
c	    Let user change export file name
c
	    call create_path(path,default_path,new_file_name,'.dat')
	    open(unit=itemp_file,
     &	    file=path,
     &	    form='binary',
     &	    access='direct',
     &	    iostat=istat,
     &	    recl=1)

	    call write_to_log( 'Import from CFS file '//path )

c
c	    Open WCP file with same name
c
	    call create_path(file_name,
     &	    default_path,new_file_name,'.wcp')

	    call get_file_name(2,itop+12,
     &	    file_name,'.wcp','NEW', ' Create file? ',iflag)
	    if( iflag .lt. 0 ) then
		close(unit=itemp_file)
		return
	    end if

	    open(unit=idata_file,
     &	    file=file_name,
     &	    form='binary',
     &	    access='direct',
     &	    recl=512)

c
c	    Read CFS file header block
c
	    read(unit=itemp_file,rec=1,iostat=istat) fh

	    if( fh.marker(1:7) .ne. 'CEDFILE' ) then
		CALL QUERY_BOX(2,itop+4,
     &		' ERROR: Not a CFS file! Press ESC to continue ',key )
		close(unit=itemp_file)
		return
	    end if

	    n_channels = min(fh.dataChans,max_channels)
	    nc = ichar(fh.commentStr(1:1))
	    id = fh.commentStr(2:nc+1)
	    call write_to_log( id )
	    call write_to_log( fh.timeStr )
	    call write_to_log( fh.dateStr )
	    n_conv = fh.DataSecs
	    adc_range = 5.
	    rec.ad_range = 5.

c	    Read Channel definition records
c
	    do ic = 1,n_channels

		inquire(unit=itemp_file,nextrec=ip)
		read(unit=itemp_file,rec=ip,iostat=istat) ch_def

		nc = ichar( ch_def.chanName(1:1))
		y_name(ic) = ch_def.chanName(2:nc+1)
		write( string, '(''Channel '',i1)') ic
		call write_to_log(string(1:10)//ch_def.chanName(2:nc+1))

		nc = ichar(ch_def.unitsY(1:1))
		y_units(ic) = ch_def.unitsY(2:nc+1)
		call write_to_log(string(1:10)//ch_def.unitsY(2:nc+1))

		if( y_units(ic) .eq. 'uV' ) then
		    write( string,
     &		'(''Ch.'',i1,'' Convert uV -> mV units (Y/N) '')') ic
		    CALL QUERY_BOX(ileft+1,itop+1,
     &		    string(1:len_trim(string)+1),key)
		    if( key .eq. 'Y' ) then
			scale(ic) = 1E-3
			y_units(ic) = 'mV'
		    else
			scale(ic) = 1.
		    end if
		else
		    scale(ic) = 1.
		end if

		nc = ichar(ch_def.unitsX(1:1))
		call write_to_log('T units '//ch_def.unitsX(2:nc+1))
		string = ch_def.unitsY(2:nc+1)
		if( string(1:1) .eq. 'u' ) then
		    t_mult = 1E-3
		else
		    t_mult = 1.
		end if

		ispacing(ic) = ch_def.dspacing

	    end do
c
c	    Read data records from CFS file
c
	    n_records = 0
	    do irec = 1,n_conv

		call display_progress( 2, 20,
     &		' Records done (ESC to abort) ',n_records, n_conv, key )
		if( key .eq. '$' )  goto 101
c
c	       Get pointer to start of data record
c
	       ipointer = fh.tablePos + 1 + (irec-1)*4

	       read(unit=itemp_file,rec=ipointer,iostat=istat) ip
	       ip = ip + 1

c
c	       Read data header
c
	       read(unit=itemp_file,rec=ip,iostat=istat) dh
c
c	       Read channel offset/scaling information records
c
	       do ichan = 1,n_channels

		    inquire(unit=itemp_file,nextrec=ip)
		    read(unit=itemp_file,rec=ip,iostat=istat) ch_info
c
c		    Multiply by 16 to account for conversion from
c		    CED's +-32767 data range to 0-4096 and
c		    by scale(ichan) to account for any units change

		    y_scale(ichan) = (ch_info.scaleY)*16.*scale(ichan)
		    gain(ichan) = convert_gain( y_scale(ichan) )

		    dt = ch_info.scaleX*t_mult
		    rec.dt = dt
		    t_units = 'ms'

		    np(ichan) = ch_info.dataPoints
		    ioffset(ichan) = ch_info.dataOffset

	       end do

		if( irec .eq. 1 ) then
c
c		    Find a suitable number of points per record
c
		    npmax = 0
		    do ichan = 1,n_channels
			if( npmax .lt. np(ichan) ) npmax = np(ichan)
		    end do

		    n_points = 256
		    do while( n_points .lt. npmax .and.
     &			n_points .lt. max_points )
			n_points = n_points*2
		    end do

		end if
c
c		Read binary data
c
	       do ichan = 1,n_channels

		    inc = ispacing(ichan)
		    ip = dh.dataSt + ioffset(ichan) + 1
		    npced = np(ichan)

		    j = ichan
		    do i = 1,n_points
			iwork(j) = 2048
			if( i .le. npced ) then
			    read(unit=itemp_file,rec=ip,iostat=istat)
     &			    iwork(j)
			    iwork(j) = int( float(iwork(j))/16. + 2048. )
			end if
			j = j + n_channels
			ip = ip + inc
		    end do

		end do

		n_records = n_records + 1
		rec.status = 'ACCEPTED'
		rec.type = 'TEST'
		rec.number = float(irec)
		rec.iequation = 0
		rec.number = n_records
		call put_record(idata_file,n_records,rec.buf,iwork)

	    end do
101	    continue

	    close(unit=itemp_file)
	    call save_header(idata_file)
	    close(unit=idata_file)
	end if

	return
	end

	subroutine wcp_to_cfs
$include:'wcpcom.for'
c
c	Convert a WCP file to a CED Filing System file
c
	structure / channel_def /
	character*22 chanName
	character*10 unitsY
	character*10 unitsX
	integer*1 dType
	integer*1 dKind
	integer*2 dSpacing
	integer*2 otherChan
	end structure

	structure / channel_info /
	integer*4 dataOffset		      !   {offset to first point}
	integer*4 dataPoints		       !{number of points in channel}
	real*4 scaleY
	real*4 offsetY
	real*4 scaleX
	real*4 offsetX
	end structure

	structure / data_header /
	integer*4 lastDS
	integer*4 dataSt
	integer*4 dataSz
	integer*2 flags
	integer*2 space(8)
	end structure

	structure /cfs_file_header/
	character*8 marker
	character*14 name
	integer*4 fileSz
	character*8 timeStr
	character*8 dateStr
	integer*2 dataChans
	integer*2 filVars
	integer*2 datVars
	integer*2 fileHeadSz
	integer*2 dataHeadSz
	integer*4 endPnt
	integer*2 dataSecs
	integer*2 diskBlkSize
	character*73 commentStr
	integer*4 tablePos
	integer*2 fspace(20)
	end structure

	record /channel_def/ ch_def
	record /channel_info/ ch_info
	record / cfs_file_header / fh
	record / data_header / dh

	parameter(max_export=max_points*3)
	integer*4 itable(max_export)
	equivalence( itable,iwork(max_points*max_channels+1) )

	integer*4 ip,iend
	parameter(nc_path=52)
	character*52 path / ' ' /

	character key
c
c	code
c
c
c	Open WCP file and get header information
c
	open(unit=idata_file,
     &	file=file_name,
     &	form='binary',
     &	access='direct',
     &	recl=512)
	call get_header( idata_file )
c
c	Create CFS data file
c
	call create_path( path,' ',file_name,'.dat')
	call get_file_name(2,itop+12,
     &	path,'.dat','NEW',' Create file? ',iflag)
	if( iflag .lt. 0 ) then
	    close(unit=idata_file)
	    return
	end if

	open(unit=itemp_file,
     &	file=path,
     &	form='binary',
     &	access='direct',
     &	recl=1)

	call write_to_log( 'Export to CFS: '//path )

c
c	Write CFS file header block
c
	ip=1
	write(unit=itemp_file,rec=ip) fh

c
c	Write Channel definition records
c
	do ichan = 1,n_channels

	    ch_def.dType = 2
	    ch_def.dKind = 0
	    ch_def.dspacing = 2

	    ch_def.chanName(1:1) = char(2)
	    ch_def.chanName(2:3) = y_name(ichan)

	    ch_def.unitsY = ' '
	    ch_def.unitsY(1:1) = char(2)
	    ch_def.unitsY(2:3) = y_units(ichan)

	    ch_def.unitsX = ' '
	    ch_def.unitsX(1:1) = char(2)
	    ch_def.unitsX(2:3) = 'ms'

	    inquire(unit=itemp_file,nextrec=ip)
	    write(unit=itemp_file,rec=ip) ch_def
	end do
c
c	Copy records from WCP to CFS file
c
	inquire(unit=itemp_file,nextrec=iend)
	fh.fileHeadSz = iend-1

	n_done = 0
	do irec = 1,min(n_records,max_export)

	    call get_record(idata_file,irec,rec.buf,iwork)

	    call display_progress( 2, 20,
     &	    ' Records done (ESC to abort) ', irec, n_records, key )
	    if( key .eq. '$' )	goto 101
c
c	    Write data record header
c
	    ip = iend
	    itable(irec) = ip-1
	    write(unit=itemp_file,rec=ip) dh
	    do ichan = 1,n_channels
		 ch_info.dataOffset = (ichan-1)*n_points*2
		 ch_info.dataPoints = n_points
		 ch_info.scaleY = y_scale(ichan)/16.
		 ch_info.offsetY = 0.
		 ch_info.scaleX = dt
		 ch_info.offsetX = 0.
		 inquire(unit=itemp_file,nextrec=ip)
		 write(unit=itemp_file,rec=ip) ch_info
	    end do

	    inquire(unit=itemp_file,nextrec=ip)
	    dh.dataSt = ip-1
	    fh.dataheadSz = dh.dataSt - itable(irec)

	    do ichan = 1,n_channels

		j = ichan
		do i = 1,n_points
		    iwork(j) = int( float(iwork(j)-2048)*16.)
		    j = j + n_channels
		end do
		inquire(unit=itemp_file,nextrec=ip)
		write(unit=itemp_file,rec=ip )
     &		(iwork(j),j=ichan,n_points*n_channels,n_channels)


	    end do

	    inquire(unit=itemp_file,nextrec=iend)
	    dh.dataSz = iend - itable(irec) - 1
	    if( irec.gt.1 ) then
		dh.lastDS = itable(irec-1)
	    else
		dh.lastDS = 0
	    end if
	    dh.flags = 0
	    write(unit=itemp_file,rec=(itable(irec)+1)) dh

	    n_done = n_done + 1

	end do
101	continue

c
c	Write pointer table to file
c
	fh.tablePos = iend-1
	write(unit=itemp_file,rec=iend ) (itable(irec),irec=1,n_done)
	inquire(unit=itemp_file,nextrec=iend)
	fh.fileSz = iend-1

c
c	Write file header block again with final values
c	for complete file
c
	fh.marker = 'CEDFILE"'

	ie = len_trim( path )
	is = ie
	do while( is.gt.1 .and.
     &		  path(is:is) .ne. '\' .and.
     &		  path(is:is) .ne. ':' )
	    is = is - 1
	end do
	fh.name(2:14) = path(is+1:ie)
	fh.name(1:1) = char( len_trim(fh.name(2:14)) )

	fh.timeStr = '10:00:00'
	fh.dateStr = '11-02-93'
	fh.dataChans = n_channels
	fh.filVars = 0
	fh.datVars = 0
	fh.endPnt = itable(n_done)
	fh.dataSecs = n_done
	fh.diskBlkSize = 1
	nc = len_trim(id)
	fh.commentStr = ' '
	fh.commentStr(2:73) = id
	fh.commentStr(1:1) = char(nc)

	ip = 1
	write(unit=itemp_file,rec=ip ) fh

	close(unit=itemp_file)
	close(unit=idata_file)

	return
	end

	subroutine ascii_to_wcp( ileft, itop )
$include:'wcpcom.for'
c
c	Convert a list of numbers into an WCP file


	character*12 new_file_name / ' ' /
	parameter(max_files=500,nc_path=52)
	character*52 path / ' ' /
	character*12 files(max_files)
	equivalence( iwork, files )
	real*4 y(max_channels,max_points)
	equivalence( iwork, y )
	real*4 row(20),ymax(max_channels),ymin(max_channels)

	character key
	logical end_of_file
c
c	code
c

	call create_path( path, default_path, '*', '.*' )
	call files_menu(path,0,new_file_name,ileft,itop,10,
     &	files,max_files)

	if( new_file_name .ne. ' ' ) then

	    call create_path(path,default_path,new_file_name,' ')
	    open(unit=itemp_file,
     &	    file=path,
     &	    form='binary',
     &	    iostat=istat,
     &	    recl=1)

	    call write_to_log( 'Import from '//path )

c
c	    Open WCP file with same name
c
	    call create_path(file_name,
     &	    default_path,new_file_name,'.wcp')
	    call get_file_name(2,itop+12,
     &	    file_name,'.wcp','NEW',' Create file? ',iflag)
	    if( iflag .lt. 0 ) then
		close(unit=itemp_file)
		return
	    end if

	    open(unit=idata_file,
     &	    file=file_name,
     &	    form='binary',
     &	    access='direct',
     &	    recl=512)

	    do ic = 1,max_channels
		ymax(ic) = -1E30
		ymin(ic) = 1E30
	    end do

	    end_of_file = .false.
	    n_channels = 0
	    np_in = 0
	    do while((.not. end_of_file) .and. (np_in.lt.max_points))

		call extract_row(itemp_file,row,nc,end_of_file)

		if( nc .gt. 1 ) then
		    dt = row(1) - t0
		    t0 = row(1)
		    np_in = np_in + 1
		    do ic = 1,min(nc-1,max_channels)
			y(ic,np_in) = row(ic+1)
			if(y(ic,np_in).gt.ymax(ic)) ymax(ic)= y(ic,np_in)
			if(y(ic,np_in).lt.ymin(ic)) ymin(ic)= y(ic,np_in)
		    end do

		    if( mod( np_in, 10 ) .eq. 0 ) then
			call display_progress( 2, 20,
     &		    ' Points done (ESC to abort) ', np_in,2048, key )
			if( key .eq. '$' ) end_of_file = .true.
		    end if

		    n_channels = max(nc-1,n_channels)
		end if
	    end do
c
c	    Select a scaling range so that channels fit into record
c
	    do ic = 1,n_channels
		r = ymax(ic) - ymin(ic)
		r = r*1.5
		ymax(ic) = ymax(ic) + 0.25*r
		ymin(ic) = ymin(ic) - 0.25*r
		y_scale(ic) = (ymax(ic) - ymin(ic))/float(max_adc)
		gain(ic) = convert_gain( y_scale(ic) )
		izero_sample(ic) = 1
	    end do

c
c	    Select a record size
c
	    n_points = 256
	    do while( n_points. lt. np_in )
		n_points = n_points*2
	    end do
c
c	    Convert from real values into binary integers
c
	    j = 0
	    do i = 1,n_points
		k = min(i,np_in)
		do ic = 1,n_channels
		   j = j + 1
		   iwork(j) = int( (y(ic,k) - ymin(ic))/y_scale(ic))
		end do
	    end do


	    np = n_channels*n_points
	    nb = np/256
	    n_records = 1

	    rec.status = 'ACCEPTED'
	    rec.number = 1.
	    rec.time = 0.
	    rec.ad_range = adc_range
	    rec.dt = dt

	    call put_record( idata_file, 1, rec.buf, iwork )

	    call display_progress( 2, 20,
     &	    ' Records done (ESC to abort) ', ir,n_records, key )

	    call write_to_log( 'New file '//file_name )

	    call save_header( idata_file )
	    close(unit=itemp_file)
	    close(unit=idata_file)

	end if
	return
	end


       subroutine extract_row(ifile,row,n,end_of_file)
       real*4 row(1)
       integer*2 n
       logical end_of_file

	logical quit
	character*1 byte,cr,lf
	character*20 string

	cr = char(13)
	lf = char(10)

	end_of_file = .false.
	is = 0
	n = 0
	quit = .false.
	do while( .not. quit )
	    read(unit=ifile,end=50) byte
	    if( (byte .eq. cr) .or. (byte .eq. lf) ) quit = .true.
	    goto 51
50	    quit = .true.
	    end_of_file = .true.
51	    continue

	    inum = index('0123456789Ee+-.',byte)

	    if( inum .gt. 0 ) then
c
c		If character is part of a number, append it to
c		the number string
c
		is = is + 1
		string(is:is) = byte
	    elseif( is .gt. 0 ) then
c
c		If enough characters are available for a number
c		decode it.
c
		n = n + 1
		read( string, '(f16.0)', err=100 ) row(n)
		goto 101
100		row(n) = 0.
101		continue
		is = 0
		string = ' '
	    end if
	end do
	return
	end
