	subroutine record_averaging( abort )
$INCLUDE: 'wcpcom.for'
	logical abort	    ! Returned .TRUE. if no average created
c
c	Digital averaging
C
	LOGICAL redraw,SPECIAL,new_menu,quit
	logical new_start / .true. /
	INTEGER*2 IDISPLAY_AREA(4)

	character string*60, key, stat*8

	parameter(nmenu=8,istatus_left=64,istatus_top=19)
	character*15 menu(nmenu) /
     &	'Magnify       +',
     &	'Next  rec. PgDn',
     &	'Prev. rec. PgUp',
     &	'Goto  rec. Home',
     &	'Mark start   F1',
     &	'Mark End     F2',
     &	'Do average   F3',
     &	'Exit        ESC'/

c
c	Display magnification, offsets & colour
c
	integer*2 iy_magn(max_channels) / 6*6 /
	integer*2 min_y_scale(max_channels) / 6*6 /
	integer*2 max_y_scale(max_channels) / 6*32 /
	integer*2 iy_offset(max_channels) / 6*0 /
	character*1 display_channel(max_channels) / 6*'Y' /
C
C -- CODE -------------------------------------------------------
c
	abort = .true.
c
c	Open digitised signal data file
c
	ifile = idata_file
	open(unit=idata_file,file=file_name,form='binary',
     &	access='direct', recl=512)
	call get_header( ifile )


	if( new_start ) then
	    i_start = 1
	    i_end = n_points
	    new_start = .false.
	end if


C
C -- Set size of display area
C 
	CALL SET_CHARACTER_HEIGHT(ISCREEN,1000)
	CALL GET_CHARACTER_SIZE(IW,IH)
	IDISPLAY_AREA(1) = IW
	IDISPLAY_AREA(2) = MAX_ndc - 24576 - IH
	IDISPLAY_AREA(3) = IDISPLAY_AREA(1) + ((60*IW)/512)*512
	IDISPLAY_AREA(4) = IDISPLAY_AREA(2) + 24576
	CALL SET_SIZE(IDISPLAY_AREA(1),IDISPLAY_AREA(2)
     &	,IDISPLAY_AREA(3),IDISPLAY_AREA(4))
C
C	Set display size to whole of buffer , cursor in middle
C
	N_DISP = N_POINTS
	ICURSOR = N_DISP/2
	IOLD_CURSOR = ICURSOR
	I0 = 1
	I1 = N_DISP
C
C	Read first frame then do a change frame
C	to get frame number on display
c
	irecord = 1
	call get_record(ifile,irecord,rec.buf,iwork)
	istep = 0
	call change_record(ifile,irecord,istep,rec.buf,iwork)

	redraw = .TRUE.
	new_menu = .true.
	call erase_all

C -- Begin display loop --------------------------------------------
C
	quit = .false.
	do while ( .not. quit )
c
c	    Refresh options menu
c
	    if( new_menu ) then
		key = ' '
		iop = IMENU_VERTICAL1(menu,'+QPH123$'
     &		,nmenu,istatus_left-1,1,new_menu,iop,' Options ',key)
	    endif


	    IF( redraw ) THEN
C
C	    -- Draw display border and help information -------------------
C
		T_MIN = FLOAT(I0 -1)*DT
		T_MAX = FLOAT(I0 + N_DISP - 1)*DT
		call set_writing_mode( iscreen, overwrite )
c		 call set_fill_interior( iscreen, 1, 1, 5 )
		CALL ERASE_BOX(1,1,62,21)
		CALL DISPLAY_BOX(1,1,62,21)
		CALL MOVE_CURSOR(2,21)
		WRITE(STRING,'(f7.2,1x,a)') T_MIN,T_UNITS
		CALL DISPLAY_STRING(STRING(1:13))
		WRITE(STRING,'(f7.2,1x,a)') T_MAX,T_UNITS
		CALL MOVE_CURSOR(48,21)
		CALL DISPLAY_STRING(STRING(1:13))
		CALL MOVE_CURSOR(2,1)
		CALL DISPLAY_STRING(' Create average records ')

c		 call set_fill_interior( iscreen, 0, 0, 1 )
		call set_writing_mode( iscreen, 2 )

		call display_box(1,22,istatus_left-2,25)

c
c		Display start/end of analysis area
c
		CALL SET_WRITING_MODE(ISCREEN,2)
		call set_polyline_type(iscreen,3)

		if( (i_start .ge. i0) .and. (i_start.le.i0+n_disp))
     &		call display_cursor(
     &		iscreen,idisplay_area,i_start-i0+1,n_disp)

		if( (i_end.ge.i0) .and. (i_end.le.i0+n_disp))
     &		call display_cursor(
     &		ISCREEN,idisplay_area,I_end-I0+1,N_DISP)

c
c		Display zero level
c
		do ich = 1,n_channels
		    if( display_channel(ich) .eq. 'Y' ) then
			call set_polyline_type(iscreen,3)
			call set_polyline_colour(iscreen,
     &			icolour(ich))
			call display_horizontal_cursor(iscreen,
     &			idisplay_area,iy_zero(ich),iy_magn(1),
     &			iy_offset(1))
		    end if
		end do
		call set_polyline_colour( iscreen, 1 )
		call set_polyline_type(iscreen,1)
		call set_writing_mode( iscreen, overwrite )
c
c		Put readout cursor on-screen
c
		icursor = max(min(icursor,i0+n_disp-1),i0)
		iold_cursor = icursor
		call display_cursor(
     &		iscreen,idisplay_area,iold_cursor-i0,n_disp)

		CALL SET_WRITING_MODE(	ISCREEN, overwrite )
C
C --		Display signal on screen
C
		do ich = 1,n_channels
		    if( display_channel(ich) .eq. 'Y' ) then
			call plot_channel(iscreen,idisplay_area,
     &			iwork,
     &			ich,n_channels,i0, n_disp, iy_magn(ich),
     &			iy_offset(ich),icolour(ich))
		    end if
		end do

		redraw = .false.
	    end if
C
C --	   Draw vertical readout cursor -------------------------------
C
	    call set_polyline_colour( iscreen, 1 )
	    call set_writing_mode( iscreen, exor )
	    call display_cursor(iscreen,idisplay_area,iold_cursor-i0,
     &	    n_disp)
	    call display_cursor(iscreen,idisplay_area,icursor-i0,n_disp)
	    call set_writing_mode( iscreen, overwrite )
	    IOLD_CURSOR = ICURSOR

c
c --	    Display status information
c
	    call move_cursor(3,23)
	    stat = rec.status
	    tm = rec.time
	    write(string,
     &	     '(''Record  '',i5,''/'',i5,'' at '',f11.2,1x,a)')
     &	     irecord,n_records,tm,stat
	    call display_string(string(1:50))

	    iy = 25 - n_channels - 2
	    call display_box(istatus_left-1,iy,79,25)
	    TIME = FLOAT(ICURSOR-1)*DT*tscale
	    write(string,'(''T:'',F11.2,a)') time,t_units
	    call move_cursor(istatus_left,iy+1)
	    call display_string(string(1:15))

	    do ich = 1,n_channels
		if( display_channel(ich) .eq. 'Y' ) then
		    i = (icursor-1)*n_channels + ich
		    y = float(iwork(i) - iy_zero(ich))*y_scale(ich)
		    write( string,'(a2,f11.2,a2)') y_name(ich),y,
     &		    y_units(ich)
		    call move_cursor(istatus_left,iy+ich+1)
		    call set_text_colour(iscreen,icolour(ich))
		    call display_string(string(1:15))
		end if
	    end do
	    call set_text_colour(iscreen,black)

	    call set_margins(2,1,80,25)

c
c	    Wait for user to press a key
c
	    call wait_for_key( key, special )

	    ibig_step = max(n_disp/10,2)
	    if( special .and. (key .eq. 'L') ) then
C		<- = move cursor left 1 point
		ICURSOR = max( ICURSOR - 1, 1 )
		IF(ICURSOR .LT. I0) THEN
		    I0 = max(I0 - ibig_step,1)
		    I1 = I0 + N_DISP - 1
		    redraw = .TRUE.
		ENDIF
		iop = 0
	    elseif( special .and. (key .eq. 'R') ) then
C		-> = move cursor right 1 point
		ICURSOR = min0(ICURSOR + 1,n_points)
		i1 = i0 + n_disp - 1
		IF(ICURSOR .GT. I1) THEN
		    I1 = min0(I1 + ibig_step,n_points)
		    I0 = I1 - N_DISP + 1
		    redraw = .TRUE.
		ENDIF
		iop = 0
	    elseif( special .and. (key .eq. 'B') ) then
C		CTRL <- = B Move cursor left (big step)
		ICURSOR = max(ICURSOR - ibig_step,1)
		IF(ICURSOR .LT. I0) THEN
		    I0 = max(I0 - ibig_step,1)
		    I1 = I0 + N_DISP - 1
		    redraw = .TRUE.
		ENDIF
		iop = 0
	    elseif( special .and. (key .eq. 'F') ) then
C		CTRL -> = Move cursor right (big step)
		ICURSOR = min0( ICURSOR + ibig_step, n_points )
		i1 = i0 + n_disp - 1
		IF(ICURSOR .GT. I1) THEN
		    I1 = min0( I1 + ibig_step*2, n_points )
		    I0 = I1 - N_DISP + 1
		    redraw = .TRUE.
		ENDIF
		iop = 0
	    else
C
c		Present options menu and return "iop=1..8" if
c		an option has been selected. "iop=0" if no selection
c
		iop = IMENU_VERTICAL1(menu,'+QPH123$'
     &		,nmenu,istatus_left-1,1,new_menu,iop,' Options ',key)

	    endif

	    select case (iop)
	    case (1)
C
C	    Expand display
C
	    call change_display_magnification( iwork,
     &	    i0,n_disp,iy_magn,iy_offset,min_y_scale,max_y_scale,
     &	    idisplay_area )
	    icursor = max(min(icursor,i0+n_disp-1),i0)
	    redraw = .TRUE.
	    new_menu = .true.

	    case (2)
C
C	    PgDn - Read next frame
C
	    istep = 1
	    call change_record(ifile,irecord,istep,rec.buf,iwork)
	    redraw = .TRUE.

	    case (3)
C
C	    PgUp - Read last frame stored
C
	    istep = -1
	    call change_record(ifile,irecord,istep,rec.buf,iwork)
	    redraw = .TRUE.

	    case (4)
C
C	    Goto selected record
C
	    write(string,'('' Go to record (1-'',i5,'') ? '')')
     &	    n_records
	    call display_message(2,23,46,string(1:30),1)
	    call get_number(r,1.,float(n_records),float(irecord))
	    call erase_box(2,23,istatus_left-1,25)
	    istep = int(r) - irecord
	    call change_record(ifile,irecord,istep,rec.buf,iwork)
	    redraw = .TRUE.

	    case( 5 )
c
c		Set start of peak-finding area
c
		i_start = icursor
		redraw = .true.

	    case( 6 )
c
c		Set end of peak-finding area
c
		i_end = icursor
		redraw = .true.

	    case( 7 )
c
c		DO averaging
c
		call create_averages( ifile, i_start, i_end )
		quit = .true.
		abort = .false.

	    case (8)
c
c		Cancel
c
		quit = .true.

	    end select
	end do

	close(unit=ifile)
	return
	end

	SUBROUTINE CREATE_AVERAGES(ifile,i_start,i_end)
C
C	-----------------------------------------------------------
C	Average individual record in .SCA file and store on SCAN.AVG
C	file. Note that records can be shifted to match mid-points
C	of rising phases.
C	-----------------------------------------------------------
C
$INCLUDE:'wcpcom.for'
C
	CHARACTER KEY
	LOGICAL new_menu,first
	real*4 sum(max_points)
	EQUIVALENCE (IWORK(max_points*max_channels+1),sum)
	integer*2 ibuf(max_points)
	EQUIVALENCE (IWORK(max_points*(max_channels+2)+1),ibuf)

	parameter(imid_point = max_points/2)
	parameter(nmenu=4)
	character*38 menu(nmenu)
	character*8 list(nmenu)
	character*40 title
	character*70 avg_name

	parameter( no_alignment=1, mid_positive=2, mid_negative=3 )
	integer*2 ipolarity / 1 /
	integer*2 ir_s /0/, ir_e /0/, igroup_size /0/
	integer*2 iy_zero_avg(max_channels)
c
c	code
c
c
c	Open average data file (.avg extension)
c
	avg_name = file_name
	ix = index( avg_name, '.' )
	avg_name(ix:ix+3) = '.avg'
	open(unit=iavg_file,file=avg_name,form='binary',
     &	access='direct', recl=512)


c	Let user set range of records to be averaged
c
	i = 1
	write(menu(i),'('' Start at record (1-'',I5,'')'')') n_records
	write(list(i),'(i5)') max(min(ir_s,n_records),1)
	if( ir_e .eq. 0 ) then
	    ir_e = n_records
	    igroup_size = n_records
	endif
	i = i + 1
	menu(i) = ' End at record '
	write(list(i),'(i5)') min(ir_e,n_records)
	i = i + 1
	menu(i) = ' In groups of '
	write(list(i),'(i5)') igroup_size

	title = ' '
10     if(title.eq.' ') title = ' Set range of records to be averaged '
	call text_window(menu,list,3,2,2,title)

	i = 1
	ir_s = int(check_limits(list,1.,float(n_records),i,title))
	if( title .ne. ' ' ) goto 10
	i = i + 1
	ir_e = int(check_limits(list,1.,float(n_records),i,title))
	if( title .ne. ' ' ) goto 10
	i = i + 1
	igroup_size= int(check_limits(list,1.,float(n_records),i,title))
	if( title .ne. ' ' ) goto 10

c
c	Get type of alignment used to line up records before averaging
c
	menu(1) = ' No alignment '
	menu(2) = ' Mid-point of positive rising phase '
	menu(3) = ' Mid-point of negative rising phase '
	new_Menu = .true.
	ialign = Iwait_MENU_VERTICAL1(menu,'123'
     &	,3,3,3,new_menu,ialign,' Align records by ',key)
c
c	Get type of record to be averaged
c
	call select_record_type( 4,4+ialign, selected_type )


	menu(1) = ' WAIT ... Averaging records '
	menu(2) = ' Press ESC to abort'
	menu(3) = ' '
	call display_message(4,6,34,menu,3)
C
C -- Loop to calculate average of group of records
C
	ix = 5
	iy = 16

	do ichan = 1,n_channels
c
c	    Average each channel separately

	    n_averages = 0

	    do ir0 = ir_s,ir_e,igroup_size
c
c		Clear summation array for group
c
		do i = 1,n_points
		    sum(i) = 0.
		end do
		navg = 0
		imidj = 0

		first = .true.
		do ir = ir0,min(ir0+igroup_size-1,ir_e)

		    call get_record(ifile,ir,rec.buf,iwork)

		    if( rec.status .eq. 'ACCEPTED' .and.
     &		    (rec.type .eq. selected_type .or.
     &		    selected_type .eq. 'ALL') ) then
c
c			Extract channel from record
c			(and subtract zero level)
c
			do i = 1,n_points
			    j = (i-1)*n_channels + ichan
			    ibuf(i) = iwork(j) - iy_zero(ichan)
			end do

		       if( ialign .ne. no_alignment ) then

			    if( ialign .eq. mid_positive ) then
				ipolarity = 1
			    else
				ipolarity = -1
			    end if
c
c			    Find peak of signal
c
			    ipeak = -32767
			    do i = i_start,i_end
				if(ibuf(i)*ipolarity .gt. ipeak) then
				    ipeak = ibuf(i)*ipolarity
				    ipeaki = i
				endif
			    end do
c
c			    Find mid-point of rising phase
c
			    imid = ipeak/2
			    imidi = ipeaki
			    do while((ibuf(imidi)*ipolarity .gt. imid)
     &			    .and. imidi.gt.i_start )
				imidi = imidi - 1
			    end do

			   if( imidj .eq. 0 ) imidj = imidi

			else
			    imidj = 0
			    imidi = 0
			end if
c
c			Add signal to summation buffer
c
			do i = 1,n_points
			    j = max(min(imidi-imidj+i,n_points),1)
			    sum(i) = sum(i) +
     &			    float(ibuf(j))*y_scale(ichan)
			end do
			navg = navg + 1
c
c			Save the zero level so it can be restored
c			to the averaged record (i.e. the zero level
c			of the average record is acquired from the
c			last ACCEPTED record) 18/10/95
c
			iy_zero_avg(ichan) = iy_zero(ichan)

			call move_cursor(5,9)
			write( menu(3),
     &			'('' Records:'',i5,''/'',i5,'' Avg.'',i5)')
     &			ir,ir_e,n_averages+1
			call display_string( menu(3)(1:32) )
c
c			Keep record no. and time of first record
c			in series so it can be stored with average record
c
			if( first ) then
			    igroup = ir
			    gtime = rec.time
			    first = .false.
			end if

		    endif
		end do

		n_averages = n_averages + 1
c
c		Get average record with other channels
c		(if this is not the first)
c
		if( ichan .ne. 1 ) then
		   call get_record(iavg_file,n_averages,rec.buf,iwork)
		end if

		navg = max(navg,1)
		do i = 1,n_points
		    j = (i-1)*n_channels + ichan
		    iwork(j) = int(sum(i)/(y_scale(ichan)*float(navg)))
     &		     + iy_zero_avg(ichan)
		end do
c
c		Save to averages file
c
		rec.number = float(igroup)
		rec.time = gtime
		rec.status = 'ACCEPTED'
		call put_record(iavg_file,n_averages,rec.buf,iwork)
	    end do
	end do

	itemp = n_records
	n_records = n_averages
	call save_header( iavg_file )
	n_records = itemp
	close( unit= iavg_file )

	return
	end

