	subroutine waveform_analysis( i_start, i_end )
$INCLUDE:'wcpcom.for'
c
C	-------------------------------------------------------------------
c	Analyse signal waveforms
C	-------------------------------------------------------------------
c
	integer*2 i_start,i_end
c	Start/End of analysis area. These values are also used
c	by WCPA2D.FOR for on-line waveform analysis
c	5/6/95 ... Absolute/pos/neg peak modes added
c	18/10/95 ... Area calculation correct
c		     (i_end-i_start instead of i_end-i_start+1)
C
	LOGICAL CHANGE_display,SPECIAL,new_menu,quit,out_of_range
	CHARACTER*1 KEY
	CHARACTER*80 STRING
	CHARACTER*60 TEXT(14)

	integer*2 iarea(4)

	parameter(nmenu=14,istatus_left=64,istatus_top=21)
	character*15 menu(nmenu) /
     &	'Select Chan. F1',
     &	'Magnify       +',
     &	'Next  rec. PgDn',
     &	'Prev. rec. PgUp',
     &	'Goto  rec. Home',
     &	'Mark T.zero  F2',
     &	'Mark Start   F3',
     &	'Mark End     F4',
     &	'Do Analysis  F5',
     &	'Plot Results F6',
     &	'Quantal Ana. F7',
     &	'Zero level   F8',
     &	'LP Filter    F9',
     &	'Exit        ESC'/


	parameter(ileft=1,itop=1,nheight=10,nwidth=60)
	parameter(nv=11)

c	Display magnification, offsets & colour
c
	integer*2 iy_scale(max_channels) / 6*3 /
	integer*2 min_y_scale(max_channels) / 6*3 /
	integer*2 max_y_scale(max_channels) / 6*512 /
	integer*2 iy_offset(max_channels) / 6*0 /
	character*56 title

	integer*2 ich /1/
	character*4 selected_type / 'ALL' /

	logical new_start / .true. /
	character rec_status*8, rec_type*4

	real*4 xy(max_points*2)
	equivalence( iwork(max_points+1), xy )
C
C
C -- CODE -------------------------------------------------------
C
c
c	Select data file to be analysed (.WCP or .AVG)
c
	itype = 0
	call select_data_file( 2,2, itype, ifile, title )

	CALL GET_SCREEN_DEVICE(ISCREEN)
C
C -- Set size and location of display area
C 
	CALL SET_CHARACTER_HEIGHT(ISCREEN,1000)
	CALL GET_CHARACTER_SIZE(IW,IH)
	call erase_all
	iright = ileft + nwidth + 1
	ibottom = itop + nheight + 1
	iarea(1) = ileft*iw
	iarea(2) = max_ndc - (itop+nheight)*ih
	iarea(3) = iarea(1) + nwidth*iw
	iarea(4) = iarea(2) + nheight*ih
C
C	Set display range to whole of buffer , cursor in middle
C
	if( new_start ) then
	    i0 = 1
	    i_start = 1
	    i_zero = 1
	    n_disp = n_points
	    i_end = n_points
	    icursor = n_points/2
	    IOLD_CURSOR = ICURSOR
	    new_start = .false.
	end if

	i1 = i0 + n_disp - 1
C
C	Read first frame then do a change frame
C	to get frame number on display
C
	irecord = 1
	call find_next_record(ifile,irecord,iwork,
     &	selected_type, 0, ich, out_of_range )

	change_display = .true.
	new_menu = .true.
	nlines = 0
C
C -- Begin display loop --------------------------------------------
C
	quit = .false.
	do while( .not. quit )
c
c	    Refresh options menu
c
	    if( new_menu ) then
		key = ' '
		iop = IMENU_VERTICAL1(menu,'1+QPH23456789$',nmenu,
     &		istatus_left-1,1,new_menu,iop,' Wave. Options ',key)
	    endif

	    IF( CHANGE_display ) THEN

C
C	    -- Draw display border and help information -------------------
C
		call erase_box(ileft,itop,iright,ibottom)
		call display_box(ileft,itop,iright,ibottom)

		call move_cursor(ileft+1,itop)
		call display_stringt(title)

		call move_cursor(ileft+1,ibottom)
		t = rec.dt*float(i0-1)*tscale
		write(string,'(1x,f6.1,a)') t,t_units
		call display_stringt( string )

		call move_cursor(iright-10,ibottom)
		t = rec.dt*float(i0+n_disp-1)*tscale
		write(string,'(1x,f6.1,a)') t,t_units
		call display_stringt( string )

c
c		Display analysis area cursors
c
		call set_writing_mode( iscreen, transparent )
		call set_polyline_type( iscreen, dotted )
		if( i_start.ge.i0 .and. i_start.le.(i0+n_disp)	)
     &		call display_cursor(iscreen,iarea,i_start-i0+1,n_disp)
		if( i_end.ge.i0 .and. i_end.le.(i0+n_disp)  )
     &		call display_cursor(iscreen,iarea,i_end-i0+1,n_disp)
		call set_polyline_type( iscreen, dot_dash )
		if( i_zero.ge.i0 .and. i_zero.le.(i0+n_disp)  )
     &		 call display_cursor(iscreen,iarea,i_zero-i0+1,n_disp)
c
c		Add cursor
c
		call set_polyline_type( iscreen, solid )
		call set_writing_mode( iscreen, exor )
		call display_cursor(iscreen,iarea,icursor-i0+1,n_disp)
		iold_cursor = icursor
		call set_writing_mode( iscreen, overwrite )

c
c		Plot channel being analysed
c
		call plot_channel( iscreen, iarea, iwork,1,1
     &		,i0, n_disp, iy_scale(ich),iy_offset(ich),icolour(ich))

		call set_writing_mode( iscreen, transparent )
		call set_polyline_type(iscreen,dotted)
		call set_polyline_colour( iscreen, icolour(ich))
		call display_horizontal_cursor(iscreen,
     &		iarea,iy_zero(ich),iy_scale(ich),iy_offset(ich))
		call set_polyline_type(iscreen,solid)
		call set_writing_mode( iscreen, overwrite )
		call set_polyline_colour( iscreen, black )

		call move_cursor( ileft+10, ibottom )
		rec_status = rec.status
		rec_type = rec.type
		rec_time = rec.results(1,ixtim)
		write( string,
     &		'(''Rec.'',i5,''/'',i5,1x,a4,'' at'',f8.1,''s '',a)')
     &		irecord,n_records,rec_type,rec_time,rec_status

		call display_stringt( string )
		change_display = .FALSE.

		call create_waveform_results(nv,ich, text, nlines )
		call display_results( text, 2, nlines )

	    end if

C
C -----     Draw vertical readout cursor -------------------------------
C
	    call set_writing_mode( iscreen, exor )
	    call display_cursor( iscreen, iarea, iold_cursor-i0+1,
     &	    n_disp)
	    call display_cursor( iscreen, iarea, icursor-i0+1,n_disp)
	    call set_writing_mode( iscreen, overwrite )
	    iold_cursor = icursor
C
c
c --	    Display status box ----------------------------------
c
	    call display_box(istatus_left-1,istatus_top-1,79,25)
c
c	    Display current cursor values
c
	    write( string, '(''Channel '',i1)') ich-1
	    call move_cursor(istatus_left,istatus_top)
	    call display_stringt(string)
	    t = FLOAT(icursor-i_zero)*rec.dt*tscale
	    write(string,'(''T:'',F8.3,a)') t,t_units
	    call move_cursor(istatus_left,istatus_top+1)
	    call display_stringt(string)

	    y = float(iwork(icursor) - iy_zero(ich) )*y_scale(ich)
	    write(string,'(a,f8.3,a)') y_name(ich),y,y_units(ich)
	    call move_cursor(istatus_left,istatus_top+2)
	    call display_stringt( string )

c
c	    Wait for user to press a key
c
	    call wait_for_key( key, special )

	    ibig_step = max(n_disp/10,2)
	    if( special .and. (key .eq. 'L') ) then
C		<- = move cursor left 1 point
		ICURSOR = max( ICURSOR - 1, 1 )
		IF( ICURSOR .LT. i0 ) THEN
		    i0 = max(i0 - ibig_step,1)
		    i1 = i0 + n_disp - 1
		    CHANGE_DISPLAY = .TRUE.
		ENDIF
		iop = 0
	    elseif( special .and. (key .eq. 'R') ) then
C		-> = move cursor right 1 point
		ICURSOR = min(ICURSOR + 1,n_points)
		i1 = i0 + n_disp - 1
		IF (ICURSOR .GT. i1 ) THEN
		    i1 = min(i1 + ibig_step,n_points)
		    i0 = i1 - n_disp + 1
		    CHANGE_DISPLAY = .TRUE.
		ENDIF
		iop = 0
	    elseif( special .and. (key .eq. 'B') ) then
C		CTRL <- = B Move cursor left (big step)
		ICURSOR = max(ICURSOR - ibig_step,1)
		IF(ICURSOR .LT. i0) THEN
		    i0 = max(i0 - ibig_step*2,1)
		    i1 = i0 + n_disp - 1
		    CHANGE_DISPLAY = .TRUE.
		ENDIF
		iop = 0
	    elseif( special .and. (key .eq. 'F') ) then
C		CTRL -> = Move cursor right (big step
		ICURSOR = min( ICURSOR + ibig_step, n_points )
		i1 = i0 + n_disp - 1
		IF(ICURSOR .GT. i1) THEN
		    i1 = min( i1 + ibig_step, n_points )
		    i0 = i1 - n_disp + 1
		    CHANGE_DISPLAY = .TRUE.
		ENDIF
		iop = 0
	    else
C
c		Present options menu and return "iop=1..14" if
c		an option has been selected. "iop=0" if no selection
c
		iop = IMENU_VERTICAL1(menu,'1+QPH23456789$',nmenu,
     &		istatus_left-1,1,new_menu,iop,' Wave. Options ',key)

	    endif
c
c ---	    Process menu options selected by user --------------------
c
	    select case( iop )

	    case( 1 )
c
c		Select channel and record type
c
		new_menu = .true.
		call select_channel( 2,2, ' Channel No. ', ich )
		call select_record_type( 3,3+ich, selected_type )

		irecord = max(irecord-1,1)
		call find_next_record(ifile,irecord,iwork,
     &		selected_type, 0, ich, out_of_range )

		new_menu = .true.
		change_display = .true.

	    case( 2 )
C
C --		Select display scaling mode
C
		n_hold = n_channels
		n_channels = 1
		call change_display_magnification(iwork,i0,n_disp,
     &		iy_scale(ich),iy_offset(ich),min_y_scale(ich),
     &		max_y_scale(ich),iarea)
		n_channels = n_hold

		icursor = max(min(icursor,i0+n_disp-1),i0)
		new_menu = .true.
		change_display = .true.

	    case( 3 )
C
C --		PgDn - Read next valid record
C
		call find_next_record(ifile,irecord,iwork,
     &		selected_type, 1, ich, out_of_range )
		change_display = .true.

	    case( 4 )
C
C --		PgUp - Read previous valid record
C
		call find_next_record(ifile,irecord,iwork,
     &		selected_type, -1, ich, out_of_range )
		change_display = .true.

	    case( 5 )
C
C --		Goto selected record
C
		write(string,'('' Go to record (1-'',i5,'') ? '')')
     &		 n_records
		call display_message(3,3,46,string(1:30),1)
		call get_number(r,1.,float(n_records),float(irecord))
		call erase_box(2,23,istatus_left-1,25)
		istep = int(r) - irecord

		call find_next_record(ifile,irecord,iwork,
     &		selected_type, istep, ich, out_of_range )
		change_display = .true.

	    case( 6 )
c
c		Mark zero time point on record
c
		i_zero = icursor
		change_display = .true.

	    case( 7 )
c
c		Mark start of analysis area
c
		i_start = icursor
		change_display = .true.

	    case( 8 )
c
c		Mark end of analysis area
c
		i_end = icursor
		change_display = .true.

	   case( 9 )
c
c		Do waveform analysis
c
		call do_analysis(ifile,ir_s,ir_e,selected_type,ich,
     &		i_start,i_end)

		call find_next_record(ifile,irecord,iwork,
     &		selected_type, 0, ich, out_of_range )
		new_menu = .true.
		change_display = .true.

	    case( 10 )
c
c --		F6 Plot X/Y plots of results
c
		call plot_results(ifile,title(1:len_trim(title)+1),
     &		nv,selected_type,ich,xy)
		call erase_all
		new_menu = .true.
		change_display = .true.

	    case( 11 )
c
c --		Quantal analysis
c
		call quantal_content_analysis(ifile,i_start,i_end)
		new_menu = .true.
		change_display = .true.

	    case( 12 )
c
c --		F6 Set zero baseline level
c
		call set_zero_level1(iwork,icursor,ich)

c		Reload record to recompute baseline

		call find_next_record(ifile,irecord,iwork,
     &		selected_type, 0, ich, out_of_range )

		new_menu = .true.
		change_display = .true.

	    case( 13 )
c
c --		Set signal smoothing factor
c
		call display_message(2,2,52,
     &		' Low-pass filter cut-off (Hz) ',1)
	       call get_number(filter_cutoff,0.,1000./rec.dt,
     &	       1000.*filter_cutoff)
	       filter_cutoff = filter_cutoff/1000.

		call find_next_record(ifile,irecord,iwork,
     &		selected_type, 0, ich, out_of_range )
		new_menu = .true.
		change_display = .true.

	    case( 14 )
C
C --		Esc quit this option
C
		quit = .true.

	    end select
	end do

	call save_header( ifile )
	close(unit=ifile)
	return
	end

	subroutine do_analysis(ifile,ir_s,ir_e,selected_type,ichan,
     &	i_start,i_end)
$INCLUDE:'wcpcom.for'
C
C	------------------------------------------------------------------
C	Read each frame stored on file and calculate, average current,
C	peak current, area, rise time, zero current level. Store these
C	values in the frames's analysis block.
c
c	ir_s ... ir_e	  Series of record to be analysed (In)
c	selected_type	  Type of record to analysed (In)
c	ichan		  Channel to be analysed (In)
c	i_start .. i_end  Range of samples within record to be analysed
c
	integer*2 ir_s,ir_e
	character*(*) selected_type
	parameter(nmenu=3)
	character*22 menu(nmenu) /
     &	' Absolute peak   A',
     &	' Positive peak   +',
     &	' Negative peak   -' /

	parameter( iAbsMode=1, iPosMode=2, iNegMode=3 )
	integer*2 iPeakMode /iAbsMode/

	CHARACTER KEY
	LOGICAL out_of_range,new_menu


C
C -- CODE -------------------------------------------------------------
C
c
c	Get range of records to be fitted
c
	call set_record_range(ir_s,ir_e,2,2,' Records to be analysed ')
c
c	Select peak analysis mode
c
	new_menu = .true.
	iPeakMode = Iwait_MENU_VERTICAL1(menu,'A+-'
     &	,3,2,6,new_menu,iPeakMode,' Peak analysis mode ',key)

C
C ----- Analyse records in series IR_S to IR_E
c	Place results in ANALYSIS sector of each record
c
	irecord = ir_s - 1
	out_of_range = .false.
	t_last = 0.
	do while( (irecord .lt. ir_e) .and. .not. out_of_range )
C
C	    Read data record from file
C
	    call find_next_record(ifile,irecord,iwork,
     &	    selected_type, 1, ichan, out_of_range )

	    if( .not. out_of_range ) then

		rec.results(ichan,ixnum) = rec.number
		rec.results(ichan,ixtim) = rec.time
c
c		Time since last valid record
c
		if( t_last .gt. 0. ) then
		    rec.results(ichan,ixint) = rec.time - t_last
		else
		    rec.results(ichan,ixint) = 0.
		end if
		t_last = rec.time

C
C		Calculate average and area
C
		sum = 0.
		do i = i_start,i_end
		    sum = sum + float(iwork(i))
		end do
		avg = sum / float(i_end - i_start + 1)
     &		- float(iy_zero(ichan))
		rec.results(ichan,ixavg) = avg*y_scale(ichan)
		rec.results(ichan,ixarea) =
     &		avg*float(i_end-i_start)*y_scale(ichan)*rec.dt*tscale
c
c		Calculate variance within analysis range
c
		avg = avg + float(iy_zero(ichan))
		var = 0.
		do i = i_start,i_end
		    y = float(iwork(i)) - avg
		    var = var + y*y
		end do
		var = var/float( max(i_end-i_start+1,1) )
		rec.results(ichan,ixvar) =
     &		var*y_scale(ichan)*y_scale(ichan)
C
C		Find peak value within analysis range
c		(Absolute, positive or negative depending on mode)
C
		iz = iy_zero(ichan)
		iMax = 0
		iMin = 4096
		do i = i_start,i_end
		    iY = iwork(i) - iz
		    if( iY .gt. iMax ) then
			iMax = iY
			iMax0 = i
		    end if
		    if( iY .lt. iMin ) then
			iMin = iY
			iMin0 = i
		    end if
		end do
c
c		Select Abs./pos./neg. peak
c
		select case (iPeakMode)
		case (iAbsMode)
		    if( iabs(iMax) .gt. iabs(iMin) ) then
			iPeak = IMax
			iPk0 = iMax0
		    else
			iPeak = iMin
			iPk0 = iMin0
		    end if
		case (IPosMode)
		    iPeak = iMax
		    iPk0 = iMax0
		case (iNegMode)
		    iPeak = iMin
		    iPk0 = iMin0
		end select

		rec.results(ichan,ixpeak) = float(iPeak)*y_scale(ichan)
c
c		Find 10% - 90% rise time
c
		level_10 = abs(iPeak/10)
		level_50 = abs(iPeak/2)
		level_90 = abs(iPeak) - level_10

		ip_10 = i_start
		ip_90 = ipk0
		do i = ipk0,i_start,-1
		    iy = abs( iwork(i) - iz )
		    if( iy .ge. level_90) ip_90 = i
		    if( iy .le. level_10 ) then
			ip_10 = i
			goto 20
		    end if
		end do
20		continue
		rec.results(ichan,ixrise_time) =
     &		float(ip_90-ip_10)*rec.dt*tscale
C
C		Calculate max. rate-of-rise
c
		max_diff = 0
		do i = max(ip_10,2),ipk0
		    idiff = iwork(i) - iwork(i-1)
		    if( abs(idiff) .gt. abs(max_diff) )
     &		    max_diff = idiff
		end do
		rec.results(ichan,ixrate_of_rise) =
     &		float(max_diff)*y_scale(ichan)/(rec.dt*tscale)

C
C		Calculate time to 50% and 90% decay
C
		ip_50 = ipk0
		ip_90 = ipk0
		do i = ipk0,i_end
		    iy = abs( iwork(i) - iz )
		    if( iy .ge. level_50) ip_50 = i
		    if( iy .le. level_10 ) then
			ip_90 = i
			goto 30
		    end if
		end do
30		continue
		rec.results(ichan,ixt90) =
     &		float(ip_90 - ipk0)*rec.dt*tscale
		rec.results(ichan,ixt50) =
     &		float(ip_50 - ipk0)*rec.dt*tscale

		call put_analysis_block(ifile,irecord,rec.buf)

	    end if
C
c	    Display count of records done
c
	    call display_progress( 5, 9,
     &	    ' Records done (ESC to abort)', irecord, ir_e, key )
	    IF(KEY.EQ.'$') GOTO 101	! ESC key

	end do
101	continue

	RETURN
	END

	subroutine create_waveform_results(nv,ichan,text,nlines )
$include:'wcpcom.for'
	character*(*) text(1)

	call variable_units( ichan )

	nlines = 0
	if( rec.results(ichan,ixnum) .ne. 0. ) then
	    do i = 1,nv
		nlines = nlines + 1
		write( text(nlines), '(a,''='',f12.3,1x,a)')
     &		var_name(i),rec.results(ichan,i),v_units(i)
	    end do
	else
	    nlines = nlines + 1
	    text(1) = 'No Results'
	end if
	return
	end
