	program wavgen
$include:'wavcom.for'
c
c	Voltage Clamp Waveform Generator V1.1 9/1/95
c	(c) J. Dempster 1994
c	Program now adjusts D/A update interval between primary & alternate
c	CED 1401 D/A output now terminates correctly when ESC pressed
c

	parameter(nmenu=9  ,istatus_left=64)
	character*14 menu(nmenu) /
     &	'Edit Wave   F1',
     &	'Load Wave   F2',
     &	'Save Wave   F3',
     &	'Load Alt.   F4',
     &	'Del. Wave   F5',
     &	'Preview     F6',
     &	'Output      F7',
     &	'Lab. Int.   F8',
     &	'Exit         Q' /

	character key
	parameter(np_max=6000)
	parameter(iDacSize=np_max*4)
	integer*2 idac(iDacSize)
	character*16 lab_card_name

	record /pulse/ primary
	record /pulse/ alternate

	integer*2 iprimary_area(4),ialternate_area(4)
	logical new_menu,quit,new_start,erase_display,output

c	code
c
	new_start = .true.

C	Prevent run-time MATHs error from aborting program
C	(see Appendix D Microsoft FORTRAN V4.1 Users Guide)
	CALL LCWRQQ(16#133E)
C
C	Open Gem graphics package
C
	CALL OPEN_WORKSTATION(ISCREEN,1)
	IF(ISCREEN.EQ.0) STOP
c
c	Initialise pulse
	primary.pulses = 1.
	primary.groups = 10.
	primary.period = 1000.
	do ipulse = 1,max_pulses
	     primary.pulse_height_start(ipulse) = 0.
	     primary.pulse_height_end(ipulse) = 0.
	     primary.pulse_height_inc = 0.
	     primary.pulse_width(ipulse) = 0.
	     primary.pulse_width_inc(ipulse) = 0.
	     alternate.pulse_height_start(ipulse) = 0.
	     alternate.pulse_height_end(ipulse) = 0.
	     alternate.pulse_height_inc = 0.
	     alternate.pulse_width(ipulse) = 0.
	     alternate.pulse_width_inc(ipulse) = 0.
	 end do
	 primary.pulse_height_start(1) = 1000.
	 primary.pulse_height_end(1) = 1000.
	 primary.pulse_width(1) = 100.
	 alternate_pulses = 0.
	 primary.synch_amplitude = 5000.
	 primary.synch_delay = 0.
	 primary.synch_delay_inc = 0.
	 alternate.synch_amplitude = 5000.
	 alternate.synch_delay_inc = 0.
	 primary.file_name = ' '
	 alternate.file_name = ' '
	 interface_card = 1
	 primary_name = ' '
	 alternate_name = ' '


C	Read configuration file which supplies interface card no.,
c	last used waveform files

	call read_initialisation_file('\gemapps\gemsys\wavgen.ini' )

c
c	If primary or alternate files exist, load them
c
	if( primary_name .ne. ' ' ) then
	   call load_waveform( 0,0,primary, primary_name,'PRI')
	end if
	if( alternate_name .ne. ' ' ) then
	   call load_waveform( 0,0,alternate, alternate_name,'ALT')
	end if


C
C -- Set size of display area
C 
	CALL SET_CHARACTER_HEIGHT(ISCREEN,1000)
	CALL GET_CHARACTER_SIZE(IW,IH)
	iprimary_area(1) = IW
	iprimary_area(2) = MAX_ndc - (ipr_bottom-1)*IH + ih/2
	iprimary_area(3) = iprimary_area(1) + ((60*IW)/512)*512
	iprimary_area(4) = iprimary_area(2) + 3*4096
	ialternate_area(1) = IW
	ialternate_area(2) = MAX_ndc - (ialt_bottom-1)*IH + ih/2
	ialternate_area(3) = ialternate_area(1) + ((60*IW)/512)*512
	ialternate_area(4) = ialternate_area(2) + 3*4096

	quit = .false.
	erase_display = .true.
	do while( .not. quit )

	    if( alternate_name .eq. ' ' ) then
		menu(4) =  'Load Alt.   F4'
	    else
		menu(4) =  'Cancel Alt. F4'
	    end if


	    if( erase_display ) then
		call erase_waveform_window()
		erase_display = .false.
	    end if

	    call move_cursor(43,1)
	    call get_lab_interface_shortname(interface_card,
     &	    lab_card_name)
	    call display_string( ' '//lab_card_name )

	    new_menu = .true.
	    iop = iwait_menu_vertical1(menu,'12345678Q',nmenu,
     &	    istatus_left,1,new_menu,iop,' Options ',key)

	    select case( iop )

	    case( 1 )
c
c ----		Edit voltage program settings
c
		call edit_voltage_program( primary )
		erase_display = .true.

	    case( 2 )
c
c ----		Load a pulse protocol from a *.vpr file
c
		call load_waveform( 2,2,primary, primary_name,'PRI')
		erase_display = .true.

	    case( 3 )
c
c		Save voltage program to *.vpr file
c
		call save_waveform( 2,2,primary, primary_name)
		erase_display = .true.

	    case( 4 )
c
c ----		Load/Cancel the alternate voltage program
c
		if( alternate_name .eq. ' ' ) then
		    call load_waveform(2,2,
     &		    alternate, alternate_name, 'ALT')  !Load Alternate
		else
		    alternate_name = ' '
		    alternate_groups = 0.
		endif
		erase_display = .true.

	    case( 5 )

		call delete_waveform( 3,3+iop )
		erase_display = .true.

	    case( 6 )
c
c		Preview waveform
c
		if( new_start ) then
		    call open_lab( interface_card, idac )
		    new_start = .false.
		    call allocate_dac_buffer(idac,1,istart,np_max*2)
		end if

		np_dac = np_max
		output = .false.
		call do_waveform(iprimary_area,ialternate_area,
     &		idac(istart),np_dac,
     &		primary,alternate,output)

	    case( 7 )
c
c		Output waveform
c
		if( new_start ) then
		    call open_lab( interface_card, idac )
		    call allocate_dac_buffer(idac,1,istart,np_max*2)
		    new_start = .false.
		end if

		np_dac = np_max
		output = .true.
		call do_waveform(iprimary_area,ialternate_area,
     &		idac(istart),np_dac,
     &		primary,alternate,output)

	    case( 8 )

		if( .not. new_start ) call close_lab()
		call select_lab_interface(interface_card,lab_card_name)
		call open_lab( interface_card, idac )
		erase_display = .true.

	    case( 9 )
C
C		Stop program
C
		CALL QUERY_BOX(2,2,
     &		' Exit Program! Are you sure (Y/N) ? ',key)
		if( key .eq. 'Y' ) quit = .true.
		erase_display = .true.

	    end select
	end do

	call save_initialisation_file('\gemapps\gemsys\wavgen.ini' )
	call close_workstation( iscreen )
	stop
	end



	subroutine edit_voltage_program( active )
$include: 'wavcom.for'

	parameter(nmenu=9)
	character*18 menu(nmenu) /
     &	'Program      F1',
     &	'Pulse #1     F2',
     &	'Pulse #2     F3',
     &	'Pulse #3     F4',
     &	'Pulse #4     F5',
     &	'Pulse #5     F6',
     &	'Waveform     F7',
     &	'Sync. Pulse  F8',
     &	'Exit        ESC' /

	logical quit,new_menu
	record /pulse/ active
	character key

c
c	code


	quit = .false.
	do while( .not. quit )

	    call erase_waveform_window()

	    new_menu = .true.
	    iop = iwait_menu_vertical1(menu,'12345678$',nmenu,2,2,
     &	    new_menu,iop,' Edit Wave ',key)

	    select case( iop )

	    case( 1 )
		call set_program(3,iop+3,active)
	    case( 2 )
		call set_pulse(1,3,iop+3,active)
	    case( 3 )
		call set_pulse(2,3,iop+3,active)
	    case( 4 )
		call set_pulse(3,3,iop+3,active)
	    case( 5 )
		call set_pulse(4,3,iop+3,active)
	    case( 6 )
		call set_pulse(5,3,iop+3,active)
	    case( 7 )
		call set_external(3,iop+3,active)
	    case( 8 )
		call set_synch(3,iop+3,active)
	    case( 9 )
		quit = .true.
	    end select
	end do
	return
	end

	subroutine set_program(ix,iy,active)
$include:'wavcom.for'
c
c	Set program period repeat rates
c
	parameter(nmenu=4, big=1E30 )
	character*26 menu(nmenu) /
     &	'Pulse repeat period  (ms)',
     &	'Pulses per group        ',
     &	'Groups per program      ',
     &	'Holding Voltage      (mV)' /

	character*12 list(nmenu)
	character*36 title
	record /pulse/ active
c
c	code
c
	i = 1
	r = active.period
	write(list(i),'(f12.3)') r
	i = i + 1
	r = active.pulses
	write(list(i),'(f12.3)') r
	i = i + 1
	r = active.groups
	write(list(i),'(f12.3)') r
	i = i + 1
	r = active.holding_voltage
	write(list(i),'(f12.3)') r

	title = ' '
100	if( title .eq. ' ' ) title = ' Edit Program '
	call text_window( menu, list, nmenu, ix, iy, title )

	i = 1
	active.period = check_limits(list,0.,big,i,title)
	if( title .ne. ' ' ) goto 100

	i = i + 1
	active.pulses = check_limits(list,1.,big,i,title)
	if( title .ne. ' ' ) goto 100

	i = i + 1
	active.groups = check_limits(list,1.,big,i,title)
	if( title .ne. ' ' ) goto 100

	i = i + 1
	active.holding_voltage = check_limits(list,-big,big,i,title)
	if( title .ne. ' ' ) goto 100

	return
	end

	subroutine set_pulse  (ipulse, ix, iy, active )
$include:'wavcom.for'
c
c	Set pulse amplitude / width parameters
c
	parameter(nmenu=5, big=1E30 )
	character*30 menu(nmenu) /
     &	'Pulse #  height (start) (mV)',
     &	'Pulse #  height (end)   (mV)',
     &	'Increment               (mV)',
     &	'Pulse #  width          (ms)',
     &	'Increment               (ms)' /
	character*12 list(nmenu)
	character*36 title
	record /pulse/ active
c
c	code
c
	i = 1
	menu(i)(8:8) = char( ichar('0') + ipulse )
	r = active.pulse_height_start(ipulse)
	write(list(i),'(f12.3)') r

	i = i + 1
	menu(i)(8:8) = char( ichar('0') + ipulse )
	r = active.pulse_height_end(ipulse)
	write(list(i),'(f12.3)') r

	i = i + 1
	r = active.pulse_height_inc(ipulse)
	write(list(i),'(f12.3)') r

	i = i + 1
	menu(i)(8:8) = char( ichar('0') + ipulse )
	r = active.pulse_width(ipulse)
	write(list(i),'(f12.3)') r

	i = i + 1
	r = active.pulse_width_inc(ipulse)
	write(list(i),'(f12.3)') r

	title = ' '
100	if( title .eq. ' ' ) title = ' Edit Pulse '
	call text_window( menu, list, nmenu, ix, iy, title )

	i = 1
	active.pulse_height_start(ipulse) =
     &	 check_limits(list,-big,big,i,title)
	if( title .ne. ' ' ) goto 100

	i = i + 1
	active.pulse_height_end(ipulse) =
     &	 check_limits(list,-big,big,i,title)
	if( title .ne. ' ' ) goto 100

	i = i + 1
	active.pulse_height_inc(ipulse) =
     &	 check_limits(list,-big,big,i,title)
	if( title .ne. ' ' ) goto 100

	i = i + 1
	active.pulse_width(ipulse) = check_limits(list,0.,big,i,title)
	if( title .ne. ' ' ) goto 100

	i = i + 1
	active.pulse_width_inc(ipulse) = check_limits(list,-big,big,i,
     &	title)
	if( title .ne. ' ' ) goto 100

	return
	end

	subroutine set_synch(ix,iy,active)
$include:'wavcom.for'
c
c	Set Synchronization pulse parameters
c
	parameter(nmenu=3, big=1E30 )
	character*30 menu(nmenu) /
     &	'Synch. pulse delay   (ms)',
     &	'Increment            (ms)',
     &	'Synch. pulse amplitude (mV) ' /

	character*12 list(nmenu)
	character*36 title
	record /pulse/ active

c
c	code
c
	i = 1
	r = active.synch_delay
	write(list(i),'(f12.3)') r
	i = i + 1
	r = active.synch_delay_inc
	write(list(i),'(f12.3)') r
	i = i + 1
	r = active.synch_amplitude
	write(list(i),'(f12.3)') r

	title = ' '
100	if( title .eq. ' ' ) title = ' Edit Synch. Pulse '
	call text_window( menu, list, nmenu, ix, iy, title )

	i = 1
	active.synch_delay = check_limits(list,0.,big,i,title)
	if( title .ne. ' ' ) goto 100

	i = i + 1
	active.synch_delay_inc = check_limits(list,-big,big,i,title)
	if( title .ne. ' ' ) goto 100

	i = i + 1
	active.synch_amplitude = check_limits(list,-big,big,i,title)
	if( title .ne. ' ' ) goto 100


	return
	end

	subroutine set_external(ix,iy,active)
$include:'wavcom.for'
c
c	Set external waveform data file name
c
	parameter(nmenu=1, big=1E30 )
	character*8 menu(nmenu) /
     &	' Name ' /

	character*30 list(nmenu)
	character*36 title
	record /pulse/ active

c
c	code
c
	i = 1
	list(i) = active.file_name

	title = ' '
100	if( title .eq. ' ' ) title = ' External Waveform '
	call text_window( menu, list, nmenu, ix, iy, title )

	active.file_name = list(1)

	if( active.file_name .ne. ' ' ) then
	    call read_external_waveform(active.file_name)
	end if

	return
	end

	 subroutine create_stimulus(idac,irecord,
     &	 igroup,dt_dac,np_dac,primary,alternate,active,rec_type)
$include:'wavcom.for'
c
c	Create Voltage-clamp command pulse & synch. pulse waveforms
c	for output via D/A converter channels 0 & 1.
c	-----------------------------------------------------------
c	Pulse voltage programs are defined in record structures
c	"primary" and "alternate" (See wavcom.for structure)
c	D/A output waveform is return in array idac(2*np_dac)"
c	interleaved DA0,DA1,DA0,DA1....
c
	integer*2 idac(1) ! Array to be filled with D/A waveform
	integer*2 irecord ! Current D/A sweep record to be created
	integer*2 igroup  ! Returned containing sweep group
	real*4 dt_dac	  ! Returned containing D/A update interval (ms)
	integer*2 np_dac  ! On entry contains the maximum spaces available
c			    in the D/A buffer for data points (per channel)
c			    It is returned containing the number of points
c			    to be output
	record /pulse/ primary	 ! Primary pulse pattern record
	record /pulse/ alternate ! Alternate pulse pattern record
	record /pulse/ active	 ! Returned with currentle active pattern
	character*4 rec_type	 ! Returned containing record type
c				   "TEST" for primary record,
c				   "LEAK" for alternate
c
	integer*2 istart(max_pulses)
	integer*2 iend(max_pulses)
	real*4 rlevel(max_pulses)
	real*4 step(max_pulses)
	character*60 string

	parameter(izero_level=2048 )
c
c	code
c
	max_points = np_dac

	call lab_limits(interface_card,dt_min,dt_max,ad_min,ad_max,dac)
	bitv = dac*1000. / 2048.
c
c	If an alternate voltage program is in use, determine the
c	total number of pulses (both primary & alternate) per group
c
	ngroups_per_program = int(primary.groups)
	nprimary_sweeps = int(primary.pulses)
	nsweeps = nprimary_sweeps
	if( alternate_name .ne. ' ' ) then
	    nsweeps = nprimary_sweeps + int(alternate.pulses)
	end if
c
c	Select primary or alternate voltage
c
	isweep = mod( irecord-1, nsweeps ) + 1
	igroup = (irecord-1)/nsweeps + 1
	igroup = mod(igroup-1,ngroups_per_program)+1
	if( isweep .le. nprimary_sweeps ) then
	    rec_type = 'TEST'
	    active = primary
	else
	    rec_type = 'LEAK'
	    active = alternate
c
c	    This line ensures that the period after the last
c	    alternate pulse, is a primary period rather than
c	    an alternate
c
	    if( isweep .eq. nsweeps )
     &	    active.period = primary.period

	end if
c
c	Determine the maximum duration of pulse within the group
c
	t_max = 0.
	do ipulse = 1,max_pulses
	    t_max = t_max +
     &	    active.pulse_width(ipulse) +
     &	    active.pulse_width_inc(ipulse)*primary.groups
	end do

c
c	If an external waveform file is in use, read it in
c	and let it define the sampling interval
c
	if( active.file_name .ne. ' ' ) then
	    dt_dac = max( dt_ext, dac_min_interval() )
	    call check_dt_dac( dt_dac )
	    t_max = t_max + dt_dac*float(np_ext)
	    if( dt_dac .ne. dt_ext ) then
		write( string,
     &		'(''Ext. Waveform interval '',f6.2,
     &		  ''ms changed to '',f6.2,''ms'')') dt_dac,dt_ext
		call move_cursor(12,24)
		call display_stringt( string )
	    end if
	    start_delay = t_max * 0.1
	    t_max = ( t_max + start_delay ) * 1.1
	else
c
c	    If no external pulse, determine D/A update interval
c	    from duration of pulses
c
	    start_delay = t_max * 0.1
	    t_max = ( t_max + start_delay ) * 1.1
	    dt_dac = max( t_max/float(max_points),  dac_min_interval() )
	    call check_dt_dac( dt_dac )
	end if

	np_dac = min( int( t_max/dt_dac ), max_points )

c
c	Set holding voltage level
c
	iholding_level = izero_level + int(active.holding_voltage/bitv)

	istart(1) = int( start_delay / dt_dac )
	iend(1) = istart(1)
	do ipulse = 1,max_pulses
c
c	    Start of pulse
c
	    istart(ipulse) = iend( max(ipulse-1,1) ) + 1
c
c	    End of pulse
c
	    iend(ipulse) = istart(ipulse) +
     &	    max(int( active.pulse_width(ipulse)/dt_dac ),1) +
     &	    int( active.pulse_width_inc(ipulse)/dt_dac ) * (igroup-1)
c
c	    Pulse start level
c
	    rlevel(ipulse) = float(iholding_level) +
     &	    (active.pulse_height_start(ipulse)/bitv) +
     &	    float(igroup-1) * (active.pulse_height_inc(ipulse)/bitv)
c
c	    Pulse rate of change
c
	    step(ipulse) = (active.pulse_height_end(ipulse) -
     &	    active.pulse_height_start(ipulse)) /
     &	    ( float( iend(ipulse) - istart(ipulse) ) * bitv )

	end do


c
c	No of points (per channel) to O/P to DACs
c
	isynch_pulse_start = int(active.synch_delay/dt_dac) +
     &	int(active.synch_delay_inc/dt_dac)*(igroup-1)
	isynch_pulse_start = max(min(isynch_pulse_start,np_dac-2),1)
	isynch_pulse_end = isynch_pulse_start + 1
	isynch_off  = izero_level
	isynch_on = min( int(active.synch_amplitude/bitv)
     &	 + izero_level,4095)

	do i = 1,np_dac
	    j = 2*i
	    idac(j-1) = iholding_level
	    idac(j) = isynch_off
	end do

	do ipulse = 1,max_pulses
	    i0 = istart(ipulse)
	    i1 = iend(ipulse)
	    r0 = rlevel(ipulse)
	    dl = step(ipulse)

	    do i = i0,i1
		j = i*2-1
		idac(j) = int( r0 + dl*float(i-i0) )
	    end do
	end do

c
c	If Ext Waveform file exists, add its contents to D/A sweep
c	(Note this occurs only for primary sweeps
c
	if( rec_type .eq.'TEST' .and. primary.file_name .ne. ' ' ) then
	    j = (iend(max_pulses)+1)*2 - 1
	    do i = 1,np_ext
		idac(j) = idac(j) + int(y(i)/bitv)
		j = j + 2
	    end do
	end if
c
c	Add Synch. pulse to D/A channel 1
c
	idac(isynch_pulse_start*2) = isynch_on
c
c	Keep everything within 0-4095 limits
c
	do j = 1,np_dac*2
	    idac(j) = min(4095,idac(j))
	end do

	if( np_dac .gt. max_points ) then
	    call move_cursor(2,25)
	    call display_string('ERROR ... D/A buffer too big! ')
	    call display_int(np_dac)
	    call display_int(max_points)
	end if

	return
	end

	subroutine do_waveform(iprimary_area,ialternate_area,
     &	idac,np_dac,
     &	primary,alternate,output)
$include:'wavcom.for'
c
c	Create D/A waveforms and display on screen
c	and send to D/A converters if output=TRUE
c
	integer*2 iprimary_area(4)   ! Enter with screen display area
				     ! for primary pulses
	integer*2 ialternate_area(4) ! Enter with screen display area
				     ! for alternate pulses
	integer*2 idac(1)	     ! D/A output buffer
	integer*2 np_dac	     ! Enter with max. no. points allowed
				     ! Returned with no. of points in waveform
	record /pulse/ primary	     ! Primary pulse pattern
	record /pulse/ alternate     ! Alternate pulse pattern
	logical output		     ! If TRUE, output waveform via D/As

	record /pulse/ active
	character*4 rec_type
	character key
	logical special,repeat
	character*80 string
	real*4 vdac(2)
c
c	code
c
	repeat = .false.
	call erase_waveform_window()

	call move_cursor(2,1)
	call display_string(' WavGen V1.1             ')
	if( output ) then
	    CALL QUERY_BOX(2,2,' Repeat Programs ? (Y/N) ? ',key)
	    call erase_waveform_window()
	    if( key .eq. 'Y' ) then
		repeat = .true.
		call move_cursor(2,1)
		call display_string(' WavGen V1.1 <Active-R>  ')
	    else
		call move_cursor(2,1)
		call display_string(' WavGen V1.1 <Active>    ')
	    endif
	else
	    call move_cursor(2,1)
	    call display_string(' WavGen V1.1 <Preview>  ')
	end if
	call move_cursor(20,25)
	call display_string('<<< Press ESC to abort >>>')

	call create_stimulus(idac,1,igroup,dt_dac,np_dac,
     &	 primary,alternate,active,rec_type)

	nprimary_sweeps = int( primary.pulses )
	nprimary_groups = int( primary.groups )
	nsweeps_per_group = nprimary_sweeps
	if( alternate_name .ne. ' ' ) then
	    nalternate_sweeps = int( alternate.pulses )
	    nsweeps_per_group = nprimary_sweeps + nalternate_sweeps
	end if
	nsweeps = nsweeps_per_group * nprimary_groups

	t_start = time_in_seconds()

100	continue

	do isweep = 1,nsweeps
c
c	    Plot voltage sweep
c
	   call create_stimulus(idac,isweep,igroup,dt_dac,np_dac,
     &	   primary,alternate,active,rec_type)

	    call move_cursor(16,23)
	    if( rec_type .eq. 'TEST' ) then

		call plot_channel( iscreen, iprimary_area, idac,
     &		1, 2, 1, np_dac, 3, 0, blue	     )

		call plot_channel( iscreen, iprimary_area, idac,
     &		2, 2, 1, np_dac, 1, 2048 , black )

	       call move_cursor(2,ipr_bottom)
	       call display_string(' 0. ')
	       call move_cursor(49,ipr_bottom)
	       write(string,'(1x,f9.1,''ms'')') dt_dac*float(np_dac)
	       call display_stringt( string )

		call move_cursor(8,ipr_bottom)
		write( string,
     &		'('' Primary:   Group '',i4,''/'',i4,
     &		  '' Sweep '',i4,''/'',i4)')
     &		igroup, nprimary_groups,
     &		mod(isweep-1,nsweeps_per_group)+1,nprimary_sweeps
		itrace_colour = red
	    else

		call plot_channel( iscreen, ialternate_area, idac,
     &		1, 2, 1, np_dac, 3, 0, red	     )

		call plot_channel( iscreen, ialternate_area, idac,
     &		2, 2, 1, np_dac, 1, 2048 , black )

	       call move_cursor(2,ialt_bottom)
	       call display_string(' 0. ')
	       call move_cursor(49,ialt_bottom)
	       write(string,'(1x,f9.1,''ms'')') dt_dac*float(np_dac)
	       call display_stringt( string )
		call move_cursor(8,ialt_bottom)
		write( string,
     &		'('' Alternate: Group '',i4,''/'',i4,
     &		  '' Sweep '',i4,''/'',i4)')
     &		igroup, nprimary_groups,
     &		mod(isweep-1,nsweeps_per_group)+1-nprimary_sweeps
     &		,nalternate_sweeps
	    end if
	    call display_stringt( string )

	    if( output ) then
c
c		Output waveform to D/A converters
c
		idac_trigger = 0
		idac_mode = 1
		ndac_channels = 2
		call memory_to_dac( dt_dac, ndac_channels,
     &		np_dac,idac_trigger,idac,idac_mode,ierr)

	    end if

	    time = time_in_secs()
	    key = ' '
	    time_for_next_pulse = time +
     &	     max( active.period, np_dac*dt_dac ) / 1000.
	    do while( time .le. time_for_next_pulse .and.
     &		      key .ne. '$' )
c
c		N.B. This 100ms delay is here to avoid lost
c		D/A interrupts which seemed to be happening
c		when call were made too rapidly to the routine
c		time_in_secs() ??????
c
		call wait(0.1 )

		call get_key( key, special )
		time = time_in_secs()
		call move_cursor(1,25)
		write( string, '(f8.1,''s'')') time - t_start
		call display_stringt( string )
	    end do

	    if( output ) then
		call dac_stop()
		if(interface_card.eq.1) then
c
c		     Temporary Bug Fix to force CED 1401 to stop DAC output
		     call write_ced( 'clear;')
		     call wait(0.2)
		end if
		vdac(1) =  primary.holding_voltage  / 1000.
		vdac(2) =  0.
		call set_dacs( vdac, 2 )
	    end if

	    if( key .eq. '$' ) goto 101

	end do

	if( repeat ) goto 100

101	continue
	string = ' '
	call move_cursor(2,25)
	call display_string( string )
	call move_cursor(2,1)
	call display_string(' WavGen V1.1           ')
	return
	end

	subroutine load_waveform( ix,iy,protocol,fname,wave_type )
$INCLUDE:'wavcom.for'
c
c	Load a voltage protocol from file.
c
	record /pulse/ protocol     ! Pulse protocol record
	character*(*) fname	    ! Pulse protocol file name
	character*(*) wave_type     ! 'PRI'=Primary, 'ALT'=Alternative

	parameter(maxc=512)
	character*512 cbuf
	parameter(max_files=500)
	character*12 files(max_files)
	character*20 new_file_name / ' ' /
	character*6 keyword

	logical eof,ok
C
C	CODE
C	----
C
	ok = .false.
	if( ix .ne. 0 ) then

	    call files_menu(
     &	    '\gemapps\gemsys\*.wvg',0,new_file_name,
     &	    ix,iy,10,files,max_files)
	    if( new_file_name .ne. ' ' ) then
		fname = '\gemapps\gemsys\'//new_file_name
		ok = .true.
	    end if
	else
	    ok = .true.
	end if

	if( ok ) then

	    call move_cursor(2,2)
	    call display_string(' Loading ... ')
	    call display_string(fname)

	    open(unit=itemp_file,
     &	    file=fname,
     &	    form='binary',
     &	    access='direct',
     &	    recl=1,
     &	    iostat=istat )

	    if( istat .ne. 0 ) then
		call move_cursor(1,25)
		call display_reversed(
     &		'ERROR: Cannot open file ')
		call display_reversed(fname)
		close(unit=itemp_file,iostat=istat)
		fname = ' '
		return
	    end if
c
c	    Open file and read in ASCII text until EOF character is found
c	    or we run out of characters.
c
	    eof = .false.
	    nc = 0
	    cbuf = ' '
	    do while( .not. eof )
		nc = nc + 1
		read(unit=itemp_file,err=100,rec=nc) i
		cbuf(nc:nc) = char(i)
		if( (i .eq. 26) .or. (nc.eq.maxc) ) eof = .true.
	    end do
100	    close(unit=itemp_file)

	    call read_flt( 'PER=',cbuf, protocol.period )
	    call read_flt( 'PULS=',cbuf, protocol.pulses )
	    call read_flt( 'GRPS=',cbuf, protocol.groups )
	    call read_flt( 'HV=',cbuf, protocol.holding_voltage )
	    call read_flt( 'SD=',cbuf, protocol.synch_delay)
	    call read_flt( 'SDI=',cbuf, protocol.synch_delay_inc)
	    call read_flt( 'SA=',cbuf, protocol.synch_amplitude)
	    call read_char( 'EXT=',cbuf, protocol.file_name )

	    do ipulse = 1,max_pulses

		write( keyword, '(''PHS'',i1,''='')' ) ipulse
		call read_flt( keyword,cbuf,
     &		protocol.pulse_height_start(ipulse) )

		write( keyword, '(''PHE'',i1,''='')' ) ipulse
		call read_flt( keyword,cbuf,
     &		protocol.pulse_height_end(ipulse) )

		write( keyword, '(''PW'',i1,''='')' ) ipulse
		call read_flt( keyword,cbuf,
     &		protocol.pulse_width(ipulse) )

		write( keyword, '(''PHI'',i1,''='')' ) ipulse
		call read_flt( keyword,cbuf,
     &		protocol.pulse_height_inc(ipulse) )

		write( keyword, '(''PWI'',i1,''='')' ) ipulse
		call read_flt( keyword,cbuf,
     &		protocol.pulse_width_inc(ipulse) )

	    end do

	    if( protocol.file_name .ne. ' ' .and.
     &		wave_type .eq. 'PRI' ) then
		call read_external_waveform(protocol.file_name)
	    end if

	end if

	return
	end

	subroutine save_waveform( ix,iy,protocol,fname )
$INCLUDE:'wavcom.for'
c
c	Save a voltage protocol to file.
c
	record /pulse/ protocol     ! Pulse protocol record
	character*(*) fname	    ! Pulse protocol file name

	character*512 cbuf
	character*30 new_file_name / '\gemapps\gemsys\' /

	character*8 f
	character*6 keyword
C
C	CODE
C	----
C
	 call get_file_name(ix,iy,new_file_name,'.wvg','NEW'
     &	 ,' File name ',iflag)

	if( iflag .ge. 0 ) then
c
c	    Open file
c
	    fname = new_file_name
	    open(unit=itemp_file,file=new_file_name,form='binary',
     &	    access='direct', recl=1, iostat=istat )

	    f = '(f10.2)'
	    cbuf = ' '
	    call add_flt( protocol.period, 'PER=',cbuf,f)
	    call add_flt( protocol.pulses, 'PULS=',cbuf,f)
	    call add_flt( protocol.groups, 'GRPS=',cbuf,f )
	    call add_flt( protocol.holding_voltage, 'HV=',cbuf,f)
	    call add_flt( protocol.synch_delay,'SD=',cbuf,f )
	    call add_flt( protocol.synch_delay_inc,'SDI=',cbuf,f )
	    call add_flt( protocol.synch_amplitude,'SA=',cbuf,f )
	    call add_char( protocol.file_name,'EXT=',cbuf )

	    do ipulse = 1,max_pulses

		write( keyword, '(''PHS'',i1,''='')' ) ipulse
		call add_flt( protocol.pulse_height_start(ipulse),
     &		keyword, cbuf, f )

		write( keyword, '(''PHE'',i1,''='')' ) ipulse
		call add_flt( protocol.pulse_height_end(ipulse),
     &		keyword, cbuf, f )

		write( keyword, '(''PW'',i1,''='')' ) ipulse
		call add_flt( protocol.pulse_width(ipulse),
     &		keyword, cbuf, f )

		write( keyword, '(''PHI'',i1,''='')' ) ipulse
		call add_flt( protocol.pulse_height_inc(ipulse),
     &		keyword, cbuf, f )

		write( keyword, '(''PWI'',i1,''='')' ) ipulse
		call add_flt( protocol.pulse_width_inc(ipulse),
     &		keyword, cbuf, f )

	    end do


	    nc = len_trim(cbuf)
	    cbuf(nc+1:nc+1) = char(26)
	    do i = 1,nc+1
		write(unit=itemp_file) cbuf(i:i)
	    end do
	    close(unit=itemp_file)
	end if

	return
	end

	subroutine delete_waveform(il,it)
C
C --	Delete .protocol protocol file
C
$INCLUDE:'wavcom.for'
C
	CHARACTER*12 NEW_FILE_NAME/ ' ' /
	parameter(max_files=500,nc_path=52)
	character*52 path / ' ' /
	character*12 files(max_files)
	equivalence( iwork, files )
	character key
C
C	CODE
C
	path = '\gemapps\gemsys\'
	ix = len_trim(path) + 1
	path(ix:nc_path) = '*.wvg'
	call files_menu(path,0,new_file_name,il,it,10,files,max_files)

	if( new_file_name .ne. ' ' ) then
	    path(ix:nc_path) = new_file_name
	    call query_box(4,7,
     &	    ' Delete: '//path(1:len_trim(path))//' (Y/N) ? ',key)
	    if( key .eq. 'Y' ) then
		call delete_file( ierr, path )
	    end if
	end if

	return
	end

	subroutine add_logical( log_val, key, string )
	logical log_val
	character*(*) key,string

	i0 = len_trim(string)+1
	nc = len(string)
	string(i0:nc) = key
	i0 = len_trim(string)+1
	write( string(i0:nc), '(l1,a2)' ) log_val,char(13)//char(10)
	return
	end

	subroutine add_flt( r, key, string, fstring )
	character*(*) key,string,fstring
	character*20 asc

	i0 = len_trim(string)+1
	nc = len(string)
	string(i0:nc) = key
	i0 = len_trim(string)+1
	write( asc, fmt=fstring ) r
	is = ileading_space(asc)
	ie = len_trim(asc)
	string(i0:nc) = asc(is:ie)//char(13)//char(10)
	return
	end

	subroutine add_int( i, key, string, fstring )
	character*(*) key,string,fstring
	character*20 asc

	i0 = len_trim(string)+1
	nc = len(string)
	string(i0:nc) = key
	i0 = len_trim(string)+1
	write( asc, fmt=fstring ) i
	is = ileading_space(asc)
	ie = len_trim(asc)
	string(i0:nc) = asc(is:ie)//char(13)//char(10)
	return
	end

	subroutine add_char( string_in, key, string )
	character*(*) key,string,string_in

	i0 = len_trim(string)+1
	nc = len(string)
	string(i0:nc) = key
	i0 = len_trim(string)+1
	string(i0:nc) = string_in
	i0 = len_trim(string)+1
	string(i0:i0+1) = char(13)//char(10)
	return
	end

	subroutine read_flt( mask, header, r )
	character*(*) mask, header
	real*4 r
	character*16 string

	call find_item( header, mask, is, ie )
	if( is .gt. 0 ) then
	    string = header(is:ie)
	    read( string, '(f16.0)', err=100 ) r
	end if

100	return
	end

	subroutine read_int( mask, header, i )
	character*(*) mask, header
	integer*2 i
	character*16 string

	string = ' '
	call find_item( header, mask, is, ie )
	if( is .gt. 0 ) then
	    string = header(is:ie)
	    read( string, '(f16.0)', err=100 ) r
	    i = int(r)
	end if
100	return
	end

	subroutine read_char( mask, header, string )
	character*(*) mask, header, string

	call find_item( header, mask, is, ie )
	if( is .gt. 0 ) string = header(is:ie)
	return
	end

	subroutine read_logical( mask, header, log )
	character*(*) mask, header
	logical log
	character*6 string

	call find_item( header, mask, is, ie )
	if( is .gt. 0 ) then
	    string = header(is:ie)
	    read( string, '(L1)', err=100 ) log
	end if
100	return
	end

	subroutine find_item( string, name, is,ie )
	character*(*) name,string
	integer*2 nc,is,ie
c
c	Searches <string> for items with the form:
c	<name> <data> <cr> <lf>
c	or
c	<name> <data> <\>
c

	nc = len( string )
	nn = len_trim(name)
	is = index( string, name(1:nn) )
	if ( is .gt. 0 ) then
	    ie = index( string(is:nc), char(13) )
	    if( ie .ne. 0 ) then
		ie = is + ie - 2
		is = is + nn
	    endif
	endif
c	 call move_cursor(1,1)
c	 call display_string(name)
c	 call display_string(string(is:ie))
c	 call display_int(is)
c	 call display_int(ie)
c	 call paws
	return
	end

	subroutine erase_waveform_window
$INCLUDE:'wavcom.for'

	CALL ERASE_BOX(1,1,62,25)
	call move_cursor(2,1)
	call display_string(' WavGen V1.1 ' )

	iheight = ipr_bottom - 2

	CALL DISPLAY_BOX(1,2,62,ipr_bottom)
	call move_cursor(2,2)
	call display_Stringt( ' Primary: '//primary_name )

	CALL DISPLAY_BOX(1,ialt_bottom-iheight,62,ialt_bottom)
	if( alternate_name .ne. ' ' ) then
	    call move_cursor(2,ialt_bottom-iheight)
	    call display_Stringt( ' Alternate: '//alternate_name )
	else
	    call move_cursor(2,ialt_bottom-iheight)
	    call display_Stringt( ' Alternate: None ' )
	end if

	return
	end

	SUBROUTINE read_initialisation_file( fname )
	character*(*) fname
	CHARACTER*(512) HEADER
C
$INCLUDE:'wavcom.for'
C
	logical file_exists

C	CODE
C	----
C
	inquire(file=fname, exist=file_exists)

	if( file_exists ) then

	    open(unit=ini_file,file=fname,form='binary',
     &	    access='direct',recl=512, iostat=istat )

	    read(unit=ini_file,rec=1,err=100) header
	    call read_int( 'IFC=', header, interface_card )
	    call read_char( 'PRI=', header, primary_name )
	    call read_char( 'ALT=', header, alternate_name )
100	    close(unit=ini_file)
	end if
	return
	end

	SUBROUTINE save_initialisation_file( fname )
	character*(*) fname
	CHARACTER*(512) HEADER
C
$INCLUDE:'wavcom.for'

	character ky
C
C	CODE
C	----
C
	open(unit=ini_file,file=fname,form='binary',
     &	access='direct',recl=512,iostat=istat)

	if( istat .eq. 0 ) then
	    header = ' '
	    call add_int( interface_card, 'IFC=', header, '(i4)' )
	    call add_char( primary_name,'PRI=', header )
	    call add_char( alternate_name,'ALT=', header )

	    write(unit=ini_file,rec=1) header
	    close(unit=ini_file)
	else
	    call query_box(2,20,
     &	    'ERROR! Cannot create file WAVGEN.INI',ky )
	end if
	return
	end

	subroutine get_file_name(ix,iy,
     &	file_name,extension,file_type,title,iflag)

	character*(*) file_name,extension,file_type,title
	character key

	parameter( nnew=4 )
	character*16 new_menu(nnew) /
     &	' Change Name F1',
     &	' Overwrite   F2',
     &	' Append      F3',
     &	' Abort      ESC' /

	parameter( nold=2 )
	character*16 old_menu(nold) /
     &	' Change Name F1',
     &	' Abort      ESC' /

	logical file_exists,new_m,quit

	integer*2 overwrite,append,abort
	parameter( overwrite=0, append=1, abort=-1 )

c	code
c
	quit = .false.
	iflag = abort
	do while ( .not. quit )

	    lwidth = max(max(len(title)+2,len(file_name)+2),40)
	    call erase_box(ix,iy,ix+lwidth,iy+3)
	    call display_box(ix,iy,ix+lwidth,iy+3)
	    call move_cursor(ix+1,iy)
	    call display_string(title)
	    call move_cursor(ix+1,iy+3)
	    call display_string(' Press RETURN to continue, ESC=cancel ')

	    call move_cursor(ix+2,iy+1)
	    call get_string( file_name, nc, key )

	    if( key .ne. '$' ) then

		nc = len_trim( file_name )
		if( extension .ne. ' ' ) then
		    i = index( file_name, '.' )
		    if( i .eq. 0 ) i = nc+1
		    file_name(i:i+3) = extension
		endif
c
c		Does a file of this name exist already?
c
		inquire( file=file_name, exist = file_exists )

		call upper_case( file_type )

		if( file_type .eq. 'NEW' ) then
c
c		    NEW file tests
c
		    if( file_exists ) then
			new_m = .true.
			iop = 1
			iop = Iwait_MENU_VERTICAL1(new_menu,'123$',nnew,
     &			ix+1,iy+2,new_m,iop,' File Exists! ',key)

			if( iop.gt.1 ) quit = .true.
			if( iop.eq.2 ) iflag = overwrite
			if( iop.eq.3 ) iflag = append
			if( iop.eq.4 ) iflag = abort

		    else
c
c			If file does not exist
c			check to see if the file can be opened
c
			open(unit=9,file=file_name,iostat=istat )
			if( istat .ne. 0 ) then
			    call erase_box(ix+1,iy+4,ix+34,iy+6)
			    call display_box(ix+1,iy+4,ix+34,iy+6)
			    call move_cursor(ix+2,iy+5)
			    call display_string(
     &			    ' ERROR! Cannot create this file ')
			    quit = .false.
			    iflag = abort
			else
			    quit = .true.
			    iflag = overwrite
			end if
			close(unit=9,iostat=istat)

		    end if
		else
c
c		    Open an OLD file
c
		    if( .not. file_exists ) then
			new_m = .true.
			iop = 1
			iop = Iwait_MENU_VERTICAL1(old_menu,'1$',nold,
     &			ix+1,iy+2,new_m,iop,' File not found! ',key)
			if( iop .eq. 2 ) then
			    quit = .true.
			    iflag = abort
			end if
		    else
			quit = .true.
			iflag = overwrite
		    endif
		endif
	    else
		quit = .true.
		iflag = abort
	    end if
	end do

	return
	end

	subroutine read_external_waveform( file_name )
$include:'wavcom.for'
c
c	Read in a list of ASCII T,Y data pairs defining an
c	external waveform

	character*(*) file_name     ! Name of external data file
	real*4 row(20)

	logical end_of_file
	character*60 string
c
c	code
c
	open(unit=itemp_file,
     &	file=file_name,
     &	form='binary',
     &	iostat=istat,
     &	recl=1)

	end_of_file = .false.
	np_ext = 0
	do while((.not. end_of_file) .and. (np_ext.lt.max_ext))

	    call extract_row(itemp_file,row,nc,end_of_file)

	    if( nc .gt. 1 ) then
		dt_ext = row(1) - t0
		t0 = row(1)
		np_ext = np_ext + 1
		y(np_ext) = row(2)
	    end if

	    call move_cursor(2,23)
	    write( string,
     &	    '(''Reading '',i4,'' t= '',f8.2,''ms y= '',f8.2,''mV'')')
     &	    np_ext,row(1),y(np_ext)
	    call display_stringt(string)

	end do

	close(unit=itemp_file)
	return
	end


       subroutine extract_row(ifile,row,n,end_of_file)
       real*4 row(1)
       integer*2 n
       logical end_of_file

	logical quit
	character*1 byte,cr,lf
	character*20 string

	cr = char(13)
	lf = char(10)

	end_of_file = .false.
	is = 0
	n = 0
	quit = .false.
	do while( .not. quit )
	    read(unit=ifile,end=50) byte
	    if( (byte .eq. cr) .or. (byte .eq. lf) ) quit = .true.
	    goto 51
50	    quit = .true.
	    end_of_file = .true.
51	    continue

	    inum = index('0123456789Ee+-.',byte)

	    if( inum .gt. 0 ) then
c
c		If character is part of a number, append it to
c		the number string
c
		is = is + 1
		string(is:is) = byte
	    elseif( is .gt. 0 ) then
c
c		If enough characters are available for a number
c		decode it.
c
		n = n + 1
		read( string, '(f16.0)', err=100 ) row(n)
		goto 101
100		row(n) = 0.
101		continue
		is = 0
		string = ' '
	    end if
	end do
	return
	end
