	BLOCK DATA
$INCLUDE: 'VGECOM.FOR'

	DATA N_POINTS /512/
	DATA PULSE_MATRIX /1000.,0.,100.,100.,10.,0.,0.,0.,0.,0.
     &				,0.,0.,0.,0.,10.,1.,0.,0.,5000.,0./
	DATA FILE_NAME,ALT_FILE / '            ','            '/
	DATA INTERFACE_CARD /0/
	DATA V_DISPLAY /2000./
	data synch_level / 5000. /
	DATA NPROG /1/

	END

	PROGRAM VGEN
C
C	Voltage clamp command pulse generator program
C	V2.7  (c) J. Dempster  1990,1993
C	--------------------------------------------------
C	Voltage display scale now +/- 1.6V 14/9/87
c	Labmaster supported
c	V2.5 Amplicon PC-24 now supported
c	DAC output buffer now allocated with allocate_dac_buffer
c	V2.6 ... D/A output now prevented from exceeding 0-4095 range
c	V2.6a ... works with LAB-PC, files_menu bug fixed
c	V2.7a ... Synch. pulse amplitude now programmable
c	V2.8  ... Support for Digidata 1200
c	V2.9  ... Support for N.I. ATMIO-16F
c		  and bug with CED 1401+ fixed (perhaps)
c	V2.9a ... ATMIO-16F in diff
c       V3.0 ... CED micro1401 support added
C
$INCLUDE: 'VGECOM.FOR'
	CHARACTER*7 MENU(9)
	CHARACTER*64 HELP(9)
	LOGICAL OUTPUT_REQUIRED,OUTPUT_DONE
	character*40 card_name / ' ' /

	parameter( max_help = 200 )
	character*66 help_text(max_help)
C
C
C	CODE
C

C	Prevent run-time MATHs error from aborting program
C	(see Appendix D Microsoft FORTRAN V4.1 Users Guide)
	CALL LCWRQQ(16#133E)

	CALL OPEN_WORKSTATION(ISCREEN,1)

C	Read configuration file to find interface in use

	call load_settings

c
c	Set directory to \lab
c
	call change_directory( ierr, '\lab' )
c
c	Select laboratory interface
c
	if( interface_card .le. 0 ) then
	    CALL MOVE_CURSOR(2,1)
	    CALL DISPLAY_STRING(
     &      ' VGEN Pulse generator V3.0 (c) J.Dempster 1990-1997 ')
	    call select_lab_interface( interface_card, card_name )
	    call erase_all
	endif


C	Get limits allowed by interface

	CALL LAB_LIMITS(MAX0(INTERFACE_CARD,1)
     &,DT_MIN,DT_MAX,AD_MIN,AD_MAX,DAC)

	V_MIN = -DAC*1000.
	V_MAX = DAC*1000.
	BIT_MV = (DAC*2000.)/4096.
	OUTPUT_DONE = .FALSE.

C	Open lab. interface

	CALL OPEN_LAB(INTERFACE_CARD,iwork)
	IF( iwork(1) .NE. 0) then
	    ierr = 1
	else
	    ierr = 0
	endif
C
	MENU(1) = 'BEGIN'
	HELP(1) = ' Begin voltage program'
	MENU(2) = 'PREVIEW'
	HELP(2) = ' Preview voltage program (no output)'
	MENU(3) = 'ENTER'
	HELP(3) = ' Enter voltage program parameters'
	MENU(4) = 'LOAD'
	HELP(4) = ' Load primary voltage program from a .VGE file'
	MENU(5) = 'SAVE'
	HELP(5) = ' Save the current voltage program to a .VGE file'
	MENU(6) = 'ALTERN'
	HELP(6) = ' Load alternate pulse program from a .VGE file'
	MENU(7) = 'SETUP'
	HELP(7) = ' Set display and synch. pulse parameters '
	MENU(8) = 'HELP'
	HELP(8) = ' Read Help file '
	MENU(9) = 'QUIT'
	HELP(9) = ' Quit program and return to DOS'
C
	IOP = 1
C
C -- Main program loop ---------------------------------------------
C
10	continue

	CALL MOVE_CURSOR(2,1)
	CALL DISPLAY_STRING(
     &' VGEN Pulse generator V2.7 (c) J.Dempster 1990-1993 ')

	call get_lab_interface_name( interface_card, card_name )
	CALL MOVE_CURSOR(2,2)
	CALL DISPLAY_STRING(card_name)
C
	CALL FILES_IN_USE
C
	CALL MOVE_CURSOR(1,22)
	CALL ERASE_EOS
	IOP = IMENU(MENU,HELP,'BPELSATHQ',9,22,IOP,' Main menu ')
	IF(IOP.EQ.0) GOTO 10
	GOTO(1,2,3,4,5,6,7,8,9) IOP
C
C	Run voltage program
C
1	OUTPUT_REQUIRED = .TRUE.
	if( ierr .eq. 0 ) then
	    CALL EXECUTE_VOLTAGE_PROGRAM(OUTPUT_REQUIRED)
	else
	    call move_cursor(5,5)
	    call display_string(' Laboratory Interface Not Working ')
	endif
	OUTPUT_DONE = .TRUE.
	GOTO 10
C
C	Preview
C
2	OUTPUT_REQUIRED = .FALSE.
	CALL EXECUTE_VOLTAGE_PROGRAM(OUTPUT_REQUIRED)
	GOTO 10
C
C	Edit voltage program
C
3	CALL SET_PULSE_MATRIX
	CALL ERASE_ALL
	GOTO 10
C
C	Load primary voltage program
C
4	CALL LOAD_PROGRAM
	CALL ERASE_ALL
	GOTO 10
C
C	Save voltage program
C
5	CALL SAVE_PROGRAM
	GOTO 10
C
C	Load alternate program / or remove it if one is already loaded
C
6	IF(NPROG.GT.1) THEN
		MENU(6) = ' ALTERN'
		HELP(6) = ' Load alternate pulse program from a .VGE file'
		NPROG = 1
	ELSE
		CALL LOAD_ALTERNATE_PROGRAM
		MENU(6) = ' ALT OFF'
		HELP(6) = ' Remove alternate pulse program '
		NPROG = 2
		CALL ERASE_ALL
	ENDIF
	GOTO 10
c
c	Setup display and synch. pulse parameters
c
7	call setup
	CALL ERASE_ALL
	goto 10
C
C	Read help file
C
8	CALL display_HELP(' VGEN: Help file ',
     &	'\gemapps\gemsys\vgen.HLP',help_text,max_help)
	CALL ERASE_ALL
	GOTO 10
C
C	Stop program and turn off interface
C
9	CALL CLOSE_WORKSTATION(ISCREEN)
	if( ierr .eq. 0 ) CALL CLOSE_LAB
	call save_settings
	STOP
	END
	SUBROUTINE SET_PULSE_MATRIX
$INCLUDE: 'VGECOM.FOR'
C
C	Set voltage program parameter matrix
C	-------------------------------------
C	
	INTEGER IWINDOW(2)
C
	CHARACTER KEY
	CHARACTER*24 MENU(2,10)
	CHARACTER*9 STRING
	PARAMETER(IWIDTH=25,ILEFT=1,NCOL=2,NROW=10)
	DATA IWINDOW /28,65/
C
C	CODE
C
C
	MENU(1,1) = 'Pulse repeat period (ms)'
	MENU(2,1) = 'Holding Voltage (mV)'
	MENU(1,2) = 'Pulse height        (mV)'
	MENU(2,2) = 'Increment       (mV)'
	MENU(1,3) = 'Pulse width         (ms)'
	MENU(2,3) = 'Increment       (ms)'
	MENU(1,4) = 'Pre-pulse height    (mV)'
	MENU(2,4) = 'Increment       (mV)'
	MENU(1,5) = 'Pre-pulse width     (ms)'
	MENU(2,5) = 'Increment       (ms)'
	MENU(1,6) = 'Mid-pulse height    (mV)'
	MENU(2,6) = 'Increment       (mV)'
	MENU(1,7) = 'Mid-pulse width     (ms)'
	MENU(2,7) = 'Increment       (ms)'
	MENU(1,8) = 'Groups per program   '
	MENU(2,8) = 'Pulses per group    '
	MENU(1,9) = 'Synch. pulse delay  (ms)'
	MENU(2,9) = 'Increment       (ms)'
	menu(1,10) = 'Synch. pulse ampl. (mv)'
	menu(2,10) = 'Ramp factor        (mV)'
C	
C	Display menu of options
C
	IBOTTOM = 25
	ITOP = IBOTTOM - NROW - 2
	CALL MOVE_CURSOR(3,ITOP)
	CALL ERASE_EOS
	CALL DISPLAY_BOX(1,ITOP,79,IBOTTOM)
	CALL MOVE_CURSOR(3,ITOP)
	CALL DISPLAY_STRING(' Enter voltage program parameters ')
C
	CALL MOVE_CURSOR(3,IBOTTOM-1)
	CALL DISPLAY_STRING('Select entry with: '//
     &CHAR(27)//CHAR(24)//CHAR(25)//CHAR(26)
     &//' Press ESC when complete')
C
C	Display current contents of stimulus parameter matrix
C
	LINE = ITOP + 1
	DO 10 IROW = 1,NROW
C
C		Display column 1
C
		CALL MOVE_CURSOR(3,LINE)
		CALL DISPLAY_STRING(MENU(1,IROW))
		CALL MOVE_CURSOR(IWINDOW(1),LINE)
		WRITE(STRING,910) PULSE_MATRIX(1,IROW)
910		FORMAT(F8.1)
		CALL DISPLAY_STRING(STRING)
C
C		Display column 2
C
		CALL MOVE_CURSOR(IWINDOW(1)+14,LINE)
		CALL DISPLAY_STRING(MENU(2,IROW))
		CALL MOVE_CURSOR(IWINDOW(2),LINE)
		WRITE(STRING,910) PULSE_MATRIX(2,IROW)
		CALL DISPLAY_STRING(STRING)
		LINE = LINE + 1
10	CONTINUE
C
C	Let user select entry within matrix and change it
C
	IROW = 1
	ICOL = 1
20	CONTINUE
C
C		Display selected entry in reverse video
C		and wait for user to change it
C
		CALL MOVE_CURSOR(IWINDOW(ICOL),IROW+ITOP)
		CALL GET_NUMBER_AND_KEY(PULSE_MATRIX(ICOL,IROW),KEY)
		CALL MOVE_CURSOR(IWINDOW(ICOL),IROW+ITOP)
C
		IF(KEY.EQ.'L') THEN
			ICOL = ICOL - 1
			IF(ICOL.LT.1) ICOL = 1
		ELSEIF(KEY.EQ.'R') THEN
			ICOL = ICOL + 1
			IF(ICOL.GT.NCOL) ICOL = NCOL
		ELSEIF(KEY.EQ.'U') THEN
			IROW = IROW - 1
			IF(IROW.LT.1) IROW = 1
		ELSEIF(KEY.EQ.'D') THEN
			IROW = IROW + 1
			IF(IROW.GT.NROW) IROW = NROW
		ENDIF
C
C		If ESC has not been pressed - keep waiting
C
	IF(KEY.NE.'$') GOTO 20
C
	CALL ERASE_ALL
	RETURN
	END
	SUBROUTINE EXECUTE_VOLTAGE_PROGRAM(OUTPUT_REQUIRED)
$INCLUDE: 'VGECOM.FOR'
C
C	-------------------------------------------------
C
	INTEGER*2 IDISPLAY_AREA(4),IMATRIX(2,10,2)
	CHARACTER*10 LABEL
	CHARACTER*58 STRING
	CHARACTER*9 PROG(2)
	CHARACTER KEY
	LOGICAL OUTPUT_REQUIRED,SPEC,repeat_mode

C
C --	CODE
C
	call erase_box(2,2,32,4)
	call display_box(2,2,32,4)
	CALL MOVE_CURSOR(3,3)
	call ask_user(' Repeat Program (Y/N) ? ',key)
	if( key .eq. 'Y' ) then
	    repeat_mode = .true.
	else
	    repeat_mode = .false.
	end if


	PROG(1) = 'Primary'
	PROG(2) = 'Alternate'
C
C	Set DAC update interval so that largest pulse in program
C	will fit into buffer of size N_POINTS
C
	GROUPS = PULSE_MATRIX(1,8)
	TMAX = PULSE_MATRIX(1,3)+GROUPS*PULSE_MATRIX(2,3)
     &	+ PULSE_MATRIX(1,5)+GROUPS*PULSE_MATRIX(2,5)
     &	+ PULSE_MATRIX(1,7)+GROUPS*PULSE_MATRIX(2,7)
	dt = max( (tmax*2.)/float(n_points), 0.5 )
	dt = max( min( dt, dt_max ), dt_min )
	ISTART = N_POINTS/10
	
C		Ensure that sampling interval is a multiple of
C		of clock period of interface 

		CALL CHECK_DT_dac(DT)

99	continue
C	
C -- Read primary pulse program from storage matrix -----------------
C
	PULSE_REPEAT_PERIOD = PULSE_MATRIX(1,1)
	IHOLDING_LEVEL = int((PULSE_MATRIX(2,1)-V_MIN)/BIT_MV)
C
C	Pulse height & increment
C
	IMATRIX(1,2,1) = int(PULSE_MATRIX(1,2)/BIT_MV)
	IMATRIX(2,2,1) = int(PULSE_MATRIX(2,2)/BIT_MV)
C
C	Pulse width & increment
C
	IMATRIX(1,3,1) = int(PULSE_MATRIX(1,3)/DT)
	IMATRIX(2,3,1) = int(PULSE_MATRIX(2,3)/DT)
C
C	Pre-Pulse height & increment
C
	IMATRIX(1,4,1) = int(PULSE_MATRIX(1,4)/BIT_MV)
	IMATRIX(2,4,1) = int(PULSE_MATRIX(2,4)/BIT_MV)
C
C	Pre-Pulse width & increment
C
	IMATRIX(1,5,1) = int(PULSE_MATRIX(1,5)/DT)
	IMATRIX(2,5,1) = int(PULSE_MATRIX(2,5)/DT)
C
C	Mid-Pulse height & increment
C
	IMATRIX(1,6,1) = int(PULSE_MATRIX(1,6)/BIT_MV)
	IMATRIX(2,6,1) = int(PULSE_MATRIX(2,6)/BIT_MV)
C
C	Mid-Pulse width & increment
C
	IMATRIX(1,7,1) = int(PULSE_MATRIX(1,7)/DT)
	IMATRIX(2,7,1) = int(PULSE_MATRIX(2,7)/DT)
C
C	No. of groups and pulses per group
C
	N_GROUPS = int(PULSE_MATRIX(1,8))
	IMATRIX(2,8,1) = int(PULSE_MATRIX(2,8))
C
C	Synch pulse delay and increment
C
	IMATRIX(1,9,1) = MIN0(MAX0(int(PULSE_MATRIX(1,9)/DT),1)
     &			,N_POINTS)
	IMATRIX(2,9,1) = int(PULSE_MATRIX(2,9)/DT)
	ISYNCH_WIDTH = MAX0(int(1./DT),1)+1
c
c	Synch. pulse amplitude
c
	IMATRIX(1,10,1) = int(pulse_matrix(1,10)/BIT_MV)
c
c	Height of end of voltage pulse
c
	IMATRIX(2,10,1) = int(
     &	( pulse_MATRIX(1,2) + pulse_matrix(2,10))/BIT_MV )

C --	Read alternate pulse matrix (if used) -----------------------
C	Note that pulse repeat period, holding voltage and number of
C	groups per program are still defined by primary program
C
	IF(NPROG .GT. 1) THEN
C
C		Pulse height & increment
C
		IMATRIX(1,2,2) = int(ALT_MATRIX(1,2)/BIT_MV)
		IMATRIX(2,2,2) = int(ALT_MATRIX(2,2)/BIT_MV)
C
C		Pulse width & increment
C
		IMATRIX(1,3,2) = int(ALT_MATRIX(1,3)/DT)
		IMATRIX(2,3,2) = int(ALT_MATRIX(2,3)/DT)
C
C		Pre-Pulse height & increment
C
		IMATRIX(1,4,2) = int(ALT_MATRIX(1,4)/BIT_MV)
		IMATRIX(2,4,2) = int(ALT_MATRIX(2,4)/BIT_MV)
C
C		Pre-Pulse width & increment
C
		IMATRIX(1,5,2) = int(ALT_MATRIX(1,5)/DT)
		IMATRIX(2,5,2) = int(ALT_MATRIX(2,5)/DT)
C
C		Mid-Pulse height & increment
C
		IMATRIX(1,6,2) = int(ALT_MATRIX(1,6)/BIT_MV)
		IMATRIX(2,6,2) = int(ALT_MATRIX(2,6)/BIT_MV)
C
C		Mid-Pulse width & increment
C
		IMATRIX(1,7,2) = int(ALT_MATRIX(1,7)/DT)
		IMATRIX(2,7,2) = int(ALT_MATRIX(2,7)/DT)
C
C		No. of pulses per group
C
		IMATRIX(2,8,2) = int(ALT_MATRIX(2,8))
C
C		Synch. pulse
C
		IMATRIX(1,9,2) = MIN0(MAX0(int(ALT_MATRIX(1,9)/DT),1)
     &			,N_POINTS)
		IMATRIX(2,9,2) = int(ALT_MATRIX(2,9)/DT)
c
c		Synch. pulse amplitude
c
		IMATRIX(1,10,2) = int(alt_matrix(1,10)/BIT_MV)
c
c		Height of end of voltage pulse
c
		IMATRIX(2,10,2) = int(
     &		( ALT_MATRIX(1,2) + alt_matrix(2,10))/BIT_MV )

	ENDIF
C
C	Define size and location of graphics display area 
C
	CALL SET_CHARACTER_HEIGHT(ISCREEN,1000)
	CALL GET_CHARACTER_SIZE(IW,IH)
	IDISPLAY_AREA(1) = IW
	IDISPLAY_AREA(2) = NDC_MAX - 24576 - IH
	IDISPLAY_AREA(3) = IDISPLAY_AREA(1) + ((60*IW)/512)*512
	IDISPLAY_AREA(4) = IDISPLAY_AREA(2) + 24576
	CALL SET_SIZE(IDISPLAY_AREA(1),IDISPLAY_AREA(2)
     &            ,IDISPLAY_AREA(3),IDISPLAY_AREA(4))
C
	T_MIN = 0.
	T_MAX = FLOAT(N_POINTS - 1)*DT
	Y_MAX = 2048.*BIT_MV
	Y_MIN = -2048.*BIT_MV
	NSCALE = int(V_MAX/V_DISPLAY)
C
C 	-- Draw display border  --------------------------------------
C
	CALL ERASE_ALL
	CALL FILES_IN_USE
	CALL MOVE_CURSOR(1,2)
	CALL DISPLAY_BOX(1,1,62,21)
	CALL MOVE_CURSOR(3,21)
	WRITE(LABEL,980) T_MIN,'ms'
980	FORMAT(F7.1,1X,A2)
	CALL DISPLAY_STRING(LABEL)
	WRITE(LABEL,980) T_MAX,'ms'
	CALL MOVE_CURSOR(50,21)
	CALL DISPLAY_STRING(LABEL)
	WRITE(LABEL,981) Y_MAX/FLOAT(NSCALE),'mV'
981	FORMAT(F7.0,1X,A2)
	CALL MOVE_CURSOR(63,1)
	CALL DISPLAY_STRING(LABEL)
	WRITE(LABEL,981) Y_MIN/FLOAT(NSCALE),'mV'
	CALL MOVE_CURSOR(63,20)
	CALL DISPLAY_STRING(LABEL)
C
C
	CALL FILL_RECTANGLE(ISCREEN,IDISPLAY_AREA)
C
	CALL DISPLAY_BOX(1,23,62,25)
	call move_cursor(2,1)

	IF( OUTPUT_REQUIRED ) THEN

	    CALL DISPLAY_STRING(' Voltage program in progress ')

C	    Find part of IWORK contained completly within 64Kb page

	    NCHAN = 2
	    NBYTES = N_POINTS*NCHAN*2
	    call allocate_dac_buffer(iwork,1,iws,n_points*nchan)

	ELSE
		CALL DISPLAY_STRING(' Voltage program preview (no output) ')
	ENDIF
C
C -- Set time of 1st pulse to be now
C
	go_time = time_in_secs()
C
	DO 100 IGROUP = 1,N_GROUPS
	DO 100 IP = 1,NPROG
C
C	    Generate group of pulses
C
	    DO IPULSE = 1,IMATRIX(2,8,IP)
C
C		Set up start and end points of pulse steps in program
C
		IPRE_PULSE_START = ISTART
		IMID_PULSE_START = IPRE_PULSE_START + IMATRIX(1,5,IP)
		IPULSE_START = IMID_PULSE_START + IMATRIX(1,7,IP)
		IPULSE_END = IPULSE_START + IMATRIX(1,3,IP)
		np_dac = min(ipulse_end + 20,n_points)
		IPRE_PULSE_LEVEL = IHOLDING_LEVEL + IMATRIX(1,4,IP)
		IMID_PULSE_LEVEL = IHOLDING_LEVEL + IMATRIX(1,6,IP)
		IPULSE_LEVEL = IHOLDING_LEVEL + IMATRIX(1,2,IP)
		IPULSE_LEVEL_end = IHOLDING_LEVEL + IMATRIX(2,10,IP)
C
C		Create 1ms synch. pulse
C
		ISYNCH_START = min(IMATRIX(1,9,IP),np_dac-1)
		ISYNCH_END = MIN0(ISYNCH_START+ISYNCH_WIDTH,np_dac)
		isynch_level = imatrix(1,10,ip)
C
C		Start of O/P buffer to start of pre-pulse
C
		J = 1
		CALL FILL_ARRAY(IHOLDING_LEVEL,IDISPLAY_V(1)
     &		,IPRE_PULSE_START-1)
C
C		Pre-pulse
C
		CALL FILL_ARRAY(IPRE_PULSE_LEVEL
     &		,IDISPLAY_V(IPRE_PULSE_START)
     &		,IMID_PULSE_START-IPRE_PULSE_START)
C
C		Mid-pulse
C
		CALL FILL_ARRAY(IMID_PULSE_LEVEL
     &		,IDISPLAY_V(IMID_PULSE_START)
     &		,IPULSE_START-IMID_PULSE_START)
C
C		Main pulse (or ramp)
C
		v = float(ipulse_level)
		dv = (float(ipulse_level_end) - v) /
     &		float( ipulse_end - ipulse_start )
		do ii = ipulse_start,ipulse_end
		    idisplay_v(ii) = int( v )
		    v = v + dv
		end do
C
C		End of main pulse to end of buffer
C
		CALL FILL_ARRAY(IHOLDING_LEVEL
     &		,IDISPLAY_V(IPULSE_END)
     &		,(np_dac-IPULSE_END)+1)
C
C		Ensure that pulse ALWAYS returns to holding level
C
		IDISPLAY_V(np_dac) = IHOLDING_LEVEL
C
C		Synch. pulse
C
		CALL FILL_ARRAY(0,IDISPLAY_SYNCH,np_dac)
		CALL FILL_ARRAY(ISYNCH_LEVEL
     &		,IDISPLAY_SYNCH(ISYNCH_START)
     &		,ISYNCH_END-ISYNCH_START)
C
C		Copy pulse waveform into D/A output buffer
C
		CALL FILL_ARRAY(2048,IWORK(IWS),np_dac*2)
		J = IWS
		DO I = 1,np_dac
		    IWORK(J) = max(min(IDISPLAY_V(I),4095),0)
		    J = J + 2
		end do
C
C		Copy Synch. pulse into D/A buffer
C
		J = IWS - 1 + 2*ISYNCH_START
		DO I = ISYNCH_START,ISYNCH_END-1
		    IWORK(J) = max(min(ISYNCH_LEVEL+IWORK(J),4095),0)
		    J = J + 2
		end do
C
C		Display voltage and synch pulse
C		multiply voltage by NSCALE to set display range
C
		ISHIFT = 2048 - 2048/NSCALE
		CALL ADD_ARRAY(-ISHIFT,IDISPLAY_V,np_dac)
		CALL MULTIPLY_ARRAY(NSCALE,IDISPLAY_V,np_dac)
		CALL YT_PLOT(ISCREEN,IDISPLAY_V,np_dac)
		CALL YT_PLOT(ISCREEN,IDISPLAY_SYNCH,np_dac)

		T_MIN = 0.
		T_MAX = FLOAT(np_dac - 1)*DT
		Y_MAX = 2048.*BIT_MV
		Y_MIN = -2048.*BIT_MV
		NSCALE = int(V_MAX/V_DISPLAY)

		CALL MOVE_CURSOR(3,21)
		WRITE(LABEL,'(F7.1,1X,A2)') T_MIN,'ms'
		CALL DISPLAY_STRING(LABEL)
		WRITE(LABEL,'(F7.1,1X,A2)') T_MAX,'ms'
		CALL MOVE_CURSOR(50,21)
		CALL DISPLAY_STRING(LABEL)
		WRITE(LABEL,'(F7.0,1X,A2)') Y_MAX/FLOAT(NSCALE),'mV'
		CALL MOVE_CURSOR(63,1)
		CALL DISPLAY_STRING(LABEL)
		WRITE(LABEL,'(F7.0,1X,A2)') Y_MIN/FLOAT(NSCALE),'mV'
		CALL MOVE_CURSOR(63,20)
		CALL DISPLAY_STRING(LABEL)
C
C		Inter-pulse period timing
C
161		CONTINUE
		clock_time = time_in_secs()
		IF(CLOCK_TIME.LT.GO_TIME) GOTO 161
		GO_TIME = CLOCK_TIME + PULSE_REPEAT_PERIOD/1000.
C
		WRITE(STRING,900) PROG(IP),IGROUP,N_GROUPS
     &		,IPULSE,IMATRIX(2,8,IP)
900		FORMAT(A,' Group ',I5,'/',I5,' Pulse ',I5,'/',I5
     &		,' ESC to stop')

		CALL MOVE_CURSOR(3,24)
		CALL DISPLAY_STRING(STRING)
C
C		Send pulse to D/A converters
C
		IF( OUTPUT_REQUIRED ) THEN
		    NCHAN = 2
		    ITRIG = 0
		    IMODE = 0
		    CALL MEMORY_TO_DAC(DT,NCHAN,np_dac,ITRIG
     &		    ,IWORK(IWS),IMODE,IERR)
		ENDIF

C
C		Check for termination of program by user
C
		CALL GET_KEY(KEY,SPEC)
		IF( (KEY.EQ.'$') .OR. (IERR.NE.0) ) THEN
c
c		     Clear keyboard buffer
c
		     call clear_key_buffer

		     CALL MOVE_CURSOR(3,24)
		     CALL ASK_USER('Abort voltage program (Y/N) ? '
     &		     ,KEY)
		     IF(KEY.EQ.'Y') GOTO 200
		ENDIF

	    end do
C
C	    Increment pulse program parameters to next group
C
	    DO I = 1,9
		IMATRIX(1,I,IP) = IMATRIX(1,I,IP) + IMATRIX(2,I,IP)
	    end do
c
c	    Increment pulse height (end) with same value as
c	    pulse height start
c
	    IMATRIX(2,10,IP) = IMATRIX(2,10,IP) + imatrix(2,2,ip)

100	continue
c
c	If user has selected repeat_mode do it all again
c
	if( repeat_mode ) goto 99

200	RETURN
	END
	SUBROUTINE LOAD_PROGRAM
$INCLUDE: 'VGECOM.FOR'
C
C	Load a voltage program from a .VGE file
C
	PARAMETER(IBOTTOM=25,ITOP=IBOTTOM-3,ILEFT=1,IRIGHT=62)
	parameter(max_files=50)
	character*12 files(max_files),file_name1 /' '/
C
C	CODE
C
	call move_cursor(3,5)
	CALL DISPLAY_STRING(' Load primary voltage program ')
	call files_menu('*.VGE',0,file_name1,3,6,10,files,max_files)

	IF(FILE_NAME1 .EQ. ' ') RETURN
	ALT_FILE = file_name1
	FILE_NAME = file_name1
	CALL OPEN_FILE(IFILE,IERR,FILE_NAME)
	IF(IERR.NE.0) RETURN
	CALL READ_BYTES(IFILE,IERR,PULSE_MATRIX,NB_MATRIX)
	CALL CLOSE_FILE(IFILE,IERR)
C
	RETURN
	END
	SUBROUTINE LOAD_ALTERNATE_PROGRAM
$INCLUDE: 'VGECOM.FOR'
C
C	Load a voltage program from a .VGE file
C
	PARAMETER(IBOTTOM=25,ITOP=IBOTTOM-3,ILEFT=1,IRIGHT=62)
	parameter(max_files=50)
	character*12 files(max_files),file_name1 /' '/
C
C	CODE
C
	call move_cursor(3,5)
	CALL DISPLAY_STRING(' Load alternate voltage program ')
	call files_menu('*.VGE',0,file_name1,3,6,10,files,max_files)
	if( file_name1 .eq. ' ' ) return
	alt_file = file_name1
	CALL OPEN_FILE(IFILE,IERR,ALT_FILE)
	IF(IERR.NE.0) RETURN
	CALL READ_BYTES(IFILE,IERR,ALT_MATRIX,NB_MATRIX)
	CALL CLOSE_FILE(IFILE,IERR)
C
	RETURN
	END

	SUBROUTINE SAVE_PROGRAM
$INCLUDE: 'VGECOM.FOR'
C
C	Save the current voltage program to a .VGE file
C
	PARAMETER(IBOTTOM=25,ITOP=IBOTTOM-3,ILEFT=1,IRIGHT=62)
	LOGICAL ABORT
C
C	CODE
C
	CALL MOVE_CURSOR(1,ITOP)
	CALL ERASE_EOS
	CALL DISPLAY_BOX(ILEFT,ITOP,IRIGHT,IBOTTOM)
	CALL MOVE_CURSOR(3,ITOP)
	CALL DISPLAY_STRING(
     &' Save the current voltage program to a .VGE file')
	CALL MOVE_CURSOR(3,ITOP+1)
	CALL DISPLAY_STRING('File Name ? ')
	CALL GET_FILE_NAME(FILE_NAME,'.VGE','NEW',ABORT)
	IF(ABORT .EQV. .TRUE.) RETURN
C
	CALL CREATE_FILE(IFILE,IERR,FILE_NAME)
	CALL WRITE_BYTES(IFILE,IERR,PULSE_MATRIX,NB_MATRIX)
	CALL CLOSE_FILE(IFILE,IERR)
	RETURN
	END
C
	SUBROUTINE FILES_IN_USE
$INCLUDE: 'VGECOM.FOR'
C
	CALL MOVE_CURSOR(65,3)
	CALL DISPLAY_STRING('FILES IN USE')
	CALL MOVE_CURSOR(65,4)
	CALL DISPLAY_STRING('Primary:')
	CALL MOVE_CURSOR(65,5)
	CALL DISPLAY_STRING(FILE_NAME)
	IF(NPROG .GT. 1) THEN
		CALL MOVE_CURSOR(65,6)
		CALL DISPLAY_STRING('Alternate:')
		CALL MOVE_CURSOR(65,7)
		CALL DISPLAY_STRING(ALT_FILE)
	ENDIF
	RETURN
	END

	subroutine clear_key_buffer
	character key
	logical special

10	continue
	    call wait(0.05)
	    caLL GET_KEY(KEY,SPECIAL)
	if( key .ne. char(0) ) goto 10
	return
	end

	SUBROUTINE display_HELP(TITLE,FILE_NAME,text,max_lines)
C
C	Read help .HLP text file
C
C
	PARAMETER(NDISP=22)
	CHARACTER*(*) TITLE,FILE_NAME
	CHARACTER*80 STRING
	CHARACTER*(*) TEXT(MAX_LINES)
	CHARACTER KEY
      LOGICAL SPECIAL
C
C     CODE
C     ----
C
	CALL ERASE_ALL
	CALL DISPLAY_BOX(1,1,80,25)
	CALL MOVE_CURSOR(2,1)
	CALL DISPLAY_STRING(TITLE)
	CALL MOVE_CURSOR(2,25)
	CALL DISPLAY_STRING(' '//CHAR(2)//' Next Page '//CHAR(1)//
     &' Previous page  ESC Exit help file ')
	CALL SET_MARGINS(5,3,79,24)
C
C	Open file
C
	CALL OPEN_FILE(IH,IERR,FILE_NAME)
C
	IF(IERR.NE.0) THEN
		CALL MOVE_CURSOR(5,5)
		CALL DISPLAY_STRING(' Sorry can''t find help file ')
		CALL NEW_LINE
		CALL ASK_USER('Press ESC to continue ',KEY)
		RETURN
	ENDIF

	call move_cursor(5,5)
	call display_string('...WAIT...')
C
C    Read list a row at a time until the end
C    of the file is reached
C
	IBYTE = 0
	LINE = 0
10		CONTINUE
C
C    	Read a row of the text file
C
		ICH = 0
13		CALL READ_BYTES(IH,NREAD,IBYTE,1)
		IF((NREAD.LE.0) .OR. (ICH.GE.79)) GOTO 1100
			if( ibyte .ne. 10 ) then
			    ICH = ICH + 1
			    STRING(ICH:ICH) = CHAR(IBYTE)
			    goto 13
			endif
11	CONTINUE
	LINE = LINE + 1
	TEXT(LINE) = STRING(1:ICH-1)
	IF((LINE.LT.MAX_LINES)) GOTO 10
C
1100	CONTINUE
	NLINES = LINE
C
C	Close file
C
	CALL CLOSE_FILE(IH,IERR)
C
	LINE = 1
15	CONTINUE
	CALL ERASE_BOX(2,2,79,24)
	CALL MOVE_CURSOR(5,3)
	DO 20 L = LINE, MIN0(LINE + NDISP-1,NLINES)
		CALL DISPLAY_STRING(TEXT(L))
		CALL NEW_LINE
20	CONTINUE
	CALL WAIT_FOR_KEY(KEY,SPECIAL)
	IF((KEY.EQ.'D') .or. (key.eq.'Q')) THEN
		LINE = LINE + NDISP
		IF(LINE.GT.NLINES) LINE = LINE - NDISP
	ELSEIF(KEY.EQ.'U' .or. (key.eq.'P')) THEN
		LINE = LINE - NDISP
		IF(LINE.LT.1) LINE = LINE + NDISP
	ELSEIF(KEY.EQ.'$') THEN
		RETURN
	ENDIF
	GOTO 15
	END
	subroutine setup
C
C	Set or change adc data collection parameters
C
	PARAMETER(NROWS=1)
	CHARACTER*40 MENU(NROWS) /
     &	' Screen display range (+/- mV) ' /

	CHARACTER*12 TEXT(NROWS)
	character*40 title
	automatic text,title
C
$INCLUDE:'vgecom.for'
C
C	CODE
C	----

	iold = interface_card
	call select_lab_interface( interface_card, title )
	if( iold .ne. interface_card ) then

	    call close_lab()

C	    Get limits allowed by interface

	    CALL LAB_LIMITS(MAX(INTERFACE_CARD,1)
     &	    ,DT_MIN,DT_MAX,AD_MIN,AD_MAX,DAC)

	    V_MIN = -DAC*1000.
	    V_MAX = DAC*1000.
	    BIT_MV = (DAC*2000.)/4096.

	    CALL OPEN_LAB(INTERFACE_CARD,iwork)

	endif


	write( text(1), '(f7.0)' ) v_display
C
	title = ' '
100	if( title .eq. ' ' ) then
	    title = ' Set Parameters '
	endif

	CALL TEXT_WINDOW(MENU,TEXT,NROWS,4,6,title)

	v_display = abs( check_limits(text,-10000.,10000.,1,title) )
	if( title .ne. ' ' ) goto 100

	return
	end

	subroutine save_settings
$include:'vgecom.for'
c
c	Save current program settings to initialisation file VGEN.INI
c	in directory \gemapps\gemsys
c

	call create_file( ifile, ierr, '\gemapps\gemsys\VGEN.ini' )

	if( ierr .eq. 0 ) then

	    call write_item(ifile,'IFC=', float(interface_card) )
	    call write_item(ifile,'VD=', v_display )

	    i = 26
	    call write_bytes( ifile, ierr, i, 1 )

	    call close_file( ifile, ierr )
	endif
	return
	end

	subroutine load_settings
$include:'vgecom.for'
c
c	Load current program settings from initialisation file VGEN.INI
c	in directory \gemapps\gemsys
c
	character string*512
	equivalence( string, iwork )
c
c	code
c

	call open_file( ifile, ierr, '\gemapps\gemsys\vgen.ini' )

	if( ierr .eq. 0 ) then

	    call read_bytes( ifile, ierr, iwork, 512 )

	    call read_item(string,'IFC=', r )
	    interface_card = int(r)
	    call read_item(string,'VD=', v_display )

	    call close_file( ifile, ierr )
	endif
	return
	end

	subroutine read_item( string, name, value )
	character*(*) name,string
	real*4 value
	integer*2 nc,is,ie
c
c	Searches <string> for items with the form:
c	<name> <number> <cr> <lf>
c	and then converts the number to REAL internal format
c

	nc = len( string )
	is = index( string, name )
	if ( is .gt. 0 ) then
	    ie = index( string(is:nc), char(13) )
	    if( ie .ne. 0 ) then
		ie = is + ie - 1
		is = is + len(name)
		read( string(is:ie), '(f16.0)', err=100 ) value
100		continue
	    endif
	endif
	return
	end

	subroutine write_item( ifile, name, value )
	integer*2 ifile
	character*(*) name
	real*4 value

	character string*30,crlf*2
	integer*2 istring,nc
	equivalence( string, istring )
c
c	code
c
	crlf = char(13)//char(10)
	write( string,'(a,f16.4,a)') name,value,crlf
	nc = len_trim(string)
	call write_bytes( ifile, ierr, istring, nc )
	return
	end


