	PROGRAM VCAN
C
C -- VCAN V4.0 Voltage Clamp Analysis Program -----------------
C    (c) J. Dempster MAY. 1991
C	Department of Physiology/Pharmacology,
C	University of Strathclyde.
C	This program is provided for academic research purposes
C	only and must not be sold or distributed further without
C	the permission of the author.
C -------------------------------------------------------------
C	V3.2 ... Labmaster support added.
c	V3.3 ... Ext. trigger bug fixed, FORTRAN V5
c	V3.4 ... Zero level bug in VCAANA fixed
c	V3.5 ... Floppy disc corruption bug fixed
c	V3.6 ... Data file header corruption bug fixed
c	V3.8 ... Voltage ramps added
c		 Amplicon PC-24 D/A board now supported
c	V3.9 ... March 1991 ... Interface No. 10 = External user supplied
c		 A/D sampling interval DT now corrected to value supported
c		 by lab. interface.
c	V4.0 ... New CED 1401 interface software
c		 File path added
c		National Instruments LAB-PC added
c	V4.0a Old LABCED.FOR restored due to problems (in Ljubljana)
c	V4.0b 21-aug-91 Dagan labmaster problem fixed
c	V4.0c Manual erase during recording fixed,
c	      Changes to LAB2801.for
c	V4.0d CED 1401-plus added, trigger stated saved in VCAN.INI
c	V4.0e LAB-PC+ supported added
c	V4.0f FEB 1993 files_menu bug fixed
c	V4.0g MAR 1993 N.I. ATMIO-16X support added
c	V4.0h AUG 1993 Changes to LAB.LIB
c	V4.1  FEB 1994 Support for Digiadat 1200
c	V4.2 APR 1994 Support for N.I. ATMIO-16F
c	V4.2a ATMIO-16F in differential mode
c	V4.2b Disk space bug fixed
c	V4.2c Channel flipping bug fixed (labpc.for) 2/9/94
c	V4.2d 5/6/95 Digidata 1200 Set_Dacs corrected
c       V4.3 27/3/97 Support for CED micro1401 added

$INCLUDE: 'VCACOM.FOR'

C	Master menu
	character*80 string
	character*56 message(10)
	character drive
	logical new_menu
	integer*4 ifree4

	CHARACTER KEY
	PARAMETER(nmenu=11,istatus_left=59,istatus_top=19)
	CHARACTER*20 MENU(Nmenu) /
     &	 'RECORD TO DISC    F1',
     &	 'VIEW    RECORDS   F2',
     &	 'LEAK SUBTRACTION  F3',
     &	 'PLOT I/V CURVES   F4',
     &	 'FIT EXP. CURVES   F5',
     &	 'FIT H-H  CURVES   F6',
     &	 'PLOT ALL RECORDS  F7',
     &	 'SET PARAMETERS    F8',
     &	 'LOAD/SAVE FILES   F9',
     &	 'LAB. INTERFACE   F10',
     &	 'EXIT PROGRAM       Q' /

	character*40 lab_card_name / ' ' /
C
C
C	CODE
C	----
C
C -- Initialisation ----------------------------------------------
C

C	Prevent run-time MATHs error from aborting program
C	(see Appendix D Microsoft FORTRAN V4.1 Users Guide)
	CALL LCWRQQ(16#133E)
C
C	Open Gem graphics package
C
	CALL OPEN_WORKSTATION(ISCREEN,1)
	IF(ISCREEN.EQ.0) STOP
	CALL SET_MARGINS(2,1,79,24)


C	Read configuration file

	CALL OPEN_FILE(IDATA_FILE_NO,IERR,'VCAN.INI')
	IF(IERR .EQ. 0) THEN
	    CALL GET_HEADER
	    CALL CLOSE_FILE(IDATA_FILE_NO,IERR)
	    IDATA_FILE_NO = 0
	ENDIF

	if( default_path .eq. ' ' ) then	! If a default file path
	    call get_default_disc( drive )	! does not exist, create
	    default_path = drive//':\lab\'      ! one on the current drive.
	end if

	ix = len_trim(default_path)		! Make sure the path
	if( default_path(ix:ix).ne.'\') then    ! ends with a '\'
	    ix = ix + 1
	    default_path(ix:ix) = '\'
	end if

	file_name = default_path			! Create the
	file_name(ix+1:len(file_name)) = 'unnamed.vca'	! default data file.

	call open_file( idata_file_no, ierr, file_name )
	if( ierr .eq. 0 ) then
	    string = default_path
	    call get_header
	    default_path = string
	else
	    call create_file( idata_file_no, ierr, file_name )
	    if( ierr .ne. 0 ) then
		default_path = drive//':\'
		file_name = default_path(1:len_trim(default_path))//
     &		'unnamed.vca'
		call create_file( idata_file_no, ierr, file_name )
	    end if
	end if

	bit_current = convert_gain( gain_current, 1 )
	bit_volts = convert_gain( gain_volts, 2 )
C
C 	Create work  file for for frame averages
C
	CALL CREATE_FILE(IAVG_FILE_NO,IERROR,'VCAN.AVG')
	IF(IERROR .NE.0) THEN
	    CALL CLOSE_WORKSTATION(ISCREEN)
	    STOP 'Cannot create file VCAN.AVG'
	ENDIF

100	CONTINUE
c
c	Flush all disc buffers
c
	call reset_disc

	call erase_all

c
c	Display title
c
	call display_box(1,1,istatus_left-2,25)
	call move_cursor(5,5)
	call display_string(
     &  'VCAN - Voltage Clamp Analysis Program  V4.3')
	call move_cursor(5,6)
	call display_string(
     &  ' (c) J. Dempster 1989-1997 All Rights Reserved')

$if defined (dagan)
	call move_cursor(5,7)
	call display_string(
     &	'  (Licensed to DAGAN Corporation, 1994)')
$endif

$if defined (life)
	call move_cursor(5,7)
	call display_string(
     &	'  (Licensed to Life Science Resources, 1994)')
$endif

$if defined (demo)
	call move_cursor(5,8)
	call display_string(
     &	 ' (Demonstration version - recording disabled)')
$endif

	call move_cursor(3,24)
	call get_lab_interface_name ( interface_card, lab_card_name )
	call display_string( lab_card_name )

c
c	Display program status
c
	call display_box(istatus_left-1,istatus_top-1,79,25)
	call set_margins(istatus_left,istatus_top,79,25)
	call move_cursor(istatus_left,istatus_top)

	call display_string( file_name(1:20) )
	call new_line
	call display_string( file_name(21:30) )
	call new_line

	write(string,'(''Records   '',I7)') n_frames
	call display_string( string(1:20) )
	call new_line

	ifree4 = int4( free_disc_space() )
	write(string,'(''Free Disc '',i7,''Kb'')' ) ifree4
	call display_string( string(1:20) )
	call new_line

	write(string,'(''Free Memory  '',i4,''Kb'')' ) ifree_memory()
	call display_string( string(1:20) )

	call set_margins(2,1,80,25)

C
c	Present options menu and wait for user response
c
	key = ' '
	new_Menu = .true.
	iop = Iwait_MENU_VERTICAL1(menu,'1234567890Q'
     &	,nmenu,istatus_left-1,1,new_menu,iop,' Options ',key)

	select case( iop )
	case( 1 )
C
C --	    Create ADC data file
C
$if defined(demo)
$else
	    CALL DIGITISE_ANALOGUE_SIGNAL(MENU(1))
	    FREE_SPACE = FREE_DISC_SPACE()
$endif
	case( 2 )
C
C --	    View ADC data records
C
	    IF(N_FRAMES .GT. 0) THEN
		call select_data_file( 3,5, ifile_no, n_max, string )
		nc = itrailing_space( string ) + 1
		IFRAME = 1
		CALL DISPLAY_FRAMES(string(1:nc),iFILE_NO,IFRAME,' ',
     &		message,0)
		call save_header
	    ENDIF

	case( 3 )
C
C --	    View/Create averaged records
C
	    IF(N_FRAMES.GT.0) THEN
		IFRAME = 1
		CALL CREATE_AVERAGES
		IF(N_RECORDS .GT. 0) CALL DISPLAY_FRAMES(
     &		' LEAK-SUBTRACTED AVERAGE RECORDS F2'
     &		,IAVG_FILE_NO,IFRAME,' ',message,0)
	    ENDIF

	case( 4 )
	    if( n_frames .gt. 0 ) call current_voltage_analysis
	case( 5 )
	    if( n_frames .gt. 0 ) call fit_exponentials
	case( 6 )
	    if( n_frames .gt. 0 ) call fit_hodgkin_huxley
	case( 7 )
	    if( n_frames .gt. 0 ) CALL DUMP_RECORDS
	case( 8 )
C
C --	    Configure ADC collection parameters
C
	    CALL SET_ADC_PARAMETERS
	    call save_header
	case( 9 )
C
C --	    .VCA data file operations
C
	    CALL FILES_OPTIONS
	case( 10 )
c
c --	    Set laboratory interface
c
$if defined( dagan )
		call select_dagan_interface(interface_card,lab_card_name)
$else
		call select_lab_interface(interface_card,lab_card_name)
$endif
	case( 11 )
C
C --	    Stop program
C
	    CALL QUERY_BOX(3,8,' Exit Program! Are you sure (Y/N) ? '
     &	    ,KEY)
	    IF( KEY .EQ. 'Y' ) THEN
		IF(IDATA_FILE_NO.NE.0) CALL CLOSE_FILE(IDATA_FILE_NO,IERR)
		CALL CLOSE_FILE(IAVG_FILE_NO,IERR)
		CALL CLOSE_WORKSTATION(ISCREEN)
		STOP
	    ENDIF
	end select
	goto 100

	end


	BLOCK DATA
C
$INCLUDE: 'VCACOM.FOR'

C
	DATA IDATA_FILE_NO,IAVG_FILE_NO /0,0/
	DATA default_path,FILE_NAME,ID /' ',' ',' '/
	DATA NB_ANALYSIS,NB_DATA,N_CHANNELS,NB_FILE /1,4,2,0/
	DATA N_FRAMES,N_RECORDS,N_POINTS /0,0,512/
	DATA N_GROUPS_REQUESTED,N_TEST_RECORDS /5,4/
	DATA I_BASE,N_BASE,I_START,I_END,I_ZERO /1,20,1,512,1/
	DATA GAIN_CURRENT,GAIN_VOLTS,DT /1000.,10.,0.16/
	data izero_current,izero_volts / 2048,2048/
	data fixed_zero_current,FIXED_zero_volts / 'N', 'Y' /
	DATA C_UNITS,T_UNITS,V_UNITS /'nA  ','ms  ','mV  '/
	data clamp_mode / 'V' /
	data itrigger_mode /1/
	DATA ADC_RANGE,INTERFACE_CARD /5.,1/
	DATA RECORD_GAIN /1.,1./
	DATA VOLTS_REVERSAL / -90./

	  data	pulse_period /2000./
	  data	holding_voltage / 0. /
	  data	pulse_height / 100. /
	  data	pulse_height_inc / 100. /
	  data	pulse_width / 100. /
	  data	pulse_width_inc / 0. /
	  data	pre_pulse_height /0./
	  data	pre_pulse_height_inc /0./
	  data	pre_pulse_width /0./
	  data	pre_pulse_width_inc /0./
	  data	pulse_height_end /100./
	  data	mid_pulse_height_inc /0./
	  data	mid_pulse_width /0./
	  data	mid_pulse_width_inc /0./
	  data	groups_per_program / 10./
	  data	pulses_per_group /1./
	  data	synch_pulse_delay /0./
	  data	synch_pulse_delay_inc /0./
	  data	primary_name,alternate_name /' ',' '/
	END

	subroutine select_data_file( ix, iy, ifile_no, n_max, name )
	character*(*) name
$include:'vcacom.for'

	character key
	logical new_menu

	parameter(nmenu=2)
	character*38 menu(nmenu) /
     &	' RAW SIGNAL RECORDS              F1',
     &	' LEAK-SUBTRACTED AVERAGE RECORDS F2' /

c
c	code
c
	if( n_records .gt. 0 ) then
	    new_Menu = .true.
	    itype = Iwait_MENU_VERTICAL1(menu,'12'
     &	    ,nmenu,ix,iy,new_menu,itype,' Record type ',key)
	    if( itype .eq. 1 ) then
		ifile_no = idata_file_no
		n_max = n_frames
	    else
		ifile_no = iavg_file_no
		n_max = n_records
	    endif
	else
	    itype = 1
	    ifile_no = idata_file_no
	    n_max = n_frames
	endif

	name = menu(itype)
	return
	end

	SUBROUTINE SET_ADC_PARAMETERS
C
C	Set or change adc data collection parameters
C
$INCLUDE: 'VCACOM.FOR'
C
	PARAMETER(NROWS=8)
	CHARACTER*10 TEXT(NROWS)
	character*48 title
	cHARACTER*38 MENU(NROWS) /
     &	'No. of groups to be collected',
     &	'No. of records/group',
     &	'Record size (256,512,1024,2048)',
     &	'Digital sampling interval (ms)',
     &	'Current channel gain factor (mV/',
     &	'Current channel Units (uA,nA,pA)',
     &	'Voltage channel gain factor ',
     &	'A/D converter range (+/-1.25,2.5,5,10V) ' /

C
C	CODE
C	----

C	Get limits allowed by interface

	CALL LAB_LIMITS(INTERFACE_CARD,DT_MIN,DT_MAX,AD_MIN,AD_MAX,DAC)
c

	menu(5) = 'Current channel gain factor (mV/'//c_units//')'
C
C	Insert current values into reponse field of form
C
	WRITE(TEXT(1),'(i4)') N_GROUPS_REQUESTED
	WRITE(TEXT(2),'(i4)') N_TEST_RECORDS
	write(text(3),'(i4)') n_points
	IF( T_UNITS .EQ. 's' ) DT = DT*1000.
	WRITE(TEXT(4),'(f10.3)') DT
	WRITE(TEXT(5),'(f10.3)') GAIN_CURRENT
	TEXT(6) = C_UNITS
	WRITE(TEXT(7),'(f10.3)') GAIN_VOLTS
	WRITE(TEXT(8),'(f10.3)') ADC_RANGE
	WRITE(TEXT(9),'(i4)') INTERFACE_CARD

C
	title = ' '
100	if( title .eq. ' ' ) then
	    title = ' Set Recording/Analysis Parameters '
	endif
	CALL TEXT_WINDOW(MENU,TEXT,NROWS,3,3,title)
C
	I = 1
	N_GROUPS_REQUESTED = int(check_limits(text,1.,2000.,i,title))
	if( title .ne. ' ' ) goto 100
C
	I = I + 1
	N_test_records = int(check_limits(text,1.,400.,i,title))
	if( title .ne. ' ' ) goto 100
C
	I = I + 1
	n_points= int(check_limits(text,256.,float(max_points),i,title))
	if( title .ne. ' ' ) goto 100

	n = 256
10	if( (n_points .gt. n) .and. (n.ne.max_points) ) then
	    n = n * 2
	    goto 10
	endif
	n_points = n
	nb_data = (n_points*n_channels) / npoints_per_block
C
	I = I + 1
	R = FLOAT(N_CHANNELS)
	dt = check_limits(text,dt_min*r,dt_max*r,i,title)
	if( title .ne. ' ' ) goto 100
	IF( DT .GT. 2. ) THEN
	    T_UNITS = 's'
	    DT = DT/1000.
	ELSE
	    T_UNITS = 'ms'
	ENDIF

	I = I + 1
	gain_current = check_limits(text,0.,1E30,i,title)
	if( title .ne. ' ' ) goto 100
C
	I = I + 1
	ix = ileading_space( text(i) )
	C_UNITS = TEXT(I)(ix:ix+3)
	IF((C_UNITS.NE.'nA') .AND. (C_UNITS.NE.'uA')
     &	.AND. (C_UNITS.NE.'pA')) then
	    write(title
     &	    ,'(''ERROR! Row'',i2,'' Must be nA,uA, or pA'')') i
	    goto 100
	endif
C
	I = I + 1
	gain_VOLTS = check_limits(text,0.,1E30,i,title)
	if( title .ne. ' ' ) goto 100
C
	I = I + 1
	adc_range = check_limits(text,ad_min,ad_max,i,title)
	if( title .ne. ' ' ) goto 100
C
	call check_adc_range( interface_card, adc_range )

	BIT_CURRENT = CONVERT_GAIN(GAIN_CURRENT,0)
	BIT_VOLTS = CONVERT_GAIN(GAIN_VOLTS,1)

	RETURN
	END
	
