	PROGRAM SCAN
$INCLUDE:'SCACOM.FOR'
C
C -- SCAN V3.9a Spontaneous Current Analysis Program ---------------
C    (c) J. Dempster  1988,1989,1990,1991
C	Department of Physiology/Pharmacology,
C	University of Strathclyde.
C	This program is provided for academic research purposes
C	only and must not be sold or distributed further without
C	the permission of the author.
C -------------------------------------------------------------
C	V3.3 Labmaster supported added, interface now selected from main menu
c	V3.4 External trigger fail on initial start-up fixed
c	     Now FORTRAN V5.0
c	V3.6 Multiple plots on single page now possible
c	     Faulty data file header update buf fixed
c	V3.8 Zero line on hard copies made optional
c	     Clipping removed from HPGL files
c	     HPGL files now have .PGL extension
c	     On-line measurement and printer output added
c	V3.9 ... March 1991 ... Interface 10 = user supplied added to list
c	     sampling interval DT corrected to interface-supported value
c	     when interface is opened. (See SCAA2D.FOR)
c
c	V4.0  ... APril 1991 Fix to LABCED.FOR for garbage characters
c	      being send by 1401 in response to ERR; on Vanilla 386SX
c	      Data directory now implementaed as path added to file name
c	V4.0a Old LABCED.FOR restored due to problems (in Ljubljana)
c	V4.0b August 1991 Dagan problems with Labmaster fixed
c	V4.0c Sep 1991 ... Set Params in SCAA2D.for now works properly
c	V4.0d Sep 1992 ... CED 1401-plus added
c	V4.0e Jan 1993 ... Lab-PC+ support added
c	V4.0f Feb 1993 files_menu bug fixed.
c	V4.0g Mar 1993 Logging bug fixed in SCAA2D.FOR
c	V4.0h AUG 1993 New DISPLAY_ADC, New GEMDOS2.FOR
c	V4.1  FEB 1994 Support for Digiadat 1200
c	V4.2 APR 1994 Support for N.I. ATMIO-16F
c	V4.2a 20/4/94 ATMIO-16f in differential mode
c	V4.2b 18/5/94 Disk space bug fixed
c	V4.2c 2/9/94 Channel flipping bug fixed
c	V4.2d 6/5/95 Digidata 1200 set_dacs fixed
c       V4.3 27/3/97 Support for CED micro1401 added

	character*80 string
	character drive
	logical new_menu
	integer*4 ifree4

	CHARACTER KEY
	PARAMETER(nmenu=11,istatus_left=59,istatus_top=20)
	CHARACTER*20 MENU(Nmenu) /
     &	 'RECORD TO DISC    F1',
     &	 'VIEW    RECORDS   F2',
     &	 'AVERAGE RECORDS   F3',
     &	 'ANALYSE RECORDS   F4',
     &	 'FIT EXP. CURVES   F5',
     &	 'QUANTAL CONTENT   F6',
     &	 'PLOT ALL RECORDS  F7',
     &	 'SET PARAMETERS    F8',
     &	 'LOAD/SAVE FILES   F9',
     &	 'LAB. INTERFACE   F10',
     &	 'EXIT PROGRAM       Q' /

	character*24 errmsg1 / ' No records available! ' /
	character*40 lab_card_name / ' ' /
C
C
C	CODE
C	----
C
C -- Initialisation ----------------------------------------------
C

C	Prevent run-time MATHs error from aborting program
C	(see Appendix D Microsoft FORTRAN V4.1 Users Guide)
	CALL LCWRQQ(16#133E)
C
C	Open Gem graphics package
C
	CALL OPEN_WORKSTATION(ISCREEN,1)
	IF(ISCREEN.EQ.0) STOP
	CALL SET_MARGINS(2,1,80,25)

C	Read configuration file

	CALL OPEN_FILE(IDATA_FILE_NO,IERR,'SCAN.INI')
	IF(IERR .EQ. 0) THEN
	    CALL GET_HEADER
	    CALL CLOSE_FILE(IDATA_FILE_NO,IERR)
	    IDATA_FILE_NO = 0
	ENDIF

	if( default_path .eq. ' ' ) then	! If a default file path
	    call get_default_disc( drive )	! does not exist, create
	    default_path = drive//':\lab\'      ! one on the current drive.
	end if

	ix = len_trim(default_path)		! Make sure the path
	if( default_path(ix:ix).ne.'\') then    ! ends with a '\'
	    ix = ix + 1
	    default_path(ix:ix) = '\'
	end if

	file_name = default_path			! Create the
	file_name(ix+1:len(file_name)) = 'unnamed.sca'	! default data file.

	call open_file( idata_file_no, ierr, file_name )
	if( ierr .eq. 0 ) then
	    string = default_path
	    call get_header
	    default_path = string
	else
	    call create_file( idata_file_no, ierr, file_name )
	    if( ierr .ne. 0 ) then
		default_path = drive//':\'
		file_name = default_path(1:len_trim(default_path))//
     &		'unnamed.sca'
		call create_file( idata_file_no, ierr, file_name )
	    end if
	    n_frames = 0
	end if

	BIT_CURRENT = CONVERT_GAIN(GAIN_CURRENT)
C
C 	Create work  file for for frame averages
C
	CALL CREATE_FILE(IAVG_FILE_NO,IERr,'SCAN.AVG')
	IF(IERR .NE.0) THEN
	    CALL CLOSE_WORKSTATION(ISCREEN)
	    STOP 'Cannot create file SCAN.AVG'
	ENDIF
C
C
100	CONTINUE
c
c	Flush all disc buffers
c
	call reset_disc

	call erase_all

c
c	Display title
c
	call display_box(1,1,istatus_left-2,25)
	call move_cursor(5,5)
	call display_string(
     &  'SCAN - Synaptic Current Analysis Program V4.3')
	call move_cursor(5,6)
	call display_string(
     &  ' (c) J. Dempster 1989-1997, All Rights Reserved')

$if defined (dagan)
	call move_cursor(5,7)
	call display_string(
     &	'  (Licensed to DAGAN Corporation, 1994)')
$endif

$if defined (life)
	call move_cursor(5,7)
	call display_string(
     &	'  (Licensed to Life Science Resources, 1994)')
$endif

$if defined (demo)
	call move_cursor(5,8)
	call display_string(
     &	' (Demonstration version - recording disabled)')
$endif


	call move_cursor(3,24)
	call get_lab_interface_name ( interface_card, lab_card_name )
	call display_string( lab_card_name )

c
c	Display program status
c
	call display_box(istatus_left-1,istatus_top-1,79,25)
	call set_margins(istatus_left,istatus_top,79,25)
	call move_cursor(istatus_left,istatus_top)

	call display_string( file_name(1:20) )
	call new_line
	call display_string( file_name(21:30) )
	call new_line

	write(string,'(''Records   '',I7)') n_frames
	call display_string( string(1:20) )
	call new_line

	ifree4 = int4( free_disc_space() )
	write(string,'(''Disc space'',I7,''Kb'')' ) ifree4
	call display_string( string(1:20) )
	call new_line

	write(string,'(''Free Memory  '',i4,''Kb'')' ) ifree_memory()
	call display_string( string(1:20) )

	call set_margins(2,1,80,25)

C
c	Present options menu and wait for user response
c
	new_Menu = .true.
	iop = Iwait_MENU_VERTICAL1(menu,'1234567890Q'
     &	,nmenu,istatus_left-1,1,new_menu,iop,' Options ',key)

	select case( iop )

	    case( 1 )
$if defined(demo)
$else
		CALL DIGITISE_ANALOGUE_SIGNAL	    ! Record signals
$endif
	    case( 2 )
c
c		View records on file
c
		IF(N_FRAMES .GT. 0) THEN
		    IFRAME = 1
		    call display_records(' VIEW RECORDS ',
     &		    idata_file_no,iframe,' ',' ',0)
		    call save_header
		ELSE
		    call display_message(3,3,26,errmsg1,1)
		ENDIF

	    case( 3 )
C
C		 View/Create averaged records
C
		IF( N_FRAMES .GT. 0 ) THEN
		    CALL CREATE_AVERAGES
		ELSE
		    call display_message(3,3,26,errmsg1,1)
		ENDIF

	    case( 4 )
C
C		  Analyse Peak/Steady-state
C
		if( n_frames .gt. 0 ) then
		    cALL PEAK_ANALYSIS
		else
		    call display_message(3,3,26,errmsg1,1)
		endif

	    case( 5 )
C
C		Analyse exponentials
C
		if( n_frames .gt. 0 ) then
		    CALL FIT_EXPONENTIALS
		else
		    call display_message(3,3,26,errmsg1,1)
		endif

	    case( 6 )
C
C		Quantal content analysis
C
		if( n_frames .gt. 0 ) then
		    call quantal_content_analysis
		else
		    call display_message(3,3,26,errmsg1,1)
		endif

	    case( 7 )
C
C		 Plot hard copy
C
		if( n_frames .gt. 0 ) then
		    CALL DUMP_RECORDS
		else
		    call display_message(3,3,26,errmsg1,1)
		endif

	    case( 8 )
C
C		 Configure ADC collection parameters
C
		CALL SET_ADC_PARAMETERS
		call save_header

	    case( 9 )
C
C		 Files options
C
		CALL FILES_OPTIONS

	    case( 10 )
c
c		Choose lab. interface
c
$if defined( dagan )
		call select_dagan_interface(interface_card,lab_card_name)
$else
		call select_lab_interface(interface_card,lab_card_name)
$endif

	     case( 11 )
C
C		 Stop program
C
		CALL QUERY_BOX(5,9,
     &		' Exit Program! Are you sure (Y/N) ? ',key)
		IF( KEY .EQ. 'Y' ) THEN
		    IF(IDATA_FILE_NO.NE.0) THEN
			CALL CLOSE_FILE(IDATA_FILE_NO,IERROR)
		     ENDIF
		     CALL CLOSE_FILE(IAVG_FILE_NO,iERROR)
		     CALL CLOSE_WORKSTATION(ISCREEN)
		     STOP
		 ENDIF
	end select
	goto 100

	END


	BLOCK DATA
C
$INCLUDE:'SCACOM.FOR'
C
	DATA NB_ANALYSIS,NB_DATA,N_CHANNELS,NB_FILE /1,2,1,0/
	DATA N_FRAMES,N_RECORDS,N_POINTS /0,0,512/
	DATA N_RECORDS_REQUESTED /10/
	DATA I_BASE,N_BASE,I_START,I_END,I_ZERO /1,20,1,512,1/
	DATA GAIN_CURRENT,DT /1000.,0.05/
	DATA Izero_CURRENT /2048/
	data fixed_zero / 'N' /
	DATA C_UNITS,T_UNITS /'mV  ','ms  '/
	DATA ADC_RANGE /5./
	DATA TRIGGER_LEVEL /10./
	data pre_trigger /20./
	DATA INTERFACE_CARD /1/
	DATA RECORD_GAIN /1./
	DATA default_path,FILE_NAME / ' ',' ' /
	DATA IDATA_FILE_NO /0/
	DATA IAVG_FILE_NO /0/
	DATA ID / ' ' /
	END



	SUBROUTINE SET_ADC_PARAMETERS
C
C	Set or change adc data collection parameters
C
	PARAMETER(NROWS=8)
	CHARACTER*40 MENU(NROWS) /
     &	' No. of records to be collected',
     &	' Samples/record (256,512,1024,2048)',
     &	' Digital sampling interval (ms)',
     &	' Scale factor (mV/',
     &	' Units',
     &	' Trigger level (% full scale)',
     &	' Pre-trigger points (%)',
     &	' Input voltage range (+/-1.25,2.5,5,10V) ' /

	CHARACTER*12 TEXT(NROWS)
	character*40 title
C
$INCLUDE:'SCACOM.FOR'
C
C	CODE
C	----

C	Get limits allowed by interface

	CALL LAB_LIMITS(INTERFACE_CARD
     &,DT_MIN,DT_MAX,AD_MIN,AD_MAX,DAC)
C
	MENU(4) = ' Calibration  factor (mV/'//C_UNITS//')'
C
C	Insert current values into reponse field of form
C
	WRITE(TEXT(1),901) N_RECORDS_REQUESTED
901	FORMAT(I4)
	write(text(2),901) n_points
	IF( T_UNITS .EQ. 's' ) DT = DT*1000.
	WRITE(TEXT(3),902) DT
902	FORMAT(F12.3)
	WRITE(TEXT(4),902) GAIN_CURRENT
	TEXT(5) = C_UNITS
	WRITE(TEXT(6),902) TRIGGER_LEVEL
	write(text(7),902) pre_trigger
	WRITE(TEXT(8),902) ADC_RANGE
C

	title = ' '
100	if( title .eq. ' ' ) then
	    title = ' Set Recording/Analysis Parameters '
	endif

	CALL TEXT_WINDOW(MENU,TEXT,NROWS,3,5,title)

	n_records_requested = int(
     &	check_limits(text,1.,2000.,1,title) )
	if( title .ne. ' ' ) goto 100

	n_points = int(
     &	 check_limits(text,256.,float(max_points),2,title) )
	if( title .ne. ' ' ) goto 100

	i = 256
10	if( (n_points .gt. i) .and. (i.ne.max_points) ) then
	    i = i * 2
	    goto 10
	endif
	n_points = i

	dt = check_limits(text,dt_min,dt_max,3,title)
	if( title .ne. ' ' ) goto 100
	IF( DT .GT. 2. ) THEN
	    T_UNITS = 's'
	    DT = DT/1000.
	ELSE
	    T_UNITS = 'ms'
	ENDIF

	gain_current = check_limits(text,0.,1E30,4,title)
	if( title .ne. ' ' ) goto 100

	c_units = text(5)

	trigger_level = check_limits(text,-100.,100.,6,title)
	if( title .ne. ' ' ) goto 100

	pre_trigger = check_limits(text,0.,100.,7,title)
	if( title .ne. ' ' ) goto 100

	adc_range = check_limits(text,ad_min,ad_max,8,title)
	if( title .ne. ' ' ) goto 100

	call check_adc_range( interface_card, adc_range )

	BIT_CURRENT = CONVERT_GAIN(GAIN_CURRENT)

	RETURN
	END

	subroutine select_data_file( ix, iy, ifile_no, n_max, name )
	character*(*) name
$include:'scacom.for'

	character key
	logical new_menu

	parameter(nmenu=2)
	character*24 menu(nmenu) /
     &	' RAW SIGNAL RECORDS  F1',
     &	' AVERAGE RECORD      F2' /

c
c	code
c
	if( n_records .gt. 0 ) then
	    new_Menu = .true.
	    itype = Iwait_MENU_VERTICAL1(menu,'12'
     &	    ,nmenu,ix,iy,new_menu,itype,' Record type ',key)
	    if( itype .eq. 1 ) then
		ifile_no = idata_file_no
		n_max = n_frames
	    else
		ifile_no = iavg_file_no
		n_max = n_records
	    endif
	else
	    itype = 1
	    ifile_no = idata_file_no
	    n_max = n_frames
	endif

	name = menu(itype)
	return
	end

