	subroutine stability_plots
$INCLUDE:'patCOM.FOR'
c
c	Create plots showing amplitude and temporal stability
c	of single channel current recording
C
C
	CHARACTER*52 TITLE
	CHARACTER*18 YLABEL,xlabel
	CHARACTER KEY
	LOGICAL new_plot,plot_available,cursor_key,new_menu,quit

	parameter(max_np=2000)
	real*4 xy(max_np)
	equivalence (iwork, xy)

	parameter(nmenu=5,naxes_menu=6,istatus_left=59,istatus_top=17)
	parameter(bigneg=-1E30,bigpos=1E30)
	character*36 axes_menu(naxes_menu)
	character*12 list(naxes_menu)
	character*35 err

	character*20 menu(nmenu) /
     &	' Create plot      F1',
     &	' Set axes range   F2',
     &	' Plot display     F3',
     &	' List plot        F4',
     &	' Exit            ESC'/

	character*12 label(2)
	logical display(2)

C
C	CODE
C	----
C

	new_plot = .false.
	plot_available = .false.
	cursor_key = .false.
	iop = 1
	CALL ERASE_ALL
	call display_box(1,1,istatus_left-2,25)
	CALL MOVE_CURSOR(2,1)
	CALL DISPLAY_STRINg(' Stability plots ')

	title = ' '
	new_menu = .true.
	quit = .false.
	nrep = 0

	do while( .not. quit )

C
C	    Plot graph on screen
C
	    if( new_plot ) then

		call erase_box(1,1,istatus_left-2,25)
		call display_box(1,1,istatus_left-2,25)

		if( title .ne. ' ' ) then
		    call move_cursor(2,1)
		    call display_stringt( title )
		end if
		call erase_box(istatus_left-1,istatus_top-1,79,25)
		call display_box(istatus_left-1,istatus_top-1,79,25)

		if( plot_available ) then
		    call plot_graph('S',xy,np
     &		    ,xlo,ylo,xhi,yhi,xtic,ytic,xlabel,ylabel
     &		    ,report,nrep)
		end if

		new_plot = .false.

	    endif

	    iop = Iwait_MENU_VERTICAL1(menu,'1234$',nmenu,
     &	    istatus_left-1,1,new_menu,iop,' Options ',key)

	    select case( iop )

	    case( 1 )
C
C		Create stability plots
c
		call create_stability_plot(xy,np,max_np,
     &		xlabel,ylabel,title,plot_available)

		if( plot_available ) then

		    xlo = xmin
		    xhi = xmax
		    ymin = 1E30
		    ymax = -ymin
		    xmin = 1E30
		    xmax = -xmin
		    do i = 1,np
			j = i*2-1
			if( xmin .gt. xy(j) ) xmin = xy(j)
			if( xmax .lt. xy(j) ) xmax = xy(j)
			j = j + 1
			if( ymin .gt. xy(j) ) ymin = xy(j)
			if( ymax .lt. xy(j) ) ymax = xy(j)
		    end do
		    xlo = xmin
		    xhi = xmax
		    ylo = ymin
		    yhi = ymax

                    if(xlo .eq. xhi ) then
                        xhi = xhi + 1.
                        xlo = xlo - 1.
                    end if
                    if(ylo .eq. yhi ) then
                        yhi = yhi + 1.
                        ylo = ylo - 1.
                    end if

		    xtic = (xhi-xlo)/5.
		    ytic = (yhi-ylo)/5.
		    new_plot = .true.
		    new_menu = .true.
		    nrep = 0
		endif

	    case( 2 )
C
C --		Set plot axes range and tic spacing
C
		if( plot_available ) then
		    WRITE(axes_menu(1)
     &		    ,'('' X axis range: minimum ('',G10.4,'')'')') XMIN
		    WRITE(axes_menu(2)
     &		    ,'('' X axis range: maximum ('',G10.4,'')'')') XMAX
		    axes_menu(3) = ' X axis tic spacing '
		    WRITE(axes_menu(4)
     &		    ,'('' Y axis range: minimum ('',G10.4,'')'')') YMIN
		    WRITE(axes_menu(5)
     &		    ,'('' Y axis range: maximum ('',G10.4,'')'')') YMAX
		    axes_menu(6) = ' Y axis tic spacing '

		    write(list(1),'(F12.3)') xlo
		    write(list(2),'(F12.3)') xhi
		    write(list(3),'(F12.3)') xtic
		    write(list(4),'(F12.3)') ylo
		    write(list(5),'(F12.3)') yhi
		    write(list(6),'(F12.3)') ytic

		    err = ' '
2100		    if( err .eq. ' ' ) err = ' Set axes range '

		    CALL text_window(axes_menu,list,naxes_menu,2,2,err)

		    xlo  = check_limits(list,bigneg,bigpos,1,err)
		    if( err .ne. ' ' ) goto 2100
		    xhi  = check_limits(list,bigneg,bigpos,2,err)
		    if( err .ne. ' ' ) goto 2100
		    xtic = check_limits(list,0.,bigpos,3,err)
		    if( err .ne. ' ' ) goto 2100
		    ylo  = check_limits(list,bigneg,bigpos,4,err)
		    if( err .ne. ' ' ) goto 2100
		    yhi  = check_limits(list,bigneg,bigpos,5,err)
		    if( err .ne. ' ' ) goto 2100
		    ytic = check_limits(list,0.,bigpos,6,err)
		    if( err .ne. ' ' ) goto 2100

		    new_plot = .true.
		    new_menu = .true.
		endif

	    case( 3 )
C
C --		Plot hard copy of graph or histogram
C
		if( plot_available ) then
		    call plot_graph('H',xy,np
     &		    ,xlo,ylo,xhi,yhi,xtic,ytic,xlabel,ylabel
     &		    ,report,nrep)
		    new_plot = .true.
		    new_menu = .true.
		endif

	    case( 4 )
C
C --		Display table of current graph values
C
		 if( plot_available ) then

		    Display(1) = .true.
		    label(1) = xlabel
		    Display(2) = .true.
		    label(2) = ylabel
                    call ListData( xy, np,2, Display, Label, 2,2)
		    new_plot = .true.
		endif

	    case( 5 )
c
c --		Exit
c
		quit = .true.
		new_plot = .true.

	    end select
	end do

	return
	end

	subroutine create_stability_plot(xy,np,max_np,
     &	xlabel,ylabel,title,plot_available)
$include:'patcom.for'
c
c	Calculate selected stability plot
c
	real*4 xy(1)		! (Out) X/Y graph array
	integer*2 np		! (Out) No. of points in xy
	integer*2 max_np	! (In) Max. number of points allowed

	character*(*) xlabel	! (Out) X axis label
	character*(*) ylabel	! (Out) Y axis label
	character*(*) title	! (Out) Plot title
	logical plot_available	! (Out) .true. = result is in XY

	character key
	logical new_menu

	parameter(nmenu=5)
	character*40 menu(nmenu) /
     &	' Dwell time vs time                F1',
     &	' Average state amplitude vs time   F2',
     &	' Mean current vs time              F3',
     &	' Open probability vs time          F4',
     &	' Quit                             ESC' /

	integer*4 iEventStart /0/, iEventEnd /0/
	integer*4 iRecordStart /0/, iRecordEnd /0/

c	code
c
	title = ' '
	plot_available = .false.

	itype = Iwait_MENU_VERTICAL1(menu,'1234$',nmenu,2,2,new_menu
     &	,itype,' Select Plot Type ',key)
	call move_cursor(4,3+itype)

	select case( itype )
	case( 1 )
	    call dwell_time_vs_time( xy, np, max_np,
     &	    iEventStart,iEventEnd,xlabel,ylabel,title)
	    plot_available = .true.

	case( 2 )
	    call average_amplitude_vs_time( xy, np, max_np,
     &	    iEventStart,iEventEnd,xlabel,ylabel,title)
	    plot_available = .true.

	case( 3 )
	    call mean_current_vs_time( xy, np, max_np,
     &	    iRecordStart,iRecordEnd,xlabel,ylabel,title)
	    plot_available = .true.

	case( 4 )
	    call mean_current_vs_time( xy, np, max_np,
     &	    iRecordStart,iRecordEnd,xlabel,ylabel,title)
	    plot_available = .true.

	    do i = 1,np
		xy(2*i) = xy(2*i) / (float(iunit)*ScaleIm)
	    end do
	    ylabel = 'Prob'
	    title = ' Open state probability vs time '

	end select

	if( np .le. 0 ) plot_available = .false.
	return
	end

	subroutine dwell_time_vs_time(xy,np,max_np,
     &	iStart,iEnd,xlabel,ylabel,title)
$INCLUDE: 'PATCOM.FOR'
c
c	Calculate average dwell time in selected state over
c	a series of events and plot vs time
c
	real*4 xy(1)			! (Out) dwell time vs time X-Y plot
	integer*2 np			! (Out) No. of points in xy
	integer*2 max_np		! (In) Max. no. of points allowed
	integer*4 iStart,iEnd		! Entered = first..last records
	character*(*) xlabel		! (Out) x axis label
	character*(*) ylabel		! (Out) y axis label
	character*(*) title		! (Out) Histogram title

	parameter(nmenu=3)
	character*40 menu(nmenu) /
     &	' Start at event (1-       )',
     &	' End at event ',
     &	' No. of events to average ' /

	character*10  list(nmenu)
	character*32 err
	character key
	integer*4 iEvent
	character*6 sname

	record /event_record/ event
	integer*4 nAvg /100/
	integer*4 nAvgd
c
c	code
c

	call find_cursor(ix,iy)

	call select_state( ix,iy, ilevel, 4 )

	i = 1
	write(menu(i),'('' Start at event (1-'',i7,'')'')') n_events
	write(list(i),'(I7)') max(min(iStart,n_events),1)
	i = i + 1
	if( iEnd .eq. 0 ) iEnd = n_events
	write(list(i),'(I7)') iEnd
	i = i + 1
	write(list(i),'(I7)') navg

	iy = iy + 4
	err = ' '
50	if( err .eq. ' ' ) err = ' Setup Plot '
	call text_window(menu,list,nmenu,ix,iy, err )

	i = 1
	iStart = int4( check_limits(list,1.,float(n_events),i
     &	,err))
	if( err .ne. ' ' ) goto 50
	i = i + 1
	iEnd = int4(check_limits(list,float(iStart),float(n_events),
     &	i,err))
	if( err .ne. ' ' ) goto 50
	i = i + 1
	nAvg = int4( check_limits(list,1.,float(n_events),i,err))
	if( err .ne. ' ' ) goto 50

	iy = iy + 6

	key = 'S'
	nAvgd = 0
	Time = 0.
	Avg = 0.
	np = 0
	iEvent = iStart
	do while( key .ne. '$' )

	    read( unit=iEvent_file, rec=iEvent ) event

	    if( (event.level .eq. ilevel) .or.
     &		(ilevel .eq. iall ) ) then
		Avg = Avg + event.dwell_time
		Time = Time + float(event.start)
		nAvgd = nAvgd + 1
	    end if

	    if( nAvgd .eq. nAvg ) then
		np = np + 1
		xy(2*np-1) = (Time * dt * 0.001)/ float( nAvgd )
		xy(2*np)   = Avg / float( nAvgd )
		Time = 0.
		Avg = 0.
		nAvgd = 0
	    end if

	    call display_progress(ix,iy,
     &	    'Events Done (ESC to Abort)        ',iEvent,iEnd,key)

	    iEvent = iEvent + 1
	    if( iEvent .gt. iEnd .or. np .eq. max_np ) key = '$'

	end do

	xlabel = 's'
	ylabel = 'ms'
	call state_name( ilevel, sname )
	title = ' '//sname//' state time vs time '

	return
	end

	subroutine average_amplitude_vs_time(xy,np,max_np,
     &	iStart,iEnd,xlabel,ylabel,title)
$INCLUDE: 'PATCOM.FOR'
c
c	Calculate average dwell time in selected state over
c	a series of events and plot vs time
c
	real*4 xy(1)			! (Out) dwell time vs time X-Y plot
	integer*2 np			! (Out) No. of points in xy
	integer*2 max_np		! (In) Max. no. of points allowed
	integer*4 iStart,iEnd		! Entered = first..last records
	character*(*) xlabel		! (Out) x axis label
	character*(*) ylabel		! (Out) y axis label
	character*(*) title		! (Out) Histogram title

	parameter(nmenu=3)
	character*40 menu(nmenu) /
     &	' Start at event (1-       )',
     &	' End at event ',
     &	' No. of events to average ' /

	character*10  list(nmenu)
	character*32 err
	character key
	integer*4 iEvent
	character*6 sname

	record /event_record/ event
	integer*4 nAvg /100/
	integer*4 nAvgd
c
c	code
c

	call find_cursor(ix,iy)

	call select_state( ix,iy, ilevel, 4 )

	i = 1
	write(menu(i),'('' Start at event (1-'',i7,'')'')') n_events
	write(list(i),'(I7)') max(min(iStart,n_events),1)
	i = i + 1
	if( iEnd .eq. 0 ) iEnd = n_events
	write(list(i),'(I7)') iEnd
	i = i + 1
	write(list(i),'(I7)') navg

	iy = iy + 4
	err = ' '
50	if( err .eq. ' ' ) err = ' Setup Plot '
	call text_window(menu,list,nmenu,ix,iy, err )

	i = 1
	iStart = int4( check_limits(list,1.,float(n_events),i
     &	,err))
	if( err .ne. ' ' ) goto 50
	i = i + 1
	iEnd = int4(check_limits(list,float(iStart),float(n_events),
     &	i,err))
	if( err .ne. ' ' ) goto 50
	i = i + 1
	nAvg = int4( check_limits(list,1.,float(n_events),i,err))
	if( err .ne. ' ' ) goto 50

	iy = iy + 6

	key = 'S'
	nAvgd = 0
	Time = 0.
	Avg = 0.
	np = 0
	iEvent = iStart
	do while( key .ne. '$' )

	    read( unit=iEvent_file, rec=iEvent ) event

	    if( ((event.level .eq. ilevel) .or.
     &		(ilevel .eq. iall )) .and.
     &		(event.variance .ge. 0.) ) then
		Avg = Avg + event.average_current
		Time = Time + float(event.start)
		nAvgd = nAvgd + 1
	    end if

	    if( nAvgd .eq. nAvg ) then
		np = np + 1
		xy(2*np-1) = (Time * dt * 0.001)/ float( nAvgd )
		xy(2*np)   = Avg / float( nAvgd )
		Time = 0.
		Avg = 0.
		nAvgd = 0
	    end if

	    call display_progress(ix,iy,
     &	    'Events Done (ESC to Abort) ',iEvent,iEnd,key)

	    iEvent = iEvent + 1
	    if( iEvent .gt. iEnd .or. np .eq. max_np ) key = '$'

	end do

	xlabel = 's'
	ylabel = 'pA'
	call state_name( ilevel, sname )
	title = ' '//sname//' state amplitude vs time '

	return
	end

	subroutine mean_current_vs_time(xy,np,max_np,
     &	iStart,iEnd,xlabel,ylabel,title)
$INCLUDE: 'PATCOM.FOR'
c
c	Calculate mean channel current vs time
c
	real*4 xy(1)			! (Out) dwell time vs time X-Y plot
	integer*2 np			! (Out) No. of points in xy
	integer*2 max_np		! (In) Max. no. of points allowed
	integer*4 iStart,iEnd		! Entered = first..last records
	character*(*) xlabel		! (Out) x axis label
	character*(*) ylabel		! (Out) y axis label
	character*(*) title		! (Out) Histogram title


	parameter(nmenu=3)
	character*30 menu(nmenu) /
     &	' Start at record (1-       )',
     &	' End at record ',
     &	' No. of points to be averaged' /
	character*10 list(nmenu)
	character*32 err
	character key
	integer*4 nAvg /0/
	integer*4 irecord,nAvgd,iSample,iSample0
c
c	code
c
	call open_data_file

	call find_cursor(ix,iy)


	i = 1
	write(menu(i),'('' Start at record (1-'',i7,'')'')')
     &	n_records
	write(list(i),'(I7)') max(min(iStart,n_records),1)
	i = i + 1
	if( iEnd .eq. 0 ) iEnd = n_records
	write(list(i),'(I7)') iEnd
	i = i + 1
	if( nAvg .eq. 0 ) nAvg = (n_records*np_record)/10
	write(list(i),'(I8)') nAvg

	err = ' '
50	if( err .eq. ' ' ) err = ' Setup plot '
	call text_window(menu,list,nmenu,ix,iy, err )

	i = 1
	iStart = int4(check_limits(list,1.,float(n_records),i,err))
	if( err .ne. ' ' ) goto 50
	i = i + 1
	iEnd   = int4(check_limits(list,float(iStart),float(n_records),
     &	i,err))
	if( err .ne. ' ' ) goto 50
	i = i + 1
	nAvg = int4( check_limits(list,1.,
     &	float(np_record)*float(n_records),i,err))
	if( err .ne. ' ' ) goto 50

	iy = iy + 6

	iSample = 0
	iSample0 = 1
	Avg = 0.
	nAvgd = 0
	np = 0
	key = 'S'
	irecord = iStart
	do while( key .ne. '$' )

	    read(unit=1,rec=irecord+idata_offset)
     &	    (iBuf(i),i=1,np_record)

	    do i = 1,np_record

		iSample = iSample + 1
		Avg = Avg + float( iBuf(i) )
		nAvgd = nAvgd + 1
		if( nAvgd .eq. nAvg ) then
		    np = np + 1
		    xy(np*2-1) = float(iSample + iSample0)*dt*0.0005
		    xy(np*2) = (Avg/float(nAvgd) - float(ibase))*
     &			       ScaleIm
		    Avg = 0.
		    iSample0 = iSample
		    nAvgd = 0
		end if

	    end do

	    call display_progress(ix,iy,
     &	    'Records Done (ESC to Abort)    ',irecord,iEnd,key)
	    irecord = irecord + 1
	    if( irecord .gt. iEnd .or. np .eq. max_np ) key = '$'

	end do

	close(unit=idata_file)

	xlabel = 's'
	ylabel = 'pA'
	title = ' Mean channel current vs time '

	return
	end
