	subroutine setup
$INCLUDE: 'patcom.for'

	PARAMETER(IMENU_LEFT=63,IMENU_TOP=1,NROW=9 ,NCOL=1)
	CHARACTER*32 MENU(NROW) /
     &	' Input voltage range         F1',
     &	' Digital sampling interval   F2',
     &	' Channel name                F3',
     &	' Channel units               F4',
     &	' Channel scale factor        F5',
     &	' Test pulse parameters       F6',
     &	' Printer typeface             F',
     &	' Printer line width           W',
     &	' Exit                       ESC' /

	logical quit,new_menu
	character key
c
c	code
c
	call open_data_file

	quit = .false.
	do while( .not. quit )
C
C	    Erase and re-display screen
C
	    call erase_box(2,2,56,23)
C
C	    Wait for user to select an option from the menu
C
	    new_menu = .true.
	    iop = iwait_menu_vertical1(menu,'123456FW$',nrow,
     &	    2,2,new_menu,iop,' Setup ',key)

	    select case( iop )
	    case( 1 )
		call set_adc_range( 5,4, adc_range )
	    case( 2 )
		call set_sampling_interval( 5,5 )
	    case( 3 )
		call set_channel_name( 5,6 )
	    case( 4 )
		call set_channel_units( 5,7 )
	    case( 5 )
		call set_scale_factors( 5,8  )
	    case( 6 )
		call set_test_pulse( 5,9 )
	    case( 7  )
		call select_font( 5,10 , ifont, ipoint_size )
	    case( 8  )
		call set_line_thickness( 5, 11 )
	    case( 9  )
		quit = .true.
	    end select
	end do
c
c	Save new parameters to data file header block
c
	call save_header
	close(unit=1)

	return
	end

	subroutine set_adc_range( ix, iy, ad_range )
$INCLUDE: 'patcom.for'
c
c	Select analogue input voltage range (unit = Volts )

	character*22 menu(10)
	real*4 adc(10)

	logical new_menu
	character key


	call get_adc_ranges( interface_card, adc, nmenu )

	do i = 1,nmenu
	    write( menu(i), '('' +/-'',f8.2,''V'')') adc(i)
	end do

	iop = 1
	do while( (adc(iop) .gt. ad_range) .and. iop.lt.nmenu )
	    iop = iop + 1
	end do

	new_menu = .true.
	iop = Iwait_MENU_vERTICAL1(menu,'123456789'
     &	,nmenu,ix,iy,new_menu,iop,' Input voltage range ',key)

	ad_range = adc(max(iop,1))
	return
	end

	SUBROUTINE set_sampling_interval( ix, iy )
$INCLUDE: 'patcom.for'
C
C	Set digital sampling interval
C
	PARAMETER(NROWS=1)
	character*30 menu(nrows)
	CHARACTER*12 LIST(NROWS)
	character*38 title
C
C	CODE
C	----

c
c	Get allowed interval limits for the interface unit
c
	CALL LAB_LIMITS(INTERFACE_CARD,DT_MIN,DT_MAX,AD_MIN,AD_MAX,DAC)

	write( menu(1),
     &	'(''('',1pg10.2,''-'',1pg10.0,'') ms'')') dt_min,dt_max
	write(list(1),'(f9.3)') dt
	title = ' '
100	if( title .eq. ' ' ) title = ' Set sampling interval '
C
	CALL TEXT_WINDOW(MENU,LIST,NROWS,ix,iy,title)
C
	i = 1
	dt = check_limits(list,dt_min,dt_max,i,title)
	if( title .ne. ' ' ) goto 100

	return
	end

	SUBROUTINE set_channel_name( ix, iy )
$INCLUDE: 'patcom.for'
C
C	Set or change a/d input channels
C
	PARAMETER(NROWS=max_channels)
	character*36 menu(nrows)
	CHARACTER*2 LIST(NROWS)
	character*36 title
C
C	CODE
C	----

	do i = 1,n_channels
	    write( menu(i), '('' Ch.'',i1,'' Name '')') i-1
	    list(i) = y_name(i)
	end do

	title = ' '
100	if( title .eq. ' ' ) title = ' Set channel names '
C
	CALL TEXT_WINDOW(MENU,LIST,n_channels,ix,iy,title)
C
	do i = 1,n_channels
	    call extract_string( list(i), y_name(i) )
	end do
	return
	end

	SUBROUTINE set_channel_units( ix, iy )
$INCLUDE: 'patcom.for'
C
C	Set channel units
C
	PARAMETER(NROWS=max_channels)
	character*30 menu(nrows)
	CHARACTER*2 LIST(NROWS)
	character*36 title
C
C	CODE
C	----

	do i = 1,n_channels
	    write( menu(i), '('' Ch.'',i1,'' Units '')') i-1
	    list(i) = y_units(i)
	end do

	title = ' '
100	if( title .eq. ' ' ) title = ' Set channel units '
C
	CALL TEXT_WINDOW(MENU,LIST,n_channels,ix,iy,title)
C
	do i = 1,n_channels
	    call extract_string( list(i), y_units(i) )
	end do
	return
	end

	SUBROUTINE set_scale_factors( ix, iy )
$INCLUDE: 'patcom.for'
C
C	Set channel units
C
	PARAMETER(NROWS=2)
	character*30 menu(nrows) /
     &	' Vm Membrane Potential ',
     &	' Im Current (mV/pA) '/
	CHARACTER*12 LIST(NROWS)
	character*36 title
C
C	CODE
C	----

	i = 1
	write(list(i),'(f10.3)') GainVm
	i = i + 1
	write(list(i),'(f10.3)') GainIm

	title = ' Set scale factor '
	do while( title .ne. ' ' )
	    CALL TEXT_WINDOW(MENU,LIST,nrows,ix,iy,title)
	    i = 1
	    GainVm = check_limits(list,0.,1E30,i,title)
	    if( title .ne. ' ' ) cycle
	    i = 1 + i
	    GainIm = check_limits(list,0.,1E30,i,title)
	    if( title .ne. ' ' ) cycle
	end do

	ScaleIm = convert_gain( GainIm )
	ScaleVm = convert_gain( GainVm )

	return
	end

	subroutine set_line_thickness( ix, iy )
$INCLUDE: 'patcom.for'

	call display_message(ix,iy,40,' Line Thickness (1-6) ',1)
	r = float( iline_thickness )
	call get_number(r,1.,10.,r)
	iline_thickness = int(r)
	return
	end

	subroutine extract_string( list, string )
	character*(*) list, string

	ix = ileading_space( list )
	ns = len( string )
	nl = len( list )
	string = list(ix:min(ix+ns-1,nl))
	return
	end

	subroutine set_test_pulse( ix, iy )
$include:'patcom.for'
c
c	Set Giga-seal formation test pulse height & width
c	Enter with: np = No. points in A/D sweep
c	dt = A/D sampling / D/A output interval (ms)
c	Returns:
c
        parameter(nmenu=2)
        character*36 menu(nmenu) /
     &  ' Pulse height (mV) ',
     &  ' Command voltage divide factor ' /
	character*8 list(nmenu)
	character*32 title
c
c	code
c
        i = 1
        write(list(i),'(f7.0)') PulseHeight
        i = i + 1
        write(list(i),'(f7.0)') VDivide

	title = ' Set test pulse '
	do while( title .ne. ' ' )
	    call text_window(menu,list,nmenu,ix,iy,title)
            i = 1
            PulseHeight = check_limits(list,-5000.,5000.,i,title)
	    if( title .ne. ' ' ) cycle
            i = i + 1
            VDivide = check_limits(list,1.,1000.,i,title)
	    if( title .ne. ' ' ) cycle

	end do

	return
	end
