	SUBROUTINE PATSAV
C
C	Copy files PATCH.1, PATCH.2 to storage files
C
$INCLUDE: 'PATCOM.FOR'

	CHARACTER*16 NAMPAT /' '/
	PARAMETER (N_EVENTS_PER_BLOCK = 32)
	CHARACTER KEY
	CHARACTER*40 TEXT
	LOGICAL ABORT,new_menu

	PARAMETER(Nmenu=6,istatus_left=59)
	CHARACTER*20 MENU(nmenu) /
     &	'SAVE TO   FILE    F1',
     &	'LOAD FROM FILE    F2',
     &	'SIMULATION        F3',
     &	'IMPORT FROM VCAN  F4',
     &	'IMPORT FROM SCAN  F5',
     &	'CANCEL           ESC' /
C
C	CODE
C	----
C
	call erase_all
	call display_box(1,1,istatus_left-2,25)
	new_menu = .true.
	iop = Iwait_MENU_VERTICAL1(menu,'12345$'
     &	,nmenu,istatus_left-1,1,new_menu,iop,' File Options ',key)


	GOTO(1,2,3,4,5,6) iop
C
C	Save files
C	----------
C
1	CONTINUE
C
	call file_box(3,5,nampat,'.PAT','NEW'
     &	,' Save data to .PAT storage file ',abort)
	IF( ABORT ) RETURN
C
C	SAVE PATCH.1
C
C	Copy file PATCH.1 to storage file (ifile_4)
C
	CALL CREATE_FILE(IFILE_4,IERR,NAMPAT)
C
	CALL FIND_CURSOR(IX,IY)
	IBLOCK_S = 1
	IBLOCK_E = N_RECORDS*NB_DATA + 1
	IBLOCK_OUT = 1
	DO 110 IBLOCK = IBLOCK_S,IBLOCK_E
		IBLOCK_IN = IBLOCK
		CALL READ_FILE(IFILE_1,IERR,IBUFFER,IBLOCK_IN,1)
		CALL WRITE_FILE(IFILE_4,IERR,IBUFFER,IBLOCK_OUT,1)
		CALL MOVE_CURSOR(IX,IY)
		WRITE(TEXT,9110) IBLOCK,IBLOCK_E
9110		FORMAT(' Block done ',I5,'/',I5)
		CALL DISPLAY_STRING(TEXT)
		IBLOCK_OUT = IBLOCK_OUT + 1
110	CONTINUE
C
C	Copy PATCH.2
C
	IBLOCK_S = 1
	IBLOCK_E = (NSTATE/N_EVENTS_PER_BLOCK) + 1
C
	DO 120 IBLOCK = IBLOCK_S,IBLOCK_E
		IBLOCK_IN = IBLOCK
		CALL READ_FILE(IFILE_2,IERR,IBUFFER,IBLOCK_IN,1)		
		CALL WRITE_FILE(IFILE_4,IERR,IBUFFER,IBLOCK_OUT,1)
		CALL MOVE_CURSOR(IX,IY)
		WRITE(TEXT,9110) IBLOCK,IBLOCK_E
		CALL DISPLAY_STRING(TEXT)
		IBLOCK_OUT = IBLOCK_OUT + 1
120	CONTINUE
C
	CALL CLOSE_FILE(IFILE_4,IERR)
	ERROR = ' '
	RETURN
C
C	LOAD FILES
C	----------
C
2	CONTINUE
C
	call file_box(3,5,nampat,'.PAT','OLD'
     &	,' Load data from .PAT storage file ',abort)
	IF( ABORT ) RETURN


C
C	Load PATCH.1
C
C	Copy data from storage file to PATCH.1
C
	CALL OPEN_FILE(IFILE_4,IERR,NAMPAT)
C
C	Get header data from storage file
C
	IHOLD = INTERFACE_CARD
	CALL READ_FILE(IFILE_4,IERR,IHEAD,1,1)
	INTERFACE_CARD = IHOLD
C
	CALL FIND_CURSOR(IX,IY)
	IBLOCK_S = 1
	IBLOCK_E = N_RECORDS*NB_DATA + 1
	IBLOCK_IN = 1
	DO 210 IBLOCK = IBLOCK_S,IBLOCK_E
		IBLOCK_OUT = IBLOCK
		CALL READ_FILE(IFILE_4,IERR,IBUFFER,IBLOCK_IN,1)
		CALL WRITE_FILE(IFILE_1,IERR,IBUFFER,IBLOCK_OUT,1)
		CALL MOVE_CURSOR(IX,IY)
		WRITE(TEXT,9110) IBLOCK,IBLOCK_E
		CALL DISPLAY_STRING(TEXT)
		IBLOCK_IN = IBLOCK_IN + 1
210	CONTINUE
C
C	COPY PATCH.2
C
	IBLOCK_S = 1
	IBLOCK_E = NSTATE/N_EVENTS_PER_BLOCK + 1
	DO 220 IBLOCK = IBLOCK_S,IBLOCK_E
		IBLOCK_OUT = IBLOCK
		CALL READ_FILE(IFILE_4,IERR,IBUFFER,IBLOCK_IN,1)
		CALL WRITE_FILE(IFILE_2,IERR,IBUFFER,IBLOCK_OUT,1)
		CALL MOVE_CURSOR(IX,IY)
		WRITE(TEXT,9110) IBLOCK,IBLOCK_E
		CALL DISPLAY_STRING(TEXT)
		IBLOCK_IN = IBLOCK_IN + 1
220	CONTINUE
C
	CALL CLOSE_FILE(IFILE_4,IERR)
	ERROR = ' '
	RETURN
C
C	Generate test signal
C
3	CALL simulated_current
	RETURN
c
c	Import data from leak-subtracted VCAN averages file VCAN.AVG
C
4	call import_from_vcan
	return

c
c	Import data from SCAN data file
C
5	call import_from_scan
	return

6	RETURN
	END

	SUBROUTINE PATINI
C
C	Initialisation
C
$INCLUDE: 'PATCOM.FOR'
	CHARACTER KEY
C
C	CODE
C	----
C
	NBREQD = IFIX(TIMREQ/(256.*1E-3*DT))
	BIT_CURRENT = CONVERT_GAIN(GAIN)
C
	IERR = 0
	CALL OPEN_FILE(IFILE_1,IERR,'PATCH.1')
	IF(IERR.NE.0) THEN
		call erase_box(3,5,60,8)
		call display_box(3,5,60,8)
		call move_cursor(4,6)
		CALL ASK_USER(
     &'File ... PATCH.1 not found on disc, Create new file (Y/N) ? '
     &,KEY)
		IF(KEY.EQ.'N') STOP
C
C		Create new file
C
		call move_cursor(4,7)
		CALL DISPLAY_STRING(
     &'Size of file to be create (Mbyte) ? ')
		CALL GET_NUMBER(SIZE_MBYTE,.1,1000.,2.)
		NBLOCK = 2*IFIX(SIZE_MBYTE*1024.) + 1
		CALL CREATE_FILE(IFILE_1,IERR,'PATCH.1')
		CALL WRITE_FILE(IFILE_1,IERR,IHEAD,1,1)
		CALL WRITE_FILE(IFILE_1,IERR,IHEAD,NBLOCK,1)
		IF(IERR.NE.0) THEN
			CALL DISPLAY_STRING(
     &'ERROR ... Can''t create work file ... PATCH.1')
			STOP
		ENDIF
C
C		Close and re-open to make permanent in case of a crash
C
		CALL CLOSE_FILE(IFILE_1,IERR)
		CALL OPEN_FILE(IFILE_1,IERR,'PATCH.1')
C
	ELSE
		CALL READ_FILE(IFILE_1,IERR,IHEAD,1,1)
	ENDIF
C
C	Open open/close state list file
C
	CALL OPEN_FILE(IFILE_2,IERR,'PATCH.2')
	IF(IERR.NE.0) CALL CREATE_FILE(IFILE_2,IERR,'PATCH.2')
	IF(IERR .NE. 0) THEN
		CALL DISPLAY_STRING(
     &'ERROR ... Can''t create event list file ... PATCH.2')
		STOP
	ENDIF
	RETURN
	END

	REAL FUNCTION CONVERT_GAIN(GAIN_IN)
$INCLUDE: 'PATCOM.FOR'
C
C	Derive "bit_value" from "gain" and vice_versa
C
	PARAMETER( ADC_MAX = 2048.)
	CONVERT_GAIN = 1000.*RANGE_VOLTS/(ADC_MAX*GAIN_IN)
	RETURN
	END
	SUBROUTINE PUT_RECORD(IRECORD_IN,IFILE_NO)
C
C	Write a record to the file currently connected
C	to file handle No. "ifile_no"
C
C	Records are stored as collections of records, each record
C	consisting of 'nb_analysis' blocks and 'nb_data' data blocks.
C	A block contains 256 words. The first block on the file
C	contains the file HEADER data, and the records follow thereafter.
C
$INCLUDE: 'PATCOM.FOR'
C
	IRECORD = IRECORD_IN
	NB_RECORD = NB_ANALYSIS + NB_DATA
	IBLOCK = (IRECORD - 1)*NB_RECORD + 2
C
C	Save data blocks
C
	IBLOCK = IBLOCK + NB_ANALYSIS
	CALL WRITE_FILE(IFILE_NO,IERROR,IBUFFER,IBLOCK,NB_DATA)
	RETURN
	END
	SUBROUTINE GET_RECORD(IRECORD_IN,IFILE_NO)
C
C	Read a record from the file currently connected
C	to file handle No. "ifile_no"
C
C	Records are stored as collections of records, each record
C	consisting of 'nb_analysis' blocks and 'nb_data' data blocks.
C	A block contains 256 words. The first block on the file
C	contains the file HEADER data, and the records follow thereafter.
C
$INCLUDE: 'PATCOM.FOR'
C
C	Ensure that record # remains within legal limits for file
C
	IRECORD = IRECORD_IN
	IF(IRECORD .GT. N_RECORDS) IRECORD = N_RECORDS
	IF(IRECORD .LT. 1) IRECORD = 1
C
	NB_RECORD = NB_ANALYSIS + NB_DATA
	IBLOCK =  (IRECORD - 1)*NB_RECORD + 2
C
C	Read data blocks
C
	IBLOCK = IBLOCK + NB_ANALYSIS
	CALL READ_FILE(IFILE_NO,IERROR,IBUFFER,IBLOCK,NB_DATA)
C
	RETURN
	END
	SUBROUTINE CHANGE_RECORD(IRECORD,ISTEP,IFILE_NO)
C
C	Save current record and read next record
C
$INCLUDE: 'PATCOM.FOR'
C
C -----
C
C	Save current record
C
	CALL PUT_RECORD(IRECORD,IFILE_NO)
C
C	Read next record
C
	IRECORD = IRECORD + ISTEP
	IF(IRECORD.GT.N_RECORDS) IRECORD = N_RECORDS
	IF(IRECORD.LT.1) IRECORD = 1
	CALL GET_RECORD(IRECORD,IFILE_NO)
C
	RETURN
	END

	SUBROUTINE import_from_vcan
$INCLUDE: 'PATCOM.FOR'
C
c	Import leak-subtracted records from VCAN's averages file VCAN.AVG
C	-----------------------------------------------------------------

C
C --	VCAN data record analysis block ----------------------------------
C
	CHARACTER*8 FRAME_STATUS
	CHARACTER*4 FRAME_TYPE
	INTEGER*2 IANALYSIS(256)
	COMMON /ANALYSIS_BLOCK/ IANALYSIS
	EQUIVALENCE (FRAME_STATUS,IANALYSIS(1))
     &	,(FRAME_TYPE,IANALYSIS(5))
     &	,(ANALYSIS,IANALYSIS(8))
     &	,(RECORD_NO,IANALYSIS(8))
     &	,(FRAME_TIME,IANALYSIS(10))
C

	CHARACTER*(512) HEADER
	EQUIVALENCE (IBUFFER,HEADER)

	CHARACTER KEY
	LOGICAL SPECIAL,found

	character*40 msg(2)

C
C	CODE
C
	CALL open_FILE( in_file, IERR, 'VCAN.AVG' )
	IF( IERR .NE. 0 ) THEN
	  ERROR = 'Can''t open file VCAN.AVG'
	  RETURN
	ENDIF

C
C	Read header block of .VCA file
C
	CALL READ_FILE(in_file,IERROR,IBUFFER,1,1)
C
	CALL FIND_ENTRY('DT=',ISTART,IEND,HEADER,FOUND)
	IF( FOUND  ) DT = GET_ENTRY(HEADER(ISTART:IEND))
C
	CALL FIND_ENTRY('GC=',ISTART,IEND,HEADER,FOUND)
	IF( FOUND  ) GAIN = GET_ENTRY(HEADER(ISTART:IEND))
C
	CALL FIND_ENTRY('AD=',ISTART,IEND,HEADER,FOUND)
	IF( FOUND) range_volts = GET_ENTRY(HEADER(ISTART:IEND))
C
	CALL FIND_ENTRY('BC=',ISTART,IEND,HEADER,FOUND)
	IF( FOUND) BIT_CURRENT = GET_ENTRY(HEADER(ISTART:IEND))
C
c	No. of analogue channels in record
c
	CALL FIND_ENTRY('NC=',ISTART,IEND,HEADER,FOUND)
	IF( FOUND) n_channels = int( GET_ENTRY(HEADER(ISTART:IEND)) )
C
c	No. of sectors in analysis area of VCAN record
c
	CALL FIND_ENTRY('NBA=',ISTART,IEND,HEADER,FOUND)
	IF( FOUND) nba = int( GET_ENTRY(HEADER(ISTART:IEND)) )
C
c	No. of sectors in data area of VCAN record
c
	CALL FIND_ENTRY('NBD=',ISTART,IEND,HEADER,FOUND)
	IF( FOUND) nbd = int( GET_ENTRY(HEADER(ISTART:IEND)) )
	nb_out = nbd/n_channels
C
c	No. of VCAN records in file
c
	CALL FIND_ENTRY('NF=',ISTART,IEND,HEADER,FOUND)
	IF( FOUND) N_FRAMES = int( GET_ENTRY(HEADER(ISTART:IEND)) )

	np_sector = 256
	n_points = (nbd*np_sector)/n_channels

	CALL FIND_ENTRY('ID=',ISTART,IEND,HEADER,FOUND)
	IF( FOUND) cell = HEADER(ISTART:IEND)

	msg(1) = 'WAIT ... Reading records '
	msg(2) = ' '
	call display_message(4,7,30,msg,2)
	ixc = 5
	iyc = 9
	n_records = 0
c
c	Set file pointer to start of data area in PATCH.1
c
	iout_sector = 2

	do 10 iframe = 1,n_frames

	    call get_key( key, special )
	    if( key .eq. '$' ) goto 20
c
c	    Read record from VCAN.AVG file
c
	    in_sector = (iframe-1)*(nba+nbd) + 2
	    call read_file(in_file,ierr,ianalysis,in_sector,nba)
	    call read_file(in_file,ierr,iwork,in_sector+nba,nbd)

	    if( frame_status .eq. 'ACCEPTED' ) then
c
c		If this record is marked ACCEPTED write its
c		current channel into PATCH.1
c
		CALL MOVE_CURSOR(ixc,iyc)
		WRITE(msg(2),'(''Records '',i5,''/'',i5)') iframe,
     &		n_frames
		CALL DISPLAY_STRING(msg(2)(1:22))
c
c		VCAN record consists of <n_points> pairs of
c		current,voltage samples. Move all current samples
c		to beginning of <iwork> array
c
		j = 1
		do 15 k = 1,n_points
		    iwork(k) = iwork(j)
		    j = j + 2
15		continue

		call write_file(ifile_1,ierr,iwork,iout_sector,nb_out)
		iout_sector = iout_sector + nb_out
		n_records = n_records + (nb_out/nb_data)
	    endif
10	continue
20	continue

	recording_time = float(n_records)*dt / 1000.

	call close_file( in_file, ierr )
	return
	end

	SUBROUTINE import_from_scan
$INCLUDE: 'PATCOM.FOR'
C
c	Import records from SCAN's data file .SCA
C	-----------------------------------------

C
C --	SCAN data record analysis block ----------------------------------
C
	CHARACTER*8 FRAME_STATUS
	CHARACTER*4 FRAME_TYPE
	INTEGER*2 IANALYSIS(256)
	COMMON /ANALYSIS_BLOCK/ IANALYSIS
	EQUIVALENCE (FRAME_STATUS,IANALYSIS(1))
     &	,(FRAME_TYPE,IANALYSIS(5))
     &	,(ANALYSIS,IANALYSIS(8))
     &	,(RECORD_NO,IANALYSIS(8))
     &	,(FRAME_TIME,IANALYSIS(10))
C

	CHARACTER*(512) HEADER
	EQUIVALENCE (IBUFFER,HEADER)

	CHARACTER KEY
	LOGICAL ABORT,SPECIAL,found

	character*40 msg(2)
	character*20 file_name / ' ' /

C
C	CODE
C
	call file_box(3,5,file_name,'.SCA','OLD'
     &	,' Import records from .SCA file ',abort)
	IF( ABORT ) RETURN

	CALL open_FILE( in_file, IERR, file_name )
	IF( IERR .NE. 0 ) THEN
	  ERROR = 'Can''t open file '//file_name
	  RETURN
	ENDIF

C
C	Read header block of .VCA file
C
	CALL READ_FILE(in_file,IERROR,IBUFFER,1,1)
C
	CALL FIND_ENTRY('DT=',ISTART,IEND,HEADER,FOUND)
	IF( FOUND  ) DT = GET_ENTRY(HEADER(ISTART:IEND))
C
	CALL FIND_ENTRY('GC=',ISTART,IEND,HEADER,FOUND)
	IF( FOUND  ) GAIN = GET_ENTRY(HEADER(ISTART:IEND))
C
	CALL FIND_ENTRY('AD=',ISTART,IEND,HEADER,FOUND)
	IF( FOUND) range_volts = GET_ENTRY(HEADER(ISTART:IEND))
C
	CALL FIND_ENTRY('BC=',ISTART,IEND,HEADER,FOUND)
	IF( FOUND) BIT_CURRENT = GET_ENTRY(HEADER(ISTART:IEND))
C
c	No. of sectors in analysis area of SCAN record
c
	CALL FIND_ENTRY('NBA=',ISTART,IEND,HEADER,FOUND)
	IF( FOUND) nba = int( GET_ENTRY(HEADER(ISTART:IEND)) )
C
c	No. of sectors in data area of SCAN record
c
	CALL FIND_ENTRY('NBD=',ISTART,IEND,HEADER,FOUND)
	IF( FOUND) nbd = int( GET_ENTRY(HEADER(ISTART:IEND)) )
C
c	No. of SCAN records in file
c
	CALL FIND_ENTRY('NF=',ISTART,IEND,HEADER,FOUND)
	IF( FOUND) N_FRAMES = int( GET_ENTRY(HEADER(ISTART:IEND)) )

	np_sector = 256
	n_points = nbd*np_sector

	CALL FIND_ENTRY('ID=',ISTART,IEND,HEADER,FOUND)
	IF( FOUND) cell = HEADER(ISTART:IEND)

	msg(1) = 'WAIT ... Reading records '
	msg(2) = ' '
	call display_message(4,7,30,msg,2)
	ixc = 5
	iyc = 9
	n_records = 0
c
c	Set file pointer to start of data area in PATCH.1
c
	iout_sector = 2

	do 10 iframe = 1,n_frames

	    call get_key( key, special )
	    if( key .eq. '$' ) goto 20
c
c	    Read record from .SCA file
c
	    in_sector = (iframe-1)*(nba+nbd) + 2
	    call read_file(in_file,ierr,ianalysis,in_sector,nba)
	    call read_file(in_file,ierr,iwork,in_sector+nba,nbd)

	    if( frame_status .eq. 'ACCEPTED' ) then
c
c		If this record is marked ACCEPTED write its
c		current channel into PATCH.1
c
		CALL MOVE_CURSOR(ixc,iyc)
		WRITE(msg(2),'(''Records '',i5,''/'',i5)') iframe,
     &		n_frames
		CALL DISPLAY_STRING(msg(2)(1:22))
c
		call write_file(ifile_1,ierr,iwork,iout_sector,nbd)
		iout_sector = iout_sector + nbd
		n_records = n_records + (nbd/nb_data)
	    endif
10	continue
20	continue

	recording_time = float(n_records)*dt / 1000.

	call close_file( in_file, ierr )
	return
	end

	SUBROUTINE FIND_ENTRY(MASK,ISTART,IEND,HEADER,FOUND)
C
C	Find the location of the string mask in the
C	header string and return the istart and iend indexes
C	found is set to .false. if mask is not found
C
	CHARACTER*(*) MASK
	CHARACTER*(*) HEADER
	LOGICAL FOUND
C
C	Search HEADER for MASK
C
	FOUND = .FALSE.
	NCH = LEN(HEADER)
	NCM = LEN(MASK)
	ICH = 0
	ICM = 0
10	CONTINUE
		IF(ICM .GE. NCM) THEN
			FOUND = .TRUE.
			ISTART = ICH + 1
		ENDIF
		ICH = ICH + 1
		ICM = ICM + 1
		IF(MASK(ICM:ICM) .NE. HEADER(ICH:ICH) ) THEN
			ICH = ICH - ICM + 1
			ICM = 0
		ENDIF
	IF(( .not. FOUND ) .AND. (ICH.LE.NCH)) GOTO 10
C
C	IF( .not. FOUND ) THEN
C		CALL MOVE_CURSOR(2,23)
C		CALL DISPLAY_STRING(MASK//' not found in header')
C	ENDIF

	IF( FOUND .EQV. .FALSE.) RETURN
C
C	FIND END OF ENTRY (TERMINATED BY A \)
C
	I = ISTART
	FOUND = .FALSE.
20	CONTINUE
	    IF((HEADER(I:I).EQ.'\').OR.(HEADER(I:I).EQ.CHAR(13))) THEN
		IEND = I - 1
		I = NCH
		FOUND = .TRUE.
	    ENDIF
	    I = I + 1
	IF(I.LE.NCH) GOTO 20
	RETURN
	END


	REAL FUNCTION GET_ENTRY(HEADER)
	REAL RN
C
C	CONVERT STRING IN HEADER
C	TO A REAL NUMBER
C
	CHARACTER*(*) HEADER
C
	READ(HEADER,900) RN
900	FORMAT(F13.0)
C
	GET_ENTRY = RN
	RETURN
	END


