	subroutine files_options
$INCLUDE:'patcom.for'
c
c	Data file handling module including import/export to other formats
c	------------------------------------------------------------------
C	17/4/96 ... Voltage stepping parameters added to ini file

	CHARACTER KEY
	logical new_menu,quit

	PARAMETER(Nmenu=7,istatus_left=59)
	CHARACTER*20 MENU(nmenu) /
     &	'Load   data file  F1',
     &	'Merge  data file  F2',
     &	'Delete data file  F3',
     &	'Change directory  F4',
     &	'Simulation        F5',
     &	'File conversion   F6',
     &	'Exit             ESC' /

C
C -- CODE ------------------------------------------------------
C
C
C	Display program status box
C
	new_menu = .true.
	key = ' '
	quit = .false.
	do while( .not. quit )

	    call erase_box(1,1,istatus_left-2,25)
	    call title_box

	    iop = Iwait_MENU_VERTICAL1(menu,'123456$',nmenu
     &	    ,2,2,new_menu,iop,' Files Options ',key)

	    select case (iop)

	    case(1)
		 CALL LOAD_data_FILE(3,3+iop)
	    case(2)
		 call merge_data_file(3,3+iop)
	    case(3)
		CALL DELETE_data_FILE(3,3+iop)
	    case(4)
		CALL CHANGE_data_DIRECTORY(3,3+iop)
	    case(5)
		call simulations
	    case(6)
		call file_conversion
	    case(7)
		quit = .true.
	    end select
	end do
	return
	end


	SUBROUTINE LOAD_data_FILE(il,it)
C
C --	Load .scd file
C
$INCLUDE:'patcom.for'
C
	parameter(max_files=500)
	character*70 path
	CHARACTER*12 NEW_FILE_NAME / ' ' /

	character*12 files(max_files)
	equivalence( files, iwork )
C
C	CODE
C

C	Display directory of .scd files and let user choose

	call create_path( path, default_path, '*.scd', '.scd' )
	call files_menu(path,0,new_file_name,il,it,10,files,max_files)

	if( new_file_name .ne. ' ' ) then

	    call create_path(file_name,default_path,new_file_name,'.scd')
	    call open_data_file
	    call load_events(2,20)
	    close( unit=idata_file )

	    call write_to_log( 'File Loaded: '//file_name )

	end if
	return
	end

	subroutine merge_data_FILE(il,it)
C
C --	Append a .SCD file on to the end of the current file
C
$INCLUDE:'patcom.for'
C
	parameter(max_files=500)
	character*70 path /' '/
	character*70 old_file_name / ' ' /
	CHARACTER*12 NEW_FILE_NAME / ' ' /

	character*12 files(max_files)
	equivalence( files, iwork )

	integer*4 np_add,ir,n_add
C
C	CODE
C

C	Display directory of .scd files and let user choose

	call create_path( path, default_path, '*.scd', '.scd' )
	call files_menu(path,0,new_file_name,il,it,10,files,max_files)
	call create_path(path,default_path,new_file_name,'.scd')

	if( file_name .eq. path )
     &	call display_error( 2,20, ' Cannot merge file with itself ')

	if( new_file_name .ne. ' ' .and. path .ne. file_name ) then
c
c	    Load merge file to find out how big it is
c
	    old_file_name = file_name
	    file_name = path
	    call open_data_file
	    np_add = np_file
c
c	    Re-load old file
c
	    file_name = old_file_name
	    call open_data_file
c
c	    Add new file to end of old
c
	    open(unit=itemp_file,
     &	    file= path,
     &	    form='binary',
     &	    access='direct',
     &	    recl=np_record*2,
     &	    err=101)

	    n_add = np_add / np_record
	    do ir = 1,n_add
c
c		Read record from merge file
c
		read(unit=itemp_file,rec=ir+idata_offset)
     &		(iBuf(i),i=1,np_record)
c
c		Add to end of data file
c
		n_records = n_records + 1
		np_file = np_file + np_record
		write(unit=idata_file,rec=n_records+idata_offset)
     &		(iBuf(i),i=1,np_record)

		call display_progress( 2, 20,
     &		' Records added (ESC to abort) ',ir,n_add,key)
		if( key .eq. '$') goto 101

	    end do
101	    continue

	    close( unit=itemp_file )
	    nOverview = 0
	    nOverviewSlice = 0
	    call save_header
	    close( unit=idata_file )
	    call write_to_log( 'File Merged: '//path )

	end if

	return
	end



	subroutine delete_data_file(il,it)
C
C --	Delete .scd file
C
$INCLUDE:'patcom.for'
C
	CHARACTER*12 NEW_FILE_NAME/ ' ' /
	parameter(max_files=500)
	character*70 path / ' ' /
	character key
	character*12 files(max_files)
	equivalence( files, iwork )
C
C	CODE
C
	call create_path( path, default_path, '*.scd', '.scd' )
	call files_menu(path,0,new_file_name,il,it,10,files,max_files)

	if( new_file_name .ne. ' ' ) then
	    call create_path(path,default_path,new_file_name,'.scd')
	    call query_box(2,7,
     &	    ' Delete: '//path(1:60)//' (Y/N) ? ',key)
	    if( key .eq. 'Y' ) then
		call delete_file( ierr, path )
c		call write_to_log(
c    &		path(1:len_trim(path))//' deleted.' )
	    end if
	end if

	return
	end

	SUBROUTINE CHANGE_data_DIRECTORY(ileft,itop)
C
C --	Change directory
C
$INCLUDE:'patcom.for'

	parameter(max_drives=26)
	character*14 drives(max_drives)
	equivalence( drives, iwork )

	parameter(max_files=500)
	character*12 files(max_files)
	equivalence( files, iwork(26*7+1) )

	character*58 path
	character*12 directory
	character*62 search
	character key
	logical new_menu,quit

C
C	CODE
C
	call get_drives( drives, ndrives )
	do i = 1,ndrives
	    if( drives(i)(1:1) .eq. default_path(1:1) ) idrive = i
	end do
c
c	Select disc drive
c
	ncp = len(default_path)
	call erase_box( ileft, itop, ileft+ncp+2, itop+12 )
	call display_box( ileft, itop, ileft+ncp+2, itop+12 )
	call move_cursor( ileft+1, itop+1 )
	call display_string( default_path )

	idrive = Iwait_MENU_VERTICAL1(drives,'1234567890',ndrives
     &	,ileft+2,itop+2,new_menu,idrive,' Disc Drive ',key)

	nd = len_trim(drives(idrive))
	path = drives(idrive)(1:nd)//'\'
	quit = .false.
	do while( .not. quit )

	    call move_cursor( ileft+1, itop+1 )
	    call display_string( default_path )

	    np = len_trim(path)
	    search = path(1:np)//'*.*'
	    ns = len_trim(search)
	    call files_menu(search(1:ns),2#10000,directory,
     &	    ileft+2,itop+2,10,files,max_files)

	    if( directory .ne. ' ' ) then
		np = len_trim(path)
		nd = len_trim(directory)
		path = path(1:np)//directory(1:nd)//'\'
	    else
		quit = .true.
	    end if
	end do

	default_path = path
       call write_to_log( 'Data Directory: '//path )

	return
	end

	SUBROUTINE SAVE_HEADER
$INCLUDE:'patcom.for'
C
C	WRITE HEADER BLOCK TO .scd FILE
C
	CHARACTER*(512) HEADER
C
C	CODE
C	----
C
        version = 7.2

	HEADER = ' '
	call add_flt( version, 'VER=', header, '(f4.1)' )
c
c	Number of A/D channels in data file
c
	call add_int( 1, 'NC=', header, '(i2)' )

c
c	No. of A/D samples in file
c
	call add_int4( np_file, 'NP=', header, '(i10)' )
c
c	No. of open/close events detected
c
	call add_int4( n_events, 'NEV=', header, '(i10)' )
c
c	Sampling interval and time units (always ms)
c
	call add_flt( dt, 'DT=', header, '(f8.4)' )
	call add_char( 'ms','TU=', header )

	call add_int( nzero, 'NZ=', header, '(i4)' )
c
c	Channel units and scaling factors
c
	call add_char( 'Im', 'Y0=', header )
	call add_char( 'pA', 'YU=', header )
c
c	Units per bit
c
	call add_flt( ScaleIm, 'YS0=', header, '(g10.3)' )
c
c	Gain factor: mV per unit (e.g. mV per pA )
c	for current channel (GainIm) and voltage (GainVm)
c
	call add_flt( GainVm, 'GVM=', header, '(g10.3)' )
	call add_flt( GainIm, 'GIM=', header, '(g10.3)' )
c
c	Zero current level (A/D units 0-4096)
c
	call add_int( ibase, 'YZ0=', header, '(i5)' )
c
c	Positive limit of A/D converter input voltage range
c
	call add_flt( adc_range, 'AD=', header, '(f7.4)' )

c
c	Channel unitary current amplitude, and lower and upper
c	transition thresholds (all in A/D units)
c
	call add_int( iunit, 'UNI=', header, '(i5)' )
	call add_flt( close_threshold, 'CTH=', header, '(f7.4)' )
	call add_flt( open_threshold,  'OTH=', header, '(f7.4)' )

        call add_flt( Vm,  'VMEM=', header, '(f10.2)' )
c
c	T/F flag indicating whether the currents come from
c	voltage-gated(T) or ligand-gated(F) channels
c
	call add_logical( VoltageGatedChannels, 'VGC=', header )
c
c	Start of voltage step which opens channels
c	(No. of samples from start of record)
c
	call add_int( iVoltageStepStart, 'VSS=', header, '(i5)' )
c
c	Experiment user-entered ident. line
c
	call add_char( cell,'ID=', header )

	write(unit=idata_file,rec=1,err=100) header,
     &	nOverView,nOverviewSlice,ioverview

	return
100	call Report_Error(2,24,'Could not create header block')
	return
	end

	SUBROUTINE GET_HEADER
$INCLUDE:'patcom.for'
C
C	Read data from PAT file header block into HEADER common area
C
	CHARACTER*(512) HEADER
C
C	CODE
C	----
C
C	Read header block of .scd file
C
	read(unit=1,rec=1,iostat=istat) header,
     &	nOverView,nOverviewSlice,ioverview

	if( istat .eq. 0 ) then
	    call read_flt( 'VER=', header, version )
	    call read_int4( 'NP=', header, np_file )
	    n_records = np_file / np_record
	    call read_int4( 'NEV=', header, n_events )
	    call read_flt( 'AD=', header, adc_range )
	    call read_flt( 'DT=', header, dt )

	    call read_flt( 'YS0=', header, ScaleIm )
	    call read_flt( 'GIM=', header, GainIm )
	    ScaleIm = convert_gain( GainIm )
	    call read_flt( 'GVM=', header, GainVm )
	    ScaleVm = convert_gain( GainVm )
	    call read_int( 'YZ0=', header, ibase )
	    call read_int( 'UNI=', header, iunit )
	    call read_flt( 'CTH=', header, close_threshold )
	    call read_flt( 'OTH=', header, open_threshold )
            call read_flt( 'VMEM=', header, Vm )
	    call read_logical( 'VGC=', header, VoltageGatedChannels )
	    call read_int( 'VSS=', header, iVoltageStepStart )
	    call read_char( 'ID=', header, cell )
	end if

	return
	end


	subroutine add_logical( log_val, key, string )
	logical log_val
	character*(*) key,string

	i0 = len_trim(string)+1
	nc = len(string)
	string(i0:nc) = key
	i0 = len_trim(string)+1
	write( string(i0:nc), '(l1,a2)' ) log_val,char(13)//char(10)
	return
	end

	subroutine add_flt( r, key, string, fstring )
	character*(*) key,string,fstring
	character*20 asc

	i0 = len_trim(string)+1
	nc = len(string)
	string(i0:nc) = key
	i0 = len_trim(string)+1
	write( asc, fmt=fstring ) r
	is = ileading_space(asc)
	ie = len_trim(asc)
	string(i0:nc) = asc(is:ie)//char(13)//char(10)
	return
	end

	subroutine add_int( i, key, string, fstring )
	character*(*) key,string,fstring
	character*20 asc

	i0 = len_trim(string)+1
	nc = len(string)
	string(i0:nc) = key
	i0 = len_trim(string)+1
	write( asc, fmt=fstring ) i
	is = ileading_space(asc)
	ie = len_trim(asc)
	string(i0:nc) = asc(is:ie)//char(13)//char(10)
	return
	end

	subroutine add_char( string_in, key, string )
	character*(*) key,string,string_in

	i0 = len_trim(string)+1
	nc = len(string)
	string(i0:nc) = key
	i0 = len_trim(string)+1
	string(i0:nc) = string_in
	i0 = len_trim(string)+1
	string(i0:i0+1) = char(13)//char(10)
	return
	end

	subroutine read_flt( mask, header, r )
	character*(*) mask, header
	real*4 r
	character*16 string

	call find_item( header, mask, is, ie )
	if( is .gt. 0 ) then
	    string = header(is:ie)
	    read( string, '(f16.0)', err=100 ) r
	end if

100	return
	end

	subroutine read_int( mask, header, i )
	character*(*) mask, header
	integer*2 i
	character*16 string

	string = ' '
	call find_item( header, mask, is, ie )
	if( is .gt. 0 ) then
	    string = header(is:ie)
	    read( string, '(f16.0)', err=100 ) r
	    i = int(r)
	end if
100	return
	end

	subroutine read_char( mask, header, string )
	character*(*) mask, header, string

	call find_item( header, mask, is, ie )
	if( is .gt. 0 ) string = header(is:ie)
	return
	end

	subroutine read_logical( mask, header, log )
	character*(*) mask, header
	logical log
	character*6 string

	call find_item( header, mask, is, ie )
	if( is .gt. 0 ) then
	    string = header(is:ie)
	    read( string, '(L1)', err=100 ) log
	end if
100	return
	end

	subroutine find_item( string, name, is,ie )
	character*(*) name,string
	integer*2 nc,is,ie
c
c	Searches <string> for items with the form:
c	<name> <data> <cr> <lf>
c	or
c	<name> <data> <\>
c

	nc = len( string )
	nn = len_trim(name)
	is = index( string, name(1:nn) )
	if ( is .gt. 0 ) then
	    ie = index( string(is:nc), char(13) )
	    if( ie .ne. 0 ) then
		ie = is + ie - 2
		is = is + nn
	    endif
	endif
c	 call move_cursor(1,1)
c	 call display_string(name)
c	 call display_string(string(is:ie))
c	 call display_int(is)
c	 call display_int(ie)
c	 call paws
	return
	end

	SUBROUTINE read_initialisation_file( fname )
	character*(*) fname
	CHARACTER*(512) HEADER
	EQUIVALENCE (ibuffer,HEADER)
C
$INCLUDE:'patcom.for'
C
	character drive
	logical file_exists

C	CODE
C	----
C
	inquire(file=fname, exist=file_exists)

	if( file_exists ) then

	    open(unit=ini_file,file=fname,form='binary',
     &	    access='direct',recl=512, iostat=istat )

	    read(unit=ini_file,rec=1,err=100) header
	    call read_int( 'IFC=', header, interface_card )
	    call read_int( 'FNT=', header, ifont )
	    call read_int( 'FSZ=', header, ipoint_size )
	    call read_int( 'LSZ=', header, iline_size )
	    call read_int4( 'NPR=', header, np_record )
	    call read_flt( 'PH=', header, PulseHeight )
	    call read_flt( 'BEV=', header, BriefEvent )
	    call read_flt( 'BEL=', header, BriefEventLimit )
	    call read_char( 'DP=', header, default_path )
	    call read_char( 'FIL=', header, file_name )
c	    17/4/96
	    call read_flt( 'VSTA=', header, VStart )
	    call read_flt( 'VSTP=', header, VStep )
	    call read_int( 'NST=', header, nStep )
	    call read_flt( 'VDIV=', header, VDivide )

100	    close(unit=ini_file)

	else
	    call get_default_disc( drive )	! does not exist, create
	    default_path = drive//':\'          ! one on the current drive.
	    file_name = drive//':\standard.scd'
	end if
	return
	end

	SUBROUTINE save_initialisation_file( fname )
	character*(*) fname
	CHARACTER*(512) HEADER
	EQUIVALENCE (ibuffer,HEADER)
C
$INCLUDE:'patcom.for'

C
C	CODE
C	----
C
	open(unit=ini_file,file=fname,form='binary',
     &	access='direct',recl=512,iostat=istat)

	if( istat .eq. 0 ) then
	    header = ' '
	    call add_int( interface_card, 'IFC=', header, '(i4)' )
	    call add_int( ifont, 'FNT=', header, '(i2)' )
	    call add_int( ipoint_size, 'FSZ=', header, '(i3)' )
	    call add_int( iline_size, 'LSZ=', header, '(i3)' )
	    call add_int4( np_record, 'NPR=', header, '(i10)' )
	    call add_flt( PulseHeight, 'PH=', header, '(f10.1)' )
	    call add_flt( BriefEvent, 'BEV=', header, '(f10.1)' )
	    call add_flt( BriefEventLimit, 'BEL=', header, '(f10.1)')
	    call add_char( default_path,'DP=', header )
	    call add_char( file_name,'FIL=', header )
c	    17/4/96
	    call add_flt( VStart, 'VSTA=', header, '(f10.1)' )
	    call add_flt( VStep, 'VSTP=', header, '(f10.1)')
	    call add_int( nStep, 'NST=', header, '(i3)' )
	    call add_flt( VDivide, 'VDIV=', header, '(f10.1)')


	    write(unit=ini_file,rec=1) header
	    close(unit=ini_file)
	else
	    call Report_Error(2,24,'Cannot create file: PAT.INI')
	end if
	return
	end

	subroutine read_int4( mask, header, i )
	integer*4 i
	character*(*) mask, header
	character*16 string

	string = ' '
	call find_item( header, mask, is, ie )
	if( is .gt. 0 ) then
	    string = header(is:ie)
	    read( string, '(f16.0)', err=100 ) r
	    i = int4(r)
	end if
100	return
	end

	subroutine add_int4( i, key, string, fstring )
	integer*4 i
	character*(*) key,string,fstring
	character*20 asc

	i0 = len_trim(string)+1
	nc = len(string)
	string(i0:nc) = key
	i0 = len_trim(string)+1
	write( asc, fmt=fstring ) i
	is = ileading_space(asc)
	ie = len_trim(asc)
	string(i0:nc) = asc(is:ie)//char(13)//char(10)
	return
	end

