	subroutine display_records
C
$INCLUDE: 'PATCOM.FOR'
C
c	17/4/96 ... Duration bug in analyse_Segment fixed
c       10/10/96 ... LP filter bug fixed
c       11/6/97 ... Plot display bugs fixed
c                   Overview printed incorrectly,
c                   Wrong calibration factor in single records    
C -- Display selected ADC records and allow values to be
C	read by cursor.
C
	LOGICAL CHANGE_DISPLAY,SPECIAL,new_menu,change_overview,
     &	first_call,quit
	INTEGER*2 IXY(2)
	integer*2 iwindow(4),ioverview_window(4)
	CHARACTER KEY
	CHARACTER*50 STRING
	character*15 string15
	parameter(nmenu=11,istatus_left=64,istatus_top=20)
	character*15 menu(nmenu) /
     &	'Resize Window Z',
     &	'Next  rec. PgDn',
     &	'Prev. rec. PgUp',
     &	'Goto  rec. Home',
     &	'Set Czero    F1',
     &	'Set Cunitary F2',
     &	'Mark start   F3',
     &	'Mark end     F4',
     &	'Plot display F5',
     &	'LP Filter    F6',
     &	'Exit        ESC'/

	integer*4 istart,iend,irecord
C
C -- CODE -------------------------------------------------------
C
	call open_data_file

	call erase_all
C
C -- Set size of display area
C
	CALL SET_CHARACTER_HEIGHT(ISCREEN,1000)
	CALL GET_CHARACTER_SIZE(IW,IH)

	iwindow_width = ((60*IW)/512)*512

	ioverview_window(1) = iw
	ioverview_window(2) = ndc_max - 4*ih
	ioverview_window(3) = ioverview_window(1) + iwindow_width
	ioverview_window(4) = ioverview_window(2) + 4096

	iwindow(1) = ioverview_window(1)
	iwindow(2) = ndc_max - 20*ih
	iwindow(3) = ioverview_window(3)
	iwindow(4) = iwindow(2) + max_adc*iy_magn_min

C
C	Set display size to whole of buffer , cursor in middle
C
	ICURSOR = np_record/2
	IOLD_CURSOR = ICURSOR
	IRECORD_ZERO = 1
	ICURSOR_ZERO = 1
	I_BASELINE = IBASE

	ip_start = 1
	ip_end = np_record
	iylo = 0
	istart = 1
	iend = n_records
C
C
C	Read first frame then do a change frame
C	to get frame number on display
C
	IRECORD = 1
	read(unit=idata_file,rec=irecord+idata_offset)
     &	(iBuf(i),i=1,np_record)
	CHANGE_DISPLAY = .TRUE.
	change_overview = .true.
	new_menu = .true.

C
C -- Begin display loop --------------------------------------------
C
	quit = .false.
	do while ( .not. quit )

	    if( new_menu ) then
		key = ' '
		iop = IMENU_VERTICAL1(menu,'ZQPH123456$'
     &		,nmenu,istatus_left-1,1,new_menu,iop,' Options ',
     &		 key)
	    endif


	    if( change_overview ) then

		istart = 1
		iend = n_records
		call create_overview( istart, iend )
c
c		Restore buffer
c
		read(unit=idata_file,rec=irecord+idata_offset)
     &		(iBuf(i),i=1,np_record)

		call erase_box(1,1,62,6)
		call display_box(1,1,62,6)

		call move_cursor(2,1)
		call display_string(' Display recording ')

		call move_cursor(2,6)
		call display_string(' 0.s ')

		write( string, '(1x,f10.1,''s '')')
     &		float(np_file) * dt / 1000.
		call move_cursor(48,6)
		call display_stringt( string )

		dx = float( ioverview_window(3)
     &		     - ioverview_window(1) ) /
     &		     float( nOverview )

		call set_polyline_colour( iscreen, blue )
		x = float( ioverview_window(1) )
		do i = 1,nOverview*2,2
		    ix = int(x)
		    ixy(1) = ix
		    ixy(2) = ioverview(i) + ioverview_window(2)
		    ixy(3) = ix
		    ixy(4) = ioverview(i+1) + ioverview_window(2)
		    call polyline( iscreen, ixy, 2 )
		    x = x + dx
		end do
		call set_polyline_colour( iscreen, black )

		first_call = .true.

		call superimpose_box( ioverview_window,
     &		irecord,nOverview,nOverviewSlice, first_call )

		change_overview = .false.
	    end if

	    IF( CHANGE_DISPLAY ) THEN
C
C	    -- Draw display border and help information
C
		T_MIN = (float(irecord-1)*float(np_record))*dt*0.001
		t_max = t_min + float(np_record)*dt*0.001
		CALL erase_BOX(1,7,62,21)
		CALL DISPLAY_BOX(1,7,62,21)
		CALL MOVE_CURSOR(2,21)
		WRITE(string,'(F8.3,''s'')') t_min
		CALL DISPLAY_STRINGt(string)
		WRITE(string,'(F8.3,''s'')') t_max
		CALL MOVE_CURSOR(50,21)
		CALL DISPLAY_STRINGt(string)
		CHANGE_DISPLAY = .FALSE.
		IOLD_CURSOR = ICURSOR
		call display_vertical_cursor(iscreen,iwindow,
     &		iold_cursor-1,np_record)
C
C		Draw zero current level cursor
C
		CALL SET_WRITING_MODE(ISCREEN,2)
		CALL SET_POLYLINE_TYPE(ISCREEN,5)
		call display_horizontal_cursor(iscreen,
     &		iwindow,ibase,iy_magn,iy_offset)
C
C		Draw unit current level cursor
C
		CALL SET_POLYLINE_TYPE(ISCREEN,3)
		call display_horizontal_cursor(iscreen,
     &		iwindow,ibase+iunit,iy_magn,iy_offset)
		CALL SET_POLYLINE_TYPE(ISCREEN,1)
C
C --	    Display signal on screen
C
		CALL SET_WRITING_MODE(ISCREEN,1)
		call plot_channel( iscreen, iwindow,
     &		iBuf,1,1,1, np_record, iy_magn, iy_offset, blue )


		CALL SET_POLYLINE_TYPE(ISCREEN,3)
		call display_vertical_cursor(iscreen,iwindow,
     &		ip_start-1,np_record)
		call display_vertical_cursor(iscreen,iwindow,
     &		ip_end-1,np_record)
		CALL SET_POLYLINE_TYPE(ISCREEN,1)

		CHANGE_DISPLAY = .FALSE.

		first_call = .false.

		call superimpose_box( ioverview_window,
     &		irecord,nOverview,nOverviewSlice, first_call )

		call analyse_segment( iBuf, ip_start, ip_end )

	    ENDIF
C
C --	    Draw vertical readout cursor
C
	    CALL SET_WRITING_MODE(ISCREEN,3)
	    call display_vertical_cursor(iscreen,iwindow,
     &	    iold_cursor-1,np_record)
	    call display_vertical_cursor(iscreen,iwindow,
     &	    icursor-1,np_record)
	    CALL SET_WRITING_MODE(ISCREEN,1)
	    IOLD_CURSOR = ICURSOR
c
c --	    Display status box
c
	    call display_box(istatus_left-1,istatus_top-1,79,25)

	    call move_cursor(istatus_left,istatus_top)
	    write(string15,'(''Record  '',I5)') irecord
	    call display_string(string15)

	    TIME = FLOAT(ICURSOR-1)*dt + t_min
	    call move_cursor(istatus_left,istatus_top+1)
	    write(string,'(''T:'',F10.2,''ms'')') time
	    call display_stringt(string)

	    CURRENT = FLOAT(iBuf(ICURSOR)-IBASE)*ScaleIm
	    call move_cursor(istatus_left,istatus_top+2)
	    write(string,'(''C:'',F10.2,''pA'')') current
	    call display_stringt(string)


	    call wait_for_key( key, special )

C	    Process <- and -> arrow keys
	    if( special .and. (key .eq. 'L') ) then
C		<- = move cursor left 1 point
		ICURSOR = max( ICURSOR - 1, 1 )
		iop = 0
	    elseif( special .and. (key .eq. 'R') ) then
C		-> = move cursor right 1 point
		ICURSOR = min(ICURSOR + 1,np_record)
		iop = 0
	    elseif( special .and. (key .eq. 'B') ) then
C		CTRL <- = B Move cursor left 20 points
		ICURSOR = max(ICURSOR - 20,1)
		iop = 0
	    elseif( special .and. (key .eq. 'F') ) then
C		CTRL -> = Move cursor right 20 points
		ICURSOR = min( ICURSOR + 20, np_record )
		iop = 0
	    else
C
c		Present options menu and return "iop=1..14" if
c		an option has been selected. "iop=0" if no selection
c
		iop = IMENU_VERTICAL1(menu,'ZQPH123456$'
     &		,nmenu,istatus_left-1,1,new_menu,iop,' Options ',key)

	    endif

	    select case (iop)
	    case (1)
C
C --		Expand display
C
		call set_overview_window(ioverview_window,
     &		irecord,nOverview,nOverviewSlice)
c
c		Close and re-open data file with desired record size
c
		call save_header
		close(unit=idata_file)
		call open_data_file
c
		call move_cursor(1,25)
		call display_int4( n_records )

		read(unit=idata_file,rec=irecord+idata_offset)
     &		(iBuf(i),i=1,np_record)

		CHANGE_DISPLAY = .TRUE.
		change_overview = .true.

	    case( 2 )
C
C --		PgDn - Read next record stored
C
		irecord = min(irecord+1,n_records)
		read(unit=idata_file,rec=irecord+idata_offset)
     &		(iBuf(i),i=1,np_record)
		CHANGE_DISPLAY = .TRUE.

	    case ( 3 )
C
C --		PgUp a Read last record
C
		irecord = max(irecord-1,1)
		read(unit=idata_file,rec=irecord+idata_offset)
     &		(iBuf(i),i=1,np_record)
		CHANGE_DISPLAY = .TRUE.

	    case (4)
C
C --		Home - go to record
C
		r = float(irecord-1)*float(np_record)*dt*0.001
		rmax = 0.001*float(n_records)*float(np_record)

		call get_number_box(2,2,' Go to record ',
     &		' (s) ',0.,rmax,r)
		irecord = int4( (r*1000.)/(float(np_record)*dt) ) + 1
		irecord = max(min(n_records,irecord),1)

		read(unit=idata_file,rec=irecord+idata_offset)
     &		(iBuf(i),i=1,np_record)

		CHANGE_DISPLAY = .TRUE.
		change_overview = .true.

	    case (5)
C
C --	    F1 - Set zero current baseline level
C
		ibase = iBuf(icursor)
		call save_header
		change_display = .true.

	    case (6)
C
C --		F2 - Set unit current level
C
		iunit = iBuf(icursor) - ibase
		call save_header
		change_display = .true.

	    case (7)
c
c		F4 Mark start of analysis segment
c
		ip_start = icursor
		change_display = .true.

	    case (8)
c
c		F4 Mark end of analysis segment
c
		ip_end = icursor
		change_display = .true.

	    case (9)
C
C --		F5 Plot screen
C
		call plot_display(irecord)
		CHANGE_DISPLAY = .TRUE.
		change_overview = .true.
		new_menu = .true.

	    case( 10 )
c
c --		F6 Low pass filter
c
		string = ' '
                Filter_Cutoff = 0.
                call gaussian_filter( string, Filter_Cutoff )
		change_display = .true.
		change_overview = .true.
		new_menu = .true.

	    case (11)
C
C --		Esc quit this option
C
		quit = .true.

	    end select
	end do

	call save_header
	close(unit=idata_file,iostat=istat)
	return
	end

	subroutine create_overview( istart, iend )
$INCLUDE: 'PATCOM.FOR'
c
c	Create a buffer containing a condensed image
c	of the A/D sample data in the data file between
c	records istart and iend.
c	ibuf is returned containing minimum and maximum
c	data values for a series of nOverview slices from
c	the data file.
c
	integer*4 istart,iend,new_slice
	integer*4 irecord,i,j,k,n,jMax,np
C
C -- CODE -------------------------------------------------------
C
c
c	code
c
	nOverView = maxOverview
	jMax = nOverview*2 - 1
	np = (iend - istart + 1)*np_record
	new_slice =  max( np / nOverview, 1 )

	if( nOverViewSlice .ne. new_slice) then

	    call move_cursor(2,2)
	    call display_string(' ... Wait ... ')

	    nOverviewSlice = new_slice
	    nOverView = 0
	    j = 1
	    n = 0
	    imin = 32767
	    imax = -imin

	    do irecord = istart,iend

		read(unit=idata_file,rec=irecord+idata_offset)
     &		(iBuf(k),k=1,np_record)

		do i = 1,np_record

		    iY = iBuf(i)
		    if( iY .gt. imax ) imax = iY
		    if( iY .lt. imin ) imin = iY

		    n = n + 1
		    if( n .ge. nOverviewSlice ) then
			ioverview(j) = imin
			ioverview(j+1) = imax
			j = min(j + 2,jMax)
			n = 0
			imin = 32767
			imax = -imin
		    end if
		end do
	    end do
	    nOverview = (j+1) / 2
	    call save_header
	end if
	return
	end

	subroutine superimpose_box( iarea,irecord,np,
     &	 nskip,first_call)
$include:'patcom.for'
	real*4 dx
	integer*4 irecord,np,nskip
	integer*2 ibox(4),ixy(10),iarea(4)
	logical first_call

	dx = float( iarea(3) - iarea(1) ) / float(np)
	ibox(1) = iarea(1) + int(
     &	(float(irecord-1)*float(np_record)*dx)/float(nskip))
	ibox(3) = ibox(1) + int( float(np_record)*dx/float(nskip) )
	iheight  = int(
     &		   4096. * float(iy_magn_min) / float(iy_magn) )
	iyhi = min( iy_offset + iheight, 4096 )
	iy_offset = max(iyhi - iheight,0)
	ibox(2) = iarea(2) + iy_offset
	ibox(4) = ibox(2) + iheight

	call set_polyline_colour( iscreen, 2 )
	call set_polyline_type ( iscreen, 3 )
	call set_writing_mode( iscreen, 3 )

	if( .not. first_call ) call polyline( iscreen, ixy, 5 )

	ixy(1) = ibox(1)
	ixy(2) = ibox(2)
	ixy(3) = ibox(3)
	ixy(4) = ibox(2)
	ixy(5) = ibox(3)
	ixy(6) = ibox(4)
	ixy(7) = ibox(1)
	ixy(8) = ibox(4)
	ixy(9) = ibox(1)
	ixy(10) = ibox(2)
	call polyline( iscreen, ixy, 5 )

	call set_polyline_colour( iscreen, 1 )
	call set_polyline_type ( iscreen, 1 )
	call set_writing_mode( iscreen, 1 )
	return
	end

	subroutine set_overview_window(iarea,irecord,np,nskip)
$include:'patcom.for'

	integer*2 iarea(4)
	integer*4 irecord,np,ip,nskip

	character key
	logical special, quit
	character*40 msg(10)
	character*60 string
c
c	code
c

	msg(1) =   ' Re-size Display Windows '
	msg(2) =   ' '
	msg(3) =   ' '//char(1)//'   Enlarge vertical'
	msg(4) =   ' '//char(2)//'   Reduce vertical'
	msg(5) =   ' '//char(3)//'   Enlarge horizontal'
	msg(6) =   ' '//char(4)//'   Reduce  horizontal '
	msg(7) =   ' +   Move window up '
	msg(8) =   ' -   Move window Down '
	msg(9) =   ' ESC Exit '
	msg(10) =   ' '

	call display_message(2,8,46,msg,10)

	 quit = .false.
	do while( .not. quit )

	    write( string,
     &	    '('' Width '',f7.2,''ms''
     &	      '' Magn. '',f5.1,''%''
     &	      '' Offset '',f5.1,''%'')' )
     &	    float(np_record*dt),
     &	    (float(iy_magn)*100.)/float(iy_magn_min),
     &	    (float(iy_offset)*100.)/4096.
	    call move_cursor(3,10)
	    call display_stringt( string )
c
c	   Wait for key press
c
	   call wait_for_key( key, special )

	    call superimpose_box( iarea,irecord,np,nskip,
     &	    .false. )

c
c   ----    Expand/Contract display window ---
c

	    select case (key)
	    case ('L')
c
c		Shrink window
c
		ip = irecord * np_record
		np_record = max(np_record/2,np_record_min)
		irecord = ip / np_record

	    case ('R')
c
c		Expand windows
c
		ip = irecord * np_record
		np_record = min(np_record*2,np_record_max)
		irecord = max( ip / np_record, 1 )
		irecord = min( irecord , np_file/np_record )

	    case ('-')
c
c		Move window down
c
		iy_offset = max(iy_offset - 100,0)

	    case ('+')
c
c		Move window up
c
		iy_offset = min(iy_offset + 100,4096-100)

	    case ('U')
c
c		Expand window vertically
c
		iy_magn = max(iy_magn-1,iy_magn_min)

	    case ('D')
c
c		Contract window vertically
c
		iy_magn = min(iy_magn+1,16)

	    case ( '$' )

		quit = .true.

	    end select

	    call superimpose_box( iarea,irecord,np,
     &	    nskip,.false. )

	end do

	return
	end

	subroutine analyse_segment( ibufIn, ip_start, ip_end )
$include:'patcom.for'
c
c	Analyse segment of A/D samples in "ibuf"
c	from ip_start to ip_end
c
	integer*2 ibufIn(1)
	character*80 string
c
c	code
c
	if( ip_end .gt. np_record ) then
	    ip_end = np_record
	    ip_start = 1
	end if

	if( ip_start .gt. ip_end )  then
	    itemp = ip_end
	    ip_end = ip_start
	    ip_start = itemp
	end if

c
c	Average current
c
	avg = 0.
	navg = ip_end - ip_start + 1
	do i = ip_start,ip_end
	    avg = avg + float( ibufIn(i) )
	end do
	avg = avg/float(navg)

c
c	Time duration of segment
c
	duration = float(navg)*dt

c
c	Current variance
c
	variance = 0.
	do i = ip_start,ip_end
	   residual = float(ibufIn(i)) - avg
	   variance = variance + residual*residual
	end do
	var = var / float(navg)

	variance = variance*ScaleIm*ScaleIm/
     &	 float(navg)
	avg = (avg - float(ibase) )*ScaleIm

	call erase_box(1,22,62,25)
	call display_box(1,22,62,25)
	write( string,
     &	'(''Duration '',f10.2,''ms  No. points '',i5)')
     &	duration,navg
	call move_cursor(2,23)
	call display_stringt( string )
	write( string,
     &	'(''Average  '',f10.2,''pA  Variance '',f10.4,''pA^2'')')
     &	avg,variance
	call move_cursor(2,24)
	call display_stringt( string )

	return
	end

	subroutine plot_display(irecord)
$include:'patcom.for'

c	--------------------------------------------------------------
c	Plot a hard copy of the currently displayed record on
c	Printer,Plotter,ASCII file, or HPGL file.
c
c	n_disp = No of points to be displayed
c	--------------------------------------------------------------

	integer*4 irecord
	LOGICAL SPECIAL
	CHARACTER*30 device
	character key
	parameter(lwidth=53)
	character*36 err

	real*4 y_bar,t_bar
	integer*2 iarea(4)

	integer*2 ixy(maxOverview*4)
	equivalence( iWork(nWork-maxOverview*4), ixy )

	logical first / .true. /, not_set / .true. /, new_menu,
     &	to_file
	character*2 crlf
	character*40 string
	character*60 rec_list

	parameter(nmenu=4)
	character*18 menu(nmenu) /
     &	' This record F1 ',
     &	' All records F2 ',
     &	' From list   F3 ',
     &	' Overview    F4' /

	parameter(ncalmenu=6)
	character*34 cal_name(ncalmenu) /
     &	' Vertical bar       (pA) ',
     &	' Horizontal bar     (ms) ',
     &	' Plot zero level    (Y/N) ',
     &	' Plot unitary level (Y/N) ',
     &	' Start at record ',
     &	' End at record ' /

	character*12 list(ncalmenu)

	parameter( isingle=1, iall_records=2, ilist=3, iover=4 )
	parameter(nmax=100)
	integer*2 irlist(nmax) /100*0/
	character draw_zero /  'Y' /, draw_unit / 'Y' /
	integer*4 istart,iend,irec,ir,ir_s,ir_e

	character tab
c
c	code
c
	tab = char(9)
c
c	Select record or range of records to be plotted
c
	new_menu = .true.
	itype = Iwait_MENU_VERTICAL1(menu,'1234'
     &	,nmenu,2,2,new_menu,itype,' Plot Records ',key)

	select case (itype)
	case (isingle)
	    ir_s = irecord
	    ir_e = irecord
	    write( rec_list, '(''Rec. '',i4)') irecord
	    iplot_height = 3*4096
	    nplots_per_page = 1
	    ncal = 4
	case (iall_records)
	    ir_s = 1
	    ir_e = n_records
	    write( rec_list, '(''Recs. '',i4,'' - '',i4)') ir_s,ir_e
	    iplot_height = 4096
	    nplots_per_page = 6
	    ncal = 6
	case (ilist)
	    call edit_list( 3, 3+itype, ' List ', irlist, nmax )
	    ir_s = 1
	    ir_e = nmax
	    do while( irlist(ir_e).le.0 .and. ir_e.gt.1 )
		ir_e = ir_e - 1
	    end do
	    iplot_height = 4096
	    nplots_per_page = 6
	    rec_list = 'Recs.'
	    j = 6
	    do i = 1,min(ir_e,10)
		if( irlist(i) .gt. 0 ) then
		    write( rec_list(j:j+4), '(i4)' ) irlist(i)
		    j = j + 5
		end if
	    end do
	    ncal = 4
	case( iover )
	    ir_s = 1
	    ir_e = 1
	    iplot_height = 3*4096
	    nplots_per_page = 1
	    ncal = 6
	end select
C
C --	Set plotting area size
C
	ivertical_spacing = iplot_height/16 + iplot_height
	itop = ndc_max - ndc_max/10
	ileft = (ndc_max/16)*3
	iplot_length = ndc_max - ndc_max/4

c
c	Select destination to send plot to
c
	call select_plot_device(3,3+itype,idev,ihandle,device)
	if( (idev.eq. 0) .and. (ihandle.eq.0) ) return

	if( (idev.eq. 0) .and. (ihandle.ne.0) ) then
	    to_file = .true.
	else
	    to_file = .false.
	end if

c
c	Let user enter calibration bars
c
	j = 1
	if( not_set ) y_bar = 1.
	write( list(j), '(g10.3)') y_bar

	j = j + 1
	if( not_set ) then
	    if( itype .ne. iover ) then
	       t_bar = float(np_record)*dt*0.1
	    else
	       t_bar = float(np_record)*float(n_records)*dt*0.1
	    end if
	end if
	write(list(j), '(g10.3)' ) t_bar

	j = j + 1
	list(j) = draw_zero

	j = j + 1
	list(j) = draw_unit
	not_set = .false.

	if( ncal .gt. 4 ) then
c
c	    Do these entries only when plotting series of records
c
	    j = j + 1
	    write(cal_name(j),
     &	    '('' Start at record (1-'',i5,'')'')') n_records
	    write( list(j), '(i5)') ir_s
	    j = j + 1
	    write( list(j), '(i5)') n_records
	end if

	err = ' '
10	if( err .eq. ' ' )  err = ' Set calibration bars '
	call text_window(cal_name,list,ncal,4,10,err )

	j = 1
	y_bar = check_limits(list,0.,1E30,j,err)
	if( err .ne. ' ' ) goto 10
	j = 1 + j
	t_bar = check_limits(list,0.,1E30,j,err)
	if( err .ne. ' ' ) goto 10
	j = 1 + j
	draw_zero = check_letter(list,'YN',j,err)
	if( err .ne. ' ' ) goto 10
	j = 1 + j
	draw_unit = check_letter(list,'YN',j,err)
	if( err .ne. ' ' ) goto 10

	if( ncal .gt. 4 ) then
	    j = j + 1
	    ir_s = int(
     &	    check_limits(list,1.,float(n_records),j,err))
	    if( err .ne. ' ' ) goto 10
	    j = 1 + j
	    ir_e = int(
     &	    check_limits(list,1.,float(n_records),j,err))
	    if( err .ne. ' ' ) goto 10
	end if


	if( idev .eq. iscreen ) call erase_all
c
c	Plot list of records
c
	first = .true.
	nplots = 0
	if( itype .eq. iover ) then
	    istart = ir_s
	    iend = ir_e
	    ir_s = 1
	    ir_e = 1
	end if

	do ir = ir_s,ir_e

	    if( itype .eq. ilist ) then
		irec = irlist(ir)
	    else
		irec = ir
	    end if

	    if( irec .gt. 0 .and. irec .le. n_records ) then

		if( itype .ne. iover ) then
		     read(unit=idata_file,rec=irec+idata_offset )
     &		     (ibuf(i),i=1,np_record)
                    dtplot = dt 
		    np = np_record
		else
		     call create_overview( istart,iend )
                     dtplot = 0.5*(dt*nOverviewSlice)
                     np = nOverview*2
                     do i = 1,np
			ibuf(i) = ioverview(i)
		     end do
		end if

		if( to_file ) then
c
c		    Write records to ASCII file
c
		    call display_progress(2,23,
     &		    ' Writing to file (Press ESC to abort)',ir,ir_e,key)
		    if( key .eq. '$' ) goto 101
c
c		    Title
c
		   crlf = char(13)//char(10)
		   write(unit=ihandle) 'File: '//file_name//crlf
		   write(unit=ihandle) cell//crlf
		   write(unit=ihandle)
     &		   'Time (ms)'//tab//'Current (pA)'//crlf

		   if( iType .ne. iover ) then
			do j = 1,np
                            t = dtplot*float(j-1)
			    y = float( ibuf(j)-ibase )*ScaleIm
			    write(string,'(1pg12.4,a,1pg12.4,a)')
     &			    t,tab,y,crlf
			    call WriteNoSpaces( ihandle, string )
			end do
		    else
			k = 0
                        do j = 1,np
			    k = (j-1)/2
                            t = dtplot*float(k)*2.
			    y = float( ibuf(j)-ibase )*ScaleIm
			    write(string,'(1pg12.4,a,1pg12.4,a)')
     &			    t,tab,y,crlf
			    call WriteNoSpaces( ihandle, string )
			end do
		    end if
		else
c
c		    Plot traces on printer or plotter
c
c		    Define plotting area on page
c
		    call get_text_attributes( idev, i,i,i,i,i,
     &		    ichar_width,ichar_height)
		    call set_polyline_width( idev,
     &		    (iline_thickness-1)*50+3 )

		    nplots = nplots + 1
		    iarea(1) = ileft
		    iarea(2) = itop - nplots*ivertical_spacing
		    iarea(3) = iarea(1) + iplot_length
		    iarea(4) = iarea(2) + iplot_height

		    call set_size(iarea(1),iarea(2),iarea(3),iarea(4))
		    call enable_clipping( idev )
c
c ------	    Scale signal data to fit into plotting area
c		    and plot it

                    x = float(iarea(1))
                    dx = (iarea(3) - iarea(1))/np
		    yscale = float(iplot_height)*float(iy_magn) /
     &		    ( float(iy_magn_min)*float(max_adc) )
		    do j = 1,np
                        ixy(j*2-1) = int(x)
			ixy(j*2) = int(float(ibuf(j)-iy_offset)
     &			*yscale)+ iarea(2)
                        x = x + dx
		    end do

		    call set_polyline_width( idev,
     &		    (iline_thickness-1)*50+3 )
		    call polyline( idev, ixy, np )
c
c ------	    Draw dotted line to indicate zero level
c
		    call set_writing_mode( idev, 2 )
		    call set_polyline_width( idev, 3 )
		    ixy(1) = iarea(1)
		    ixy(3) = iarea(3)
		    if( draw_zero .eq. 'Y' ) then
			ixy(2) = int(float(ibase-iy_offset)*yscale)+iarea(2)
			ixy(4) = ixy(2)
			call set_polyline_type( idev, 5 )
			call polyline( idev, ixy, 2 )
		    end if
		    if( draw_unit .eq. 'Y' ) then
			ixy(2) = int(float(ibase+iunit-iy_offset)
     &			*yscale)+iarea(2)
			ixy(4) = ixy(2)
			call set_polyline_type( idev, 3 )
			call polyline( idev, ixy, 2 )
		    end if
		    call set_polyline_width( idev,
     &		    (iline_thickness-1)*50+3 )
		    call set_polyline_type( idev, 1 )
		    call set_writing_mode( idev, 1 )

		    call disable_clipping( idev )
c
c ------	    Record Number
c
		    ixy(1) = iarea(1) - ichar_width*5
		    ixy(2) = (iarea(2) + iarea(4) )/2
		    write( string, '(i4)' ) irec
		    call graphics_text(idev,ixy,
     &		    string(1:len_trim(string)) )

		    if( nplots.eq.nplots_per_page .or. ir.eq.ir_e ) then
c
c			Page now full, output it
c
			call disable_clipping( idev )
c
c			Plot Calibration bars
c
			iy_bar = int((yscale*y_bar)/ScaleIm)
c			 ix = iarea(1) - 12*ichar_width
			ix = 2*ichar_width
			iy = iarea(2)
			call yt_calibration( idev, ix, iy, iy_bar,
     &			ichar_width,ichar_height,y_bar,'pA','V')

                        it_bar = int((t_bar*dx)/dtplot)
			call yt_calibration( idev, ix, iy, it_bar,
     &			ichar_width,ichar_height,t_bar,'ms','H')

			IXY(1) = ileft
			IXY(2) = ndc_max - ICHAR_HEIGHT*3
			CALL GRAPHICS_TEXT( Idev, IXY ,
     &			 'File: '//file_name )
			ixy(2) = ixy(2) - ichar_height
			CALL GRAPHICS_TEXT( Idev, IXY ,
     &			cell(1:len_trim(cell)) )

			if( idev.eq.iscreen .and. (.not. to_file) ) then
			    call move_cursor(2,25)
			    call display_string(
     &	  '            <<< Press any key to continue >>>     ')
			    call wait_for_key( key, special )
			end if

			call update_workstation( idev )
			call clear_workstation( idev )

			nplots = 0

		    end if

		    call disable_clipping( idev )
		    if( idev.ne.iscreen ) then
		       call display_progress(2,23,
     &		       ' Plotting (Press ESC to abort)',ir,ir_e,key)
		    end if
		end if
	    end if

	    if( key .eq. '$' ) goto 101
	    first = .false.

	end do
101	continue
C
C	Close plotting workstation
C

	if( to_file ) then
	    write( unit=ihandle ) char(26)
	    close( unit=ihandle )
	end if

	if( Idev .NE. ISCREEN ) THEN
	    CALL UNLOAD_FONTS(Idev)
	    CALL CLOSE_WORKSTATION(Idev)
c
c	    If output has been to an HPGL file
c	    fix it to make it compatible with Microsoft Word
c	    and other programs
c
	    if( device(1:1) .eq. 'H' )
     &	     call fix_hpgl( device(2:len(device)) )

	end if

	if( idev .ne. 0 ) call set_polyline_width( idev, 3 )

	call erase_all

	RETURN
	END

	subroutine edit_list( il, it, title, ilist, nmax )
$include:'patcom.for'
	integer*2 ilist(nmax)
	character*(*) title
	logical quit, new_list
	character*8 string
	character key
	parameter(ndisp=10)

	ncs = len(string)
	ib = it + ndisp + 3
	call erase_box( il,it,il+ncs+2,it+ndisp+3)
	call display_box( il,it,il+ncs+2,it+ndisp+3)
	call move_cursor(il+1,it)

	call set_text_colour( iscreen, blue )
	call display_stringt( title )

	call move_cursor(il+1,ib-2)
	call set_text_colour( iscreen, red )
	call display_string('ESC ')
	call move_cursor(il+1,ib-1)
	call display_string('to exit.')
	call set_text_colour( iscreen, black )

	new_list = .true.
	quit = .false.
	i0 = 1
	i1 = i0 + ndisp - 1
	ic = 1
	do while( .not. quit )

	    if( new_list ) then
		do i = i0,i1
		    call move_cursor(il+1,it+i-i0+1)
		    write( string, '(i5)' ) ilist(i)
		    if( ilist(ic) .le. 0 ) string = ' '
		    call display_string( string )
		end do
		new_list = .false.
	    end if
c
c	    Edit a list entry
c
	    write( string, '(i5)' ) ilist(ic)
	    if( ilist(ic) .le. 0 ) string = ' '
	    call move_cursor(il+1,ic-i0+it+1)
	    call get_string( string, nc, key )
	    read( string, '(f6.0)',err=10 ) r
	    ilist(ic) = int(r)
	    goto 11
10	    ilist(ic) = 0
11	    continue

	    call move_cursor(il+1,it+ic-i0+1)
	    write( string, '(i5)' ) ilist(ic)
	    if( ilist(ic) .le. 0 ) string = ' '
	    call display_string( string )

	    select case (key)
	    case ('U')
		ic = max(ic-1,1)
		if( ic .lt. i0 ) then
		    i0 = max(i0 - ndisp/2,1)
		    i1 = i0 + ndisp - 1
		    new_list = .true.
		end if
	    case ('D')
		ic = min(ic+1,nmax)
		if( ic .gt. i1 ) then
		    i1 = min(i1 + ndisp/2,nmax)
		    i0 = i1 - ndisp + 1
		    new_list = .true.
		end if
	    case ('$')
		quit = .true.
	    end select
	end do

	return
	end

	subroutine fix_hpgl( fname )
$include:'patcom.for'

	character*(*) fname
	character*30 temp_name / ' ' /
	parameter(iout_file=10)
	character ch

	open( unit=itemp_file,
     &	file=fname,
     &	form='binary' )

	temp_name = fname
	ix = index(temp_name,'.')
	if( ix .le. 0 ) ix = len_trim(temp_name)+1
	temp_name(ix:ix+3) = '.tzz'

	open( unit=iout_file,
     &	file=temp_name,
     &	form='binary' )

	do while( .not. eof(itemp_file) )
	    read( unit=itemp_file ) ch
	    write( unit=iout_file ) ch
	    if(ch.eq.';') write(unit=iout_file) char(13)//char(10)
	end do

	close(unit=itemp_file)
	close(unit=iout_file)

	call delete_file( ierr, fname )
	call rename_file( ierr, temp_name, fname )
	return
	end




