c	21st Aug 1991 ... Fixed channel 0-1 swapping problem
c	when in immediate mode, by making sure that clocks are
c	not started until DMA is set up.
c
c
       subroutine open_labmaster( max_channels )
$include: 'labmastc.for'

	last_channel = max_channels - 1
	return
	end

	subroutine set_adc_clock_labmaster( dt, itrigger )
$include: 'labmastc.for'
C
C	Set ADC sampling clock
c	----------------------
c	A/D samples are timed using a 16 counter fed via dividers
c	from a 1us clock. (The labmaster's 9513A time channel No.5
c	is used)
C
c	code
c
	call write_timer_csr ( ireset )
	call write_timer_register( icontrol, imaster, 16#4000 )
C
c	Convert A/D sampling period from <dt> (in ms) into
c	clocks ticks, using a clock period which
c	ensures that the no. of ticks fits into the 9513A's
c	16 bit counter register.
c
	call check_dt_labmaster( dt, iticks, ifreq )

c
c	Set counter No. 5 mode register to:- repeated counts,
c	frequency source period (set by ifreq_source):
c	ifreq_source(1) = 1us
c	ifreq_source(2) = 16us
c	ifreq_source(3) = 256us
c	ifreq_source(4) = 4096us
c	ifreq_source(5) = 65556us,
c	ACTIVE-HIGH terminal count toggled On/Off pulse
c
c
	imode5 = ior(ior(irepeated_count,ifreq_source(ifreq)),itoggle)
c
c	If external triggering requested, set Counter 5 (A/D sampling timer)
c	to be gated by an ACTIVE-HIGH level from the terminal count of
c	Counter 4. Set Counter 4 for a single count, triggered by an
c	ACTIVE-HIGH edge pulse on GATE 4.
c
	if( itrigger .ne. 0 ) then
c
c	    Set up Channel 4 to to a single 2us count when
c	    the GATE 4 goes high and to toggle its OUT 4 line
c	    high when the terminal count is reached
c

	    imode4 = ior(ifreq_source(1),itoggle)
	    call write_timer_register( 4, imoder, imode4 )
	    call write_timer_register( 4, iloadr, 2 )
c	     call wait( 0.05 )
	    call write_timer_csr( iload_counter(4) )
	    call write_timer_csr( iarm_counter(4) )

	    call inpb( itimer_csr, istatus )
	    if( iand(istatus,itc_flag(4)) .ne. 0 ) then
c		 call wait( 0.05 )
		call write_timer_csr( iarm_counter(4) )
c		 call wait( 0.05 )
	    endif

	    imode4 = ior(ior(ifreq_source(1),itoggle),igate)
	    call write_timer_register( 4, imoder, imode4 )
	    call write_timer_register( 4, iloadr, 2 )
	    call write_timer_csr( iarm_counter(4) )

	    imode5 = ior( imode5, igate )
	endif

c
c	Set Counter 5's mode and load registers and initialise counter
c	(If in External Trigger mode, gate Counter 5 with the GATE 5
c	input,
c
	call write_timer_register( 5, imoder, imode5 )
	call write_timer_register( 5, iloadr, iticks )

	return
	end

	subroutine start_clock()
$include: 'labmastc.for'

	call write_timer_csr( iarm_counter(5) )
	return
	end

	subroutine check_dt_labmaster( dt, iticks, ifreq_out )
$include: 'labmastc.for'
C
c	Adjust the floating point value in the a/d sampling interval
c	<dt> so that it matches a valid labmaster clock setting
C
c	code
C
c	Convert A/D sampling period from <dt> (in ms) into
c	clocks ticks, using a clock period which
c	ensures that the no. of ticks fits into the 9513A's
c	16 bit counter register.
c
	scale = 1.
	do 10 ifreq = 1,5
	    ticks = dt / (2.*clock_period*scale)
	    if( ticks .le. 16#7FFF ) goto 11
	    scale = scale*16.
10	continue
11	continue
	dt = ticks*scale*clock_period*2.
	iticks = int( ticks )
	ifreq_out = ifreq
	return
	end

	subroutine adc_to_memory_labmaster(dt,n_channels,n_points,
     &	itrigger,ibuffer,istart,imode,adc_range,key_returned)
$include:'labcom.for'
$include:'labmastc.for'

	INTEGER IBUFFER(1)
C
C	Input arguments
C	DT =	     Group sampling period (ms)
C	N_CHANNELS = No. A/D channels to be scanned
C	N_POINTS =   No. of sample groups held by IBUFFER
C	ITRIGGER =   1 Wait for external trigger before starting sampling
C	             0 Start sampling immediately
C	IBUFFER =    DMA Memory buffer to hold ADC samples
C	ISTART =     Starting point in IBUFFER
C			   either 1, or (N_POINTS*N_CHANNELS)/2 + 1
C	IMODE =      0 Wait till IBUFFER is full before returning
C	             1 Return once sampling has started, collect
C		       a single buffer-full
C	             2 Return once sampling has started, keep
C		       filling IBUFFEr circularly until told to stop
C	ADC_RANGE =  Input voltage range
C	KEY_RETURNED = Key pressed by user during sampling

	CHARACTER*(*) KEY_RETURNED
	CHARACTER KEY
	LOGICAL adc_done,end_of_sweep
	parameter( isingle_sweep_wait=0, isingle_sweep=1,
     &	icircular_buffer=2)
C
C	CODE
C
	nbytes = n_points*n_channels*2

	call set_auto_increment( n_channels )

	if( (interface.eq.7) .or. (interface.eq.9) ) then
c
c	    Enable DMA feature of Labmaster board
c
	    call outb( idma_csr, 16#5 )

c	    A/D control byte for DMA transfers
c
	    ibyte = 16#04

	else
c
c	    If Labmaster card does NOT have DMA, use interrupts
c
c	    Set up A/D interrupt service routine, using a section
c	    of data buffer IBUFFER which starts on a 16 byte memory
c	    paragraph boundary
c
	    call find_para_start( ibuffer, istart )
	    call enable_adc_interrupt( ibuffer(istart), nbytes, imode )
	    ibyte = 16#44
	endif
c
c	Set sampling clock interval (ms), and trigger mode
c
	dt_per_channel = dt / float(n_channels)
	call set_adc_clock_labmaster( dt_per_channel, itrigger )
	dt = dt_per_channel*float(n_channels)


c
c	Set A/D control register ie.
c	Set programmable input gain Bits 0,1
c	Auto channel increment mode Bit 7=0
c	Initiate conversion on external trigger Bit 2=1
c	Interrupt on conversion done Bit 6=1
c
	if( adc_range .lt. 1.251 ) then
	    ibyte = ior(3,ibyte)
	elseif( adc_range .lt. 2.51 ) then
	    ibyte = ior(2,ibyte)
	elseif( adc_range .lt. 5.01 ) then
	    ibyte = ior(1,ibyte)
	else
	endif

	call outb( iadc_csr, ibyte )

	if( (interface.eq.7) .or. (interface.eq.9) ) then
c
c	    If Labmaster card has DMA facility, use it.
c	    (Note that it seems to be important to set up
c	     the DMA controller after setting up the Labmaster
c	     to avoid intermittent loss or DMA bytes and
c	     mis-setting of the the DMA byte and address counter
c	     It is not clear to me why this need be so)
c
	    CALL oUTB(IDMA_MASK, ICH1_OFF )
c
c	    Set DMA controller to auto-initialize for circular
c	    A/D buffer mode
c
	    IF( ImODE .EQ. icircular_buffer ) THEN
		CaLL OUTB(IDMA_MODE,IWRITE_MODEA)
	    ELSE
		CaLL OUTB(IDMA_MODE,IWRITE_MODE)
	    ENDIF
c
	    CALL SET_DMAB_ADDRESS(IBUFFER,ISTART,NBYTES)
	    CALL SET_DMAB_COUNT(NBYTES-1)
	    CALL oUTB(IDMA_MASK, ICH1_On )
	endif
c
c	Add marker to buffer if in single sweep modes
c
	if( imode .le. 1 ) call mark_buffer( ibuffer(istart), nbytes/2)


	call outb( itimer_csr, iarm_counter(5) )
	if( itrigger .ne. 0 ) call outb( itimer_csr, iarm_counter(4) )


	if( imode .eq. isingle_sweep_wait ) then
	    end_of_sweep = .false.
	    do while( .not. end_of_sweep )
		call check_sweep(
     &		ibuffer(istart), nbytes/2, end_of_sweep, key )
		IF( KEY .NE. CHAR(0) ) KEY_RETURNED = KEY
	    end do

	    call adc_stop_labmaster()

	    call add_array(2048,ibuffer(istart),n_points*n_channels)

	endif

	return
	end

	subroutine memory_to_dac_labmaster( dt, nchan, npoints, itrig,
     &	ibuffer, imode, ierr )
$include:'labmastc.for'
	integer*2 ibuffer(1)
	integer*4 idiv4,iperiod4
c
c	Do D/A output to DAC 0 ( or DAC 0 and 1 ) of using values
c	from buffer <ibuffer> containing <npoints> values per channel,
c	updating at intervals of <dt> ms. <nchan> = no. of D/A channels
c	in use (1 or 2). If <imode>=0 wait for D/A sequence to complete
c	before returning, <imode>=1 setup D/A output and return immediately.
c

	parameter( iwait_mode = 0 )
c
c	code
c
	call find_para_start( ibuffer, istart )
	if( istart .ne. 1 ) then
	    call abort(
     &	    'MEMORY_TO_DAC_LABMASTER: IBUFFER NOT ON PARAGRAPH BOUNDARY')
	endif

c
c	Set D/A update clock to a rate which is a multiple of the
c	P.C. time-of-day clock (18.2Hz) and as close as possible
c	to the requested D/A update interval in <dt> ms.
c
	call check_dt_system( dt, iperiod4, idiv4 )
c
c	Begin D/A output sequence
c
	nbytes = nchan*npoints*2
	call setup_dacs_labmaster( ibuffer, nbytes, nchan,
     &	idiv4, iperiod4, imode )

	if( imode .eq. iwait_mode ) then
c
c	    Wait till DAC output counter reaches 0
c
20	    continue
		call get_dac_count_labmaster( ncount )
	    if( ncount .gt. 0 ) goto 20

	    call dac_stop_labmaster()

	endif

	return
	end

	subroutine check_dt_system( dt, iperiod4, idiv4 )
	integer*4 idiv4,iperiod4,idiv4a

	idiv4a = 1
10	continue
	    idiv4 = idiv4a
	    iperiod4 = 16#10000 / idiv4
	    dt1 = 1000. / ( 18.2*float(idiv4) )
	    idiv4a = idiv4a * 2
	if( (dt1 .gt. dt) .and. (idiv4.lt.64) ) goto 10
	dt = dt1
	return
	end

	subroutine set_dacs_labmaster( vdac, ndacs )
$include:'labmastc.for'
	real vdac(ndacs)
	parameter( bitv = 10. / 2048. )
	integer*2 iword
	integer*1 ibyte(2)
	equivalence( iword,ibyte )
c
c	code
c
	iword = int( vdac(1) / bitv )
	call outb( idac0_hi, ibyte(2) )
	call outb( idac0_lo, ibyte(1) )
	if( ndacs .gt. 1 ) then
	    iword = int( vdac(2) / bitv )
	    call outb( idac1_hi, ibyte(2) )
	    call outb( idac1_lo, ibyte(1) )
	endif
	return
	end


	subroutine adc_stop_labmaster()
$include:'labmastc.for'
$include:'labcom.for'
c
c	Terminate A/D sampling by turning off A/D interrupt
c	also reset clocks
c
C	code
c
	if( (interface.eq.7) .or. (interface.eq.9) ) then
	    CALL OUTB(IDMA_MASK, ICH1_OFF )
	    call outb( idma_csr, 0 )
	    call outb( iadc_csr, 0 )
	else
	    call disable_adc_interrupt()
	endif

c
c	Disable any further A/D transfers ( interrupt or DMA )
c
	call outb( iadc_csr, 0 )
	call outb( itimer_csr, ireset )
	call write_timer_register( icontrol, imaster, 0 )
	call wait(0.05)

	return
	end

	subroutine set_auto_increment( n_channels )
$include:'labmastc.for'
$include:'labcom.for'
c
c	Clear A/D and DMA control registers
c
	if( (interface.eq.7) .or. (interface.eq.9) ) then
	    call outb( idma_csr, 0 )
	endif
	call outb( iadc_csr, 0 )

c
c	Set channel to one below required starting channel,
c	and do a single software-started A/D conversion do that
c	multiplexer is set up to auto-increment first channel
c
	ibyte = idisable_auto_incr
	call outb( iadc_csr, ibyte )
	call outb( iadc_channel, (last_channel-n_channels) )
	call outb( iadc_start, 0 )
c
c	Wait for A/D done, then clear it by reading hi byte of A/D data
c
10	call inpb( iadc_csr, istatus )
	if( iand(istatus,iadc_done) .eq. 0 ) goto 10
	call inpb( iadc_data_hi, i )
	call inpb( iadc_data_lo, i )

	call outb( iadc_channel, (last_channel-n_channels+1) )
	call outb( iadc_csr, 0 )

c
c	Increment channels until at last channel
c
	do i = 1,n_channels-1
	    call outb( iadc_start, 0 )
	    istatus = 0
	    do while( iand(istatus,iadc_done) .eq. 0 )
		call inpb( iadc_csr, istatus )
	    end do
	    call inpb( iadc_data_hi, i )
	    call inpb( iadc_data_lo, i )
	end do


	return
	end

	subroutine find_para_start( ibuf, istart )
c
c	Find 1st 16 byte paragraph boundary within array IBUF
c
	integer*2 ibuf(1)

	do 10 i = 1,8
	    call varptr( iseg, ioffset, ibuf(i) )
	    if( mod( ioffset, 16 )  .eq. 0 ) goto 11
10	continue
	call abort('find_para_start: Array not byte aligned')
11	continue
	istart = i
	return
	end

	subroutine check_adc_done_labmaster( adc_done )
$include:'labmastc.for'
	logical adc_done

	call get_adc_count_labmaster( ncount )
	if( ncount .gt. 0 ) then
	    adc_done = .false.
	else
	    adc_done = .true.
	endif
	return
	end

	subroutine write_timer_register( igroup, ielement, ivalue )
$include:'labmastc.for'

c	(Input arguments)
	integer*2 igroup, ielement, ivalue
c	--------------------------
c	Set the 9513A internal register, selected by the group
c	number IGROUP (ie. channels 1-5, and control group 7)
c	and register type IELEMENT, using the contents in IVALUE

	integer*2 ival2
	integer*1 ival1(2)
	equivalence( ival1,ival2)

	ival2 = ivalue

	ireg = ior(igroup,ielement)
	call outb( itimer_csr, ireg )
	call outb( itimer_data, ival1(1) )
	call outb( itimer_data, ival1(2) )
	return
	end

	subroutine read_timer_register( igroup, ielement, ivalue )
$include:'labmastc.for'
c	(Input arguments)
	integer*2 igroup, ielement
c	(Output arguments)
	integer*2 ivalue
c	--------------------------
c	Read the 9513A internal register, selected by the group
c	number IGROUP (ie. channels 1-5, and control group 7)
c	and register type IELEMENT. Return the 16 bit register contents
c	in IVALUE

	integer*2 ival2
	integer*1 ival1(2)
	equivalence( ival1,ival2)

	ireg = ior(igroup,ielement)
	call outb( itimer_csr, ireg )
	call inpb( itimer_data, ival1(1) )
	call inpb( itimer_data, ival1(2) )
	avalue = ival2
	return
	end
	subroutine write_timer_csr( ibyte )
$include:'labmastc.for'

	call outb( itimer_csr, ibyte )
	return
	end

	subroutine digital_out_labmaster( ibyte )
$include:'labmastc.for'

c
c	Set port A & B and Clow to be input, Chigh to output
c
	call outb( idig_control, 16#93 )
c
c	Update port C
c
	call outb( idig_port_c, ibyte )

	return
	end
