	parameter( iDIGIDATABASE = 16#0320 )

	parameter(
     &	 iBoard_DACData 	    = iDIGIDATABASE + 16#00,
     &	 iBoard_ADCData 	    = iDIGIDATABASE + 16#00,
     &	 iBoard_ID		    = iDIGIDATABASE + 16#02,
     &	 iBoard_TimerData	    = iDIGIDATABASE + 16#04,
     &	 iBoard_TimerControl	    = iDIGIDATABASE + 16#06,
     &	 iBoard_TimerStatus	    = iDIGIDATABASE + 16#06,
     &	 iBoard_ADCDACControl	    = iDIGIDATABASE + 16#08,
     &	 iBoard_InterruptDMAControl = iDIGIDATABASE + 16#0A,
     &	 iBoard_DigitalIO	    = iDIGIDATABASE + 16#0C,
     &	 iBoard_ChannelScanList     = iDIGIDATABASE + 16#0E,
     &	 iBoard_RealTimeData0	    = iDIGIDATABASE + 16#10,
     &	 iBoard_RealTimeData1	    = iDIGIDATABASE + 16#12,
     &	 iBoard_RealTimeData2	    = iDIGIDATABASE + 16#14,
     &	 iBoard_RealTimeControl     = iDIGIDATABASE + 16#16,
     &	 iBoard_ADCDACStatus	    = iDIGIDATABASE + 16#18,
     &	 iBoard_ResetControl	    = iDIGIDATABASE + 16#1A )

c	 Bit maps for DAC data at 00 (HEX)
c	 DAC bit 0 used to inhibit ADC
	 parameter(  iDACINHIBITADC =	     16#0001 )
c	 Mask out the non-DAC bits
	 parameter(  iDACDATAMASK =	    16#FFF0 )

c	 Bit maps for ADC data at 00 (HEX)
c	 Mask for Tag bit in ADC word
	 parameter(  iADCTAGMASK =	    16#0001 )
c	 Mask for XTrig bit in ADC word
	 parameter(  iADCXTRIGMASK =	     16#0002 )
c	 Mask out the non-ADC bits
	 parameter(  iADCDATAMASK =	    16#FFF0 )

c	 ID value for DD1200
	 parameter(  iDIGIDATA1200ID	    = 2 )

c
c	 Bit maps for ADC/DAC/Trig control regsiter at 08h (HEX)
c	 Enable ADC inhibit via DAC bit 0
	 parameter(  iADCINHIBIT =	     16#0080 )
c	 Enable ADC gearshift timing
	 parameter(  iADCGEARENABLE = 16#0020 )
c	 Enable/disable scanlist programming
	 parameter(  iADCSCANLISTENABLE   = 2#0000000000010000 )
	 parameter(  iADCSCANLISTDISABLE  = 2#1111111111101111 )
c	 Enable/disable split-click mode
	 parameter( iAdcSplitClockEnable =  2#0000000000100000 )
	 parameter( iAdcSplitClockDisable = 2#1111111111011111 )
c	 Enable asynch digital output
	 parameter(  iASYNCHDIGITALENABLE  = 16#0008 )
c	 Enable ADC asynchronous with DAC
	 parameter(  iADCASYNCDAC	   = 16#0004 )
c	 Enable DAC channel 1 for output
	 parameter(  iDACCHAN1ENABLE	   = 16#0002 )
c	 Enable DAC channel 0 for output
	 parameter(  iDACCHAN0ENABLE	   = 16#0001 )

c
c	 Constants for DMA/Interrupt configuration port at 0A (HEX)
c	 Enable interrupt requests
	 parameter(  INTERRUPTENABLE	  = 16#8000 )
c	 Enable interrupt via IRQ 10
	 parameter(  INTERRUPTIRQ10	  = 16#0000 )
c	 Enable interrupt via IRQ 11
	 parameter(  INTERRUPTIRQ11	  = 16#2000 )
c	 Enable interrupt via IRQ 12
	 parameter(  INTERRUPTIRQ12	  = 16#4000 )
c	 Enable interrupt via IRQ 15
	 parameter(  INTERRUPTIRQ15	  = 16#6000 )
c	 Enable interrupt when ADC done
	 parameter(  INTWHENADCDONE	  = 16#0800 )
c	 Enable interrupt on ADC overrun
	 parameter(  INTWHENADCOVERRUN	  = 16#0400 )
c	 Enable interrupt on DMA complete
	 parameter(  INTWHENDMADONE	  = 16#0200 )
c	 Enable interrupt on Timer 4 done
	 parameter(  INTWHENTIMER4DONE	  = 16#0100 )
c	 Enable interrupt on Timer 3 done
	 parameter(  INTWHENTIMER3DONE	  = 16#0080 )
c	 Enable interrupt on Timer 1 done
	 parameter(  INTWHENTIMER1DONE	  = 16#0040 )
c	 Enable ADC single transfer mode
	 parameter(  ADCSINGLEDMA	  = 16#0010 )

c	 Use DMA channel 5
	 parameter(  iDMACHANNEL5	   = 16#0001 )
c	 Use DMA channel 6
	 parameter(  iDMACHANNEL6	   = 16#0002 )
c	 Use DMA channel 7
	 parameter(  iDMACHANNEL7	   = 16#0003 )
c	 DMA channel shift for ADC
	 parameter(  iDMAADCSHIFT	   = 1 )
c	 DMA channel shift for DAC
	 parameter(  iDMADACSHIFT	   = 4 )

c---------------------------------------------------------------------------
c Bit maps for Scan list register at 0E (HEX)
c	Set this bit in last list entry
       parameter(  iSCANLASTENTRYFLAG	 = 16#8000 )
c	Gain bits for gain of 1
       parameter(  iSCANCHANNELGAIN1	 = 16#0000 )
c	Gain bits for gain of 2
       parameter(  iSCANCHANNELGAIN2	 = 16#2000 )
c	Gain bits for gain of 4
       parameter(  iSCANCHANNELGAIN4	 = 16#4000 )
c	Gain bits for gain of 8NULL
       parameter(  iSCANCHANNELGAIN8	 = 16#6000 )
c	Shift for ADC channel number
       parameter(  iSCANCHANNELSHIFT	 = 256 )

c---------------------------------------------------------------------------
c Status code read from ADC/DAC status at 16 (HEX)

c	ADC has overrun the FIFO
       parameter(  iADCOVERRUN		 = 16#0080 )
c	ADC FIFO has one or more samples
       parameter(  iADCDATAREADY	 = 16#0040 )
c	A DMA channel has reached TC
       parameter(  iDMATRANSFERDONE	 = 16#0020 )
c	Timer channel 4 has reached TC
       parameter(  iTIMER4DONE		 = 16#0004 )
c	Timer channel 3 has reached TC
       parameter(  iTIMER3DONE		 = 16#0002 )
c	Timer channel 1 has reached TC
       parameter(  iTIMER1DONE		 = 16#0001 )

c---------------------------------------------------------------------------
c Commands issued to the Clear register at 1A (HEX)
       parameter(  iADCSTARTCONVERT	 = 16#0080 )
       parameter(  iRESETDMADONE	 = 16#0020 )
       parameter(  iRESETADCFLAGS	 = 16#0010 )
       parameter(  iRESET_SCAN_LIST	 = 16#10   )
       parameter(  iRESET_XTRIG_TAG	 = 16#10   )
       parameter(  iRESETDACFLAGS	 = 16#08   )
       parameter(  iRESETTIMER4DONE	 = 16#04   )
       parameter(  iRESETTIMER3DONE	 = 16#02   )
       parameter(  iRESETTIMER1DONE	 = 16#01   )
       parameter(  iRESETWHOLEBOARD	 = 16#7F )

c      Bit-map for the registers accessed from the 9513 Command Port.

       parameter(   iMASTERMODE   =16#17)
       parameter(   iSTATUSREG	  =16#1F)
       parameter(   iMODEREGISTER =16#00)
       parameter(   iLOADREGISTER =16#08)
       parameter(   iHOLDREGISTER =16#10)

c// The following three constants need to be ORed with a counter selector.
       parameter(    iMODE_REG	  =16#00)
       parameter(    iLOAD_REG	  =16#08)
       parameter(    iHOLD_REG	  =16#10)
       parameter(    iCTR1_GRP	  =16#01)
       parameter(    iCTR2_GRP	  =16#02)
       parameter(    iCTR3_GRP	  =16#03)
       parameter(    iCTR4_GRP	  =16#04)
       parameter(    iCTR5_GRP	  =16#05)

c//Commands for the 9513 Command Port.

       parameter(  iARM 	  =16#20)
       parameter(  iLOADCOUNT	  =16#40)
       parameter(  iLOADARM	  =16#60)
       parameter(  iDISARM	  =16#C0)
       parameter(  iCLEAROUT	  =16#E0)
       parameter(  iSETOUT	  =16#E8)
       parameter(  iSET16BITMODE  =16#EF)
       parameter(  iMASTERRESET   =16#FF)

c Master mode configuration
c Set up the Master Mode Register :
c     15 : scaler control = BCD division.	1:BCD
c     14 : enable data pointer auto-increment.	1:Off
c     13 : data-bus width = 8 bits.		1:16-bit
c     12 : FOUT gate ON.			1:Off
c   11-8 : FOUT divider = divided by 16.	0000
c    7-4 : FOUT source = F1 (1MHZ oscillator).
c      3 : comparator 2 disabled.
c      2 : comparator 1 disabled.
c    1-0 : Time of Day disabled.
c*/
       parameter(    iMASTER	  =16#f000)

c Bit-maps for the 9513 counters.

       parameter(  iCOUNTER1	  =16#01)
       parameter(  iCOUNTER2	  =16#02)
       parameter(  iCOUNTER3	  =16#04)
       parameter(  iCOUNTER4	  =16#08)
       parameter(  iCOUNTER5	  =16#10)

c Bit-maps for the counter output states in the 9513 Status register.

       parameter(  iOUT1  = 2 * iCOUNTER1 )
       parameter(  iOUT2  = 2 * iCOUNTER2 )
       parameter(  iOUT3  = 2 * iCOUNTER3 )
       parameter(  iOUT4  = 2 * iCOUNTER4 )
       parameter(  iOUT5  = 2 * iCOUNTER5 )

       parameter( iTOGGLE = 2#10 )
       parameter( iREPEAT_COUNT = 2#100000 )
       parameter( iACTIVE_HIGH_TC = 2#1 )
       parameter( iACTIVE_HIGH_LEVEL_GATE = 16#8000 )

cMinimum timer counts (TC-toggled) for known versions of the board.

c 333 kHz = 3 micro-second period @ 4 MHz TCToggled
       parameter(  MINACQCLOCK		= 6  )
       parameter(  MAXCHANNEL		= 15 )

c Error code
       parameter(  iERROR_BAD	  = 1 )
       parameter(  iERROR_WARNING = 2 )
       parameter(  iERROR_BADKEY  = 3 )

c---------------------------------------------------------------------------

       parameter(    iDIGI_OK	       =   0 )
       parameter(    iDIGI_ID_ERROR    =   1 )
       parameter(    iDIGI_9513_ERROR  =   2 )


c	9513A clock period 2.5E-4 ms
	parameter( clock_period = 0.25E-3 )


C
C	16 bit word DMA channels
C	==========================
C
	PARAMETER(IDMA_PAGE5=16#8B,IDMA_PAGE6=16#89,IDMA_PAGE7=16#8A
     &,IDMA_ADDRESS5=16#C4,IDMA_ADDRESS6=16#C8,IDMA_ADDRESS7=16#CC
     &,IDMA_COUNT5=16#C6,IDMA_COUNT6=16#CA,IDMA_COUNT7=16#CE
     &,IDMA_FFLOP=16#D8,IDMA_MASK=16#D4,IDMA_MODE=16#D6
     &,IDMA_STATUS=16#D0
     &,ICH5_ON=1, ICH6_ON=2, ICH7_ON=3, ITC5=2, ITC6=4,ITC7=8
     &,ich5_off=5, ich6_off=6, ich7_off=7
     &,IWRITE_MODE5=16#45,IREAD_MODE5=16#49
     &,IWRITE_MODE5A=16#55,IREAD_MODE5A=16#59
     &,IWRITE_MODE6=16#46,IREAD_MODE6=16#4A
     &,IWRITE_MODE6A=16#56,IREAD_MODE6A=16#5A
     &,IWRITE_MODE7=16#47,IREAD_MODE7=16#4B
     &,IWRITE_MODE7A=16#57,IREAD_MODE7A=16#5B )

       integer*2 iADCDAC
       common / digicom / iADCDAC
