        subroutine detect_event_mc(det,ibuf,n_points,n_channels,
     &	itrigger_channel,trigger_level,pre_trigger,iout,key)


	integer*2 ibuf(1)	! Circular A/D buffer (must be
				! twice as large as signal to be colllected)
	integer*2 n_channels	! No. of A/D channels (In)
	integer*2 n_points	! No. of samples/channel (In)
	integer*2 itrigger_channel  ! Channel to trigger on (In)
	real*4 trigger_level	! Trigger level (as % of A/D range) (in)
	real*4 pre_trigger	! Pre-trigger points (as % of record size) (in)
	integer*2 iout(1)	! Buffer to hold detected signal (Out)
	character key

	logical quit,positive_trigger,special,first
	parameter( imarker = 32767 )
c
c	Spontaneous signal detector
c	3/7/95 spurious triggering on start-up corrected
c
	np = n_points*n_channels*2
	max_bytes = np*2
	npre_trigger = float(np/2)*pre_trigger/100.
	npost_trigger = ((np/2 - npre_trigger)/n_channels)*n_channels
c
c	Set trigger level in terms of A/D bit range
c
	call get_lab_bit_range( bits_min, bits_max )

	itrigger_level = ((bits_max - bits_min)*trigger_level/100.)

	if( trigger_level .lt. 0. ) then
	    positive_trigger = .false.
	else
	    positive_trigger = .true.
	end if

	quit = .false.

	do i = 1,np
	    ibuf(i) = -2048
	end do


	nold = max_bytes-1
	navg = 0
	first = .true.
	do while( .not. quit )
c
c	    Get current DMA byte count (must be odd)
c
10	    call get_dma_count( nbytes )
	    n = nbytes .and. 2#1
	    if( n .eq. 0 ) goto 10
	    if( nbytes .eq. nold ) goto 10

	    ip = (max_bytes - nold)/2 + 1
	    nold = nbytes

	    if( first ) then
		izero = ibuf(ip)
		first = .false.
	    end if

c	    call move_cursor(1,1)
c	    call display_int(ip)
c	    call display_int( ibuf(ip))
c	    call display_int( izero)
c	    call display_int( itrigger_level )


	    if( mod(ip-itrigger_channel,n_channels) .eq. 0 ) then
c
c		If this is the trigger channel, check to see
c		if it has exceeded the threshold
c
		if( positive_trigger ) then
		    if((ibuf(ip) - izero) .gt. itrigger_level) then
			quit = .true.
			iend = ip + npost_trigger + n_channels
			if( iend .gt. np ) iend = iend - np
			ibuf(iend) = imarker
		    end if
		else
		    if((ibuf(ip) - izero) .lt. itrigger_level) then
			quit = .true.
			iend = ip + npost_trigger + n_channels
			if( iend .gt. np ) iend = iend - np
			ibuf(iend) = imarker
		    end if
		end if
c
c		Update running average
c
		navg = navg + 1
		if( navg .eq. 4 ) then
		    izero = int(
     &		    (float(izero)*7. + float(ibuf(ip)))/8.)
		    navg = 0
		    call get_key( key, special )
		    if( key .eq. '$' ) quit = .true.
		end if
	    end if
	end do
c
c	Collection phase
c
	do while( ibuf(iend) .eq. imarker )
	end do
	call adc_stop()
c
c	Copy signal from circular buffer to O/P buffer
c
	iend = max(iend/n_channels,1)*n_channels
	nout = np/2
	do i = nout,1,-1
	    iout(i) = ibuf(iend)
	    iend = iend-1
	    if( iend .lt. 1 ) iend = iend + np
	end do

	return
	end
