c   National Instruments ATMIO-16F
c   March 1994 (c) John Dempster
c   Uses DMA channels 6 and 7, no interrupts
c   7/4/94 ... Note. set_dacs_atmio16f still does not work properly
c   Under some circumstances, instead of outputing bipolar values
c   it outputs unipolar. It is not clear whether this is a software
c   problem or hardware.
c
	subroutine open_atmio16F( ierr )
$include: 'labat16c.for'

	call outw( icomm1, 16#0000 )	  ! Zero command registers
	call outw( icomm2, 16#0000 )

	call outb( imuxmem_clr, 0 )	! Clear flags
	call outb( iadc_clear, 0 )
	call outb( idac_clear, 0 )
	call outw( idma_clear, 0 )

c	Initialise the AM9513A timer

	call outw( itimer_csr, 16#ffff )	! Master reset
	call outw( itimer_csr, 16#ffef )	! Set 16 bit access mode
	call outw( itimer_csr, 16#ff17 )	! Select master mode reg.
	call outw( itimer_data, 16#f000 )	! Load master mode value
	do i = 1,5
	    call outw( itimer_csr, (16#ff00+i) )
	    call outw( itimer_data, 16#0004 )
	    call outw( itimer_csr, (16#ff08+i) )
	    call outw( itimer_data, 16#0003 )
	end do
	call outw( itimer_csr, 16#ff5f )	 ! Load all counters
c
c	Disable RTSI switch
c
	do i = 1,56
	    call outb( irtsi_shift, 0 )
	end do
	call outb( irtsi_strobe, 0 )

c	Configure command port 2
c	========================
c	Bits 6-8 & bit 11 Configure DMA channel usage
c	Ch.A (6) transfers A/D samples
c	Ch.B (7) transfers D/A samples to DAC 0 & 1
c	(Note DMA controller is not enabled yet, nor is D/A clocking)
c	Bits 13,2,3 Allow counter OUT5 to trigger D/A update
c
	call disable_dma16_channel( 6 )     ! Ensure DMA Ch.6 disabled
	call disable_dma16_channel( 7 )     ! Ensure DMA Ch.7 disabled
	icomm2_state = 2#0010100111001100
	call outw( icomm2, icomm2_state )

	ierr = 0
	return
	end

	subroutine adc_stop_atmio16F
$INCLUDE: 'labat16c.for'
c
c	Stop A/D conversions
c
	call outw( itimer_csr, 16#ffc4 )    ! Disarm counter 3
	call disable_dma16_channel( 6 )
	call outb( iadc_clear, i )	      ! Stop A/D operation
	return
	end

	subroutine check_dt_atmio16f( dt, ticks, ip )
$include: 'labat16c.for'
C
C	Correct sampling period DT so that it produces one
c	of the valid ATMIO clock rates
c
	real*4 dt	    ! Sampling interval (ms) (In/Out)
	real*4 ticks	    ! clock ticks (Out)
	integer*2 ip	    ! Index into clock period array (Out)

	parameter(nperiods=6)
	real*4 period(nperiods) / 2E-4,1E-3,1E-2,1E-1,1.,10. /

	logical done

	ip = 1
	done = .false.
	do while( .not. done )
	    ticks = dt/period(ip)
	    if( (ticks .gt. 32767.) .and. (ip.lt.nperiods) ) then
		ip = ip + 1
	    else
		done = .true.
	    end if
	end do
	ticks = min( float(int(dt/period(ip))), 32767. )
	dt = ticks*period(ip)
	return
	end

	subroutine set_clock_atmio16f( dt )
$INCLUDE: 'labat16c.for'
C
C	Set A/D sampling clock to DT (ms)
c
c
c	Am9315a clock intervals
c	2E-4ms, 1E-3ms, 1E-2,ms,1E-1ms, 1ms    ,10ms
	parameter(nperiods=6)
	integer*2 iperiod(nperiods) /
     &	16#8225, 16#8b25,16#8c25,16#8d25,16#8e25,16#8f25 /
c
c	Find a suitable clock period and interval
c
	call check_dt_atmio16f( dt, ticks, ip )
c
c	Program Am9513a counter 3
c

	call outw( itimer_csr, 16#ff03 )	! Select counter 3 mode reg.
	call outw( itimer_data, iperiod(ip) )	! Load counter clock period
	call outw( itimer_csr, 16#ff0b )	! Select counter 3 load reg.
	call outw( itimer_data, 2 )		! Store load value
	call outw( itimer_csr, 16#ff44 )	! Load counter 3
	call outw( itimer_csr, 16#fff3 )	! Set counter to decrement
	call outw( itimer_data, int(ticks) )	! Interval to load reg.

	return
	end

	subroutine adc_to_memory_atmio16f(dt,n_channels,n_points,itrigger,
     &	ibuffer,istart,imode,adc_range,key_returned)
$INCLUDE: 'labat16c.for'

	INTEGER IBUFFER(1)
C
C	Input arguments
C	DT =         Group sampling period (ms)
C	N_CHANNELS = No. A/D channels to be scanned
C	N_POINTS =   No. of sample groups held by IBUFFER
C	ITRIGGER =   1 Wait for external trigger before starting sampling
C	             0 Start sampling immediately
C	IBUFFER =    DMA Memory buffer to hold ADC samples
C	ISTART =     Starting point in IBUFFER
C			   either 1, or (N_POINTS*N_CHANNELS)/2 + 1
C	IMODE =      0 Wait till IBUFFER is full before returning
C	             1 Return once sampling has started, collect
C	               a single buffer-ful
C	             2 Return once sampling has started, keep
C	               filling IBUFFEr circulerly until told to stop
C	ADC_RANGE =  Input voltage range
C	KEY_RETURNED = Key pressed by user during sampling

	CHARACTER*(*) KEY_RETURNED
	CHARACTER KEY
	LOGICAL end_of_sweep,done
	real*4 range(8),vdac(2)
C
C	CODE
C
c
c	Ensure counter 3 (A/D sampling timer) is disarmed
c
	call outw( itimer_csr, 16#ffc4 )    ! Disarm counter 3

C	Inter-sample interval is channel group sampling interval
C	divided by number of channels in group. Note that DT1 and DT
C	are modified after SET_CLOCK_ATMIO16f to be precisely equal to an
C	interval supported by the interface.
C
	dt1 = dt / float(n_channels)
	call set_clock_atmio16f( dt1 )
	dt = dt1 * float(n_channels)
c
c	Clear A/D & DMA flags
c
	call outw( icomm1, 0 )
	call outb( iadc_clear, 0 )
	call outw( idma_clear, 0 )
c
c	Clear out any data in A/D FIFO
c
	done = .false.
	do while( .not. done )
	    call inpw( istatus, iword )
	    iword = iword .and. idata_in_fifo
	    if( iword .ne. 0 ) then
		call inpb( iadc, iword )
	    else
		done = .true.
	    end if
	end do

c
c	Derive channel gain value from input voltage range
c	(Note list of ranges defined in GET_ADC_RANGE in LAB.FOR)
c	(adc_range in V) +/-10V = gain of 1, +/-0.05V = gain of 100
c
	call get_adc_ranges( 16, range, nr )
	igain = 1
	do while( (range(igain) .gt. (adc_range+.01) )
     &	    .and. (igain.lt.nr) )
	    igain = igain + 1
	end do
	adc_range = range(igain)

c
c	Set A/D channel/gain list
c
	call outb( imuxmem_clr, 0 )	! Clear MUX memory
	do ichan = 1,n_channels
	    iword = (ichan-1)*2#10000 .or. (igain-1)*2#10
	    if( ichan .eq. n_channels ) iword = iword .or. 2#1
	    call outw( imuxmem,iword)
	end do
	call outb( imuxmem_ld,0)	 ! Finish loading
C
C --	Set-up DMA controller for transfer to memory --
C
C	Select auto-initialise or single sweep DMA mode
C
	call disable_dma16_channel( 6 )
	IF(IMODE.EQ.2) THEN
c
c	    Set DMA to write to memory, auto-initialise
	    call set_dma16_mode( 6, iwrite, iauto_init )
	ELSE
c	    Set DMA to write to memory
	    call set_dma16_mode( 6, iwrite, isingle_sweep )
	ENDIF
	nwords = N_POINTS*N_CHANNELS
	CALL set_dma16_ADDRESS(IBUFFER,ISTART,nwords,6)
c
c	Add marker to buffer if in single sweep modes
c
	if( imode .le. 1 ) call mark_buffer( ibuffer(istart), nwords)

	CALL set_dma16_COUNT(nwords-1,6)
	call enable_dma16_channel( 6 )

c
c	Arm counter 3, so that it can start initiating A/D conversions
c	when a software or external trigger occurs
c
	call outw( itimer_csr, 16#ff24 )	! Arm counter 3
c
c	Enable data acquisition
c	and multiple channel scanning (if more than 1 channel)
c
	iword = idaqen
	if( n_channels .gt. 1 ) iword = iword .or. iscanen
	call outw( icomm1, iword )

	if( itrigger .eq. 0 ) then
c
c	    Start A/D conversions immediately
c	    (Note. EXT. TRIG input (I/O pin 38) must be high (5V)
c	     in order to allow the IDAQ_START command to work.
c	     Since EXT TRIG. is often connected to DAC1,
c	     it is set to 5V here)

	    vdac(1) = 0.
	    vdac(2) = 5.
	    call set_dacs_atmio16f( vdac, 2 )

	    call outb( idaq_start, 0 )

	    vdac(1) = 0.
	    vdac(2) = 0.
	    call set_dacs_atmio16f( vdac, 2 )
	end if

C
C	If IMODE = 0 wait here till conversions are completed

	clock_start = time_in_secs()

	IERR = 0
	if( IMODE .EQ. 0 ) then
	    end_of_sweep = .false.
	    do while( .not. end_of_sweep )
		call check_sweep(
     &		ibuffer(istart), nwords, end_of_sweep, key )
		IF( KEY .NE. CHAR(0) ) KEY_RETURNED = KEY
	    end do

	    call adc_stop_atmio16f
	    call convert_adc_values( ibuffer(istart), nwords   )

	end if

	return
	end

	subroutine memory_to_dac_atmio16F( dt, nchans, npoints, itrig,
     &	ibuffer, imode, ierr )
$include:'labat16c.for'
	integer*2 ibuffer(1)
c
c	Do D/A output to DAC 0 ( or DAC 0 and 1 ) of using values
c	from buffer <ibuffer> containing <npoints> values per channel,
c	updating at intervals of <dt> ms. <nchans> = no. of D/A channels
c	in use (1 or 2). If <imode>=0 wait for D/A sequence to complete
c	before returning, <imode>=1 setup D/A output and return immediately.
c
	parameter(nperiods=6)
	integer*2 iperiod(nperiods) /
     &	16#0225,16#0b25,16#0c25,16#0d25,16#0e25,16#0f25 /

c
c	code
c
c
c	Make sure counter 5 is not running
c
	call outw( itimer_csr, 16#ffd0 )	! Disarm counter 5
c
c	Initialise DAC circuitry
c
	call outb( idac_clear, 0 )
c
c	Convert from 0-4097 to -2047 - 2048 range
c
	do i = 1,npoints*nchans
	    ibuffer(i) = ibuffer(i) - 2048
	end do
c
c	Set D/A update interval to DT (ms)
c	Am9513A counter 5 is used to update DACs
c
	call check_dt_atmio16f( dt, ticks, ip )    ! Get ticks and period
C
C --	Set-up DMA controller for transfer from memory to DACs --
C
	call disable_dma16_channel( 7 )
	call set_dma16_mode( 7, iread, isingle_sweep )
	nwords = npoints*nchans
	CALL set_dma16_ADDRESS(IBUFFER,ISTART,nwords,7)
	CALL set_dma16_COUNT(nwords-1,7)
	call enable_dma16_channel( 7 )

	call outw( itimer_csr, 16#ff05 )	! Select counter 5 mode reg.
	call outw( itimer_data, iperiod(ip) )	! Load counter clock period
	call outw( itimer_csr, 16#ff0d )	! Select counter 5 load reg.
	call outw( itimer_data, int(ticks) )	! Insert update value

	call outw( itimer_csr, 16#ff70 )	! Load and arm counter
						! starting DAC output

	return
	end

	subroutine set_dacs_atmio16f( vdac, ndacs )
$include:'labat16c.for'
	real vdac(ndacs)
	parameter( bitv = 10. / 2048. )
c
c	**** WARNING **** 7/4/94
c	This routine still has a bug in it. Under some circumstances,
c	it outputs only unipolar values (0-10V) instead of bipolar
c	e.g. when a value of -1V is requested, 9V results. It does
c	not do this consistently.
c
c	code
c
	call dac_stop_atmio16f
c
c	Waveform generation bit WGEN and DMA bits turned off to allow
c	DACs to be directly updated.

	ikeep_state = icomm2_state
	icomm2_state = icomm2_state .and. 2#1101111000111111
	call outw( icomm2, icomm2_state )

	iword = int( vdac(1) / bitv )
	call outw( idac0, iword )
	call outw( idac0, iword )

	if( ndacs .gt. 1 ) then
	    iword = int( vdac(2) / bitv )
	    call outw( idac1, iword )
	    call outw( idac1, iword )
	end if
	call inpb( idac_update, ii )
c
c	Restore DMA and WGEN bits
c
	icomm2_state = ikeep_state
	call outw( icomm2, icomm2_state )
	return
	end

	subroutine dac_stop_atmio16f
$include:'labat16c.for'
c
c	Stop D/A output (by disarming counter 5 ),
c	flush DAC FIFO
c
	call outw( itimer_csr, 16#ffd0 )	! Disarm counter 5
	call outb( idac_clear, 0 )		! Clear DAC flags
	call disable_dma16_channel( 7 )
	return
	end


	subroutine enable_dma16_channel( idma_chan )
$include:'labat16c.for'
	imask = idma_chan - 4
	CALL OUTB( IDMA_MASK, imask )
	return
	end

	subroutine disable_dma16_channel( idma_chan )
$include:'labat16c.for'
	imask = idma_chan
	CALL OUTB( IDMA_MASK, imask )
	return
	end

	subroutine set_dma16_mode( idma_chan, irw, iautoinit )
$include:'labat16c.for'
c
c	Set DMA channel operating mode
c	idma_chan =5,6,7
c	irw = 0 for read from memory, 1 for write to memory
c	iautoinit = 1 for autoinitialise at end of transfer

	imode = idma_chan .or. 16#40
	if( irw .eq. iread ) imode = imode + 16#4
	if( iautoinit .eq. 1 ) imode = imode + 16#10
	call outb( idma_mode, imode )
	return
	end

	subroutine show_status_atmio16f
$include:'labat16c.for'

	call move_cursor(1,1)
	call inpw( istatus, iword )
	call display_bits( iword  )
	call inpw( itimer_csr, iword )
	call display_bits( iword  )
	return
	end
