c
c	Port addresses
c
	parameter(
     &	ibase = 16#220,
     &	icomm1 = ibase,
     &	icomm2 = ibase+2,
     &	istatus = ibase,
     &	istart_convert=ibase+8,
     &	idaq_start=ibase+16#a,
     &	iadc_clear=ibase+16#c,
     &	iext_strobe=ibase+16#e,
     &	idma_clear=ibase+16#16,
     &	idac0 = ibase+16#10,
     &	idac1 = ibase+16#12,
     &	idac_clear=ibase+16#14,
     &	idac_update=ibase+16#e,
     &	imuxmem_clr = ibase+16#5,
     &	imuxmem_ld = ibase+16#4,
     &	imuxmem = ibase+16#6,
     &	iadc_fifo = ibase+16#16,
     &	itimer_data = ibase+16#18,
     &	itimer_csr = ibase+16#1a,
     &	idig_in = ibase+16#1c,
     &	idig_out = ibase+16#1c,
     &	irtsi_shift = ibase+16#0e,
     &	irtsi_strobe = ibase+16#0f )
c
c	Bit flags
c
	parameter(
     &	ibit0 = 		 2#1,
     &	ibit1 = 		2#10,
     &	ibit2 = 	       2#100,
     &	ibit3 = 	      2#1000,
     &	ibit4 = 	     2#10000,
     &	ibit5 = 	    2#100000,
     &	ibit6 = 	   2#1000000,
     &	ibit7 = 	  2#10000000,
     &	ibit8 = 	 2#100000000,
     &	ibit9 = 	2#1000000000,
     &	ibit10 =       2#10000000000,
     &	ibit11 =      2#100000000000,
     &	ibit12 =     2#1000000000000,
     &	ibit13 =    2#10000000000000,
     &	ibit14 =   2#100000000000000,
     &	ibit15 =  2#1000000000000000,
     &	ibit16 = 2#10000000000000000 )

	parameter(
     &	idaqcomp = ibit15,
     &	idaqen = ibit7,
     &	iscanen = ibit6,
     &	isingle_ended = ibit1,
     &	iai_sense = ibit2,
     &	idata_in_fifo = ibit12,
     &	ichan_last = ibit0,
     &	idma_on =   2#0000100000000000,
     &	idma_off =  2#1111011111111111,
     &	iwgen_on =  2#0010000000000000,
     &	iwgen_off = 2#1101111111111111,
     &	iunipolar = 2#0000000000000001,
     &	ia4rcv = ibit3,
     &	ia4drv = ibit2 )
C
C	16 bit word DMA channels
C	==========================
C
	PARAMETER(IDMA_PAGE5=16#8B,IDMA_PAGE6=16#89,IDMA_PAGE7=16#8A
     &,IDMA_ADDRESS5=16#C4,IDMA_ADDRESS6=16#C8,IDMA_ADDRESS7=16#CC
     &,IDMA_COUNT5=16#C6,IDMA_COUNT6=16#CA,IDMA_COUNT7=16#CE
     &,IDMA_FFLOP=16#D8,IDMA_MASK=16#D4,IDMA_MODE=16#D6
     &,IDMA_STATUS=16#D0
     &,ICH5_ON=1, ICH6_ON=2, ICH7_ON=3, ITC5=2, ITC6=4,ITC7=8
     &,ich5_off=5, ich6_off=6, ich7_off=7
     &,IWRITE_MODE5= 16#45,IREAD_MODE5= 16#49
     &,IWRITE_MODE5A=16#55,IREAD_MODE5A=16#59
     &,IWRITE_MODE6= 16#46,IREAD_MODE6= 16#4A
     &,IWRITE_MODE6A=16#56,IREAD_MODE6A=16#5A
     &,IWRITE_MODE7= 16#47,IREAD_MODE7= 16#4B
     &,IWRITE_MODE7A=16#57,IREAD_MODE7A=16#5B )

	parameter( iread=0, iwrite=1, iauto_init=1, isingle_sweep=0 )

c      Bit-map for the registers accessed from the 9513 Command Port.

       parameter(   iMASTERMODE   =16#17)
       parameter(   iSTATUSREG	  =16#1F)
       parameter(   iMODEREGISTER =16#00)
       parameter(   iLOADREGISTER =16#08)
       parameter(   iHOLDREGISTER =16#10)

c// The following three constants need to be ORed with a counter selector.
       parameter(    iMODE_REG	  =16#00)
       parameter(    iLOAD_REG	  =16#08)
       parameter(    iHOLD_REG	  =16#10)
       parameter(    iCTR1_GRP	  =16#01)
       parameter(    iCTR2_GRP	  =16#02)
       parameter(    iCTR3_GRP	  =16#03)
       parameter(    iCTR4_GRP	  =16#04)
       parameter(    iCTR5_GRP	  =16#05)

c//Commands for the 9513 Command Port.

       parameter(  iARM 	  =16#20)
       parameter(  iLOADCOUNT	  =16#40)
       parameter(  iLOADARM	  =16#60)
       parameter(  iDISARM	  =16#C0)
       parameter(  iCLEAROUT	  =16#E0)
       parameter(  iSETOUT	  =16#E8)
       parameter(  iSET16BITMODE  =16#EF)
       parameter(  iMASTERRESET   =16#FF)

       parameter(    iMASTER	  =16#f000)

c Bit-maps for the 9513 counters.

       parameter(  iCOUNTER1	  =16#01)
       parameter(  iCOUNTER2	  =16#02)
       parameter(  iCOUNTER3	  =16#04)
       parameter(  iCOUNTER4	  =16#08)
       parameter(  iCOUNTER5	  =16#10)

c Bit-maps for the counter output states in the 9513 Status register.

       parameter(  iOUT1  = 2 * iCOUNTER1 )
       parameter(  iOUT2  = 2 * iCOUNTER2 )
       parameter(  iOUT3  = 2 * iCOUNTER3 )
       parameter(  iOUT4  = 2 * iCOUNTER4 )
       parameter(  iOUT5  = 2 * iCOUNTER5 )

       parameter( iTOGGLE = 2#10 )
       parameter( iREPEAT_COUNT = 2#100000 )
       parameter( iACTIVE_HIGH_TC = 2#1 )
       parameter( iACTIVE_HIGH_LEVEL_GATE = 16#8000 )

	common /labat16f/ icomm2_state

c
