$NOTRUNCATE
$STORAGE:2
	SUBROUTINE GRAPHICS_TEXT(IDEVICE,NDC_XYPOS,TEXT)
C
C -- Draw TEXT at coords. in NDC_XY
C
$INCLUDE:'GEMCOM.FOR'
C
	CHARACTER*(*) TEXT
	INTEGER NDC_XYPOS(1),IDUMMY,ICONTRL(7),IXY(2)
	DATA ICONTRL /8,1,0,0,0,0,0/
C
	NC = LEN(TEXT)
	IF(NC .GT. 80) NC = 80
C
C	Store characters (one/integer) in ndc_xy work array
C
	DO 10 I = 1,NC
		INTIN(I) = ICHAR(TEXT(I:I))
10	CONTINUE
C
	ICONTRL(4) = NC
	ICONTRL(7) = IDEVICE
	IXY(1) = NDC_XYPOS(1)
	IF(NDC_XYPOS(2).GT.NDC_MAX - ICHAR_HEIGHT) THEN
		IKEEP = NDC_XYPOS(2)
		IXY(2) = NDC_MAX - ICHAR_HEIGHT
	ELSE
		IXY(2) = NDC_XYPOS(2)
	ENDIF
	CALL VDI( I,I,IXY,INTIN,ICONTRL)
	RETURN
	END

	SUBROUTINE DISPLAY_STRING(STRING)
C
$INCLUDE:'GEMCOM.FOR'
	CHARACTER*(*) STRING

c
c	Erase background for string
c
	IPTSIN(1) = ICURSOR_XY(1)
	IPTSIN(2) = ICURSOR_XY(2)
	IPTSIN(3) = IPTSIN(1) + LEN(STRING)*ICHAR_WIDTH - IPIXEL_WIDTH
	IPTSIN(4) = IPTSIN(2) + ICHAR_HEIGHT - IPIXEL_HEIGHT
	CALL FILL_RECTANGLE(ISCREEN,IPTSIN)
c
c	Display string
c
	CALL GRAPHICS_TEXT(ISCREEN,ICURSOR_XY,STRING)
	ICURSOR_XY(1) = ICURSOR_XY(1) + ICHAR_WIDTH*LEN(STRING)
	RETURN
	END

	SUBROUTINE NEW_LINE
$INCLUDE:'GEMCOM.FOR'
	I = ICURSOR_XY(2)
	I = I - ICHAR_HEIGHT
	IF(I.LT.IBOTTOM_MARGIN) I = I + ICHAR_HEIGHT
	ICURSOR_XY(2) = I
	ICURSOR_XY(1) = ILEFT_MARGIN
	RETURN
	END

	SUBROUTINE CURSOR_HOME
$INCLUDE:'GEMCOM.FOR'
	ICURSOR_XY(1) = ILEFT_MARGIN
	ICURSOR_XY(2) = ITOP_MARGIN
	RETURN
	END

	SUBROUTINE CURSOR_LEFT
$INCLUDE:'GEMCOM.FOR'
	I = ICURSOR_XY(1)
	I = I - ICHAR_WIDTH
	IF(I.GE.ILEFT_MARGIN) ICURSOR_XY(1) = I
	RETURN
	END

	SUBROUTINE CURSOR_RIGHT
$INCLUDE:'GEMCOM.FOR'
	I = ICURSOR_XY(1)
	I = I + ICHAR_WIDTH
	IF(I.LE.IRIGHT_MARGIN) ICURSOR_XY(1) = I
	RETURN
	END

	SUBROUTINE CURSOR_UP
$INCLUDE:'GEMCOM.FOR'
	I = ICURSOR_XY(2)
	I = I + ICHAR_HEIGHT
	IF(I.LE.ITOP_MARGIN) ICURSOR_XY(2) = I
	RETURN
	END

	SUBROUTINE CURSOR_DOWN
$INCLUDE:'GEMCOM.FOR'
	I = ICURSOR_XY(2)
	I = I - ICHAR_HEIGHT
	IF(I.GE.IBOTTOM_MARGIN) ICURSOR_XY(2) = I
	RETURN
	END

	SUBROUTINE MOVE_CURSOR(ICOLUMN,IROW)
$INCLUDE:'GEMCOM.FOR'
	ICURSOR_XY(1) = (ICOLUMN-1)*ICHAR_WIDTH
	ICURSOR_XY(2) = (MAX_ROWS - IROW)*ICHAR_HEIGHT
	RETURN
	END

	SUBROUTINE FIND_CURSOR(ICOLUMN,IROW)
$INCLUDE:'GEMCOM.FOR'
	ICOLUMN = ICURSOR_XY(1)/ICHAR_WIDTH + 1
	IROW = MAX_ROWS - ICURSOR_XY(2)/ICHAR_HEIGHT
	RETURN
	END

	SUBROUTINE CURSOR_ON
$INCLUDE:'GEMCOM.FOR'
	CALL SET_POLYLINE_COLOUR(ISCREEN,0)
	IPTSIN(1) = ICURSOR_XY(1)
	IPTSIN(2) = ICURSOR_XY(2)
	IPTSIN(3) = ICURSOR_XY(1) + ICHAR_WIDTH
	IPTSIN(4) = IPTSIN(2)
	CALL POLYLINE(ISCREEN,IPTSIN,2)
	RETURN
	END

	SUBROUTINE CURSOR_OFF(KEY)
	CHARACTER KEY
$INCLUDE:'GEMCOM.FOR'
	INTEGER ICONTRL(7)
	DATA ICONTRL /8,1,0,0,0,0,0/
C
	CALL SET_POLYLINE_COLOUR(ISCREEN,1)
	IPTSIN(1) = ICURSOR_XY(1)
	IPTSIN(2) = ICURSOR_XY(2)
	IPTSIN(3) = ICURSOR_XY(1) + ICHAR_WIDTH
	IPTSIN(4) = IPTSIN(2)
	CALL POLYLINE(ISCREEN,IPTSIN,2)
C
C	Re-write character in case descender has been lost
C
	INTIN(1) = ICHAR(KEY)
	ICONTRL(4) = 1
	ICONTRL(7) = ISCREEN
	CALL VDI(IPTSOUT,INTOUT,ICURSOR_XY,INTIN,ICONTRL)
	RETURN
	END

	SUBROUTINE FILL_RECTANGLE(IDEVICE,IXY)
$INCLUDE:'GEMCOM.FOR'
	INTEGER IXY(4)
	INTEGER ICONTRL(7)
	DATA ICONTRL /114,2,0,0,0,0,0/ 
C
	ICONTRL(7) = IDEVICE
	CALL VDI(IPTSOUT,INTOUT,IXY,INTIN,ICONTRL)
	RETURN
	END

	SUBROUTINE ERASE_ALL
$INCLUDE:'GEMCOM.FOR'
	IPTSIN(1) = 0
	IPTSIN(2) = 0
	IPTSIN(3) = NDC_MAX
	IPTSIN(4) = NDC_MAX
	CALL FILL_RECTANGLE(ISCREEN,IPTSIN)
	RETURN
	END

	SUBROUTINE ERASE_EOS
$INCLUDE:'GEMCOM.FOR'
	IPTSIN(1) = iLEFT_MARGIN
	IPTSIN(2) = ICURSOR_XY(2) + ICHAR_HEIGHT - IPIXEL_HEIGHT
	IPTSIN(3) = IRIGHT_MARGIN + ICHAR_WIDTH - IPIXEL_WIDTH
	IPTSIN(4) = IBOTTOM_MARGIN
	CALL FILL_RECTANGLE(ISCREEN,IPTSIN)
	RETURN
	END

	SUBROUTINE ERASE_EOL
$INCLUDE:'GEMCOM.FOR'
	IPTSIN(1) = iLEFT_MARGIN
	IPTSIN(2) = ICURSOR_XY(2)
	IF(IPTSIN(2).LT.0) IPTSIN(2) = 0
	IPTSIN(3) = IRIGHT_MARGIN + ICHAR_WIDTH - IPIXEL_WIDTH
	IPTSIN(4) = IPTSIN(2) + ICHAR_HEIGHT - IPIXEL_HEIGHT
	IF(IPTSIN(4).LT.0) IPTSIN(4) = 0
	CALL FILL_RECTANGLE(ISCREEN,IPTSIN)
	RETURN
	END

	SUBROUTINE DISPLAY_BOX(ILEFT,ITOP,IRIGHT,IBOTTOM)
$INCLUDE:'GEMCOM.FOR'
	IPTSIN(1) = ILEFT*ICHAR_WIDTH - ICHAR_WIDTH/2
	IPTSIN(2) = (MAX_ROWS-IBOTTOM)*ICHAR_HEIGHT + ICHAR_HEIGHT/2
	IPTSIN(3) = IRIGHT*ICHAR_WIDTH - ICHAR_WIDTH/2
	IPTSIN(4) = IPTSIN(2)
	IPTSIN(5) = IPTSIN(3)
	IPTSIN(6) = (MAX_ROWS - ITOP)*ICHAR_HEIGHT + ICHAR_HEIGHT/2
	IPTSIN(7) = IPTSIN(1)
	IPTSIN(8) = IPTSIN(6)
	IPTSIN(9) = IPTSIN(1)
	IPTSIN(10) = IPTSIN(2)
	CALL POLYLINE(ISCREEN,IPTSIN,5)
	RETURN
	END

	SUBROUTINE ERASE_BOX(ILEFT,ITOP,IRIGHT,IBOTTOM)
$INCLUDE:'GEMCOM.FOR'
	IPTSIN(1) = (ILEFT-1)*ICHAR_WIDTH
	IPTSIN(2) = (MAX_ROWS - IBOTTOM)*ICHAR_HEIGHT
	IPTSIN(3) = MAX0(IRIGHT*ICHAR_WIDTH,0)
	IF(ITOP.EQ.1) THEN
		IPTSIN(4) = NDC_MAX
	ELSE
		IPTSIN(4) = (MAX_ROWS-ITOP+1)*ICHAR_HEIGHT
	ENDIF
	CALL FILL_RECTANGLE(ISCREEN,IPTSIN)
	RETURN
	END

	SUBROUTINE DISPLAY_REVERSED(STRING)
$INCLUDE:'GEMCOM.FOR'
C
C	Display a string in reverse video
C
	CHARACTER*(*) STRING
C
	IPTSIN(1) = ICURSOR_XY(1)
	IPTSIN(2) = ICURSOR_XY(2)
	IPTSIN(3) = IPTSIN(1) + LEN(STRING)*ICHAR_WIDTH - IPIXEL_WIDTH
	IPTSIN(4) = IPTSIN(2) + ICHAR_HEIGHT - IPIXEL_HEIGHT
C
C	Set fill to solid to provide reversed background
C	Set text colour to background & writing mode to transparent
C
	CALL REVERSE_VIDEO_ON
	CALL FILL_RECTANGLE(ISCREEN,IPTSIN)
	CALL DISPLAY_STRING(STRING)
C
C	Set back to normal
C
	CALL REVERSE_VIDEO_OFF
	RETURN
	END

	SUBROUTINE REVERSE_VIDEO_ON
$INCLUDE:'GEMCOM.FOR'
	CALL SET_FILL_INTERIOR_STYLE(ISCREEN,1)
	CALL SET_TEXT_COLOUR(ISCREEN,0)
	CALL SET_POLYLINE_COLOUR(ISCREEN,0)
	CALL SET_WRITING_MODE(ISCREEN,2)
	RETURN
	END

	SUBROUTINE REVERSE_VIDEO_OFF
$INCLUDE:'GEMCOM.FOR'
	CALL SET_FILL_INTERIOR_STYLE(ISCREEN,0)
	CALL SET_TEXT_COLOUR(ISCREEN,1)
	CALL SET_POLYLINE_COLOUR(ISCREEN,1)
	CALL SET_WRITING_MODE(ISCREEN,0)
	RETURN
	END

	SUBROUTINE DISPLAY_CHARACTER_REVERSED(KEY)
$INCLUDE:'GEMCOM.FOR'
	CHARACTER KEY
	INTEGER ICONTRL(7)
	DATA ICONTRL /8,1,0,0,0,0,0/
C
C	Blank character space to fore or background depending
C	on REVERSE_VIDEO ON or OFF
C
	CALL SET_WRITING_MODE(ISCREEN,0)
	IPTSIN(1) = ICURSOR_XY(1)
	IPTSIN(2) = ICURSOR_XY(2)
	IPTSIN(3) = IPTSIN(1) + ICHAR_WIDTH - IPIXEL_WIDTH
	IPTSIN(4) = IPTSIN(2) + ICHAR_HEIGHT - IPIXEL_HEIGHT
	CALL FILL_RECTANGLE(ISCREEN,IPTSIN)
	CALL SET_WRITING_MODE(ISCREEN,2)
	INTIN(1) = ICHAR(KEY)
C
	ICONTRL(4) = 1
	ICONTRL(7) = ISCREEN
	CALL VDI(IPTSOUT,INTOUT,ICURSOR_XY,INTIN,ICONTRL)
	ICURSOR_XY(1) = ICURSOR_XY(1) + ICHAR_WIDTH
	RETURN
	END

	SUBROUTINE UPPER_CASE(STRING)
C
C	Convert a character string to upper case
C
	CHARACTER*(*) STRING
	CHARACTER*2 C
	DATA ICA,ICZ /97,122/
C
C ** N.B. THESE 2 LINES REQUIRED FOR CORRECT OPERATION
C	POSSIBLY A COMPILER BUG HERE.
C
	IC = ICHAR(STRING(1:1))
	C = CHAR(IC)
C ****************************************************
C
	DO 10 I=1,LEN(STRING)
		IC = ICHAR(STRING(I:I))
		IF((IC.GE.ICA) .AND. (IC.LE.ICZ) ) THEN
			STRING(I:I) = CHAR( IAND(IC,223) )
		ENDIF
10	CONTINUE
	RETURN
	END

	SUBROUTINE LOWER_CASE(STRING)
C
C	Convert a character string to lower case
C
	CHARACTER*(*) STRING
	CHARACTER*2 C
	DATA ICA,ICZ /65,90/
C
	IC = ICHAR(STRING(1:1))
	C = CHAR(IC)
	DO 10 I=1,LEN(STRING)
		IC = ICHAR(STRING(I:I))
		IF((IC.GE.ICA) .AND. (IC.LE.ICZ) ) THEN
			STRING(I:I) = CHAR( IOR(IC,32) )
		ENDIF
10	CONTINUE
	RETURN
	END

	integer function itrailing_space( string )
	character*(*) string

	nc = len( string )
	do 10 i = nc,1,-1
	    if( string(i:i) .ne. ' ' ) goto 11
10	continue
11	continue
	itrailing_space = max0(i,1)
	return
	end

	integer function ileading_space( string )
	character*(*) string

	nc = len( string )
	do 10 i = 1,nc
	    if( string(i:i) .ne. ' ' ) goto 11
10	continue
11	continue
	ileading_space = min0(i,nc)
	return
	end

	SUBROUTINE ADD_STRING(ADD,DEST)
	IMPLICIT INTEGER(A-Z)
C
C	Adds string ADD to string DEST after removing trailing spaces
C
	CHARACTER*(*) ADD
	CHARACTER*(*) DEST
C
C	CODE
C	----
C
	NCA = LEN(ADD)
	NCD = LEN(DEST)
C
C	Find end of text in DEST
C
	DO 10 I = NCD,1,-1
		IF(DEST(I:I) .NE. ' ') GOTO 11
10	CONTINUE
11	CONTINUE
	START = I+1
C
C	Find end of text in ADD
C
	DO 20 I = NCA,1,-1
		IF(ADD(I:I) .NE. ' ') GOTO 21
20	CONTINUE
	I = I + 1
21	CONTINUE
	NCA = I
C
C	Copy ADD on to the end of DEST
C	(Ensure that NCA remains within length of DEST)
C
	DEST(START:LEN(DEST)) = ADD(1:NCA)
	RETURN
	END

	SUBROUTINE DISPLAY_INT(I)
	CHARACTER*6 STRING

	WRITE(STRING,900) I
900	FORMAT(I6)
	CALL DISPLAY_STRING(STRING)
	RETURN
	END

	SUBROUTINE DISPLAY_FLT(X)
	CHARACTER*11 STRING
	WRITE(STRING,900) X
900	FORMAT(G11.2)
	CALL DISPLAY_STRING(STRING)
	RETURN
	END

	subroutine display_stringt( string )
	character*(*) string
	nc = min(len_trim(string)+1,len(string))
	call display_string( string(1:nc) )
	return
	end



