$NOTRUNCATE
$STORAGE:2
	SUBROUTINE DRAW_LINE(IDEVICE,XY_IN,NP)
C
C	Convert REAL internal coordinates into NDC
C	and draw polyline. xy contains REAL coords. np = No. of vertices
C
	REAL XY_IN(1)
C
$INCLUDE:'GEMCOM.FOR'
C
	CALL ENABLE_CLIPPING( IDEVICE )

	NPLOT = NP
	IS = 1
10	IF(NPLOT.LE.127) GOTO 20
C
C	    Plot groups of 128 points
C
	    CALL CONVERT_TO_NDC( XY_IN(IS), IPTSIN, 128 )
	    CALL POLYLINE( IDEVICE, IPTSIN, 128 )
	    NPLOT = NPLOT - 127
	    IS = IS + 254
	    GOTO 10
20	IF(NPLOT.GT.1) THEN
C
C	    Plot any remaining points
C
	    CALL CONVERT_TO_NDC(XY_IN(IS),IPTSIN,NPLOT)
	    CALL POLYLINE( IDEVICE, IPTSIN, NPLOT )
	ENDIF

	CALL DISABLE_CLIPPING(IDEVICE)

	RETURN
	END

	SUBROUTINE DRAW_MARKER(IDEVICE,XY_IN,NP)
C
C	Convert REAL internal coordinates into NDC
C	and draw polymarker. xy contains REAL coords. np = No. of vertices
C
	REAL XY_IN(1)
$INCLUDE:'GEMCOM.FOR'
C

	CALL ENABLE_CLIPPING( IDEVICE )


	NPLOT = NP
	IS = 1
10	IF(NPLOT.LE.127) GOTO 20
C
C	    Plot groups of 128 points
C
	    CALL CONVERT_TO_NDC( XY_IN(IS), IPTSIN, 128 )
	    CALL POLYMARKER( IDEVICE, IPTSIN, 128 )
	    NPLOT = NPLOT - 127
	    IS = IS + 254
	    GOTO 10
20      IF(NPLOT.GT.0) THEN
C
C	    Plot any remaining points
C
	    CALL CONVERT_TO_NDC(XY_IN(IS),IPTSIN,NPLOT)
	    CALL POLYMARKER( IDEVICE, IPTSIN, NPLOT )
	ENDIF

	CALL DISABLE_CLIPPING(IDEVICE)

	RETURN
	END

	SUBROUTINE ENABLE_CLIPPING(IDEVICE)
$INCLUDE:'GEMCOM.FOR'
C
	INTEGER IXY(4),ICONTRL(7),IDUMMY
	DATA ICONTRL /129,2,0,1,0,0,0/
C
	ICONTRL(7) = IDEVICE
C
C	Set clipping rectangle
C
	IXY(1) = NDC_XMIN
	IXY(2) = NDC_YMIN
	IXY(3) = NDC_XMAX
	IXY(4) = NDC_YMAX
C
C	Enable clip
C
	INTIN(1) = 1
	CALL VDI( I, I, IXY, INTIN, ICONTRL )
	RETURN
	END


	SUBROUTINE DISABLE_CLIPPING(IDEVICE)
$INCLUDE:'GEMCOM.FOR'
C
	INTEGER IXY(4),ICONTRL(7)
	DATA ICONTRL /129,2,0,1,0,0,0/
C
	ICONTRL(7) = IDEVICE
C
C	Set clipping rectangle
C
	IXY(1) = NDC_XMIN
	IXY(2) = NDC_YMIN
	IXY(3) = NDC_XMAX
	IXY(4) = NDC_YMAX
C
C	Disable clip
C
	INTIN(1) = 0
	CALL VDI( I, I, IXY, INTIN, ICONTRL )
	RETURN
	END
