	subroutine plot_display( ibuf, i0, n_disp, iy_scale, iy_offset,
     &	izero_level,idisplay_height, text, nlines, fit_available, ifit )
$include:'cmacom.for'
	integer*2 ibuf(1),i0,n_disp,
     &	iy_scale(max_channels),iy_offset(max_channels),idisplay_height
     &	,izero_level(max_channels),ifit(1)
	logical fit_available
c
c       10/7/96 time caibration bars corrected
c	--------------------------------------------------------------
c	Plot a hard copy of the currently displayed record on
c	Printer,Plotter,ASCII file, or HPGL file.
c	(called by SCADSP.FOR)
c
c	ibuf(1...n_points*n_channels) = Data to be plotted
c	i0 = Starting point for each channel in "ibuf"
c	n_disp = No. of points to plot
c	iy_scale(1..n_channels) = Display magnification factor
c	iy_offset(1..n_channels = Offset subtracted before scaling
c	idisplay_height = Height in n.d.c. unit of screen display area
c	text(nlines) = Text lines to be plotted at top of page
c	fit_available = If .TRUE. a best fit line is to be plotted
c	ifit(1..n_points) = best fitting exp. or H-H line
c	--------------------------------------------------------------

	LOGICAL SPECIAL
	CHARACTER*(*) TEXT(1)
C
	real row(3)
	CHARACTER device
	character key
C
	INTEGER*2 IXY(4)
	parameter(nmenu=2,lwidth=53)
	character*40 menu(nmenu) /
     &	' Vertical calibration bar (    )',
     &	' Time calibration bar     (    ) ' /

	character*12 list(nmenu)
	character*36 err
	integer*1 ieof /26/

	real cal_bar(MAX_channels) / 0./
	real bit_value(max_channels)
	character*4 channel_units(MAX_CHANNELS)
	integer*2 iarea(4)

	automatic list,err,iarea
C
C -- CODE ------------------------------------------------------------
c
	bit_value(1) = bit_current
	channel_units(1) = c_units

C
c	Let user set calibration bars
c
	ix = index( menu(1), '(' ) + 1
	menu(1)(ix:ix+3) = channel_units(1)
	if( cal_bar(1).eq.0. ) cal_bar(1) = float(max_adc)*bit_current/10.
	write(list(1),'(f8.3)') cal_bar(1)
	ix = index( menu(2), '(' ) + 1
	menu(2)(ix:ix+3) = t_units
        if( t_cal .eq.0. ) t_cal = float(n_disp)*record_dt/10.
	write(list(2),'(f8.3)') t_cal

	err = ' '
10	if( err .eq. ' ' )  err = 'Plot Screen '
	call text_window(menu,list,nmenu,3,5,err )

c
c	Unpack values from table & check for validity
c
	cal_bar(1) = check_limits(list,0.,1E30,1,err)
	if( err .ne. ' ' ) goto 10
	t_cal = check_limits(list,0.,1E30,2,err)
	if( err .ne. ' ' ) goto 10


c
c	Let user select O/P device
c
	call get_screen_device( iscreen )
	call select_plot_device(4,6,idev,ihandle,device)
	if( (idev.eq. 0) .and. (ihandle.eq.0) ) return

	if( (idev.eq.0) .and. (ihandle.ne.0) ) then
c
c	    Write record to ASCII text file in format
c	    T <TAB> CURRENT <TAB> VOLTAGE <CR> <LF>
c	    Terminate with ASCII end-of-file marker ctrl-z
c
	    x = 0.
	    ncols = 2
	    do 22 i = i0,n_disp
		row(1) = x
		j = (i-1)*n_channels + 1
		row(2)= float(ibuf(j)-izero_current)*bit_value(1)
		j = (i-1)*n_channels + 2
		call write_ascii_list(ihandle,row,ncols,1)
                x = x + record_dt
22	   continue
	    call write_bytes(ihandle,ierr,ieof,1)
	    call close_file( ihandle, ierr )
	    return
	endif

	call get_text_attributes( idev, i,i,i,i,i,
     &	ichar_width,ichar_height)

	if( idev .eq. iscreen ) call erase_all

C
C -- Set plotting area size
C
	nplots = n_channels
	ivertical_spacing = ((max_ndc/4)*3)/nplots
	ibottom = max_ndc / 8
	ileft = max_ndc / 4
	iplot_height = (ivertical_spacing/5)*4
	iplot_length = max_points*10

	do 40 ichan = 1,n_channels
c
c		Define plotting area on page
c
		iarea(1) = ileft
		iarea(2) = ibottom + (ichan-1)*ivertical_spacing
		iarea(3) = iarea(1) + iplot_length
		iarea(4) = iarea(2) + iplot_height

		call set_size( iarea(1), iarea(2), iarea(3), iarea(4))
		call enable_clipping( idev )

c
c ---------	Scale channel data to fit into plotting area
c		and plot it

		ix = iarea(1)
		idx = iplot_length / n_disp
		yscale = float(iplot_height)*float(iy_scale(ichan))
     &		/float(idisplay_height)
		iy_off = iy_offset(ichan)

		j0 = (i0-1)*n_channels + ichan
		j1 = j0 + n_disp*n_channels - 1

		k = 0
		do 41 j = j0,j1,n_channels
		    k = k + 1
		    iwork(k) = ix
		    k = k + 1
		    iwork(k) = int(float(ibuf(j)-iy_off)*yscale)
     &		     + iarea(2)
		    ix = ix + idx
41		continue

		call polyline( idev, iwork, k/2 )

c
c ---------	Draw dotted line to indicate zero level
c
		iwork(1) = iarea(1)
		iwork(2) = int(float(izero_current-iy_offset(ichan))
     &		* yscale )+iarea(2)
		iwork(3) = iarea(3)
		iwork(4) = iwork(2)
		call set_writing_mode( idev, 2 )
		call set_polyline_type( idev, 3 )
		call polyline( idev, iwork, 2 )
		call set_polyline_type( idev, 1 )
		call set_writing_mode( idev, 1 )

		call disable_clipping( idev )
c
c ---------	Plot Calibration bar
c
		ibar_size = int( (yscale*cal_bar(ichan)) /
     &		bit_value(ichan) )
		ix = max_ndc/10
		iy = iarea(2)
		if( cal_bar(ichan) .ne. 0. )
     &		call yt_calibration( idev, ix, iy, ibar_size,ichar_width,
     &		ichar_height,cal_bar(ichan),channel_units(ichan),'V')
c
c ----------	Plot time calibration below first channel
c
		if( ichan .eq. 1 ) then
                    ibar_size = int( t_cal*float(idx) / record_dt )
		    if( t_cal .ne. 0. )
     &		    call yt_calibration( idev, ix, iy, ibar_size,
     &		    ichar_width,ichar_height,t_cal,t_units,'H')
		endif


40	continue

c
c ----------	Add best fit curve (if it exists)
c
	if( fit_available ) then
c
c	    Determine plotting area on page
c
	    ichan = 1
	    iarea(1) = ileft
	    iarea(2) = ibottom + (ichan-1)*ivertical_spacing
	    iarea(3) = iarea(1) + iplot_length
	    iarea(4) = iarea(2) + iplot_height
	    call set_size( iarea(1), iarea(2), iarea(3), iarea(4))
	    call enable_clipping( idev )
c
c	    X and Y scaling factors
c
	    ix = iarea(1)
	    idx = iplot_length / n_disp
	    yscale = float(iplot_height)*float(iy_scale(ichan))
     &	    /float(idisplay_height)
	    iy_off = iy_offset(ichan)
c
c	    Create X,Y array of n.d. coordinates
c
	    k = 0
	    do 45 i = i0,n_disp
		k = k + 1
		iwork(k) = ix
		k = k + 1
		iwork(k) = int(float(ifit(i)-iy_off)*yscale) + iarea(2)
		ix = ix + idx
45	    continue
c
c	    Plot line
c
	    call polyline( idev, iwork, k/2 )
	    call disable_clipping( idev )
	endif


C
C -- Print identification information
C
	if( t_cal .ne. 0. ) then
	    IXY(1) = ileft
	    IXY(2) = max_ndc - 2*ICHAR_HEIGHT
	    DO 50 I = 1,nlines
		IXY(2) = IXY(2) - ICHAR_HEIGHT
		CALL GRAPHICS_TEXT( Idev, IXY ,TEXT(I) )
50	    CONTINUE
	endif
C
C	Close plotting workstation
C
	IF( Idev .NE. ISCREEN ) THEN
	    CALL UPDATE_WORKSTATION(Idev)
	    CALL CLEAR_WORKSTATION(Idev)
	    CALL UNLOAD_FONTS(Idev)
	    CALL CLOSE_WORKSTATION(Idev)
	else
	    call move_cursor(2,25)
	    call display_string('<<< Press any key to continue >>>')
	    call wait_for_key( key, special )
	    call erase_all
	ENDIF
	CALL SET_MARGINS(1,1,80,25)
	RETURN
	END

	subroutine plot_graph(output,xy,np
     &	,xlo,ylo,xhi,yhi,xtic,ytic,xlabel,ylabel,report,nlines)
$include: 'cmacom.for'
C
C	Plot X/Y graph on screen, printer, plotter, or file.
C	----------------------------------------------------
C	Enter with "output='S'" for screen display, "output='H' for
C	hard copy. Graph points is array "xy" "np" = No. of points
C	"xlo,ylo,xhi,yhi" are limits of X and Y axes
C	"xtic,ytic" spacing of calibration tics on axes
C	"ylabel" and "xlabel" =  axes labels
c	"report" contains "nlines" of text ro be displayed with plot
C
	character*(*) output,report(nlines)
	REAL XY(1)
	INTEGER*2 IXY(2)
	integer*1 ieof
	CHARACTER*(*) ylabel,xlabel
	CHARACTER device

C
C	CODE
c
	call get_screen_device( iscreen )

	if( output .ne. 'S' ) then
c
c	    Let user select O/P device
c
	    call select_plot_device(3,5,idev,ihandle,device)
	    if( (idev.eq. 0) .and. (ihandle.eq.0) ) return

	    if( (idev.eq.0) .and. (ihandle.ne.0) ) then
c
c		Write X/Y graph to ASCII text file in format
c		X <TAB> Y <CR> <LF>
c		Terminate with ASCII end-of-file marker ctrl-z
c
		call write_ascii_list(ihandle,xy,2,np)
		ieof = 26
		call write_bytes(ihandle,ierr,ieof,1)
		call close_file( ihandle, ierr )
		return
	    endif
	else
	    idev = iscreen
	endif

	call get_text_attributes( idev, i,i,i,i,i,
     &	ichar_width,ichar_height)
c
c	Set size/position of plot on page
c
	if( idev .eq.  iscreen ) then
	    CALL SET_SIZE(7000,5000,ichar_width*54,20000)
	elseif( device .eq. 'P' ) then
	    CALL SET_SIZE(7000,5000,20000,24000)
	else
	    CALL SET_SIZE(8000,7000,28000,20000)
	endif

	call draw_axes_manual(idev,xlo,ylo,xhi,yhi,xlabel,ylabel
     &	,'N','N','N',xtic,ytic )

	CALL SET_POLYMARKER_TYPE(IDEV,2)
	CALL SET_POLYMARKER_HEIGHT(IDEV,ICHAR_HEIGHT/4)
	CALL DRAW_marker(IDEV,XY,NP)
C
c	Display report list
c
	if( idev .eq. iscreen ) then
	    do 35 i = 1,nlines
		call move_cursor(2,i+1)
		call display_string( report(i) )
35	    continue
	else
	    IXY(1) = ICHAR_WIDTH
	    IXY(2) = max_ndc - ICHAR_HEIGHT*2
	    do 40 i = 1,nlines
		ixy(2) = ixy(2) - ichar_height
		call graphics_text( idev, ixy, report(i) )
40	    continue
	endif

C
C	Close hard copy workstation
C
	CALL GET_SCREEN_DEVICE(ISCREEN)
	IF( IDEV.NE.ISCREEN ) THEN
		CALL UPDATE_WORKSTATION(IDEV)
		CALL CLEAR_WORKSTATION(IDEV)
		CALL UNLOAD_FONTS(IDEV)
		CALL CLOSE_WORKSTATION(IDEV)
	ENDIF
	RETURN
	END


	subroutine plot_histogram(output,xy,np
     &	,xlo,ylo,xhi,yhi,xtic,ytic,xlabel,ylabel,report,nlines)
$include: 'cmacom.for'
C
C	Plot histogram on screen, printer, plotter, or file.
C	----------------------------------------------------
C	Enter with "output='S'" for screen display, "output='H' for
C	hard copy. Graph points is array "xy" "np" = No. of points
C	"xlo,ylo,xhi,yhi" are limits of X and Y axes
C	"xtic,ytic" spacing of calibration tics on axes
C	"ylabel" and "xlabel" =  axes labels
c	"report" contains "nlines" of text ro be displayed with plot

	character*(*) output,report(nlines)
	real xy(1)
	integer*2 np,nlines
	real xlo,ylo,xhi,yhi
	INTEGER*2 IXY(2)
	integer*1 ieof
	CHARACTER*(*) YLABEL,xlabel
	CHARACTER device

	REAL work(1)
	EQUIVALENCE (IWORK(301),work)
C
C	CODE
C
	call get_screen_device( iscreen )

	if( output .ne. 'S' ) then
c
c	    Let user select O/P device
c
	    call select_plot_device(3,5,idev,ihandle,device)
	    if( (idev.eq. 0) .and. (ihandle.eq.0) ) return

	    if( (idev.eq.0) .and. (ihandle.ne.0) ) then
c
c		Write X/Y graph to ASCII text file in format
c		X <TAB> Y <CR> <LF>
c		Terminate with ASCII end-of-file marker ctrl-z
c
		call write_ascii_list(ihandle,xy,2,np)
		ieof = 26
		call write_bytes(ihandle,ierr,ieof,1)
		call close_file( ihandle, ierr )
		return
	    endif
	else
	    idev = iscreen
	endif

	call get_text_attributes( idev, i,i,i,i,i,
     &	ichar_width,ichar_height)
C
C	Draw histogram by joining up edges of bins
C
	bin_half = (xy(3) - xy(1))/2.
	work(1) = xy(1) - bin_half
	work(2) = 0.
	J = 2
	DO 10 I = 1,np*2,2
	    J = J + 1
	    work(J) = xy(i) - bin_half
	    J = J + 1
	    work(J) = xy(I+1)
	    J = J + 1
	    work(J) = xy(i) + bin_half
	    J = J + 1
	    work(J) = xy(i+1)
10	CONTINUE
	J = J + 1
	work(J) = work(j-2)
	J = J + 1
	XY(J) = 0.
	NPLOT = J/2
C
	YMIN = 0.
c
c	Set size/position of plot on page
c
	if( idev .eq.  iscreen ) then
	    CALL SET_SIZE(7000,5000,ichar_width*54,20000)
	elseif( device .eq. 'P' ) then
	    CALL SET_SIZE(7000,5000,20000,24000)
	else
	    CALL SET_SIZE(8000,7000,28000,20000)
	endif

	call draw_axes_manual(idev,xlo,ylo,xhi,yhi,xlabel,ylabel
     &	,'N','N','N',xtic,ytic )

	CALL DRAW_LINE(IDEV,work,NPLOT)

C
c	Display report list
c
	if( idev .eq. iscreen ) then
	    do 35 i = 1,nlines
		call move_cursor(2,i+1)
		call display_string( report(i) )
35	    continue
	else
	    IXY(1) = ICHAR_WIDTH
	    IXY(2) = max_ndc - ICHAR_HEIGHT*2
	    do 40 i = 1,nlines
		ixy(2) = ixy(2) - ichar_height
		call graphics_text( idev, ixy, report(i) )
40	    continue
	endif

C
C	Close hard copy workstation
C
	CALL GET_SCREEN_DEVICE(ISCREEN)
	IF( IDEV.NE.ISCREEN ) THEN
		CALL UPDATE_WORKSTATION(IDEV)
		CALL CLEAR_WORKSTATION(IDEV)
		CALL UNLOAD_FONTS(IDEV)
		CALL CLOSE_WORKSTATION(IDEV)
	ENDIF
	RETURN
	END

	subroutine select_plot_device(ix,iy,idev,ihandle,device)
$include: 'cmacom.for'
c
c	Let user select plotter output device
c
c	IX,IY = top left of entry form
c	Workstation No. returned in IDEV
c	Output file handle returned in IHANDLE (with IDEV=0)
c	IDEV and IHANDLE = 0 indicates abort
c	DEVICE is returned with letter pressed by user
c
	character*(*) device

	parameter(nmenu=6,iprinter=2,iplotter=3,ifile=4,iscrn=1
     &	,ihpgl=5)
	character*20 menu(nmenu) /
     &	' Screen       S',
     &	' Printer      R',
     &	' Plotter      P',
     &	' ASCII file   F',
     &	' HPGL file    H',
     &	' Cancel     ESC'/

	character*30 list_file /' '/
	character*6 keys /'SRPFH$'/
	logical new_menu,abort
	character key

	if( list_file .eq. ' ' ) list_file = default_path

	new_menu = .true.
	itype = Iwait_MENU_VERTICAL1(menu,keys,nmenu,ix,iy,new_menu
     &	,itype,' Output to: ',key)

	if( itype .eq. iscrn ) then
c
c	    Write to screen
c
	    call get_screen_device(idev)

	elseif( itype .eq. iplotter ) THEN
c
c	    Open plotter
c
	    call display_message(ix+1,iy+1,22,' WAIT ... Plotting ',1)
	    CALL OPEN_WORKSTATION(IDEV,11)
	    CALL LOAD_FONTS(IDEV)
	    CALL SET_TEXT_FACE(IDEV,1)

	    iheight = int( (32767./12.)*(14. / 72.) )
	    call set_character_height( idev, iheight )


	ELSEIF( itype .eq. iprinter ) THEN
c
c	    Open printer
c
	    call display_message(ix+1,iy+1,22,' WAIT ... Plotting ',1)
	    CALL OPEN_WORKSTATION(IDEV,21)
	    CALL LOAD_FONTS(IDEV)
	    CALL SET_TEXT_FACE(IDEV,1)
	    call set_point_size( idev, 14 )

	ELSEIF( itype .eq. ifile ) then
c
c	    Open ASCII file
c
	    call file_box(ix+1,iy+1,list_file,' ','NEW'
     &	    ,' ASCII file ',abort)
	    if( .not. abort ) then
		call create_file( ihandle, ierr, list_file )
		idev = 0
		if (ierr .ne. 0 ) ihandle = 0
		call display_message(ix+2,iy+2,28
     &		,' WAIT ... Writing to file ',1)
	    else
		idev = 0
		ihandle = 0
	    endif
	elseif( itype .eq. ihpgl ) then
c
c	    Output to an HPGL file
c
	    call file_box(ix+1,iy+1,list_file,' ','NEW'
     &	    ,' HPGL file ',abort)
	    if( .not. abort ) then
		call display_message(ix+1,iy+1,22,' WAIT ... Plotting ',1)
		CALL OPEN_WORKSTATION_to_file(IDEV,11,list_file)
		CALL LOAD_FONTS(IDEV)
		CALL SET_TEXT_FACE(IDEV,1)
		iheight = int( (32767./12.)*(14. / 72.) )
		call set_character_height( idev, iheight )
	    endif
	else
c
c	    ESC = abort plot
c
	    idev = 0
	    ihandle = 0
	endif

	if( itype .ne. 0 ) then
	    device = keys(itype:itype)
	else
	    device = ' '
	endif
	return
	end

	subroutine write_ascii_list(ihandle,rlist,ncols,nrows)
c
c	Write contents of REAL array RLIST(NCOLS,NROWS) to file
c	as NROWS rows of ASCII text (NCOLS per row) to file
c	attached to IHANDLE

	character tab,cr,lf
	real rlist(ncols,nrows)

	character*200 string
	integer*1 istring(200)
	equivalence(string,istring)

c
c	code
c
	tab = char(9)
	cr = char(13)
	lf = char(10)
	do 20 irow = 1,nrows
	    string = ' '
	    j = 1
	    do 15 icol = 1,ncols
		write(string(j:j+12),'(1pg12.5,a)') rlist(icol,irow),tab
		j = j + 13
15	    continue
	    string(j-1:j+1) = cr//lf
	    nc = itrailing_space( string )
	    call write_bytes(ihandle,ierr,istring,nc)
20	continue
	return
	end

