	SUBROUTINE FILES_OPTIONS
C
C	Load data from .SCA type files
c	------------------------------
C
$INCLUDE:'cmacom.FOR'

	CHARACTER KEY
	logical new_menu

	PARAMETER(Nmenu=7,istatus_left=59)
	CHARACTER*20 MENU(nmenu) /
     &	'Load   data file  F1',
     &	'Merge  data file  F2',
     &	'Delete data file  F3',
     &	'Remove rejected   F4',
     &	'Change directory  F5',
     &	'Save settings     F6',
     &	'Exit             ESC' /

C
C -- CODE ------------------------------------------------------
C
C
C	Display program status box
C
	new_menu = .true.
	key = ' '
100	call erase_all
	call display_box(1,1,istatus_left-2,25)

	iop = Iwait_MENU_VERTICAL1(menu,'123456$',nmenu
     &	,istatus_left-1,1,new_menu,iop,' Files Options ',key)
	IF(IOP.LE.0) GOTO 100

	GOTO(1,2,3,4,5,6,7) IOP
C
1	CALL LOAD_data_FILE
	GOTO 200

2	call merge_data_file
	goto 200

3	CALL DELETE_data_FILE
	GOTO 100

4	call remove_rejected_records
	goto 100

5	CALL CHANGE_data_DIRECTORY
	GOTO 100

6	call save_settings
	goto 200

7	continue
C
200	CONTINUE
	RETURN
	END

	SUBROUTINE LOAD_data_FILE
C
C --	Load .SCA file
C
$INCLUDE:'CMACOM.FOR'
C
	parameter(max_files=500,nc_path=30)
	character*30 path
	CHARACTER*12 NEW_FILE_NAME / ' ' /
	character*12 files(max_files)
	equivalence( files, iwork )
C
C	CODE
C
C	Display directory of .SCA files and let user choose
C
	call move_cursor(3,5)
	call display_string(' LOAD .SCA DATA FILE  ')

	path = default_path
	ix = len_trim(path)+1
	path(ix:ix+4) = '*.SCA'
	call files_menu(path,0,new_file_name,3,6,10,files,max_files)

	if( new_file_name .ne. ' ' ) then
	    IF( IDATA_FILE_NO .NE. 0 ) then
		call save_header
		CALL CLOSE_FILE(IDATA_FILE_NO,IERROR)
	    endif

	    path(ix:nc_path) = new_file_name
	    file_name = path
	    CALL OPEN_FILE( IDATA_FILE_NO, IERROR, file_name )
C
C	    Read header block
C
	    IHOLD = INTERFACE_CARD	! Preserve interface card no.
	    CALL GET_HEADER
	    INTERFACE_CARD = IHOLD

	end if
	default_path = path(1:ix-1)
	RETURN
	END

	SUBROUTINE DELETE_data_FILE
C
C --	Delete .SCA file
C
$INCLUDE:'CMACOM.FOR'
C
	CHARACTER*12 NEW_FILE_NAME/ ' ' /
	parameter(max_files=500,nc_path=30)
	character*12 files(max_files)
	character*30 path / ' ' /
	equivalence( files, iwork )
C
C	CODE
C
	call move_cursor(3,5)
	call display_string(' DELETE .SCA DATA FILE  ')
	path = default_path
	ix = len_trim(path)+1
	path(ix:ix+4) = '*.SCA'
	call files_menu(path,0,new_file_name,3,6,10,files,max_files)

	if( new_file_name .ne. ' ' ) then
	    path(ix:nc_path) = new_file_name
	    call query_box(4,7,
     &	    ' Delete: '//path//' Are you sure (Y/N) ? ',key)
	    if( key .eq. 'Y' ) call delete_file( ierr, path )
	end if
	return
	end

	SUBROUTINE CHANGE_data_DIRECTORY
C
C --	Change directory
C
$INCLUDE:'CMACOM.FOR'
	character*40 string
C
C	CODE
C
	string = default_path
	call text_window(' ',string,1,3,5
     &	,' Change default disc & directory ')
	default_path = string

	ix = len_trim(default_path)		! Make sure the path
	if( default_path(ix:ix).ne.'\') then    ! ends with a '\'
	    ix = ix + 1
	    default_path(ix:ix) = '\'
	    ix = ix + 1
	end if
	return
	end

	subroutine save_settings
$include:'cmacom.for'
c
c	Save current program settings to initialisation file SCAN.INI
c	in directory \gemapps\gemsys
c
	nkeep_frames = n_frames
	ikeep = idata_file_no
	call create_file( ifile, ierr, '\gemapps\gemsys\CMAP.ini')
	if( ierr .eq. 0 ) then
	    n_frames = 0
	    idata_file_no = ifile
	    call save_header
	    call close_file( ifile, ierr )

	    idata_file_no = ikeep
	    n_frames = nkeep_frames
	endif

	return
	end



	SUBROUTINE GET_HEADER
C
C	Read data from .ADC file header block
C	into HEADER common are
C
	LOGICAL FOUND
	CHARACTER*(512) HEADER
	EQUIVALENCE (IBUFFER,HEADER)
C
$INCLUDE:'cmacom.FOR'
C
C	CODE
C	----
C
C	Read header block of .ADC file
C
	CALL READ_FILE(IDATA_FILE_NO,IERROR,IBUFFER,1,1)
C
	CALL FIND_ENTRY('DT=',ISTART,IEND,HEADER,FOUND)
	IF( FOUND  ) DT = GET_ENTRY(HEADER(ISTART:IEND))
C
	CALL FIND_ENTRY('GC=',ISTART,IEND,HEADER,FOUND)
	IF( FOUND  ) GAIN_CURRENT = GET_ENTRY(HEADER(ISTART:IEND))
C
	CALL FIND_ENTRY('TU=',ISTART,IEND,HEADER,FOUND)
	IF( FOUND) T_UNITS = HEADER(ISTART:IEND)
C
	CALL FIND_ENTRY('AD=',ISTART,IEND,HEADER,FOUND)
	IF( FOUND) ADC_RANGE = GET_ENTRY(HEADER(ISTART:IEND))
C
	CALL FIND_ENTRY('DL=',ISTART,IEND,HEADER,FOUND)
	IF( FOUND) delay = GET_ENTRY(HEADER(ISTART:IEND))
C
	CALL FIND_ENTRY('BC=',ISTART,IEND,HEADER,FOUND)
	IF( FOUND) BIT_CURRENT = GET_ENTRY(HEADER(ISTART:IEND))
C
	CALL FIND_ENTRY('IZC=',ISTART,IEND,HEADER,FOUND)
	IF( FOUND) izero_current = int(GET_ENTRY(HEADER(ISTART:IEND)))
C
	CALL FIND_ENTRY('CU=',ISTART,IEND,HEADER,FOUND)
	IF( FOUND) C_UNITS = HEADER(ISTART:IEND)
C
	CALL FIND_ENTRY('NC=',ISTART,IEND,HEADER,FOUND)
	IF( FOUND) N_CHANNELS =IFIX( GET_ENTRY(HEADER(ISTART:IEND)) )
C
	CALL FIND_ENTRY('NBF=',ISTART,IEND,HEADER,FOUND)
	IF( FOUND) NB_FILE = IFIX(GET_ENTRY(HEADER(ISTART:IEND)) )
C
	CALL FIND_ENTRY('NBA=',ISTART,IEND,HEADER,FOUND)
	IF( FOUND) NB_ANALYSIS = IFIX( GET_ENTRY(HEADER(ISTART:IEND)) )
C
	CALL FIND_ENTRY('NBD=',ISTART,IEND,HEADER,FOUND)
	IF( FOUND) NB_DATA = IFIX( GET_ENTRY(HEADER(ISTART:IEND)) )
	n_points = nb_data*npoints_per_block
C
	CALL FIND_ENTRY('NF=',ISTART,IEND,HEADER,FOUND)
	IF( FOUND) N_FRAMES = IFIX( GET_ENTRY(HEADER(ISTART:IEND)) )
C
	CALL FIND_ENTRY('NRQ=',ISTART,IEND,HEADER,FOUND)
	IF( FOUND) N_RECORDS_REQUESTED = 
     &IFIX( GET_ENTRY(HEADER(ISTART:IEND)) )
C
	CALL FIND_ENTRY('IFC=',ISTART,IEND,HEADER,FOUND)
	IF( FOUND) INTERFACE_CARD =
     &IFIX( GET_ENTRY(HEADER(ISTART:IEND)) )
C
	CALL FIND_ENTRY('DP=',ISTART,IEND,HEADER,FOUND)
	IF( FOUND) then
	    ie = index(header(istart:512),char(13)) + istart - 2
	    default_path = HEADER(ISTART:max(IEND,ie))
	end if

	CALL FIND_ENTRY('ID=',ISTART,IEND,HEADER,FOUND)
	IF( FOUND) ID = HEADER(ISTART:IEND)
C
	i_starte = 1
	i_starto = 1
	i_ende = n_points
	i_endo = n_points
	RETURN
	END
	SUBROUTINE FIND_ENTRY(MASK,ISTART,IEND,HEADER,FOUND)
C
C	Find the location of the string mask in the
C	header string and return the istart and iend indexes
C	found is set to .false. if mask is not found
C
	CHARACTER*(*) MASK
	CHARACTER*(*) HEADER
	LOGICAL FOUND
C
C	Search HEADER for MASK
C
	FOUND = .FALSE.
	NCH = LEN(HEADER)
	NCM = LEN(MASK)
	ICH = 0
	ICM = 0
10	CONTINUE
		IF(ICM .GE. NCM) THEN
			FOUND = .TRUE.
			ISTART = ICH + 1
		ENDIF
		ICH = ICH + 1
		ICM = ICM + 1
		IF(MASK(ICM:ICM) .NE. HEADER(ICH:ICH) ) THEN
			ICH = ICH - ICM + 1
			ICM = 0
		ENDIF
	IF(( .not. FOUND ) .AND. (ICH.LE.NCH)) GOTO 10
C
C	IF( .not. FOUND ) THEN
C		CALL MOVE_CURSOR(2,23)
C		CALL DISPLAY_STRING(MASK//' not found in header')
C	ENDIF

	IF( FOUND .EQV. .FALSE.) RETURN
C
C	FIND END OF ENTRY (TERMINATED BY A \)
C
	I = ISTART
	FOUND = .FALSE.
20	CONTINUE
	    IF((HEADER(I:I).EQ.'\').OR.(HEADER(I:I).EQ.CHAR(13))) THEN
		IEND = I - 1
		I = NCH
		FOUND = .TRUE.
	    ENDIF
	    I = I + 1
	IF(I.LE.NCH) GOTO 20
	RETURN
	END


	REAL FUNCTION GET_ENTRY(HEADER)
	REAL RN
C
C	CONVERT STRING IN HEADER
C	TO A REAL NUMBER
C
	CHARACTER*(*) HEADER
C
	READ(HEADER,900) RN
900	FORMAT(F13.0)
C
	GET_ENTRY = RN
	RETURN
	END
	SUBROUTINE SAVE_HEADER
C
C	WRITE HEADER BLOCK TO .ADC FILE
C
	CHARACTER*(512) HEADER
	EQUIVALENCE (IBUFFER,HEADER)
C
$INCLUDE:'cmacom.FOR'
C
C	CODE
C	----
C
	HEADER = ' '
C
	CALL ADD_ENTRY(DT,'DT=',HEADER)
	CALL ADD_ENTRY(BIT_CURRENT,'BC=',HEADER)
	CALL ADD_ENTRY(GAIN_CURRENT,'GC=',HEADER)
	CALL ADD_ENTRY(FLOAT(izero_current),'IZC=',HEADER)
	CALL ADD_ENTRY(ADC_RANGE,'AD=',HEADER)
	call add_entry(delay,'DL=',HEADER)
C
	CALL ADD_STRING('TU=',HEADER)
	CALL ADD_STRING(T_UNITS,HEADER)
	CALL ADD_STRING('\',HEADER)
C
	CALL ADD_STRING('CU=',HEADER)
	CALL ADD_STRING(C_UNITS,HEADER)
	CALL ADD_STRING('\',HEADER)
C
	CALL ADD_ENTRY(FLOAT(N_CHANNELS),'NC=',HEADER)
	CALL ADD_ENTRY(FLOAT(N_RECORDS_REQUESTED),'NRQ=',HEADER)
	CALL ADD_ENTRY(FLOAT(N_FRAMES),'NF=',HEADER)
	CALL ADD_ENTRY(FLOAT(NB_FILE),'NBF=',HEADER)
	CALL ADD_ENTRY(FLOAT(NB_ANALYSIS),'NBA=',HEADER)
	CALL ADD_ENTRY(FLOAT(NB_DATA),'NBD=',HEADER)
	CALL ADD_ENTRY(FLOAT(INTERFACE_CARD),'IFC=',HEADER)
C
	call add_string('DP=',header)
	call add_string(default_path,header)
	call add_string(char(13)//char(10),header)

	CALL ADD_STRING('ID=',HEADER)
	CALL ADD_STRING(ID,HEADER)
	CALL ADD_STRING('\',HEADER)
C
	CALL WRITE_FILE(IDATA_FILE_NO,IERROR,IBUFFER,1,1)
C
	RETURN
	END
	SUBROUTINE ADD_ENTRY(RN,KEY,HEADER)
C
C	CONVERT RN TO A STRING AND ADD KEY=RN\ TO HEADER STRING
C
	REAL RN
	CHARACTER*(*) KEY
	CHARACTER*(*) HEADER
	CHARACTER*(16) TEXT
C
	CALL ADD_STRING(KEY,HEADER)
	WRITE(TEXT,900) RN
900	FORMAT(1PG13.4,'\')
	CALL ADD_STRING(TEXT,HEADER)
	RETURN
	END

	subroutine remove_rejected_records
c
c	Remove records marked as "REJECTED" from data file
c	(Note that if either of a pair of fast/slow records
c	 are rejected then both are removed from the file)
c
$include:'cmacom.for'

	character*46 msg(2)
	parameter(nc_temp=30)
	character*30 temp
	character*8 status
c
c	code
c
	ix = index( file_name, '.' )
	temp = file_name
	temp(ix:nc_temp) = '.tmp'

	if( idata_file_no .gt. 0 ) then

	    call create_file( itemp, ierr, temp )

	    msg(1) = ' WAIT ... Removing REJECTED records '
	    msg(2) = ' '
	    call display_message(3,5,len(msg(1))+2,msg,2)

	    nsaved = 0
	    do ir = 1,n_frames,2
		call get_frame( ir, idata_file_no )
		status = frame_status
		call get_frame( ir+1, idata_file_no )

		write(msg(2),'('' Record '',i5,a)') ir,frame_status
		call move_cursor(4,7)
		call display_string(msg(2))

		if( (frame_status .ne. 'REJECTED') .and.
     &		(status .ne. 'REJECTED') ) then
		    nsaved = nsaved + 1
		    record_no = float( nsaved )
		    call get_frame( ir, idata_file_no )
		    call put_frame( nsaved, itemp )
		    nsaved = nsaved + 1
		    record_no = float( nsaved )
		    call get_frame( ir+1, idata_file_no )
		    call put_frame( nsaved, itemp )
		endif
	    end do

	    call close_file( idata_file_no, ierr )
	    call close_file( itemp, ierr )
	    call delete_file( IERR, file_name )
	    call rename_file( ierr, temp, file_name )
	    call open_file( idata_file_no, ierr, file_name )
	    n_frames = nsaved
	    call save_header
	endif
	return
	end

	SUBROUTINE merge_data_FILE
C
C --	Merge the data from a SCAN file on to end of current file
C
$INCLUDE:'cmacom.FOR'
C
	CHARACTER*30 FILE_NAME1 / ' ' /
	parameter(max_files=500,nc_path=30)
	character*30 path1,msg(3)
	character*12 files(max_files)
	equivalence( files, iwork )
C
C	CODE
C
C	Display directory of .SCA files and let user choose
C
	call move_cursor(3,5)
	call display_string(' MERGE .SCA DATA FILE ')
	path1 = default_path
	ix = len_trim(path1)+1
	path1(ix:ix+4) = '*.SCA'
	call files_menu(path1,0,file_name1,3,6,10,files,max_files)
	IF(FILE_NAME1 .EQ. ' ') RETURN
	path1(ix:nc_path) = file_name1

c
c	Get header block of file to be added
c
	call close_file( idata_file_no, ierr )
	call open_file( idata_file_no, ierr, path1 )
	call get_header
	gain_current1 = gain_current
	nb_data1 = nb_data
	nb_analysis1 = nb_analysis
	adc_range1 = adc_range
	nadd = n_frames
	call close_file( idata_file_no, ierr )
c
c	Re-open data file to be added to
c
	call open_file( idata_file_no, ierr, file_name )
	call get_header
c
c	Exit if file record sizes don't match
c
	if((nb_data1.eq.nb_data).and.(nb_analysis1.eq.nb_analysis)) then
c
c	    Open file to be added
C
	    call open_file( itemp, ierr, path1 )
c
c	    If GAIN_CURRENT or ADC_RANGE values don't match between files
c	    Adjust RECORD_GAIN factor to compensate
c
	    scale = (gain_current1/gain_current)*(adc_range/adc_range1)

c	    Add records to file (excluding REJECTED records)

	    msg(1) = ' WAIT ... Adding records '
	    msg(2) = ' '
	    call display_message(4,6,len(msg(1))+2,msg,2)

	    nadded = n_frames
	    n_frames = 32767
	    do ir = 1,nadd
		call get_frame( ir, itemp )
		if( frame_status .ne. 'REJECTED' ) then
		    nadded = nadded + 1
		    record_gain = scale*record_gain
		    call put_frame( nadded, idata_file_no )
		    write(msg(2),'('' Record '',i5)') nadded
		    call move_cursor(5,8)
		    call display_string(msg(2))
		endif
	    end do
	    n_frames = nadded
	    nb_file = (nb_data+nb_analysis)*n_frames + 1

	    call close_file( itemp, ierr )

	else

	    call display_message(3,5,44,
     &	    ' Different size records! Can''t merge files ',1)

	endif

	default_path = path1(1:ix-1)

	RETURN
	END


