	SUBROUTINE DIGITISE_ANALOGUE_SIGNAL
$INCLUDE:'cmacom.FOR'
C
C	Record analogue signal
C	----------------------
C	V1.2 ... save_header added to NEW FILE option curing data file bug
c		 CAPs now separated from stimulus artifact
c		 by threshold/duration detector.
c	V1.3 ... Default path added to file entry box.
c	V1.7b ... Bug in DMA buffer allocation fixed
c		  now works properly when IS>1
c
	CHARACTER KEY
	LOGICAL SPECIAL,ABORT,RECORDING,new_menu
	CHARACTER*30 NEW_FILE_NAME / ' ' /
	character*15 string15
	character*50 string
	INTEGER IDISPLAY_AREA(4)
	PARAMETER (NDC_MAX=32767)

	parameter(nmenu=6,istatus_left=64,istatus_top=20)
	character*15 menu(nmenu) /
     &	'New file     F1',
     &	'Start sweep  F2',
     &	'Set trigger  F3',
     &	'Set display  F4',
     &	'Set comment  F5',
     &	'Exit        ESC' /

	parameter(nmenur=2)
	character*15 menur(nmenur) /
     &	'Stop       ESC',
     &	'Erase disp. F1' /

	parameter( iauto_mode=1,iexternal_mode=2 )
	character*15 trigger_mode(2) /
     &	 'Free Run     ',
     &	 'Ext. Trigger ' /
	integer*2 itrigger_mode /1/

	parameter( iauto_erase=1,imanual_erase=2,no_display=3)
	character*15 display_mode(3) /
     &	  'Auto Erase     ',
     &	  'Manual Erase   ',
     &	  'No Display' /
	integer*2 idisplay_mode /1/

	parameter( iyscale=6, iy_lo=0 )

C
C -- CODE
C

C	INITIALISATION
C	==============

	CALL GET_SCREEN_DEVICE(ISCREEN)
C
C -- Set size of display area
C 
	CALL SET_CHARACTER_HEIGHT(ISCREEN,1000)
	CALL GET_CHARACTER_SIZE(IW,IH)
	IDISPLAY_AREA(1) = IW
	IDISPLAY_AREA(2) = NDC_MAX - 24576 - IH
	IDISPLAY_AREA(3) = IDISPLAY_AREA(1) + ((60*IW)/512)*512
	IDISPLAY_AREA(4) = IDISPLAY_AREA(2) + iyscale*max_adc
	CALL SET_SIZE(IDISPLAY_AREA(1),IDISPLAY_AREA(2)
     &	,IDISPLAY_AREA(3),IDISPLAY_AREA(4))
C
	CALL ERASE_ALL
	CALL SET_MARGINS(2,1,80,25)

C	Display plotting area
	
	CALL DISPLAY_BOX(1,1,62,21)
	CALL MOVE_CURSOR(2,21)
	CALL DISPLAY_STRING( ' 0.' )
	write( string, '(f6.1,''/'',f6.1,a)' )
     &	float(n_points-1)*dt,float(nwork-1)*dt,t_units
	CALL MOVE_CURSOR(45,21)
	CALL DISPLAY_STRING(string(1:20))

	call move_cursor(12,21)
	call display_string(' File '//file_name(1:26) )

	CALL MOVE_CURSOR(2,1)
	CALL DISPLAY_STRING(' Record analogue signals ')


C
C -- Set up A/D converter ------------------------------------------
C	(Note array iwork is used to load CED 1401 commands.
c	Also first element is returned non-zero if interface card
c	error has occurred)

	CALL OPEN_LAB(INTERFACE_CARD,iwork)
	call check_adc_range( interface_card, adc_range )

	IF(iwork(1) .NE. 0) THEN
	    ERROR = 'ERROR ... Interface fault'
	    RETURN
	ENDIF

C
C	Clear analysis parameter block
C
	DO I=1,20
	    ANALYSIS(I) = 0.
	end do

C	MAIN PROGRAM LOOP
C	=================

	RECORDING = .FALSE.
	new_menu = .true.

100	CONTINUE
c
c --	    Display status box ----------------------------------
c
	    if( .not. recording ) then

		call display_box(istatus_left-1,istatus_top-1,79,25)
		call set_margins(istatus_left,istatus_top,79,25)

		call move_cursor(istatus_left,istatus_top)
		write(string15,'(''Records '',I5)') n_frames
		call display_string(string15)
		call new_line
		call display_string(trigger_mode( itrigger_mode ) )
		call new_line
		call display_string(display_mode( idisplay_mode ) )
		call new_line
		write(string15,'(''Delay '',f5.0,''ms'')') delay
		call display_string(string15)

		call set_margins(1,1,80,25)
	    else
		call move_cursor(istatus_left,istatus_top)
		write(string15,'(''Records '',I5)') n_frames
		call display_string(string15)
	    endif

C	    RECORD ANALOGUE SIGNAL
C	    ======================

	    IF ( RECORDING ) THEN

		if( new_menu ) then
		    call erase_box(istatus_left-1,1,79,istatus_top-2)
		    call display_message(istatus_left-1,1,16,menur,nmenur)
		    call move_cursor(istatus_left,1)
		    call display_string(' Options ')
		    new_Menu = .false.
		endif

C
C		IMMEDIATE AND EXTERNAL TRIGGER MODES
C		====================================
c
c		Collect <nwork> A/D samples from Ch.0
c
		imode = 0
		itmode = itrigger_mode -1
		CALL ADC_TO_MEMORY(dt,N_CHANNELS,nwork
     &		,ITMODE,IWORK,IS,IMODE,ADC_RANGE,KEY)
c
c		Set first point = 2nd points (fixes bug in 1401)
c
		iwork(is) = iwork(is+1)
c
c		Extract fast record
c
		jmax = nwork + is - 1
		i0 = int( delay/dt ) + is
		i1 = min( i0 + n_points - 1, jmax )

		j = i0
		do i = 1,n_points
		    ibuffer(i) = iwork(j)
		    j = min( j + 1, jmax )
		end do

		if( idisplay_mode .eq. iauto_erase ) then
		    call fill_rectangle( iscreen, idisplay_area )
		endif

		call plot_channel( iscreen, idisplay_area, ibuffer,1,
     &		1,1, n_points, iyscale,iy_lo,1)
c
C		Stop recording if an error has occurred
C		or ESC has been pressed.

		IF( KEY .EQ. '$' ) THEN
		    RECORDING = .FALSE.
		    CALL ADC_STOP
		ENDIF
C
C		Get time of collection
C
		frame_time = time_in_secs()
		IF(N_FRAMES.EQ.0) TIME_START = FRAME_TIME
		FRAME_TIME = FRAME_TIME - TIME_START
C
C		Save on file
C
		record_gain = 1.
		RECORD_DT = DT
		t_units = 'ms'
		RECORD_T_UNITS = T_UNITS
		N_FRAMES = N_FRAMES + 1
		N_COLLECTED = N_COLLECTED + 1
		RECORD_NO = FLOAT(N_FRAMES)
		FRAME_STATUS = 'ACCEPTED'
		frame_type = 'FAST'
		nb_data = (n_points*n_channels)/npoints_per_block
		CALL PUT_FRAME(N_FRAMES,IDATA_FILE_NO)
c
c		Find peak of CAP within fast window
c
		imax = -32767
		do i = i0,i1
		    if( iwork(i) .gt. imax ) then
			imax = iwork(i)
			ipk = i
		    end if
		end do
c
c		Extract complete action potential from A/D buffer
c		and condense into <n_points> size record
c
		nskip = nwork/n_points
		j = ipk
		do while( j .ge. is )
		    j = j - nskip
		end do
		if( j .lt. is ) j = j + nskip

		jmax = nwork + is - 1
		do i = 1,n_points
		    ibuffer(i) = iwork(j)
		    j = min( j + nskip, jmax )
		end do

		call plot_channel( iscreen, idisplay_area, ibuffer,1,
     &		1,1, n_points, iyscale,iy_lo,1)

c
c		Record to disc
c
		RECORD_DT = DT*float(nskip)
		n_frames = n_frames + 1
		frame_type = 'SLOW'
		CALL PUT_FRAME(N_FRAMES,IDATA_FILE_NO)

C		Stop recording after required number of records

		IF( N_COLLECTED .GE. N_RECORDS_REQUESTED) THEN
		    CALL GET_KEY(KEY,SPECIAL)
		    CALL GET_KEY(KEY,SPECIAL)
		    RECORDING = .FALSE.
		    CALL ADC_STOP
		ENDIF

		IF( RECORDING ) GOTO 100

		call move_cursor(44,1)
		call display_string(  ' *   IDLE    * ')

	    ENDIF

C ==== NOTE: This half of routine ONLY entered when NOT recording ===
c
c	    Wait for user to select an option from menu
c
	    new_menu = .true.
	    iop = Iwait_MENU_VERTICAL1(menu,'12345$',nmenu
     &	    ,istatus_left-1,1,new_menu,iop,' IDLE Options ',key)

	    select case( iop )

	    case( 1 )
C
C		Open a new data file

		new_file_name = file_name
		nc = len_trim( default_path )
		if(new_file_name(1:nc).ne.default_path) then
		    new_file_name = default_path
		end if

		call file_box(2,2,new_file_name,'.SCA','NEW'
     &		,' New file name ',abort)

		IF( .not. ABORT ) THEN
		    FILE_NAME = NEW_FILE_NAME
		    IF( IDATA_FILE_NO .NE. 0 ) THEN
			call save_header
			CALL CLOSE_FILE(IDATA_FILE_NO,IERR)
		    ENDIF
		    CALL CREATE_FILE(IDATA_FILE_NO,IERR,FILE_NAME)
		    N_FRAMES = 0
		ENDIF
		CALL FILL_RECTANGLE(ISCREEN,IDISPLAY_AREA)
		call move_cursor(12,21)
		call display_string('File '//file_name(1:26))

	    case( 2 )

C		Enable recording to file

		IF( .NOT. RECORDING ) THEN

		    call move_cursor(44,1)
		    call display_reversed(  ' * RECORDING * ')

		    RECORDING = .TRUE.
		    new_menu = .true.
		    N_COLLECTED = 0
		ENDIF

	    case( 3 )

C		Change triggering mode: Auto-trigger=1/External trigger=2
c
3		nmodes = 2
		new_menu = .true.
		inew_mode = iwait_menu_vertical1(trigger_mode,'12',
     &		nmodes,2,2,new_menu,itrigger_mode,' Trigger Mode ',key)
		if( inew_mode .gt. 0 ) itrigger_mode = inew_mode
		call fill_rectangle( iscreen, idisplay_area )

	    case( 4 )

c
c ---------	Select Display mode: Auto-erase,Manual-erase,No display
c
		new_menu = .true.
		inew_mode = iwait_menu_vertical1(display_mode,'123'
     &		,3,2,2,new_menu,idisplay_mode,' Display Mode ',key)
		if( inew_mode .gt. 0 ) idisplay_mode = inew_mode
		call fill_rectangle( iscreen, idisplay_area )

	    case( 5 )
c
C	    Enter a comment line

		call text_window(' ',id(1:50),1,2,2,' Enter comment ')
		CALL FILL_RECTANGLE(ISCREEN,IDISPLAY_AREA)

	    case( 6 )

C		ESC = Return to menu

C		Finished with laboratory interface
C
		CALL ADC_STOP
		CALL CLOSE_LAB
C
		NB_FILE = (NB_ANALYSIS+NB_DATA)*N_FRAMES + 1
C
C		Update header block
C
		CALL SAVE_HEADER
C
		CALL CLOSE_FILE(IDATA_FILE_NO,IERROR)
		CALL OPEN_FILE(IDATA_FILE_NO,IERROR,FILE_NAME)

		RETURN

	    end select
	    goto 100

	END


