	SUBROUTINE SEARCH_FOR_EVENTS
c       18/2/98 ical_cursor & ical_record set to zero
c       at start. It's not clear what these variables are for        
C
$INCLUDE: 'CDRCOM.FOR'
C
	LOGICAL QUIT,SPECIAL,SCROLL,DISPLAY_ON
     &	,CHANGE_STATUS,NEW_PLOT,new_menu
	INTEGER IP(2)
	INTEGER*4 IPOINTER_32
	EQUIVALENCE(IPOINTER_32,IP)
	CHARACTER*16 STRING16
	CHARACTER*12 LABEL
	CHARACTER*1 KEY

	PARAMETER(IMENU_LEFT=63,IMENU_TOP=1,istatus_top=20)
	parameter(nmenu=4)
	character*15 menu(nmenu) /
     &	'Start Search F1',
     &	'Set Detector F2',
     &	'Display Off  F3',
     &	'Exit        Esc' /

C
C -- CODE -------------------------------------------------------
C
C

C	Set display area size

	CALL SET_SIZE(IDISPLAY_AREA(1),IDISPLAY_AREA(2)
     &	,IDISPLAY_AREA(3),IDISPLAY_AREA(4))

	N_POINTS = NP_RECORD
	T_RECORD = FLOAT(NP_RECORD)*DT
        ical_cursor = 0.
        ical_record = 0.
C
C -- Cursor control keys
C
	CALL ERASE_ALL
	CALL SET_MARGINS(2,1,80,25)
C
C-- Draw display border and help information -------------------
C	
	IRECORD = 1
	T_MIN = T_RECORD*FLOAT(IRECORD-1)
	T_MAX = T_MIN + T_RECORD
	CALL DISPLAY_BOX(1,1,imenu_left-1,21)
	CALL MOVE_CURSOR(2,1)
	CALL DISPLAY_STRING( ' Search recording for events ')
	CALL MOVE_CURSOR(2,21)
	WRITE(LABEL,'(F9.2,A)') T_MIN,T_UNITS
	CALL DISPLAY_STRING(LABEL)
	WRITE(LABEL,'(F9.2,A)') T_MAX,T_UNITS
	CALL MOVE_CURSOR(50,21)
	CALL DISPLAY_STRING(LABEL)
c
c	Create status display box
c
	CALL DISPLAY_BOX(imenu_left,istatus_top,80,25)

C
	QUIT = .FALSE.
	SCROLL = .FALSE.
	DISPLAY_ON = .TRUE.
	NDEAD_TIME = int(DEAD_TIME/DT)
	NTRIGGER_TIME = int(TRIGGER_TIME/DT)
	ITRIGGER_LEVEL = int(TRIGGER_LEVEL*40.96)
	ITRIGGER_ABS = IABS(ITRIGGER_LEVEL)
	RUNNING_MEAN1 = RUNNING_MEAN + 1.
	IF(ITRIGGER_LEVEL .LT. 0) THEN
		IPOLARITY = -1
	ELSE
		IPOLARITY = 1
	ENDIF
C
	PEAK = 0.
	AREA = 0.
	RISE_TIME = 0.
	DURATION = 0.
	EXP = 0.
	TAU = 0.
	R = 0.
	EVENT_SEPARATION = 0.
C
	N_EVENTS = 0
	IRECORD = 1
	IOLD_RECORD = 0
	I = 1
	IPOINTER_32 = 0
	CALL MOVE_FILE_POINTER(IFILE_2,IERR,IP(1),IP(2))

	new_menu = .true.
	key = ' '
	iop = 0
	icsec_last = 0
100	CONTINUE
c
c	    Update menu if a key has been pressed
c
	    if( key .ne. char(0) ) then
		iop = IMENU_VERTICAL1(menu,'123$'
     &		,nmenu,imenu_left,1,new_menu,iop,' Options ',key)
		key = char(0)
	    endif
c
c	    Get a key for use next time round loop

	    call get_time( ihr, imin, isec, icsec )
	    if( icsec .ne. last_checked ) then
		call get_key( key, special )
		last_checked = icsec
	    endif

C
C	    Get data record
C
	    IF(IRECORD.NE.IOLD_RECORD) THEN
		CALL GET_RECORD(IRECORD)
		IF(IRECORD.EQ.1) THEN
		    IZERO_LEVEL = IBUFFER(1)
		    ZERO_LEVEL = FLOAT(IZERO_LEVEL)
		    IZERO_OLD = 0
		ENDIF
		IOLD_RECORD = IRECORD
		I = MOD(I-1,NP_RECORD) + 1
		NEW_PLOT = .TRUE.
	    ENDIF
C
C	    Display signal on screen
C
	    IF( ( DISPLAY_ON ) .AND. ( NEW_PLOT ) ) THEN
		CALL FILL_RECTANGLE(ISCREEN,IDISPLAY_AREA)
		CALL YT_PLOT(ISCREEN,IBUFFER,NP_RECORD)
		CALL SET_WRITING_MODE(ISCREEN,3)
		CALL SET_POLYLINE_TYPE(ISCREEN,5)
		CALL YT_HORIZONTAL_CURSOR(ISCREEN,IZERO_OLD)
		CALL SET_POLYLINE_TYPE(ISCREEN,3)
		CALL YT_HORIZONTAL_CURSOR(ISCREEN,IZERO_OLD+ITRIGGER_LEVEL)
		CALL SET_POLYLINE_TYPE(ISCREEN,1)
		CALL SET_WRITING_MODE(ISCREEN,1)
		NEW_PLOT = .FALSE.
	    ENDIF
C
	    IF((IZERO_OLD .NE. IZERO_LEVEL) .AND. ( DISPLAY_ON )) THEN
		CALL SET_WRITING_MODE(ISCREEN,3)
		CALL SET_POLYLINE_TYPE(ISCREEN,5)
		CALL YT_HORIZONTAL_CURSOR(ISCREEN,IZERO_OLD)
		CALL YT_HORIZONTAL_CURSOR(ISCREEN,IZERO_LEVEL)
		CALL SET_POLYLINE_TYPE(ISCREEN,3)
		CALL YT_HORIZONTAL_CURSOR(ISCREEN,IZERO_OLD
     &		+ITRIGGER_LEVEL)
		CALL YT_HORIZONTAL_CURSOR(ISCREEN,IZERO_LEVEL
     &		+ITRIGGER_LEVEL)
		IZERO_OLD = IZERO_LEVEL
		CALL SET_POLYLINE_TYPE(ISCREEN,1)
		CALL SET_WRITING_MODE(ISCREEN,1)
	    ENDIF
C
C ------    Event detection procedure ---------------------------------
C	    If difference between sample point and IZERO_LEVEL
C	    exceeds ITHRESHOLD_LEVEL, increment above-threshold counter
C	    ITRIGGER_TIME. If ITRIGGER_TIME >= NTRIGGER_TIME, then
C	    store the position of this event in detected list file.
C
	    ICURR = IPOLARITY*(IBUFFER(I)-IZERO_LEVEL)
	    IF( ICURR .GE. ITRIGGER_ABS ) THEN
		IF( ITRIGGER_TIME .EQ. 0  ) THEN
		    IEVENT_START = I
		    IEVENT_RECORD = IRECORD
		    IEVENT_ZERO = IZERO_LEVEL
		ENDIF
		ITRIGGER_TIME = ITRIGGER_TIME + 1
		IF( ITRIGGER_TIME .GE. NTRIGGER_TIME ) THEN
		    N_EVENTS = N_EVENTS + 1
C
C		    Time since last event of this type
C
		    TIME_EVENT = FLOAT(IEVENT_START-ICAL_CURSOR)*DT
     &		    + T_RECORD*(IEVENT_RECORD-ICAL_RECORD)
		    RECORD = FLOAT(N_EVENTS)
		    IEVENT_TYPE = 2
		    CALL WRITE_BYTES(IFILE_2,IERR,IEVENT_BUFFER
     &		    ,NBYTES_EVENT)
		    CHANGE_STATUS = .TRUE.
		    I = I + NDEAD_TIME
		    ITRIGGER_TIME = 0
		ENDIF
	    ELSE
		ITRIGGER_TIME = 0
	    ENDIF
C
C	    Automatic zero current baseline update
C
	    ZERO_LEVEL = (FLOAT(IBUFFER(I))+ZERO_LEVEL
     &	    *RUNNING_MEAN)/RUNNING_MEAN1
	    IZERO_LEVEL = int(ZERO_LEVEL)

	    IF(IOP .NE. 0) THEN
	    GOTO(1,2,3,4) IOP
C
C -- 		F1 - Start/Pause
C
1		IF( .NOT. SCROLL ) THEN
		    menu(1) = 'Pause Search F1'
		    SCROLL = .TRUE.
		ELSE
		    menu(1) = 'Start Search F1'
		    SCROLL = .FALSE.
		ENDIF
		new_menu = .true.
		CHANGE_STATUS = .TRUE.
		GOTO 110
C
C -- 		F2 - Set detection criteria
C
2		CALL SET_DETECTOR
		NDEAD_TIME = int(DEAD_TIME/DT)
		NTRIGGER_TIME = int(TRIGGER_TIME/DT)
		ITRIGGER_LEVEL = int(TRIGGER_LEVEL*40.96)
		ITRIGGER_ABS = IABS(ITRIGGER_LEVEL)
		IF(ITRIGGER_LEVEL .LT. 0) THEN
			IPOLARITY = -1
		ELSE
			IPOLARITY = 1
		ENDIF
		RUNNING_MEAN1 = RUNNING_MEAN + 1.
		CHANGE_STATUS = .TRUE.
		NEW_PLOT = .TRUE.
		GOTO 110
C
C -- 		F3 Start/Stop display
C
3		IF( DISPLAY_ON ) THEN
		    menu(3) = 'Display On   F3'
		    DISPLAY_ON = .FALSE.
		ELSE
		    menu(3) = 'Display Off  F3'
		    DISPLAY_ON = .TRUE.
		ENDIF
		CHANGE_STATUS = .TRUE.
		new_menu = .true.
		GOTO 110
C
C -- 		Set quit flag
C
4		call query_box(5,5,' Abort search (Y/N) ? ',key)
		IF(KEY.EQ.'Y') quit = .true.
		GOTO 110

110		CONTINUE
		iop = 0
		key = ' '
	    ENDIF
C
C	    Update status display if it has changed
C
	    IF( CHANGE_STATUS ) THEN
		CALL MOVE_CURSOR(imenu_left+1,istatus_top+1)
		WRITE(STRING16,'(''Rec. '',I5,''/'',I5)') IRECORD,
     &		N_RECORDS
		CALL DISPLAY_STRING(STRING16)

		CALL MOVE_CURSOR(imenu_left+1,istatus_top+2)
		WRITE(STRING16,'(''Events     '',I5)') N_EVENTS
		CALL DISPLAY_STRING(STRING16)
		CALL MOVE_CURSOR(imenu_left+1,istatus_top+3)
		IF( .not. scroll ) THEN
		    CALL DISPLAY_STRING('PAUSE')
		ELSE
		    CALL DISPLAY_STRING('     ')
		ENDIF
		CALL MOVE_CURSOR(imenu_left+1,istatus_top+4)
		IF( .not. DISPLAY_ON ) THEN
		    CALL DISPLAY_STRING('DISPLAY OFF')
		ELSE
		    CALL DISPLAY_STRING('DISPLAY ON ')
		ENDIF
		CHANGE_STATUS = .FALSE.
	    ENDIF
C
	    IF( SCROLL ) THEN
C
C	    Increment buffer pointer I, and record pointer IRECORD
C	    every NP_RECORD counts
C
		I = I + 1
		IRECORD = (I-1)/NP_RECORD + IRECORD
	    ENDIF

	IF((IRECORD.LE.N_RECORDS) .AND. ( .not. QUIT ) ) GOTO 100

120	continue
C
C	Pad end of CDR.EVE with 16 transition records to ensure
C	a complete block is written (for PATSAV)
C
	DO 200 I = N_EVENTS+1,N_EVENTS+16
		CALL WRITE_BYTES(IFILE_2,IERR,IEVENT_RECORD,NBYTES_EVENT)
200	CONTINUE
C
C	Close and re-open event list file to make it permanent in
C	case of a crash
C
	CALL CLOSE_FILE(IFILE_2,IERR)
	CALL OPEN_FILE(IFILE_2,IERR,'\gemapps\gemsys\CDR.EVE')
C
	menu(1) = 'Start Search F1'
	RETURN
	END

	SUBROUTINE SET_DETECTOR
$INCLUDE: 'CDRCOM.FOR'
C
C	Set event detection criteria
C
	PARAMETER (nrows=4)
	CHARACTER*50 TITLE
	CHARACTER*40 MENU(nrows) /
     &	' Trigger level (+/-% full scale)',
     &	' Trigger duration (ms)',
     &	' Post-trigger dead time (ms) ',
     &	' Zero level running mean period (ms) ' /
	character*12 text(nrows)

C
C	CODE
C
	i = 1
	write( text(i), '(f12.3)' ) trigger_level
	i = i + 1
	write( text(i), '(f12.3)' ) trigger_time
	i = i + 1
	write( text(i), '(f12.3)' ) dead_time
	i = i + 1
	write( text(i), '(f12.3)' ) running_mean*dt
C
	title = ' '
100	if( title .eq. ' ' ) then
	    title = ' Set event detection criteria '
	endif
	CALL TEXT_WINDOW(MENU,TEXT,NROWS,3,5,title)
C
c	Get interface card in use, and find out min./max. sampling
c	and input voltage range
c
	I = 1
	trigger_level = check_limits(text,-1E30,1E30,i,title)
	if( title .ne. ' ' ) goto 100
	I = i + 1
	trigger_time = check_limits(text,0.,1E30,i,title)
	if( title .ne. ' ' ) goto 100
	I = i + 1
	dead_time = check_limits(text,0.,1E30,i,title)
	if( title .ne. ' ' ) goto 100
	I = i + 1
	running_mean = check_limits(text,0.,1E30,i,title)/dt
	if( title .ne. ' ' ) goto 100
C
	RETURN
	END
	SUBROUTINE EXIT_QUERY(IL,IT,KEY)
	CHARACTER*(*) KEY
	CHARACTER KEY1
C
	CALL QUERY_BOX(IL,IT,' Exit! Are you sure (Y/N) ? ',KEY1)
	IF(KEY1.NE.'Y') THEN
		KEY = ' '
	ENDIF
	RETURN
	END
