	SUBROUTINE MATCH_EVENTS(IA_START,IA_END)
$INCLUDE: 'CDRCOM.FOR'
C
C	Match events stored in file CDR.EVE. Limits of matching
C	area defined by IA_START, IA_END which are offsets relative
C	IEVENT_OFFSET. (IA_START & IA_END are initialy set
C	IA_START = 0 IA_END = NP_DEAD or NP_RECORD which ever is smaller)
C	Results (residual S.D.s are placed in TABLE (accessible with
C	the LIST SAVED key in DISPLAY_EVENTS
C

	PARAMETER(NROWS=4)
	CHARACTER*42 MENU(NROWS)
	CHARACTER*12 LIST(NROWS)
	character*44 title
	CHARACTER*50 STRING
	character*32 msg(3)
	CHARACTER KEY
	LOGICAL SPECIAL
	PARAMETER( MAX_ROW=1500,MAX_COL=2)
	INTEGER*2 IMATCH_BUFFER(1536)
	REAL TABLE(MAX_COL,MAX_ROW)
	EQUIVALENCE (IWORK(1),TABLE),(IMATCH_BUFFER,IWORK(4501))
C
C	CODE
C
C
C	Let user set up match parameters
C
	MENU(1) = ' Start at event '
	MENU(2) = ' End at event '
	MENU(3) = ' Match to event '
	MENU(4) = ' Match threshold (Residual SD)'
	iev_sta = 1
	WRITE(LIST(1),'(i5)') iev_sta
	iev_end = N_EVENTS
	WRITE(LIST(2),'(i5)') iev_end
	WRITE(LIST(3),'(i5)') min(max(IM_EVENT,1),n_events)
	SD_MATCH = BIT_CURRENT*100.
	WRITE(LIST(4),'(1pg12.3)') SD_MATCH
C
5	title = ' MATCH EVENTS: Set match criteria '
	CALL TEXT_WINDOW(MENU,LIST,NROWS,3,5,title)
C
	I = 1
	iev_sta = int(check_limits(list,1.,float(n_events),i,title))
	if( title .ne. ' ' ) goto 5

	I = i + 1
	iev_end = int(check_limits(list,float(iev_sta),float(n_events),
     &	 i,title))
	if( title .ne. ' ' ) goto 5

	I = i + 1
	im_event = int(check_limits(list,1.,float(n_events),
     &	 i,title))
	if( title .ne. ' ' ) goto 5
C
	I = i + 1
	sd_match = check_limits(list,0.,1E30,i,title)
	if( title .ne. ' ' ) goto 5

C
	msg(1) = 'WAIT ... Matching events '
	msg(2) = ' '
	msg(3) = ' '
	call display_message(4,6,30,msg,3)
	ixc = 5
	iyc = 8
C
C --	Find start and end (10%) level points of event to be used as the
C	model for matching
C
	CALL GET_EVENT(IM_EVENT,IRECORD)
	IEVENT_OFFSET = IEVENT_START + (IEVENT_RECORD-IRECORD)
     &*NP_RECORD
	I_START = MAX0(IEVENT_OFFSET + IA_START,1)
	I_END = MIN0(NP_RECORD+I_START-1,IA_END+IEVENT_OFFSET)
C
C	Calculate and subtract baseline
C
	CALL ADD_ARRAY(-IEVENT_ZERO,IBUFFER(I_START),NP_RECORD)
C
C	Peak analysis
C
	ISIGN = 1
	IF(TRIGGER_LEVEL.LE.0.) THEN
		ISIGN = -1
		CALL NEGATE_ARRAY(IBUFFER(I_START),NP_RECORD)
	ENDIF		
C
	CALL MAX_ARRAY(IBUFFER(I_START),I_END-I_START+1
     &,IPEAK_LEVEL,IPEAK)
	IPEAK = IPEAK + I_START - 1
	LEVEL_10 = IPEAK_LEVEL/10
C
C	Find start of event
C
	DO 110 I=IPEAK,I_START,-1
	IF(IBUFFER(I).LT.LEVEL_10) GOTO 111
110	CONTINUE
111	CONTINUE
	IM_START = I
C
C	Find end of event
C
	DO 120 I = IPEAK,I_END
		IF(IBUFFER(I).LT.LEVEL_10) GOTO 121
120	CONTINUE
121	CONTINUE
	IM_END = I
	NP_MATCH = IM_END - IM_START + 1
C
C	Copy model event to match buffer
C
	CALL COPY_ARRAY(IBUFFER,IMATCH_BUFFER,NP_RECORD*3)
C
C --	Scan through events to finds matches to the event in IMODEL
C
	N_MATCH = 0
	DO 200 IEVENT = iev_sta,iev_end
C
C		Check for Esc key
C
		CALL GET_KEY(KEY,SPECIAL)
		IF(KEY.EQ.'$') goto 200
C
C		Read in data for event
C
		CALL GET_EVENT(IEVENT,IRECORD)
C
C		Update screen every 10th event processed
C
		IF(MOD(IEVENT,10).EQ.0) THEN
			CALL MOVE_CURSOR(ixc,iyc)
			WRITE(STRING,9100) IEVENT,iev_end
9100			FORMAT('Events ',I5,'/',I5)
			CALL DISPLAY_STRING(STRING(1:18))
			WRITE(STRING,9101) N_MATCH
9101			FORMAT('Matchs ',I5)
			CALL MOVE_CURSOR(ixc,iyc+1)
			CALL DISPLAY_STRING(STRING(1:12))
		ENDIF
C
C		Set initial area of IBUFFER to look for event
C
		IEVENT_OFFSET = IEVENT_START + (IEVENT_RECORD-IRECORD)
     &	*NP_RECORD
		I_START = MAX0(IEVENT_OFFSET + IA_START,1)
		I_END = MIN0(NP_RECORD+I_START-1,IA_END+IEVENT_OFFSET)
C
C		Calculate and subtract baseline
C
		CALL ADD_ARRAY(-IEVENT_ZERO,IBUFFER(I_START)
     &	,NP_RECORD)
C
C		Find peak of event 
C
		IF(ISIGN.EQ.-1) THEN
			CALL NEGATE_ARRAY(IBUFFER(I_START),NP_RECORD)
		ENDIF		
C
		CALL MAX_ARRAY(IBUFFER(I_START),I_END-I_START+1
     &	,IPEAK_LEVEL,IPEAK)
		IPEAK = IPEAK + I_START - 1
		LEVEL_10 = IPEAK_LEVEL/10
C
C		Find start of event (10% of peak)
C
		DO 210 I=IPEAK,I_START,-1
			IF(IBUFFER(I).LE.LEVEL_10) GOTO 211
210		CONTINUE
211		CONTINUE
		IE_START = I
C
C		Calculate residual standard deviation between matching
C		segments of current event and model event
C
		J = IE_START
		SUM_Y2 = 0.
		DO 220 I = IM_START,IM_END
			Y = FLOAT(IBUFFER(J)-IMATCH_BUFFER(I))
			SUM_Y2 = SUM_Y2 + Y*Y
			J = J + 1
220		CONTINUE
		SD = BIT_CURRENT*SQRT(SUM_Y2/FLOAT(NP_MATCH))
C
C		If SD is less than threshold at it to match list
C
		IF(SD.LE.SD_MATCH) THEN
			N_MATCH = N_MATCH + 1
			TABLE(1,N_MATCH) = RECORD
			TABLE(2,N_MATCH) = SD
		ENDIF
	IF(N_MATCH .GE. MAX_ROW) GOTO 201
200	CONTINUE
201	CONTINUE
C
C	Display table of events
C
	CALL DISPLAY_STRING(' Matching events ')
	CALL LIST_TABLE(TABLE,MAX_COL,N_MATCH,10,2,3
     &,'Record No.       '//Y_UNITS//'**2 ')
C
	RETURN
	END

