	SUBROUTINE view_recording
$INCLUDE: 'cdrcom.for'
C
	PARAMETER(IMENU_LEFT=63,IMENU_TOP=1,NCOL=1)
	CHARACTER*60 STRING
	INTEGER*2 IXY(4),iarea(4)
	LOGICAL NEW_STATUS,NEW_PLOT,SPECIAL
	REAL Y_VALUE
	character key

	 parameter(nrow=8)
	 character*15 menu(nrow) /
     &	 'Expand Disp.  +',
     &	 'Next  Page PgDn',
     &	 'Prev. Page PgUp',
     &	 'Plot Display F1',
     &	 'Save Cursor  F2',
     &	 'Set T. Zero  F3',
     &	 'Calibration  F4',
     &	 'Exit        ESC' /

	logical new_menu
c
c	Display magnification, offsets & colour
c
	integer*2 iy_scale /1/
	integer*2 min_y_scale /6/
	integer*2 max_y_scale /128/
	integer*2 iy_offset /0/
	integer*2 icolour / 1 /

C
C	CODE
C

	call get_text_attributes( iscreen, i,i,i,i,i,
     &	ichar_width,ichar_height)

	istatus_top = 25 - 2

c
c	Load file overview
c
	min_sector = 2
	max_sector = (np_record/np_sector)*n_records + min_sector

	isector_start = min_sector
	isector_end = max_sector

	call load_data_buffer( min_sector, max_sector, icondensed_buf,
     &	iskip_con, np_con )
	call copy_array( icondensed_buf,iexpanded_buf,np_con )
	np_exp = np_con
	iskip_exp = iskip_con
	icursor = np_exp/2
	dt_con = dt*float(iskip_con)/1000.
	ips = 1
	ipe = np_exp

C
	ISAVE_FILE = 0

	NEW_STATUS = .TRUE.
	NEW_PLOT = .TRUE.
	new_menu = .true.
C
	CALL ERASE_ALL

100	CONTINUE

	    CALL SET_MARGINS(1,1,80,25)

	    key = ' '
	    iop = IMENU_VERTICAL1(menu,'+QP1234$'
     &	    ,nrow,imenu_left,1,new_menu,iop,' Options ',key)

C
C	    Erase and re-display screen
C
	    IF( NEW_PLOT ) THEN
C
c		Find range of points within buffer (containing
c		condensed record of whole data file) spanned
c		by expanded record

		scale = float(np_sector)/float(iskip_con)
		ips = int( float(isector_start-min_sector)*scale ) + 1
		ipe = int( float(isector_end-min_sector+1)*scale ) - 1
		dt_exp = dt*float(iskip_exp)/1000.

		iheight = max_adc*6
		ilength = ((60*ichar_width)/max_points)*max_points

		CALL ERASE_BOX(1,1,62,21)
		CALL DISPLAY_BOX(1,1,62,21)

		call move_cursor(2,21)
		t_min = float(ips-1)*dt_con
		write(string,'(F7.1,''s'')') t_min
		call display_string( string(1:9) )

		call move_cursor(50,21)
		t_max = float(ipe)*dt_con
		write(string,'(F7.1,''s'')') t_max
		call display_string( string(1:9) )

c
c		Display each channel in its own area within display
c		window
c
		ibottom = ndc_max - iheight - ichar_height
		ileft = ichar_width
		iarea(1) = ileft
		iarea(3) = iarea(1) + ilength
		iarea(2) = ibottom
		min_y_scale = max( iheight/max_adc, 1 )
		iarea(4) = iarea(2) + max_adc*min_y_scale
		iy_scale = max(min_y_scale,iy_scale)

		call enable_clipping( iscreen, iarea )

		call plot_channel( iscreen, iarea,
     &		iexpanded_buf, 1, 1, 1, np_exp,
     &		iy_scale, iy_offset, icolour )

c
c		Draw channel zero level
c
		ixy(1) = iarea(1)
		ixy(3) = iarea(3)
		ixy(2) = (ical_current - iy_offset) * iy_scale + iarea(2)
		ixy(4) = ixy(2)
		call set_polyline_type( iscreen, 3 )
		call set_polyline_colour( iscreen, icolour )
		call set_writing_mode( iscreen, 2 )
		call polyline( iscreen, ixy, 2 )
		call set_polyline_type( iscreen, 1 )
		call set_writing_mode( iscreen, 1 )
		call set_polyline_colour( iscreen, 1 )

		call disable_clipping( iscreen, iarea )

C		Plot cursor

		iarea(2) = ndc_max - iheight - ichar_height
		iarea(4) = ndc_max - ichar_height
		call display_vertical_cursor(iscreen,iarea,icursor,np_exp)
		iold_cursor = icursor
		NEW_PLOT = .FALSE.
		NEW_STATUS = .TRUE.
	    ENDIF

	    if( new_status ) then
C
C		Display cursor and update status window
C
		CALL SET_WRITING_MODE(ISCREEN,3)
		call display_vertical_cursor(iscreen,iarea,iold_cursor,
     &		np_exp)
		call display_vertical_cursor(iscreen,iarea,icursor,np_exp)
		iold_cursor = icursor

		CALL SET_WRITING_MODE(ISCREEN,1)

		CALL DISPLAY_BOX(63,istatus_top-1,79,25)
		CALL SET_MARGINS(64,istatus_top,78,24)
		CALL MOVE_CURSOR(64,istatus_top)

c
c		Cursor Time position
c
		t_value = float(icursor-1)*dt_exp + t_min - t_zero
		write( string, '(''T   '',f7.2,''s'')') t_value
		call display_string( string(1:14) )
		call new_line

		y_value = float(iexpanded_buf(icursor)
     &		- ical_current ) * bit_current
		write( string, '(a,1x,f8.2,a)') 'Y:',
     &		y_value, y_units
		call display_string( string(1:14) )

		NEW_STATUS = .FALSE.
		CALL SET_MARGINS(1,1,80,25)
	    ENDIF
c
c	    Wait for user to press a key
c
	    call wait_for_key( key, special )

C
C	    If <- or -> keys have been pressed, move cursor
C
	    iop = 0
	    if( (KEY.EQ.'L') .and. special ) THEN
C		<- Move cursor 1 point to left
		new_status = .true.
		iold_cursor = icursor
		ICURSOR = MAX0(ICURSOR - 1,1)
	    elseif( (KEY.EQ.'R') .and. special	) THEN
C		 -> Move cursor 1 point to right
		new_status = .true.
		iold_cursor = icursor
		ICURSOR = MIN0(ICURSOR + 1,np_exp)
	    elseif( (KEY.EQ.'B') .and. special	) THEN
C		 CTRL + <- Move cursor 20 points to left
		new_status = .true.
		iold_cursor = icursor
		ICURSOR = MAX0(ICURSOR - np_exp/20,1)
	    elseif( (KEY.EQ.'F') .and. special	) THEN
C		 CTRL + -> Move cursor 20 points to right
		new_status = .true.
		iold_cursor = icursor
		ICURSOR = MIN0(ICURSOR + np_exp/20,np_exp)
	    else
C
c		Present options menu and return "iop=1..10" if
c		an option has been selected. "iop=0" if no selection
c
		iop = IMENU_VERTICAL1(menu,'+QP1234$'
     &		,nrow,imenu_left,1,new_menu,iop,' Options ',key)

	    ENDIF

C
C	    If a menu option has been selected - go do it.
C
	    IF(IOP.GT.0) THEN
		GOTO (1,2,3,4,5,6,7,8) IOP
C
C ------------- Set channel display magnification
c
1		np = ipe - ips + 1


		call change_display_magnification( icondensed_buf,
     &		ips,np,iy_scale,iy_offset,min_y_scale,max_y_scale,
     &		icolour, ileft, ibottom, ilength, iheight, np_con )

		ipe = ips + np - 1
		isector_start = int(float(ips-1)/scale +0.1)
     &		+ min_sector
		isector_end = int(float(ipe-1)/scale +0.1) + min_sector

		if( (isector_start .ne. isector_start_old) .or.
     &		(isector_end .ne. isector_end_old) ) then
		    call load_data_buffer( isector_start, isector_end,
     &		    iexpanded_buf, iskip_exp, np_exp )
		endif

		icursor = np_exp/2

		new_plot = .true.
		new_menu = .true.
		new_status = .true.
		goto 110
c
c ------------ Next Page
c
2		isector_start_old = isector_start
		isector_end_old = isector_end

		n_sectors = isector_end - isector_start + 1
		isector_end = min(isector_end+n_sectors/2,max_sector)
		isector_start = isector_end - n_sectors + 1

		if( (isector_start .ne. isector_start_old) .or.
     &		(isector_end .ne. isector_end_old) ) then
		    call load_data_buffer( isector_start, isector_end,
     &		    iexpanded_buf, iskip_exp, np_exp )
		endif

		icursor = np_exp/2

		new_plot = .true.
		new_menu = .true.
		new_status = .true.

		goto 110

c
c ------------ Previous Page
c
3		isector_start_old = isector_start
		isector_end_old = isector_end

		n_sectors = isector_end - isector_start + 1
		isector_start = max(isector_start-n_sectors/2,min_sector)
		isector_end = isector_start + n_sectors - 1

		if( (isector_start .ne. isector_start_old) .or.
     &		(isector_end .ne. isector_end_old) ) then
		    call load_data_buffer( isector_start, isector_end,
     &		    iexpanded_buf, iskip_exp, np_exp )
		endif

		icursor = np_exp/2
		new_plot = .true.
		new_menu = .true.
		new_status = .true.
		goto 110

C
C ------------ Plot hard copy
C
4	       write(string,'(a,f7.2,''-'',f7.2,''s'')') file_name,
     &	       t_min,t_max

	       t_units = 's'
	       call plot_display( iexpanded_buf, np_exp,
     &	       iy_scale, min_y_scale, iy_offset, icolour,
     &	       dt_exp, t_zero - t_min, string )
	       t_units = 'ms'
	       CALL ERASE_ALL
	       NEW_STATUS = .TRUE.
	       NEW_PLOT = .TRUE.
	       new_menu = .true.
	       GOTO 110
C
C ------------ Save cursor reading to log file
C
5	       CALL SAVE_READING(T_VALUE,Y_VALUE,ISAVE_FILE,new_plot)
	       GOTO 110
C
C ------------ Set zero time point
C
6		t_zero = float(icursor-1)*dt_exp + t_min
		NEW_STATUS = .TRUE.
		GOTO 110

c
c ------------ calibrate channels
c
7		call calibrate_channels( iexpanded_buf(icursor) )

		new_plot = .true.
		new_menu = .true.
		new_status = .true.
		goto 110
C
C
C ------------ Return to main menu (close the save file if it is open)
C
8	       IF(ISAVE_FILE.NE.0) CALL CLOSE_FILE(ISAVE_FILE,IERR)
	       CALL ERASE_ALL
	       RETURN
C
110	       CONTINUE
	    ENDIF
	GOTO 100
	END

	SUBROUTINE SAVE_READING(T_VALUE,Y_VALUE,ISAVE_FILE,new_plot)
$INCLUDE: 'cdrcom.for'
	REAL Y_VALUE
	CHARACTER*50 TEXT
	logical new_plot
C
C	Save cursor readings in T_VALUE and Y_VALUE to ASCII file
C	opened with handle ISAVE_FILE. Update TEXT to let operator
C	know what has happened
C
	CHARACTER*12 SAVE_FILE / ' ' /
	LOGICAL ABORT
	real row(10)
C
C	CODE
C
C	Open file if one isn't already open
C
	IF( ISAVE_FILE .EQ. 0 ) THEN
	    call file_box(3,5,save_file,' ','NEW'
     &	    ,' Save to file ',abort)
	    if( .not. abort ) then
		call create_file(isave_file,ierr,save_file)
		nrows = 0
	    endif
	    new_plot = .true.
	ENDIF
	if( abort ) return
C
C	Write to save file
C
	ncols = 1
	row(ncols) = t_value
	ncols = ncols + 1
	row(ncols) = y_value
c
c	Write line to file in ASCII format
c
	call write_ascii_list(isave_file,row,ncols,1)

	nrows = nrows + 1
C
C	Tell user
C
	write(text,'(i5,'' Points saved in '',a)') nrows,save_file
	call move_cursor(2,25)
	call display_string( text )
C
	RETURN
	END

	subroutine load_data_buffer( isector_start, isector_end,
     &	ibuf, iskip, n_points )
$include: 'cdrcom.for'
	integer*2 ibuf(1)
	integer*4 isum4,n4,navg4
c
c	code
c
	call move_cursor(2,2)
	call display_string(' ... WAIT ')
c
c	Find total number of sample points in file
c	then determine the number of points to be skipped
c	to make the file segment fit into a buffer of "max_points"
c
	nsectors = isector_end - isector_start + 1
	points = float(nsectors)*float(np_sector)
	iskip = (int( points/float(max_points) ) + 1)

c
c	Read the data file, skipping every "iskip" points
c	into the buffer "ibuf"
c
	i = 1
	j = 0
	navg4 = iskip
	isum4 = 0
	n4 = 0
	do 10 isector = isector_start,isector_end

	    call read_file( ifile_1, ierr, ibuffer, isector, 1 )
	    do 10 i = 1,np_sector
		isum4 = ibuffer(i) + isum4
		n4 = n4 + 1
		if( n4 .eq. navg4 ) then
		    j = j + 1
		    ibuf(j) = (isum4 / n4)
		    n4 = 0
		    isum4 = 0
		endif
10	continue
	n_points = j

	return
	end

	subroutine change_display_magnification( ibuf,
     &	i0,np_exp,iy_scale,iy_offset,min_y_scale,max_y_scale,
     &	icolour,ileft, ibottom, ilength, iheight, np_con )
$include:'cdrcom.for'
	integer*2 ibuf(1),iy_scale,iy_offset,
     &	min_y_scale,max_y_scale,
     &	icolour,iarea(4)

	integer*2 ich /1/
c
c	code
c
	ich = 1
c
c	Erase selected Display area
c
	iarea(1) = ileft
	iarea(3) = iarea(1) + ilength
	iarea(2) = ibottom
	iarea(4) = iarea(2) + iheight
	call fill_rectangle( iscreen, iarea )

c
c	Re-draw channel at minimum magnification
c
	max_y = 4096
	min_dx = (iarea(3) - iarea(1))/np_con
	max_dx = 128*min_dx

	call plot_channel( iscreen, iarea, ibuf,
     &	1, 1, 1, np_con, min_y_scale,
     &	0, icolour )

c
c	Superimpose box indicating current magnified display
c	area and let user move box's size and location
c
	call set_display_window(iarea
     &	,min_dx,max_dx,min_y_scale,max_y_scale,max_adc
     &	,i0,np_exp,iy_scale,iy_offset,1,22)

	return
	end

	subroutine calibrate_channels( inew_cal )
$include:'cdrcom.for'
c
c	Calibrate channels, defining A/D unit (0-4096) to
c	real units (pA,nS,mV etc.) scale factor "bit_current" and
c	zero level for each channel "ical_current".
c
	parameter(nlist=3)
	character*14 list(nlist)
	character*38 menu(nlist) /
     &	' Units (2 letters)',
     &	' Scale factor (mV/Units)',
     &	' Level ( Units )' /

	character*40 title
	integer*2 ic / 1 /
c
c	code
c

	list(1) = y_units

	write(list(2),'(1pg12.4)') convert_gain(bit_current)

	write(list(3),'(1pg12.4)') float( inew_cal -ical_current)*
     &	bit_current

C
	title = ' '
15	if( title .eq. ' ' ) title = ' Calibration Values '
	CALL TEXT_WINDOW(MENU,LIST,nlist,3,3+ic,title)

	is = ileading_space( list(1) )
	y_units = list(1)(is:14)

	r = check_limits(list,0.,1E30,2,title)
	if( title .ne. ' ' ) goto 15
	bit_current = convert_gain( r )

	r = check_limits(list,-1E30,1E30,3,title)
	if( title .ne. ' ' ) goto 15
	ical_current = inew_cal - int( r / bit_current )

	return
	end

