	SUBROUTINE RECORD_SIGNAL
$INCLUDE: 'CDRCOM.FOR'
C
C	Continuos adc data collection routine
C	from channel 0 of ADC to file CDR.DAT
C
	LOGICAL special,new_menu
	INTEGER IXY(4)
	character*28 msg(2)
	CHARACTER*12 LABEL
	CHARACTER*1 KEY
	parameter(nmenu=3,istatus_left=64)
	character*15 menu(nmenu) /
     &	'RECORD       F1',
     &	'COMMENT      F2',
     &	'CANCEL      ESC'/

	PARAMETER( n_points=512)
	parameter(itrigger_immediate=0,irepeat_mode=2,isingle_sweep=0
     &	,n_channels=1)

C
C	CODE
C

C
C -- Set up A/D converter ------------------------------------------
C
	CALL OPEN_LAB(INTERFACE_CARD,IERR)

	call erase_all
	CALL GET_SCREEN_DEVICE(ISCREEN)
C
C -- Set size of display area
C 
	CALL SET_CHARACTER_HEIGHT(ISCREEN,1000)
	CALL GET_CHARACTER_SIZE(IW,IH)
	IDISPLAY_AREA(1) = IW
	IDISPLAY_AREA(2) = NDC_MAX - 24576 - IH
	IDISPLAY_AREA(3) = IDISPLAY_AREA(1) + ((60*IW)/512)*512
	IDISPLAY_AREA(4) = IDISPLAY_AREA(2) + 24576
	CALL SET_SIZE(IDISPLAY_AREA(1),IDISPLAY_AREA(2)
     &	,IDISPLAY_AREA(3),IDISPLAY_AREA(4))
C
C-- Draw display border and help information -------------------
C	
	T_MIN = 0.
	T_MAX = FLOAT(N_POINTS)*DT
	CALL DISPLAY_BOX(1,1,62,21)
	CALL MOVE_CURSOR(2,1)
	CALL DISPLAY_STRING(
     &	' Record from analogue input Ch.0 to disc ')
	CALL MOVE_CURSOR(2,21)
	WRITE(LABEL,'(F7.2,1X,A)') T_MIN,T_UNITS
	CALL DISPLAY_STRING(LABEL)
	WRITE(LABEL,'(F7.2,1X,A)') T_MAX,T_UNITS
	CALL MOVE_CURSOR(50,21)
	CALL DISPLAY_STRING(LABEL)
C
c	Master loop
c	-----------
c
	key = ' '
	iop = 0
	new_menu = .true.
100	continue
c
c	    Update menu if a new key has been pressed
c	    Set "iop" if an operation has been selected.
c
	    if( key .ne. char(0) ) then
		iop = IMENU_VERTICAL1(menu,'12$'
     &		,nmenu,istatus_left-1,1,new_menu,iop,' Options',key)
	    else
		iop = 0
	    endif

c
c	    Record a single record of samples for preview
c	    and display on screen
c
	    CALL ADC_TO_MEMORY(DT,N_CHANNELS,N_POINTS
     &	    ,itrigger_immediate,IWORK,IS
     &	    ,isingle_sweep,RANGE_volts,KEY)
	    CALL erase_box(2,2,61,20)
	    call yt_plot( iscreen, iwork(is), n_points )
c
c	    If an option has been selected - process it
c
	    if( iop .eq. 1 ) then
c
c		Record signal
c
		msg(1) = ' * RECORDING IN PROGRESS * '
		msg(2) = '    Press ESC to abort.'
		call display_message(3,5,30,msg,2)
C
C		Write a record to place disc heads at start of file
C
		ISTART = 2
		CALL PUT_RECORD(istart,IFILE_1)

c
c		Start repeatedly filling DMA buffer with A/D samples
c
		NBYTES_BUFFER = NP_BUFFER*2
		nbreqd = int( (recording_time*1000.) / (dt*256 ) )
		NBUFFERS = MAX0(1,NBREQD/(NP_BUFFER/256) )
		IERR = 0
		CALL ADC_TO_MEMORY(DT,n_channels,NP_BUFFER
     &		,itrigger_immediate,IWORK,IWS
     &		,irepeat_mode,RANGE_VOLTS,KEY)

C		As each half of DMA buffer (IWORK(IWS)...) becomes full
C		transfer it to disc. Continue until NBUFFERS are written
C		or ESC key is pressed

		CALL TO_DISC(IFILE_1,IERR,IWORK(IWS)
     &		,NBYTES_BUFFER,NBUFFERS,ISTART,NWRITTEN)

C		Stop A/D conversion and tidy up interface
C
		CALL ADC_STOP
		call close_lab( interface_card )
		N_RECORDS = NWRITTEN*(NP_BUFFER/NP_RECORD)
		n_events = 0
		call beep
		return

	    elseif( iop .eq. 2 ) then
c
c		Enter comment line
c
		call text_window(' ? ',cell(1:50),1,3,5
     &		,' Enter comment line ')

	    elseif( iop .eq. 3 ) then
c
c		Return to main menu
c
		call close_lab(interface_card)
		return
	    endif
	goto 100
	END
	subroutine beep
	integer*1 ibeep /7/
	integer*2 iconsol_out / 1 /
	call write_bytes( iconsol_out,ierr,ibeep,1)
	return
	end

