unit Setfitpa;
{ ===========================================================
  WinEDR (c) J. Dempster, University of Strathclyde 1998-2001
  Let users set curve fitting parameters
  ===========================================================
  19/4/99 ... Now used TValidatedEdit
  24/6/01 ... Equation parameters now displayed with super/subscripts
              using RichEdit controls
  17/12/02 ... Now performs initial parameter guesses
               and has manual guess option to retain previous settings           }

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, StdCtrls, maths, ValEdit, ComCtrls, ValidatedEdit,CurveFitter,
  HTMLLabel ;

type
  TSetFitParsFrm = class(TForm)
    ParametersGrp: TGroupBox;
    ckFixed0: TCheckBox;
    Label2: TLabel;
    ckFixed1: TCheckBox;
    ckFixed2: TCheckBox;
    ckFixed3: TCheckBox;
    ckFixed4: TCheckBox;
    ckFixed5: TCheckBox;
    ckFixed6: TCheckBox;
    ckFixed7: TCheckBox;
    bOK: TButton;
    bCancel: TButton;
    Label1: TLabel;
    edPar0: TValidatedEdit;
    edPar1: TValidatedEdit;
    edPar2: TValidatedEdit;
    edPar3: TValidatedEdit;
    edPar4: TValidatedEdit;
    edPar5: TValidatedEdit;
    edPar6: TValidatedEdit;
    edPar7: TValidatedEdit;
    edpar8: TValidatedEdit;
    ckfixed8: TCheckBox;
    edpar9: TValidatedEdit;
    ckfixed9: TCheckBox;
    GroupBox1: TGroupBox;
    rbAutomaticGuess: TRadioButton;
    rbManual: TRadioButton;
    bInitialise: TButton;
    lbPar0: THTMLLabel;
    lbPar1: THTMLLabel;
    lbPar2: THTMLLabel;
    lbPar3: THTMLLabel;
    lbPar4: THTMLLabel;
    lbPar5: THTMLLabel;
    lbPar6: THTMLLabel;
    lbPar7: THTMLLabel;
    lbPar8: THTMLLabel;
    lbPar9: THTMLLabel;
    procedure FormShow(Sender: TObject);
    procedure bOKClick(Sender: TObject);
    procedure bCancelClick(Sender: TObject);
    procedure bInitialiseClick(Sender: TObject);
  private
    { Private declarations }
    LastPar : Array[0..9] of Single ;
    procedure SetParameterLine( var lbPar : THTMLLabel ;
                                var ed : TValidatedEdit ;
                                var ck : TCheckBox ;
                                ParNum : LongInt ) ;
    procedure GetParameterLine( const ed : TValidatedEdit ;
                                const ck : TCheckBox ;
                                ParNum : LongInt ) ;

  public
    { Public declarations }
    Fit : TCurveFitter ;

  end;

var
  SetFitParsFrm: TSetFitParsFrm;

implementation


{$R *.DFM}

procedure TSetFitParsFrm.FormShow(Sender: TObject);
{ ---------------------------------------
  Initialisation when dialog form is shown
  ---------------------------------------}
begin

        SetParameterLine( lbPar0, edPar0,  ckFixed0, 0 ) ;
        SetParameterLine( lbPar1, edPar1,  ckFixed1, 1) ;
        SetParameterLine( lbPar2, edPar2,  ckFixed2, 2 ) ;
        SetParameterLine( lbPar3, edPar3,  ckFixed3, 3 ) ;
        SetParameterLine( lbPar4, edPar4,  ckFixed4, 4 ) ;
        SetParameterLine( lbPar5, edPar5,  ckFixed5, 5 ) ;
        SetParameterLine( lbPar6, edPar6,  ckFixed6, 6 ) ;
        SetParameterLine( lbPar7, edPar7,  ckFixed7, 7 ) ;
        SetParameterLine( lbPar8, edPar8,  ckFixed8, 8 ) ;
        SetParameterLine( lbPar9, edPar9,  ckFixed9, 9 ) ;
        end;


procedure TSetFitParsFrm.SetParameterLine(
          var lbPar : THTMLLabel ;
          var ed : TValidatedEdit ;
          var ck : TCheckBox ;
          ParNum : Integer
          ) ;
{ -------------------------------------------
  Create parameter line on form from Equation
  -------------------------------------------}
begin

     if ParNum < Fit.NumParameters then begin
        lbPar.Caption := Fit.ParNames[ParNum] ;
        if Pos( 'ms', Fit.ParUnits[ParNum] ) > 0 then ed.Scale := 1000.
                                                      else ed.Scale := 1. ;

        if rbAutomaticGuess.Checked and
           (not Fit.FixedParameters[ParNum]) then
           ed.Value := Fit.InitialGuess(ParNum)
        else ed.Value := Fit.Parameters[ParNum]  ;

        ed.Units := Fit.ParUnits[ParNum] ;
        ed.enabled := True ;
        ck.Enabled := True ;
        if Fit.FixedParameters[ParNum] then ck.Checked := True
                                       else ck.Checked := False ;
        lbPar.Visible := True ;
        end
     else begin
        lbPar.visible := False ;
        ed.text := '' ;
        ed.enabled := False ;
        ck.enabled := False ;
        ck.checked := False ;
        end ;
     end ;



procedure TSetFitParsFrm.GetParameterLine(
          const ed : TValidatedEdit ;
          const ck : TCheckBox ;
          ParNum : LongInt
          ) ;
{ -----------------------------------------------
  Read parameter line on form and update Equation
  -----------------------------------------------}
begin
     if ed.enabled then  begin
        Fit.Parameters[ParNum] := ed.Value ;
        Fit.FixedParameters[ParNum] := ck.Checked
        end ;
     end ;


procedure TSetFitParsFrm.bOKClick(Sender: TObject);
//
// OK button clicked
// -----------------
begin

     // Transfer equation parameters from form to Fit.

     GetParameterLine( edPar0, ckFixed0, 0 ) ;
     GetParameterLine( edPar1, ckFixed1, 1 ) ;
     GetParameterLine( edPar2, ckFixed2, 2 ) ;
     GetParameterLine( edPar3, ckFixed3, 3 ) ;
     GetParameterLine( edPar4, ckFixed4, 4 ) ;
     GetParameterLine( edPar5, ckFixed5, 5 ) ;
     GetParameterLine( edPar6, ckFixed6, 6 ) ;
     GetParameterLine( edPar7, ckFixed7, 7 ) ;
     GetParameterLine( edPar8, ckFixed8, 8 ) ;
     GetParameterLine( edPar9, ckFixed9, 9 ) ;

     // Indicate that parameters have been set
     Fit.ParametersSet := True ;

     // Exit
     hide ;
     end;


procedure TSetFitParsFrm.bCancelClick(Sender: TObject);
begin
     hide ;
     end;


procedure TSetFitParsFrm.bInitialiseClick(Sender: TObject);
// -----------------------------------------
// Create a set of initial parameter guesses
// -----------------------------------------
var
     i : Integer ;
begin

     // Get parameter data from form
     GetParameterLine( edPar0, ckFixed0, 0 ) ;
     GetParameterLine( edPar1, ckFixed1, 1 ) ;
     GetParameterLine( edPar2, ckFixed2, 2 ) ;
     GetParameterLine( edPar3, ckFixed3, 3 ) ;
     GetParameterLine( edPar4, ckFixed4, 4 ) ;
     GetParameterLine( edPar5, ckFixed5, 5 ) ;
     GetParameterLine( edPar6, ckFixed6, 6 ) ;
     GetParameterLine( edPar7, ckFixed7, 7 ) ;
     GetParameterLine( edPar8, ckFixed8, 8 ) ;
     GetParameterLine( edPar9, ckFixed9, 9 ) ;

     // Determine best initial guesses
     for i := 0 to Fit.NumParameters-1 do
         if not Fit.FixedParameters[i] then begin
            Fit.Parameters[i] := Fit.InitialGuess(i) ;
            end ;

     // Update form with new values
     SetParameterLine( lbPar0, edPar0,  ckFixed0, 0 ) ;
     SetParameterLine( lbPar1, edPar1,  ckFixed1, 1) ;
     SetParameterLine( lbPar2, edPar2,  ckFixed2, 2 ) ;
     SetParameterLine( lbPar3, edPar3,  ckFixed3, 3 ) ;
     SetParameterLine( lbPar4, edPar4,  ckFixed4, 4 ) ;
     SetParameterLine( lbPar5, edPar5,  ckFixed5, 5 ) ;
     SetParameterLine( lbPar6, edPar6,  ckFixed6, 6 ) ;
     SetParameterLine( lbPar7, edPar7,  ckFixed7, 7 ) ;
     SetParameterLine( lbPar8, edPar8,  ckFixed8, 8 ) ;
     SetParameterLine( lbPar9, edPar9,  ckFixed9, 9 ) ;

     end;

end.
