unit PicViewAutoUnit;
// ---------------------------------------
// PICV-iewer - Automation interface module
// ---------------------------------------
// 25.3.03
// 8.4.03 Specific PIC Panel file can now be closed
// 13.5.04 Updated to support multiple images


{$WARN SYMBOL_PLATFORM OFF}

interface

uses
  ComObj, ActiveX, PicViewer_TLB, StdVcl ;

type
  TAuto = class(TAutoObject, IAuto)
  protected
    procedure OpenPIC(FileName: OleVariant); safecall;
    procedure ClosePIC(FileName: OleVariant); safecall;
    function Get_NumFrames: OleVariant; safecall;
    function Get_Frame: OleVariant; safecall;
    function Get_IntensityMax: OleVariant; safecall;
    function Get_IntensityMean: OleVariant; safecall;
    function Get_IntensityMin: OleVariant; safecall;
    function Get_IntensitySD: OleVariant; safecall;
    procedure Set_Frame(Value: OleVariant); safecall;
    function Get_NumSectionsPerStack: OleVariant; safecall;
    function Get_NumStacks: OleVariant; safecall;
    function Get_Stack: OleVariant; safecall;
    procedure Set_NumSectionsPerStack(Value: OleVariant); safecall;
    procedure Set_Stack(Value: OleVariant); safecall;
    function Get_Section: OleVariant; safecall;
    procedure Set_Section(Value: OleVariant); safecall;
  end;

implementation

uses ComServ, PicViewMain, ViewUnit ;

procedure TAuto.OpenPIC(FileName: OleVariant);
// ----------------------------
// Open & display an image file
// ----------------------------
var
    i : Integer ;
    Done : Boolean ;
begin
     // If the file is already on display, select it for use
     Done := False ;
     i := 0 ;
     While (not Done) and (i <= High(MainFrm.ViewFrmsInUse)) do begin
         if MainFrm.ViewFrmsInUse[i] and
            (MainFrm.ViewFrms[i].FileName = FileName) then begin
            MainFrm.AUTOSelectedPIC := i ;
            Done := True ;
            end ;
         Inc(i) ;
         end ;

     // Open file for display if not already available
     if not Done then begin
        MainFrm.AUTOSelectedPIC := MainFrm.CreateNewViewFrm(FileName) ;
        end ;

     end;


procedure TAuto.ClosePIC(FileName: OleVariant);
// ----------------------------
// Close an image file display
// ----------------------------
begin
     MainFrm.CloseViewFrm(FileName) ;
     end;


function TAuto.Get_NumFrames: OleVariant;
// --------------------------------------------------
// Return number of frames in currently open PIC file
// --------------------------------------------------
begin
     if (MainFrm.AUTOSelectedPIC >= 0) and
        (MainFrm.AUTOSelectedPIC <= High(MainFrm.ViewFrms)) then begin
        Result := MainFrm.ViewFrms[MainFrm.AUTOSelectedPIC].NumFrames
        end
     else Result := 0 ;
     end;


function TAuto.Get_Frame: OleVariant;
// -------------------------------------------------
// Return current frame on display in selected image
// -------------------------------------------------
begin
     if (MainFrm.AUTOSelectedPIC >= 0) and
        (MainFrm.AUTOSelectedPIC <= High(MainFrm.ViewFrms)) then begin
        Result := MainFrm.ViewFrms[MainFrm.AUTOSelectedPIC].CurrentFrame ;
        end
     else Result := 0 ;
     end;


function TAuto.Get_IntensityMax: OleVariant;
// -------------------------------------------------
// Return max. intensity within selected image/frame
// -------------------------------------------------
begin
     if (MainFrm.AUTOSelectedPIC >= 0) and
        (MainFrm.AUTOSelectedPIC <= High(MainFrm.ViewFrms)) then begin
        MainFrm.ViewFrms[MainFrm.AUTOSelectedPIC].ImageStatistics ;
        Result := MainFrm.ViewFrms[MainFrm.AUTOSelectedPIC].IntensityMax ;
        end
     else Result := 0 ;
     end;


function TAuto.Get_IntensityMean: OleVariant;
// -------------------------------------------------
// Return mean intensity within selected image/frame
// -------------------------------------------------
begin
     if (MainFrm.AUTOSelectedPIC >= 0) and
        (MainFrm.AUTOSelectedPIC <= High(MainFrm.ViewFrms)) then begin
        MainFrm.ViewFrms[MainFrm.AUTOSelectedPIC].ImageStatistics ;
        Result := MainFrm.ViewFrms[MainFrm.AUTOSelectedPIC].IntensityMean ;
        end
     else Result := 0 ;
     end;


function TAuto.Get_IntensityMin: OleVariant;
// -------------------------------------------------
// Return min. intensity within selected image/frame
// -------------------------------------------------
begin
     if (MainFrm.AUTOSelectedPIC >= 0) and
        (MainFrm.AUTOSelectedPIC <= High(MainFrm.ViewFrms)) then begin
        MainFrm.ViewFrms[MainFrm.AUTOSelectedPIC].ImageStatistics ;
        Result := MainFrm.ViewFrms[MainFrm.AUTOSelectedPIC].IntensityMin ;
        end
     else Result := 0 ;
     end;


function TAuto.Get_IntensitySD: OleVariant;
// -------------------------------------------------
// Return intensity s.d. within selected image/frame
// -------------------------------------------------
begin
     if (MainFrm.AUTOSelectedPIC >= 0) and
        (MainFrm.AUTOSelectedPIC <= High(MainFrm.ViewFrms)) then begin
        MainFrm.ViewFrms[MainFrm.AUTOSelectedPIC].ImageStatistics ;
        Result := MainFrm.ViewFrms[MainFrm.AUTOSelectedPIC].IntensitySD ;
        end
     else Result := 0 ;
     end;


procedure TAuto.Set_Frame(Value: OleVariant);
// ----------------------------------------------
// Select frame within currently selected display
// ----------------------------------------------
begin
     if (MainFrm.AUTOSelectedPIC >= 0) and
        (MainFrm.AUTOSelectedPIC <= High(MainFrm.ViewFrms)) then begin
        MainFrm.ViewFrms[MainFrm.AUTOSelectedPIC].SetFrame(Round(Value)) ;
        end ;
     end;


function TAuto.Get_NumSectionsPerStack: OleVariant;
// --------------------------------------------
// Return no. sections/stacks in selected image
// --------------------------------------------
begin
     if (MainFrm.AUTOSelectedPIC >= 0) and
        (MainFrm.AUTOSelectedPIC <= High(MainFrm.ViewFrms)) then begin
        Result := MainFrm.ViewFrms[MainFrm.AUTOSelectedPIC].NumSectionsPerStack ;
        end
     else Result := 0 ;
     end;


function TAuto.Get_NumStacks: OleVariant;
// --------------------------------------
// Return no. of stacks in selected image
// --------------------------------------
begin
     if (MainFrm.AUTOSelectedPIC >= 0) and
        (MainFrm.AUTOSelectedPIC <= High(MainFrm.ViewFrms)) then begin
        Result := MainFrm.ViewFrms[MainFrm.AUTOSelectedPIC].NumStacks ;
        end
     else Result := 0 ;
     end;

function TAuto.Get_Stack: OleVariant;
// -------------------------------------------------
// Return current stack on display in selected image
// -------------------------------------------------
begin
     if (MainFrm.AUTOSelectedPIC >= 0) and
        (MainFrm.AUTOSelectedPIC <= High(MainFrm.ViewFrms)) then begin
        Result := MainFrm.ViewFrms[MainFrm.AUTOSelectedPIC].CurrentStack ;
        end
     else Result := 0 ;
     end;


procedure TAuto.Set_NumSectionsPerStack(Value: OleVariant);
// ----------------------------------------------
// Set no. sections/stack within currently selected display
// ----------------------------------------------
begin
     if (MainFrm.AUTOSelectedPIC >= 0) and
        (MainFrm.AUTOSelectedPIC <= High(MainFrm.ViewFrms)) then begin
        MainFrm.ViewFrms[MainFrm.AUTOSelectedPIC].SetNumSectionsPerStack(Round(Value)) ;
        end ;
     end;


procedure TAuto.Set_Stack(Value: OleVariant);
// ----------------------------------------------
// Select stack within currently selected display
// ----------------------------------------------
begin
     if (MainFrm.AUTOSelectedPIC >= 0) and
        (MainFrm.AUTOSelectedPIC <= High(MainFrm.ViewFrms)) then begin
        MainFrm.ViewFrms[MainFrm.AUTOSelectedPIC].SetStackNum(Round(Value)) ;
        end ;
     end;


function TAuto.Get_Section: OleVariant;
// -------------------------------------------------
// Return section # on display in selected image
// -------------------------------------------------
begin
     if (MainFrm.AUTOSelectedPIC >= 0) and
        (MainFrm.AUTOSelectedPIC <= High(MainFrm.ViewFrms)) then begin
        Result := MainFrm.ViewFrms[MainFrm.AUTOSelectedPIC].CurrentSection ;
        end
     else Result := 0 ;
     end;


procedure TAuto.Set_Section(Value: OleVariant);
// ----------------------------------------------
// Select section # within currently selected stack
// ----------------------------------------------
begin
     if (MainFrm.AUTOSelectedPIC >= 0) and
        (MainFrm.AUTOSelectedPIC <= High(MainFrm.ViewFrms)) then begin
        MainFrm.ViewFrms[MainFrm.AUTOSelectedPIC].SetSectionNum(Round(Value)) ;
        end ;
     end;

initialization
  TAutoObjectFactory.Create(ComServer, TAuto, Class_Auto,
    ciMultiInstance, tmApartment);
end.
