unit Printgra;
{ =======================================================
  Updates printer page settings in Settings.Plot
  =======================================================}
// 4.11.03 Printer selection option added

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, StdCtrls, Spin, Buttons, Printers, Shared,
  ValEdit, XYPlotDisplay, ExtCtrls, ValidatedEdit ;

type
  TPrintGraphFrm = class(TForm)
    bOK: TButton;
    bCancel: TButton;
    FontGrp: TGroupBox;
    Label7: TLabel;
    cbFontName: TComboBox;
    edFontSize: TValidatedEdit;
    GroupBox3: TGroupBox;
    Label5: TLabel;
    edLineThickness: TValidatedEdit;
    Page: TNotebook;
    PrinterGrp: TGroupBox;
    Label1: TLabel;
    Label2: TLabel;
    Label3: TLabel;
    Label4: TLabel;
    edLeftMargin: TValidatedEdit;
    edRightMargin: TValidatedEdit;
    edTopMargin: TValidatedEdit;
    edBottomMargin: TValidatedEdit;
    MetafileGrp: TGroupBox;
    Label6: TLabel;
    Label9: TLabel;
    edBitmapWidth: TValidatedEdit;
    edBitmapHeight: TValidatedEdit;
    GroupBox1: TGroupBox;
    edPrinter: TEdit;
    bPrinterSetup: TButton;
    PrinterSetupDialog: TPrinterSetupDialog;
    procedure FormShow(Sender: TObject);
    procedure bOKClick(Sender: TObject);
    procedure bPrinterSetupClick(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
    ToPrinter : Boolean ;
    Plot : TXYPlotDisplay ;

  end;

var
  PrintGraphFrm: TPrintGraphFrm;

implementation

uses PicViewMain;

{$R *.DFM}


procedure TPrintGraphFrm.FormShow(Sender: TObject);
{ --------------------------------------------
  Initialise edit boxes when form is displayed
  -------------------------------------------- }
var
     DeviceName : Array[0..100] of Char ;
     DeviceDriver : Array[0..100] of Char ;
     Port : Array[0..100] of Char ;
     DeviceMode : Cardinal ;
begin
     { Select appropriate page for printer page margins or
       metafile image size }
     if ToPrinter then begin
        Page.PageIndex := 0 ;
        Caption := ' Print ' ;
        Printer.GetPrinter( DeviceName, DeviceDriver,Port,DeviceMode);
        edPrinter.Text := String(DeviceName) ;
        bPrinterSetup.Enabled := True ;
        end
     else begin
        Page.PageIndex := 1 ;
        edPrinter.Text := 'Clipboard' ;
        Caption := ' Copy Image ' ;
        bPrinterSetup.Enabled := False ;
        end ;

     edTopMargin.Value := MainFrm.PrinterTopMargin ;
     edBottomMargin.Value := MainFrm.PrinterBottomMargin ;
     edLeftMargin.Value := MainFrm.PrinterLeftMargin ;
     edRightMargin.Value := MainFrm.PrinterRightMargin ;
     edBitMapWidth.Value := MainFrm.ImageCopyWidth ;
     edBitMapHeight.Value := MainFrm.ImageCopyHeight ;

     { Fill Fonts list with typefaces available to printer }
     cbFontName.items := Printer.fonts ;
     edFontSize.Value := MainFrm.PrinterFontSize ;
     edLineThickness.Value := MainFrm.PrinterLineThickness ;
     cbFontName.itemindex := cbFontName.items.indexof(MainFrm.PrinterFontName) ;
     if cbFontName.itemindex < 0 then  cbFontName.itemindex := 0 ;

     end;


procedure TPrintGraphFrm.bOKClick(Sender: TObject);
// ----------------------------------------------------
// Update page settings within graph plotting component
// ----------------------------------------------------
begin
     { Save new settings }
     MainFrm.PrinterTopMargin := edTopMargin.Value ;
     MainFrm.PrinterBottomMargin := edBottomMargin.Value ;
     MainFrm.PrinterLeftMargin:= edLeftMargin.Value  ;
     MainFrm.PrinterRightMargin := edRightMargin.Value ;
     MainFrm.PrinterFontName := cbFontName.text ;
     MainFrm.PrinterFontSize := Round(edFontSize.Value) ;
     MainFrm.PrinterLineThickness := Round(edLineThickness.Value) ;
     MainFrm.ImageCopyWidth := Round(edBitMapWidth.Value)  ;
     MainFrm.ImageCopyHeight := Round(edBitMapHeight.Value)  ;

     { Update settings in XYplot component }
     Plot.PrinterTopMargin := Round(MainFrm.PrinterTopMargin*10.0) ;
     Plot.PrinterBottomMargin := Round(MainFrm.PrinterBottomMargin*10.0) ;
     Plot.PrinterLeftMargin := Round(MainFrm.PrinterLeftMargin*10.0) ;
     Plot.PrinterRightMargin := Round(MainFrm.PrinterRightMargin*10.0) ;
     Plot.PrinterFontSize := MainFrm.PrinterFontSize ;
     Plot.PrinterLineWidth := MainFrm.PrinterLineThickness ;
     Plot.MetafileWidth := MainFrm.ImageCopyWidth ;
     Plot.MetafileHeight := MainFrm.ImageCopyHeight ;

     end;


procedure TPrintGraphFrm.bPrinterSetupClick(Sender: TObject);
var
     DeviceName : Array[0..100] of Char ;
     DeviceDriver : Array[0..100] of Char ;
     Port : Array[0..100] of Char ;
     DeviceMode : Cardinal ;
begin
     PrinterSetupDialog.Execute ;
     Printer.GetPrinter( DeviceName, DeviceDriver,Port,DeviceMode);
     edPrinter.Text := String(DeviceName) ;
     end;

end.
