unit BioRadUnit;
// ==================================================
// BioRad PIC file import module
// (c) John Dempster, University of Strathclyde, 2003
// ==================================================
// 7/3/2003

interface

uses
  SysUtils, Classes;



type

  TPICFileHeader = packed record
      FrameWidth : SmallInt ;     // Image width (pixels)
      FrameHeight : SmallInt ;    // Image height (pixels)
      NumFrames : SmallInt ;      // No. images in file
      LUT1Min : SmallInt ;        // Lower intensity limit of LUT map
      LUT1Max : SmallInt ;        // Upper intensity limit of LUT map
      NotesOffset : Integer ;     // Offset of notes lines in file
      ByteImage : SmallInt ;      // 1=8 bit, 0=16 bit image
      ImageNumber : SmallInt ;    // Image no. within file
      FileName : Array[1..32] of Char ;  // File name
      Merged : SmallInt ;         // Merged format??
      LUT1Color : Word ;          // LUT1 colour status
      Signature : SmallInt ;   // PIC file signature = 12345
      LUT2Min : SmallInt ;        // Lower intensity limit of LUT2 map
      LUT2Max : SmallInt ;        // Upper intensity limit of LUT2 map
      LUT2Color : Word ;          // LUT2 colour status
      Edited : SmallInt ;         // 1=file has been edited
      ILensMagnification : SmallInt ; // Integer lens magnfication factor
      FLensMagnification : Single ;   // Floating point lens magnfication factor
      Free : Array[1..3] of SmallInt ;
      end ;




  TBioRAD = class(TDataModule)
  private
    { Private declarations }
  public
    { Public declarations }
    function OpenFile(
             FileName : String ;
             var PICHeader : TPICFileHeader ) : Integer ;

    function LoadFrame(
             FileHandle : Integer ;
             FrameNum : Integer ;
             var Header : TPICFileHeader ;
             PFrameBuf : Pointer ) : Boolean ;

  end;

var
  BioRAD: TBioRAD;

implementation

uses PicViewMain;



{$R *.dfm}

const
     PICSignature = 12345 ;

function TBioRAD.OpenFile(
         FileName : String ;
         var PICHeader : TPICFileHeader ) : Integer ;
// ----------------------------------------
// Open BioRad PIC data file
// ----------------------------------------
var
    Done : Boolean ;        // Loop done flag
    FileHandle : Integer ;  // Import file handle

begin

    Result := -1 ;

    // Open file
    FileHandle := FileOpen( FileName, fmOpenRead ) ;
    if FileHandle < 0 then begin
       MainFrm.StatusBar.SimpleText := ' Unable to open : ' + FileName ;
       Exit ;
       end ;

    // Read PIC file header
    FileSeek(FileHandle,0,0) ;
    if FileRead(FileHandle, PICHeader, SizeOf(PICHeader))
        <> SizeOf(PICHeader) then begin  ;
        MainFrm.StatusBar.SimpleText := ' IMPORT: Unable to read BioRad PIC file header ' ;
        FileClose( FileHandle ) ;
        FileHandle := -1 ;
        Exit ;
        end ;

    // Check PIC file signature
    if PICHeader.Signature <> PICSignature then begin
       MainFrm.StatusBar.SimpleText := ' IMPORT: Unable to read (not a BioRad PIC file)! ' ;
       FileClose( FileHandle ) ;
       FileHandle := -1 ;
       Exit ;
       end ;

    Result := FileHandle ;
    end ;


function TBioRAD.LoadFrame(
         FileHandle : Integer ;
         FrameNum : Integer ;
         var Header : TPICFileHeader ;
         PFrameBuf : Pointer ) : Boolean ;
// ----------------------------------------
// Load frame from BioRad PIC data file
// ----------------------------------------
var
    NumBytesPerFrame : Integer ; // No. of bytes per image frame
    FilePointer : Integer ;      // File offset
begin

    if (FrameNum < 1) or (FrameNum > Header.NumFrames) then begin
       Result := False ;
       Exit ;
       end ;

    // Find file offset of start of frame
    NumBytesPerFrame := Header.FrameWidth*Header.FrameHeight ;
    if Header.ByteImage <> 1 then NumBytesPerFrame := NumBytesPerFrame*2 ;
    FilePointer := SizeOf(TPICFileHeader) + (FrameNum-1)*NumBytesPerFrame ;

    // Read data from file
    FileSeek( FileHandle, FilePointer, 0 ) ;
    if FileRead(FileHandle, PFrameBuf^, NumBytesPerFrame)
       = NumBytesPerFrame then Result := True
                          else Result := False ;
    end ;

end.
